/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.util;

import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;

public abstract class BaseTreeModel
implements TreeModel {
    private final CopyOnWriteArrayList<TreeModelListener> listeners = new CopyOnWriteArrayList();

    @Override
    public void addTreeModelListener(TreeModelListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeTreeModelListener(TreeModelListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    protected void fireTreeNodesChanged(TreeModelEvent e) {
        for (TreeModelListener listener : this.listeners) {
            listener.treeNodesChanged(e);
        }
    }

    protected void fireTreeNodesInserted(TreeModelEvent e) {
        for (TreeModelListener listener : this.listeners) {
            listener.treeNodesInserted(e);
        }
    }

    protected void fireTreeNodesRemoved(TreeModelEvent e) {
        for (TreeModelListener listener : this.listeners) {
            listener.treeNodesRemoved(e);
        }
    }

    protected void fireTreeStructureChanged(TreeModelEvent e) {
        for (TreeModelListener listener : this.listeners) {
            listener.treeStructureChanged(e);
        }
    }
}

