/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.util;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.guice.Scythebill;
import com.scythebill.birdlist.ui.messages.Messages;
import java.awt.Component;
import java.awt.Toolkit;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.joda.time.Duration;
import org.joda.time.Instant;

public class Alerts {
    private final Icon appIcon;
    private static volatile Instant lastError = null;
    private static final Duration ERROR_INTERVAL = Duration.standardSeconds(30L);

    @Inject
    public Alerts(@Scythebill Icon appIcon) {
        this.appIcon = appIcon;
    }

    public Icon getAlertIcon() {
        return this.appIcon;
    }

    public int showConfirm(Object parentObject, Messages.Name title, Messages.Name message, Object ... args) {
        String formattedMessage = this.getFormattedDialogMessage(title, message, args);
        return JOptionPane.showConfirmDialog(this.parentComponent(parentObject), formattedMessage, "", 1, 3, this.appIcon);
    }

    @Deprecated
    public int showConfirm(Object parentObject, String title, String message, Object ... args) {
        String formattedMessage = this.getFormattedDialogMessage(title, message, args);
        return JOptionPane.showConfirmDialog(this.parentComponent(parentObject), formattedMessage, "", 1, 3, this.appIcon);
    }

    public int showYesNo(Object parentObject, Messages.Name title, Messages.Name message, Object ... args) {
        String formattedMessage = this.getFormattedDialogMessage(title, message, args);
        return JOptionPane.showConfirmDialog(this.parentComponent(parentObject), formattedMessage, "", 0, 3, this.appIcon);
    }

    @Deprecated
    public int showYesNo(Object parentObject, String title, String message, Object ... args) {
        String formattedMessage = this.getFormattedDialogMessage(title, message, args);
        return JOptionPane.showConfirmDialog(this.parentComponent(parentObject), formattedMessage, "", 0, 3, this.appIcon);
    }

    public int showOkCancel(Object parentObject, Messages.Name title, Messages.Name message, Object ... args) {
        String formattedMessage = this.getFormattedDialogMessage(title, message, args);
        return JOptionPane.showConfirmDialog(this.parentComponent(parentObject), formattedMessage, "", 2, 1, this.appIcon);
    }

    @Deprecated
    public int showOkCancel(Object parentObject, String title, String message, Object ... args) {
        String formattedMessage = this.getFormattedDialogMessage(title, message, args);
        return JOptionPane.showConfirmDialog(this.parentComponent(parentObject), formattedMessage, "", 2, 1, this.appIcon);
    }

    public int showWithOptions(Object parentObject, Messages.Name title, Messages.Name message, Object ... options) {
        String formattedMessage = this.getFormattedDialogMessage(title, message, new Object[0]);
        return JOptionPane.showOptionDialog(this.parentComponent(parentObject), formattedMessage, "", -1, 2, this.appIcon, options, options[0]);
    }

    @Deprecated
    public int showWithOptions(Object parentObject, String title, String message, Object ... options) {
        String formattedMessage = this.getFormattedDialogMessage(title, message, new Object[0]);
        return JOptionPane.showOptionDialog(this.parentComponent(parentObject), formattedMessage, "", -1, 2, this.appIcon, options, options[0]);
    }

    public String getInput(Object parentObject, Messages.Name title, Messages.Name message, String defaultValue) {
        Object formattedMessage = this.getFormattedDialogMessage(title, message, new Object[0]);
        formattedMessage = (String)formattedMessage + "<br>";
        Object result = JOptionPane.showInputDialog(this.parentComponent(parentObject), formattedMessage, "", 3, this.appIcon, null, defaultValue);
        return result == null ? null : result.toString();
    }

    public void showError(Object parentObject, Messages.Name title, Messages.Name message, Object ... args) {
        String formattedMessage = this.getFormattedDialogMessage(title, message, args);
        JOptionPane.showMessageDialog(this.parentComponent(parentObject), formattedMessage, "", 0, this.appIcon);
    }

    public void showError(Object parentObject, String title, String message, Object ... args) {
        String formattedMessage = this.getFormattedDialogMessage(title, message, args);
        JOptionPane.showMessageDialog(this.parentComponent(parentObject), formattedMessage, "", 0, this.appIcon);
    }

    public void showMessage(Object parentObject, Messages.Name title, Messages.Name message, Object ... args) {
        String formattedMessage = this.getFormattedDialogMessage(title, message, args);
        JOptionPane.showMessageDialog(this.parentComponent(parentObject), formattedMessage, "", -1, this.appIcon);
    }

    @Deprecated
    public void showMessage(Object parentObject, String title, String message, Object ... args) {
        String formattedMessage = this.getFormattedDialogMessage(title, message, args);
        JOptionPane.showMessageDialog(this.parentComponent(parentObject), formattedMessage, "", -1, this.appIcon);
    }

    public void showOkWithPanel(Object parentObject, String formattedMessage, JComponent component) {
        JOptionPane.showConfirmDialog(this.parentComponent(parentObject), new Object[]{formattedMessage, component}, "", 0, 1, null);
    }

    public int showOkCancelWithPanel(Object parentObject, String formattedMessage, JComponent component) {
        return JOptionPane.showConfirmDialog(this.parentComponent(parentObject), new Object[]{formattedMessage, component}, "", 2, 1, this.appIcon);
    }

    public int showYesNoWithPanel(Object parentObject, String formattedMessage, JComponent component) {
        return JOptionPane.showConfirmDialog(this.parentComponent(parentObject), new Object[]{formattedMessage, component}, "", 0, 3, this.appIcon);
    }

    public int showOptionsWithPanel(Object parentObject, String formattedMessage, JComponent component, Object ... options) {
        return JOptionPane.showOptionDialog(this.parentComponent(parentObject), new Object[]{formattedMessage, component}, "", -1, 3, this.appIcon, options, options[0]);
    }

    public String getFormattedDialogMessage(Messages.Name title, Messages.Name message, Object ... args) {
        return this.getFormattedDialogMessage(title.toString(), message.toString(), args);
    }

    @Deprecated
    public String getFormattedDialogMessage(String title, String message, Object ... args) {
        if (args.length > 0) {
            message = String.format(message, args);
        }
        String fontName = FontManager.getFontName();
        String css = String.format("<head><style type=\"text/css\">b { font: %spt \"%s\" } p { font: %spt \"%s\"; margin-top: %spx }</style></head>", 14, fontName, 12, fontName, 8);
        message = message.replace("\n", "<br>");
        return String.format("<html>" + css + "<b>%1$s</b><p>%2$s</p>", title, message);
    }

    public String getFormattedDialogMessageUnscaled(Messages.Name titleName, Messages.Name messageName, Object ... args) {
        String message = args.length > 0 ? Messages.getFormattedMessage(messageName, args) : Messages.getMessage(messageName);
        return String.format("<html><b>%1$s</b><br><br>%2$s", Messages.getMessage(titleName), message);
    }

    public void showError(Object parentObject, Throwable t, Messages.Name title, Messages.Name message, Object ... args) {
        String formattedMessage = this.getFormattedDialogMessage(title, message, args);
        JScrollPane scrollPane = this.scrollableErrorDisplay(t);
        JOptionPane.showMessageDialog(this.parentComponent(parentObject), new Object[]{formattedMessage, "", scrollPane}, "", 0, this.appIcon);
    }

    public void showError(Object parentObject, Throwable t, String title, String message, Object ... args) {
        String formattedMessage = this.getFormattedDialogMessage(title, message, args);
        JScrollPane scrollPane = this.scrollableErrorDisplay(t);
        JOptionPane.showMessageDialog(this.parentComponent(parentObject), new Object[]{formattedMessage, "", scrollPane}, "", 0, this.appIcon);
    }

    public void reportError(Throwable t) {
        if (this.isIgnorableError(t)) {
            return;
        }
        Instant now = new Instant();
        if (lastError != null && lastError.plus(ERROR_INTERVAL).isAfter(now)) {
            return;
        }
        lastError = now;
        String formattedMessage = this.getFormattedDialogMessage(Messages.Name.EXCEPTION_TITLE, Messages.Name.EXCEPTION_MESSAGE, new Object[0]);
        JScrollPane scrollPane = this.scrollableErrorDisplay(t);
        JOptionPane.showMessageDialog(null, new Object[]{formattedMessage, "", scrollPane}, "", 0, this.appIcon);
    }

    private JScrollPane scrollableErrorDisplay(Throwable t) {
        final JTextArea textArea = new JTextArea();
        String stackTrace = Throwables.getStackTraceAsString(t);
        stackTrace = stackTrace.replaceAll("com\\.scythebill\\.birdlist", "");
        textArea.setText(t.getMessage() + "\n" + stackTrace);
        textArea.setColumns(40);
        textArea.setRows(6);
        textArea.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(textArea, 20, 30);
        textArea.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
                textArea.selectAll();
                textArea.getTransferHandler().exportToClipboard(textArea, Toolkit.getDefaultToolkit().getSystemClipboard(), 1);
                textArea.setTabSize(2);
                textArea.select(0, 0);
                textArea.requestFocusInWindow();
            }
        });
        return scrollPane;
    }

    private boolean isIgnorableError(Throwable t) {
        String stackTrace = Throwables.getStackTraceAsString(t);
        if (!stackTrace.contains("scythebill")) {
            return true;
        }
        return t.getMessage() != null && t.getMessage().equals("Width (0) and height (0) cannot be <= 0");
    }

    public void showFeedback(Messages.Name title, String feedback) {
        String formattedMessage = this.getFormattedDialogMessage(title, Messages.Name.FEEDBACK_IS_IN_CLIPBOARD, new Object[0]);
        final JTextArea textArea = new JTextArea();
        textArea.setColumns(40);
        textArea.setRows(6);
        textArea.setEditable(false);
        textArea.setText(feedback);
        JScrollPane scrollPane = new JScrollPane(textArea, 20, 30);
        textArea.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
                textArea.selectAll();
                textArea.getTransferHandler().exportToClipboard(textArea, Toolkit.getDefaultToolkit().getSystemClipboard(), 1);
                textArea.setTabSize(2);
                textArea.select(0, 0);
                textArea.requestFocusInWindow();
            }
        });
        JOptionPane.showMessageDialog(null, new Object[]{formattedMessage, "", scrollPane}, "", 1, this.appIcon);
    }

    public void showScrollableInfo(Object parentObject, String formattedMessage, String info) {
        JTextArea textArea = new JTextArea();
        textArea.setColumns(40);
        int lines = CharMatcher.is('\n').countIn(info) + 1;
        textArea.setRows(Math.min(15, Math.max(5, lines += Splitter.on('\n').splitToList(info).stream().mapToInt(s -> s.length() / 60).sum())));
        textArea.setEditable(false);
        textArea.setText(info);
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        textArea.setCaretPosition(0);
        JScrollPane scrollPane = new JScrollPane(textArea, 20, 30);
        JOptionPane.showMessageDialog(this.parentComponent(parentObject), new Object[]{formattedMessage, "", scrollPane}, "", 1, this.appIcon);
    }

    private Component parentComponent(Object parentObject) {
        if (parentObject instanceof Component) {
            return (Component)parentObject;
        }
        return null;
    }
}

