/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.uptodate;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import com.google.common.io.CharSource;
import com.google.common.io.Resources;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.SettableFuture;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import com.scythebill.birdlist.ui.guice.CurrentVersion;
import com.scythebill.birdlist.ui.prefs.PreferencesManager;
import com.scythebill.birdlist.ui.uptodate.UpToDatePreferences;
import java.io.BufferedReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;

public class UpToDateLoader {
    private static final String VERSION_INFO_URL = "http://updates.scythebill.com/version-info.json";
    private static final int TIMEOUT_IN_SECONDS = 60;
    private static final ReadableDuration TIME_BETWEEN_CHECKS = Duration.standardDays(5L);
    private final VersionNumber currentVersion;
    private final PreferencesManager preferencesManager;
    private final ListeningScheduledExecutorService executorService;

    @Inject
    UpToDateLoader(@Nullable @CurrentVersion String currentVersion, PreferencesManager preferencesManager, ListeningScheduledExecutorService executorService) {
        this.currentVersion = new VersionNumber(UpToDateLoader.versionMinusSnapshot(currentVersion));
        this.preferencesManager = preferencesManager;
        this.executorService = executorService;
    }

    public ListenableFuture<ImmutableList<VersionInfo>> load() {
        final UpToDatePreferences upToDatePreferences = this.preferencesManager.getPreference(UpToDatePreferences.class);
        Instant lastRead = new Instant(upToDatePreferences.lastRead);
        Instant timeToCheckAgain = lastRead.plus(TIME_BETWEEN_CHECKS);
        if (timeToCheckAgain.isAfterNow()) {
            return Futures.immediateFuture(ImmutableList.of());
        }
        Future loader = this.executorService.submit(new Callable<ImmutableList<VersionInfo>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ImmutableList<VersionInfo> call() throws Exception {
                String queryParams = Joiner.on("&").withKeyValueSeparator("=").join(ImmutableMap.of("v", URLEncoder.encode(UpToDateLoader.this.currentVersion.toString(), "UTF-8"), "os", URLEncoder.encode(System.getProperty("os.name"), "UTF-8"), "f", UpToDateLoader.getFeaturesString(upToDatePreferences), "l", Locale.getDefault().toLanguageTag()));
                CharSource source = Resources.asCharSource(new URL("http://updates.scythebill.com/version-info.json?" + queryParams), StandardCharsets.UTF_8);
                try (BufferedReader input = new BufferedReader(source.openStream());){
                    List<VersionInfo> infoList = UpToDateLoader.this.deserialize(input);
                    ImmutableList.Builder versionInfoSinceCurrent = ImmutableList.builder();
                    for (VersionInfo info : infoList) {
                        VersionNumber oldVersion = new VersionNumber(info.version);
                        if (oldVersion.compareTo(UpToDateLoader.this.currentVersion) <= 0) break;
                        versionInfoSinceCurrent.add(info);
                    }
                    ImmutableCollection immutableCollection = versionInfoSinceCurrent.build();
                    return immutableCollection;
                }
            }
        });
        final SettableFuture<ImmutableList<VersionInfo>> results = SettableFuture.create();
        Futures.addCallback(loader, new FutureCallback<ImmutableList<VersionInfo>>(){

            @Override
            public void onFailure(Throwable t) {
                results.setException(t);
            }

            @Override
            public void onSuccess(ImmutableList<VersionInfo> info) {
                if (results.set(info)) {
                    upToDatePreferences.lastRead = System.currentTimeMillis();
                    UpToDateLoader.this.preferencesManager.save();
                }
            }
        }, this.executorService);
        ScheduledFuture unused = this.executorService.schedule(() -> UpToDateLoader.lambda$load$0((ListenableFuture)loader), 60L, TimeUnit.SECONDS);
        return results;
    }

    private static String getFeaturesString(UpToDatePreferences upToDatePreferences) {
        ArrayList<String> features = new ArrayList<String>();
        if (upToDatePreferences.multipleUsers) {
            features.add("u");
        }
        return Joiner.on(',').join(features);
    }

    private List<VersionInfo> deserialize(Reader reader) throws JsonParseException {
        Gson gson = new Gson();
        Type versionInfoType = new TypeToken<List<VersionInfo>>(){}.getType();
        return (List)gson.fromJson(reader, versionInfoType);
    }

    private static String versionMinusSnapshot(String currentVersion) {
        return currentVersion.replace("-SNAPSHOT", "");
    }

    private static /* synthetic */ Boolean lambda$load$0(ListenableFuture loader) throws Exception {
        return loader.cancel(true);
    }

    static class VersionNumber
    implements Comparable<VersionNumber> {
        private static Splitter PERIOD_SPLITTER = Splitter.on('.');
        private final ImmutableList<Integer> versions;
        private final String versionString;

        VersionNumber(String versionString) {
            this.versionString = versionString;
            this.versions = Streams.stream(PERIOD_SPLITTER.split(versionString)).map(s -> {
                Integer i = Ints.tryParse(s);
                return i == null ? 0 : i;
            }).collect(ImmutableList.toImmutableList());
        }

        @Override
        public int compareTo(VersionNumber other) {
            if (other.versions.size() > this.versions.size()) {
                return other.compareTo(this);
            }
            for (int i = 0; i < this.versions.size(); ++i) {
                int compare = Ints.compare((Integer)this.versions.get(i), (Integer)other.versions.get(i));
                if (compare == 0) continue;
                return compare;
            }
            if (this.versions.size() > other.versions.size()) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            return this.versionString;
        }
    }

    public static class VersionInfo {
        public String version;
        public List<String> changes;
        public URI url;

        public String toString() {
            return MoreObjects.toStringHelper(this).add("version", this.version).add("changes", this.changes).add("url", this.url).toString();
        }
    }
}

