/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.taxonomy;

import com.google.common.collect.Lists;
import com.google.common.eventbus.Subscribe;
import com.google.common.io.Files;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.checklist.ExtendedTaxonomyChecklists;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.actions.ReturnAction;
import com.scythebill.birdlist.ui.app.Titled;
import com.scythebill.birdlist.ui.events.EventBusRegistrar;
import com.scythebill.birdlist.ui.events.TaxonomyChangedEvent;
import com.scythebill.birdlist.ui.events.TaxonomyStore;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.FilePreferences;
import com.scythebill.birdlist.ui.panels.ShrinkToFit;
import com.scythebill.birdlist.ui.taxonomy.ExtendedTaxonomyAdder;
import com.scythebill.birdlist.ui.taxonomy.ExtendedTaxonomyCsvExporter;
import com.scythebill.birdlist.ui.taxonomy.ExtendedTaxonomyCsvImporter;
import com.scythebill.birdlist.ui.taxonomy.ExtendedTaxonomyXmlExporter;
import com.scythebill.birdlist.ui.taxonomy.ExtendedTaxonomyXmlImporter;
import com.scythebill.birdlist.ui.taxonomy.TaxonomyWithChecklists;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.DesktopUtils;
import com.scythebill.birdlist.ui.util.FileDialogs;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import org.xml.sax.SAXException;

public class TaxonomyManagementPanel
extends JPanel
implements FontManager.FontsUpdatedListener,
ShrinkToFit,
Titled {
    private final ReportSet reportSet;
    private final TaxonomyStore taxonomyStore;
    private final ExtendedTaxonomyAdder extendedTaxonomyAdder;
    private final FontManager fontManager;
    private final FileDialogs fileDialogs;
    private final Alerts alerts;
    private JPanel centerBox;
    private JButton addTaxonomy;
    private JButton removeTaxonomy;
    private JButton exportTaxonomy;
    private JButton exportTaxonomyAsCsv;
    private JButton downloadTaxonomies;
    private JButton returnButton;
    private JLabel addTaxonomyLabel;
    private JLabel exportTaxonomyLabel;
    private JLabel exportTaxonomyAsCsvLabel;
    private JLabel removeTaxonomyLabel;
    private JLabel downloadTaxonomiesLabel;
    private JLabel emptyLabel;

    @Inject
    public TaxonomyManagementPanel(ReturnAction returnAction, ReportSet reportSet, TaxonomyStore taxonomyStore, ExtendedTaxonomyAdder extendedTaxonomyAdder, FileDialogs fileDialogs, Alerts alerts, FontManager fontManager, EventBusRegistrar eventBusRegistrar) {
        this.reportSet = reportSet;
        this.extendedTaxonomyAdder = extendedTaxonomyAdder;
        this.fileDialogs = fileDialogs;
        this.taxonomyStore = taxonomyStore;
        this.alerts = alerts;
        this.fontManager = fontManager;
        this.initGUI();
        this.exportTaxonomy.addActionListener(e -> this.exportTaxonomyAsXml(this.augmentWithChecklists(this.taxonomyStore.getTaxonomy())));
        this.exportTaxonomyAsCsv.addActionListener(e -> this.exportTaxonomyAsCsv(this.augmentWithChecklists(this.taxonomyStore.getTaxonomy())));
        this.addTaxonomy.addActionListener(e -> this.addTaxonomy());
        this.removeTaxonomy.addActionListener(e -> this.removeTaxonomy(this.taxonomyStore.getTaxonomy()));
        this.downloadTaxonomies.addActionListener(event -> DesktopUtils.openUrlInBrowser(URI.create("https://www.scythebill.com/download.html#extended"), alerts));
        this.returnButton.setAction(returnAction);
        eventBusRegistrar.registerWhenInHierarchy(this);
        this.updateUiForTaxonomy();
    }

    private TaxonomyWithChecklists augmentWithChecklists(Taxonomy taxonomy) {
        ExtendedTaxonomyChecklists checklists = this.reportSet.getExtendedTaxonomyChecklist(taxonomy.getId());
        return new TaxonomyWithChecklists(taxonomy, checklists);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTaxonomy() {
        File openFile = this.fileDialogs.openFile((Frame)SwingUtilities.getWindowAncestor(this), Messages.getMessage(Messages.Name.OPEN_A_TAXONOMY), new FileFilter(){

            @Override
            public String getDescription() {
                return Messages.getMessage(Messages.Name.BTXM_OR_CSV_FILES);
            }

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith(".csv") || f.getName().endsWith(".btxm");
            }
        }, FilePreferences.FileType.OTHER);
        if (openFile == null) {
            return;
        }
        try (BufferedReader in = Files.newReader(openFile, StandardCharsets.UTF_8);){
            TaxonomyWithChecklists taxonomy = openFile.getName().endsWith(".btxm") ? new ExtendedTaxonomyXmlImporter().readExtendedTaxonomy(in) : new ExtendedTaxonomyCsvImporter().readExtendedTaxonomy(in);
            this.extendedTaxonomyAdder.addTaxonomy(this, taxonomy);
        }
        catch (IOException | SAXException e) {
            this.alerts.showError((Object)this, (Throwable)e, Messages.Name.IMPORT_FAILED, Messages.Name.IMPORTING_TAXONOMY_FAILED_FORMAT, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportTaxonomyAsXml(TaxonomyWithChecklists extendedTaxonomy) {
        block5: {
            String fileName = extendedTaxonomy.taxonomy.getId() + ".btxm";
            try {
                File saveFile = this.fileDialogs.saveFile((Frame)SwingUtilities.getWindowAncestor(this), Messages.getMessage(Messages.Name.SAVE_TAXONOMY), fileName, null, FilePreferences.FileType.OTHER);
                if (saveFile == null) break block5;
                saveFile.createNewFile();
                try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(saveFile)), StandardCharsets.UTF_8);){
                    new ExtendedTaxonomyXmlExporter().writeExtendedTaxonomy(extendedTaxonomy, out);
                }
            }
            catch (IOException e) {
                this.alerts.showError((Object)this, Messages.Name.EXPORT_FAILED_TITLE, Messages.Name.EXPORT_FAILED_MESSAGE, e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportTaxonomyAsCsv(TaxonomyWithChecklists extendedTaxonomy) {
        block5: {
            String fileName = extendedTaxonomy.taxonomy.getId() + ".csv";
            try {
                File saveFile = this.fileDialogs.saveFile((Frame)SwingUtilities.getWindowAncestor(this), Messages.getMessage(Messages.Name.SAVE_TAXONOMY_AS_CSV), fileName, null, FilePreferences.FileType.OTHER);
                if (saveFile == null) break block5;
                saveFile.createNewFile();
                try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(saveFile)), StandardCharsets.UTF_8);){
                    new ExtendedTaxonomyCsvExporter().writeExtendedTaxonomy(extendedTaxonomy.taxonomy, extendedTaxonomy.checklists, out);
                }
            }
            catch (IOException e) {
                this.alerts.showError((Object)this, Messages.Name.EXPORT_FAILED_TITLE, Messages.Name.EXPORT_FAILED_MESSAGE, e.getMessage());
            }
        }
    }

    private void initGUI() {
        this.setLayout(new BoxLayout(this, 3));
        this.centerBox = new JPanel();
        this.add(this.centerBox);
        this.addTaxonomy = new JButton();
        this.addTaxonomy.setText(Messages.getMessage(Messages.Name.ADD_OR_UPGRADE_A_TAXONOMY));
        this.addTaxonomy.putClientProperty("Quaqua.Button.style", "bevel");
        this.exportTaxonomy = new JButton();
        this.exportTaxonomy.setText(Messages.getMessage(Messages.Name.EXPORT_THIS_TAXONOMY));
        this.exportTaxonomy.putClientProperty("Quaqua.Button.style", "bevel");
        this.exportTaxonomyAsCsv = new JButton();
        this.exportTaxonomyAsCsv.setText(Messages.getMessage(Messages.Name.EXPORT_THIS_TAXONOMY_AS_CSV));
        this.exportTaxonomyAsCsv.putClientProperty("Quaqua.Button.style", "bevel");
        this.removeTaxonomy = new JButton();
        this.removeTaxonomy.setText(Messages.getMessage(Messages.Name.DELETE_THIS_TAXONOMY));
        this.removeTaxonomy.putClientProperty("Quaqua.Button.style", "bevel");
        this.downloadTaxonomies = new JButton();
        this.downloadTaxonomies.setText(Messages.getMessage(Messages.Name.DOWNLOAD_TAXONOMIES));
        this.downloadTaxonomies.putClientProperty("Quaqua.Button.style", "bevel");
        this.returnButton = new JButton();
        this.returnButton.putClientProperty("Quaqua.Button.style", "bevel");
        this.addTaxonomyLabel = new JLabel(Messages.getMessage(Messages.Name.ADD_OR_UPGRADE_A_TAXONOMY_EXPLANATION));
        this.addTaxonomyLabel.putClientProperty("birdlist.plainLabel", true);
        this.exportTaxonomyLabel = new JLabel(Messages.getMessage(Messages.Name.EXPORT_THIS_TAXONOMY_EXPLANATION));
        this.exportTaxonomyLabel.putClientProperty("birdlist.plainLabel", true);
        this.exportTaxonomyAsCsvLabel = new JLabel(Messages.getMessage(Messages.Name.EXPORT_THIS_TAXONOMY_AS_CSV_EXPLANATION));
        this.exportTaxonomyAsCsvLabel.putClientProperty("birdlist.plainLabel", true);
        this.removeTaxonomyLabel = new JLabel(Messages.getMessage(Messages.Name.DELETE_THIS_TAXONOMY_EXPLANATION));
        this.removeTaxonomyLabel.putClientProperty("birdlist.plainLabel", true);
        this.downloadTaxonomiesLabel = new JLabel(Messages.getMessage(Messages.Name.DOWNLOAD_TAXONOMIES_EXPLANATION));
        this.downloadTaxonomiesLabel.putClientProperty("birdlist.plainLabel", true);
        this.emptyLabel = new JLabel();
        this.fontManager.applyTo(this);
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        this.centerBox.setPreferredSize(fontManager.scale(new Dimension(700, 600)));
        this.centerBox.setMinimumSize(this.centerBox.getPreferredSize());
        this.centerBox.setBorder(new EmptyBorder(fontManager.scale(20), fontManager.scale(60), fontManager.scale(20), fontManager.scale(60)));
        GroupLayout layout = new GroupLayout(this.centerBox);
        this.centerBox.setLayout(layout);
        layout.setHorizontalGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.addTaxonomy, GroupLayout.Alignment.LEADING, -2, fontManager.scale(220), -2).addComponent(this.exportTaxonomy, GroupLayout.Alignment.LEADING, -2, fontManager.scale(220), -2).addComponent(this.exportTaxonomyAsCsv, GroupLayout.Alignment.LEADING, -2, fontManager.scale(220), -2).addComponent(this.removeTaxonomy, GroupLayout.Alignment.LEADING, -2, fontManager.scale(220), -2).addComponent(this.downloadTaxonomies, GroupLayout.Alignment.LEADING, -2, fontManager.scale(220), -2).addComponent(this.returnButton, GroupLayout.Alignment.LEADING, -2, fontManager.scale(220), -2)).addGap(63).addGroup(layout.createParallelGroup().addComponent(this.addTaxonomyLabel).addComponent(this.exportTaxonomyLabel).addComponent(this.exportTaxonomyAsCsvLabel).addComponent(this.removeTaxonomyLabel).addComponent(this.downloadTaxonomiesLabel).addComponent(this.emptyLabel)))).addContainerGap(67, 67));
        layout.setVerticalGroup(layout.createSequentialGroup().addGap(this.reportSet.getSightings().isEmpty() ? 0 : fontManager.scale(24)).addGroup(layout.createBaselineGroup(false, false).addComponent(this.addTaxonomy, GroupLayout.Alignment.BASELINE, -2, fontManager.scale(58), -2).addComponent(this.addTaxonomyLabel, GroupLayout.Alignment.BASELINE, -2, -2, -2)).addGap(14).addGroup(layout.createBaselineGroup(false, false).addComponent(this.exportTaxonomy, GroupLayout.Alignment.BASELINE, -2, fontManager.scale(58), -2).addComponent(this.exportTaxonomyLabel, GroupLayout.Alignment.BASELINE, -2, -2, -2)).addGap(14).addGroup(layout.createBaselineGroup(false, false).addComponent(this.exportTaxonomyAsCsv, GroupLayout.Alignment.BASELINE, -2, fontManager.scale(58), -2).addComponent(this.exportTaxonomyAsCsvLabel, GroupLayout.Alignment.BASELINE, -2, -2, -2)).addGap(14).addGroup(layout.createBaselineGroup(false, false).addComponent(this.removeTaxonomy, GroupLayout.Alignment.BASELINE, -2, fontManager.scale(58), -2).addComponent(this.removeTaxonomyLabel, GroupLayout.Alignment.BASELINE, -2, -2, -2)).addGap(14).addGroup(layout.createBaselineGroup(false, false).addComponent(this.downloadTaxonomies, GroupLayout.Alignment.BASELINE, -2, fontManager.scale(58), -2).addComponent(this.downloadTaxonomiesLabel, GroupLayout.Alignment.BASELINE, -2, -2, -2)).addGap(14).addGroup(layout.createBaselineGroup(false, false).addComponent(this.returnButton, GroupLayout.Alignment.BASELINE, -2, fontManager.scale(58), -2).addComponent(this.emptyLabel)).addContainerGap(82, 82));
        layout.linkSize(this.addTaxonomy, this.exportTaxonomy, this.exportTaxonomyAsCsv, this.removeTaxonomy, this.downloadTaxonomies, this.returnButton);
    }

    @Subscribe
    public void taxonomyChanged(TaxonomyChangedEvent event) {
        this.updateUiForTaxonomy();
    }

    private void updateUiForTaxonomy() {
        boolean isBirds = this.taxonomyStore.isBirdTaxonomy();
        this.exportTaxonomy.setEnabled(!isBirds);
        this.exportTaxonomyLabel.setEnabled(!isBirds);
        this.exportTaxonomyAsCsv.setEnabled(!isBirds);
        this.exportTaxonomyAsCsvLabel.setEnabled(!isBirds);
        this.removeTaxonomy.setEnabled(!isBirds);
        this.removeTaxonomyLabel.setEnabled(!isBirds);
    }

    private void removeTaxonomy(Taxonomy taxonomy) {
        int okOrCancel = this.alerts.showOkCancel((Object)this, Messages.Name.REMOVE_TAXONOMY_TITLE, Messages.Name.REMOVE_TAXONOMY_MESSAGE, taxonomy.getName());
        if (okOrCancel == 0) {
            ArrayList<Sighting> sightingsToDelete = Lists.newArrayList();
            for (Sighting sighting : this.reportSet.getSightings()) {
                if (sighting.getTaxonomy() != taxonomy) continue;
                sightingsToDelete.add(sighting);
            }
            this.reportSet.mutator().removing(sightingsToDelete).mutate();
            this.reportSet.removeExtendedTaxonomy(taxonomy);
            this.taxonomyStore.extendedTaxonomyRemoved();
        }
    }

    @Override
    public String getTitle() {
        return Messages.getMessage(Messages.Name.MANAGE_TAXONOMIES);
    }
}

