/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.taxonomy;

import com.scythebill.birdlist.model.checklist.ExtendedTaxonomyChecklists;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.xml.ExtendedTaxonomyNodeParser;
import com.scythebill.birdlist.ui.taxonomy.TaxonomyWithChecklists;
import com.scythebill.xml.BaseNodeParser;
import com.scythebill.xml.NodeParser;
import com.scythebill.xml.ParseContext;
import com.scythebill.xml.TreeBuilder;
import java.io.IOException;
import java.io.Reader;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ExtendedTaxonomyXmlImporter {
    public static final String FILE_SUFFIX = ".btxm";

    public TaxonomyWithChecklists readExtendedTaxonomy(Reader in) throws IOException, SAXException {
        TreeBuilder<TaxonomyWithChecklists> builder = new TreeBuilder<TaxonomyWithChecklists>(null, TaxonomyWithChecklists.class);
        return builder.parse(new InputSource(in), new RootNodeParser());
    }

    static class RootNodeParser
    extends BaseNodeParser {
        private Taxonomy taxonomy;
        private ExtendedTaxonomyChecklists checklists;

        RootNodeParser() {
        }

        @Override
        public void addCompletedChild(ParseContext context, String namespaceURI, String localName, Object child) throws SAXParseException {
            if (child instanceof Taxonomy) {
                this.taxonomy = (Taxonomy)child;
                this.checklists = ExtendedTaxonomyNodeParser.endChecklistParsing(context);
            }
        }

        @Override
        public NodeParser startChildElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
            if ("taxonomy".equals(localName)) {
                if (this.taxonomy != null) {
                    throw new SAXParseException("Multiple extended taxonomies in a single .btxm file", context.getLocator());
                }
                ExtendedTaxonomyNodeParser.startChecklistParsing(context);
                return new ExtendedTaxonomyNodeParser();
            }
            return null;
        }

        @Override
        public void startElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
            if (!"extended-taxonomy".equals(localName)) {
                throw new SAXParseException("Unexpected root element: " + localName, context.getLocator());
            }
        }

        @Override
        public Object endElement(ParseContext context, String namespaceURI, String localName) throws SAXParseException {
            return new TaxonomyWithChecklists(this.taxonomy, this.checklists);
        }
    }
}

