/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.taxonomy;

import com.scythebill.birdlist.model.io.IndentingResponseWriter;
import com.scythebill.birdlist.model.io.ResponseWriter;
import com.scythebill.birdlist.model.io.XmlResponseWriter;
import com.scythebill.birdlist.model.xml.XmlTaxonExport;
import com.scythebill.birdlist.ui.taxonomy.TaxonomyWithChecklists;
import java.io.IOException;
import java.io.Writer;

public class ExtendedTaxonomyXmlExporter {
    static final String EXTENDED_TAXONOMY_ROOT = "extended-taxonomy";

    public void writeExtendedTaxonomy(TaxonomyWithChecklists extendedTaxonomy, Writer out) throws IOException {
        ResponseWriter rw = new XmlResponseWriter(out, "UTF-8");
        rw = new IndentingResponseWriter(rw);
        rw.startDocument();
        rw.startElement(EXTENDED_TAXONOMY_ROOT);
        rw.writeAttribute("xmlns", "http://www.adamwiner.com/checklist/1.0");
        rw.writeAttribute("version", "1.0");
        new XmlTaxonExport().withChecklists(extendedTaxonomy.checklists).writeTaxonomy(extendedTaxonomy.taxonomy, rw);
        rw.endElement(EXTENDED_TAXONOMY_ROOT);
        rw.endDocument();
        rw.flush();
    }
}

