/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.taxonomy;

import com.google.common.base.CaseFormat;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.scythebill.birdlist.model.checklist.ExtendedTaxonomyChecklists;
import com.scythebill.birdlist.model.io.CsvImportLines;
import com.scythebill.birdlist.model.io.ImportLines;
import com.scythebill.birdlist.model.sighting.SightingTaxons;
import com.scythebill.birdlist.model.taxa.Species;
import com.scythebill.birdlist.model.taxa.SpeciesImpl;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonImpl;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.TaxonomyImpl;
import com.scythebill.birdlist.ui.taxonomy.TaxonomyWithChecklists;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExtendedTaxonomyCsvImporter {
    private Integer rangeIndex;
    private Integer commonNameIndex;
    private Integer alternateCommonNameIndex;
    private Integer alternateScientificNameIndex;
    private Integer statusIndex;
    private Integer extinctIndex;
    private Integer notesIndex;
    private Integer locationCodesIndex;
    private Integer accountIdIndex;
    private static final Splitter ALTERNATE_NAME_SPLITTER = Splitter.on(CharMatcher.anyOf("/,\n\r")).omitEmptyStrings().trimResults(CharMatcher.whitespace());
    private static final ImmutableMap<String, Species.Status> STATUS_NAMES;

    public TaxonomyWithChecklists readExtendedTaxonomy(Reader in) throws IOException {
        String[] line;
        ImportLines importLines = CsvImportLines.fromReader(in);
        String id = null;
        String name = null;
        String credits = null;
        Object accountUrlFormat = null;
        String accountLinkTitle = null;
        while (true) {
            if ((line = this.trimAll(importLines.nextLine())) == null) {
                throw new EOFException("No records found");
            }
            if (line.length < 2) continue;
            if (this.lastNonEmptyEntry(line) > 2) break;
            if (Strings.isNullOrEmpty(line[0]) || Strings.isNullOrEmpty(line[1])) continue;
            String key = CharMatcher.javaLetter().retainFrom(line[0].toLowerCase());
            if ("id".equals(key) || "taxonomyid".equals(key)) {
                id = line[1];
                continue;
            }
            if ("name".equals(key)) {
                name = line[1];
                continue;
            }
            if ("credits".equals(key)) {
                credits = line[1];
                continue;
            }
            if ("accounturlformat".equals(key)) {
                accountUrlFormat = line[1];
                if (((String)accountUrlFormat).contains("{id}")) continue;
                accountUrlFormat = (String)accountUrlFormat + "{id}";
                continue;
            }
            if (!"accountlinktitle".equals(key)) continue;
            accountLinkTitle = line[1];
        }
        if (id == null) {
            throw new EOFException("No \"ID\" row was found.");
        }
        if (name == null) {
            throw new EOFException("No \"Name\" row was found.");
        }
        TaxonomyImpl taxonomy = new TaxonomyImpl(id, name, (String)accountUrlFormat, accountLinkTitle){

            @Override
            public boolean isBuiltIn() {
                return false;
            }
        };
        if (credits != null) {
            for (String credit : Splitter.on(CharMatcher.anyOf("\n\r")).omitEmptyStrings().split(credits)) {
                taxonomy.addAdditionalCredit(credit);
            }
        }
        TaxonImpl root = new TaxonImpl(Taxon.Type.classTaxon, taxonomy);
        root.setName(id);
        root.setCommonName(name);
        root.built();
        taxonomy.setRoot(root);
        Map<String, Integer> indexMap = this.toIndexMap(line);
        int orderIndex = this.getRequiredHeader(indexMap, "Order");
        int familyIndex = this.getRequiredHeader(indexMap, "Family");
        int speciesIndex = this.getRequiredHeader(indexMap, "Species");
        Integer genusIndex = indexMap.get("genus");
        Integer subspeciesIndex = indexMap.get("subspecies");
        this.commonNameIndex = this.getIndex(indexMap, "common", "commonname");
        this.rangeIndex = this.getIndex(indexMap, "range", "distribution");
        this.alternateCommonNameIndex = this.getIndex(indexMap, "alternate", "alternatecommon");
        this.alternateScientificNameIndex = this.getIndex(indexMap, "alternatescientific");
        this.statusIndex = this.getIndex(indexMap, "status");
        this.extinctIndex = this.getIndex(indexMap, "extinct");
        this.notesIndex = this.getIndex(indexMap, "notes");
        this.locationCodesIndex = this.getIndex(indexMap, "locationcodes");
        this.accountIdIndex = this.getIndex(indexMap, "accountid");
        ExtendedTaxonomyChecklists.Builder checklistsBuilder = new ExtendedTaxonomyChecklists.Builder();
        TaxonImpl currentOrder = null;
        TaxonImpl currentFamily = null;
        TaxonImpl currentGenus = null;
        TaxonImpl currentSpecies = null;
        while ((line = importLines.nextLine()) != null) {
            String speciesNamePlusSpace;
            String subspecies;
            String species;
            String genus;
            String family;
            String order = this.atIndex(line, orderIndex);
            if (!order.isEmpty()) {
                order = this.toInitialCaps(order);
                if (!(currentOrder != null && currentOrder.getName().equals(order) || (currentOrder = (TaxonImpl)root.findByName(order)) != null)) {
                    currentOrder = new TaxonImpl(Taxon.Type.order, root);
                    currentOrder.setName(order);
                    root.getContents().add(currentOrder);
                    if (this.atIndex(line, speciesIndex).isEmpty() && this.atIndex(line, familyIndex).isEmpty() && this.commonNameIndex != null && !this.atIndex(line, this.commonNameIndex).isEmpty()) {
                        currentOrder.setCommonName(this.atIndex(line, this.commonNameIndex));
                        if (this.accountIdIndex != null) {
                            currentOrder.setAccountId(Strings.emptyToNull(this.atIndex(line, this.accountIdIndex)));
                        }
                    }
                    currentFamily = null;
                    currentOrder.built();
                }
            }
            if (!(family = this.atIndex(line, familyIndex)).isEmpty()) {
                family = this.toInitialCaps(family);
                if (currentFamily == null || !currentFamily.getName().equals(family)) {
                    if (currentOrder == null) {
                        throw new IOException(String.format("Family \"%s\" found without any Order (line %,d)", family, importLines.lineNumber()));
                    }
                    currentFamily = (TaxonImpl)currentOrder.findByName(family);
                    if (currentFamily == null) {
                        currentFamily = new TaxonImpl(Taxon.Type.family, currentOrder);
                        currentFamily.setName(family);
                        currentOrder.getContents().add(currentFamily);
                        currentGenus = null;
                        if (this.atIndex(line, speciesIndex).isEmpty() && this.commonNameIndex != null && !this.atIndex(line, this.commonNameIndex).isEmpty()) {
                            currentFamily.setCommonName(this.atIndex(line, this.commonNameIndex));
                            if (this.accountIdIndex != null) {
                                currentFamily.setAccountId(Strings.emptyToNull(this.atIndex(line, this.accountIdIndex)));
                            }
                        }
                        currentFamily.built();
                    }
                }
            }
            String string = genus = genusIndex == null ? this.extractGenus(this.atIndex(line, speciesIndex), importLines) : this.atIndex(line, genusIndex);
            if (!genus.isEmpty()) {
                genus = this.toInitialCaps(genus);
                if (currentGenus == null || !currentGenus.getName().equals(genus)) {
                    if (currentFamily == null) {
                        throw new IOException(String.format("Genus \"%s\" found without any Family (line %,d)", genus, importLines.lineNumber()));
                    }
                    currentGenus = (TaxonImpl)currentFamily.findByName(genus);
                    if (currentGenus == null) {
                        currentGenus = new TaxonImpl(Taxon.Type.genus, currentFamily);
                        currentGenus.setName(genus);
                        currentFamily.getContents().add(currentGenus);
                        currentSpecies = null;
                        currentGenus.built();
                    }
                }
            }
            String string2 = species = genusIndex == null ? this.extractSpecies(this.atIndex(line, speciesIndex)) : this.atIndex(line, speciesIndex);
            if (!species.isEmpty()) {
                species = species.toLowerCase();
                if (currentSpecies == null || !currentSpecies.getName().equals(species)) {
                    String locationCodes;
                    boolean hasSubspeciesInThisLine;
                    if (currentGenus == null) {
                        throw new IOException(String.format("Species \"%s\" found without any Genus (line %,d)", species, importLines.lineNumber()));
                    }
                    this.checkNotAlreadyPresent(importLines, currentGenus, species, "A Species");
                    currentSpecies = new SpeciesImpl(Taxon.Type.species, currentGenus);
                    currentSpecies.setName(species);
                    boolean bl = hasSubspeciesInThisLine = subspeciesIndex != null && !this.atIndex(line, subspeciesIndex).isEmpty();
                    if (!hasSubspeciesInThisLine) {
                        this.setAdditionalFields((SpeciesImpl)currentSpecies, line);
                    }
                    currentGenus.getContents().add(currentSpecies);
                    currentSpecies.built();
                    if (this.locationCodesIndex != null && !(locationCodes = this.atIndex(line, this.locationCodesIndex)).isEmpty()) {
                        checklistsBuilder.addEntries(SightingTaxons.newSightingTaxon(currentSpecies.getId()), ((SpeciesImpl)currentSpecies).getStatus(), Splitter.on(',').splitToList(locationCodes));
                    }
                }
            }
            if (subspeciesIndex == null || (subspecies = this.atIndex(line, subspeciesIndex)).isEmpty()) continue;
            if (subspecies.indexOf(32) >= 0 && subspecies.startsWith(speciesNamePlusSpace = TaxonUtils.getFullName(currentSpecies) + " ")) {
                subspecies = subspecies.substring(speciesNamePlusSpace.length());
            }
            if (currentSpecies == null) {
                throw new IOException(String.format("Subspecies \"%s\" found without any Species (line %,d)", subspecies, importLines.lineNumber()));
            }
            this.checkNotAlreadyPresent(importLines, currentSpecies, subspecies, "A Subspecies");
            SpeciesImpl currentSubspecies = new SpeciesImpl(Taxon.Type.subspecies, currentSpecies);
            currentSubspecies.setName(subspecies);
            this.setAdditionalFields(currentSubspecies, line);
            currentSpecies.getContents().add(currentSubspecies);
            currentSubspecies.built();
        }
        return new TaxonomyWithChecklists(taxonomy, checklistsBuilder.build());
    }

    private String atIndex(String[] line, int index) {
        if (line.length <= index) {
            return "";
        }
        return line[index];
    }

    private String[] trimAll(String[] nextLine) {
        for (int i = 0; i < nextLine.length; ++i) {
            nextLine[i] = CharMatcher.whitespace().trimFrom(nextLine[i]);
        }
        return nextLine;
    }

    private int lastNonEmptyEntry(String[] line) {
        int lastNonEmptyEntry = -1;
        for (int i = 0; i < line.length; ++i) {
            if (Strings.isNullOrEmpty(line[i])) continue;
            lastNonEmptyEntry = i;
        }
        return lastNonEmptyEntry;
    }

    private int getRequiredHeader(Map<String, Integer> indexMap, String key) throws IOException {
        Integer index = indexMap.get(key.toLowerCase());
        if (index == null) {
            throw new IOException("No \"" + key + "\" header was found.");
        }
        return index;
    }

    private void checkNotAlreadyPresent(ImportLines importLines, Taxon parent, String childName, String childType) throws IOException {
        if (parent.findByName(childName) != null) {
            throw new IOException(String.format("%s named \"%s\" was already added to %s (line %s)", childType, childName, parent.getName(), importLines.lineNumber()));
        }
    }

    private String toInitialCaps(String name) {
        boolean wrappedInQuotes = false;
        if (((String)name).startsWith("\"") && ((String)name).endsWith("\"") && ((String)name).length() >= 2) {
            wrappedInQuotes = true;
            name = ((String)name).substring(1, ((String)name).length() - 1);
        }
        name = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, (String)name);
        if (wrappedInQuotes) {
            name = "\"" + (String)name + "\"";
        }
        return name;
    }

    private String extractGenus(String genusAndSpecies, ImportLines importLines) throws IOException {
        if (genusAndSpecies.isEmpty()) {
            return "";
        }
        int space = genusAndSpecies.indexOf(32);
        if (space < 0) {
            throw new IOException(String.format("Expected a genus and a species, but only found \"%s\" (line %,d)", genusAndSpecies, importLines.lineNumber()));
        }
        return genusAndSpecies.substring(0, space);
    }

    private String extractSpecies(String genusAndSpecies) {
        int space = genusAndSpecies.indexOf(32);
        if (space < 0) {
            return "";
        }
        return genusAndSpecies.substring(space + 1);
    }

    private Integer getIndex(Map<String, Integer> indexMap, String ... possibleNames) {
        for (String possibleName : possibleNames) {
            Integer index = indexMap.get(possibleName);
            if (index == null) continue;
            return index;
        }
        return null;
    }

    private void setAdditionalFields(SpeciesImpl species, String[] line) {
        String notes;
        String extinct;
        Species.Status statusEnum;
        String status;
        String alternateSciNames;
        String alternateCommonNames;
        String range;
        String commonName;
        if (this.commonNameIndex != null && !(commonName = this.atIndex(line, this.commonNameIndex)).isEmpty()) {
            if (this.alternateCommonNameIndex != null) {
                species.setCommonName(commonName);
            } else {
                List<String> commonNames = ALTERNATE_NAME_SPLITTER.splitToList(commonName);
                if (!commonNames.isEmpty()) {
                    species.setCommonName(commonNames.get(0));
                    if (commonNames.size() > 1) {
                        species.setAlternateCommonNames(commonNames.subList(1, commonNames.size()));
                    }
                }
            }
        }
        if (this.accountIdIndex != null) {
            species.setAccountId(Strings.emptyToNull(this.atIndex(line, this.accountIdIndex)));
        }
        if (this.rangeIndex != null && !(range = this.atIndex(line, this.rangeIndex)).isEmpty()) {
            species.setRange(range);
        }
        if (this.alternateCommonNameIndex != null && !(alternateCommonNames = this.atIndex(line, this.alternateCommonNameIndex)).isEmpty()) {
            species.setAlternateCommonNames(ALTERNATE_NAME_SPLITTER.splitToList(alternateCommonNames));
        }
        if (this.alternateScientificNameIndex != null && !(alternateSciNames = this.atIndex(line, this.alternateScientificNameIndex)).isEmpty()) {
            species.setAlternateNames(ALTERNATE_NAME_SPLITTER.splitToList(alternateSciNames));
        }
        if (this.statusIndex != null && !(status = this.atIndex(line, this.statusIndex).toUpperCase()).isEmpty() && (statusEnum = STATUS_NAMES.get(status)) != null) {
            species.setStatus(statusEnum);
        }
        if (!(this.extinctIndex == null || (extinct = this.atIndex(line, this.extinctIndex).toUpperCase()).isEmpty() || extinct.equals("0") || extinct.equals("N"))) {
            species.setStatus(Species.Status.EX);
        }
        if (this.notesIndex != null && !(notes = this.atIndex(line, this.notesIndex)).isEmpty()) {
            species.setTaxonomicInfo(notes);
        }
    }

    private Map<String, Integer> toIndexMap(String[] header) {
        HashMap<String, Integer> indexMap = Maps.newHashMapWithExpectedSize(header.length);
        for (int i = 0; i < header.length; ++i) {
            String name = CharMatcher.javaLetter().retainFrom(header[i]).toLowerCase();
            indexMap.put(name, i);
        }
        return indexMap;
    }

    static {
        ImmutableMap.Builder<String, Species.Status> builder = ImmutableMap.builder();
        for (Species.Status status : Species.Status.values()) {
            if (status.name() == null) continue;
            builder.put(status.name(), status);
        }
        STATUS_NAMES = builder.build();
    }
}

