/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.taxonomy;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.TreeMultimap;
import com.scythebill.birdlist.model.checklist.ExtendedTaxonomyChecklists;
import com.scythebill.birdlist.model.io.CsvExportLines;
import com.scythebill.birdlist.model.io.ExportLines;
import com.scythebill.birdlist.model.taxa.Species;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.TaxonVisitor;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.xml.ExtendedTaxonomyParsing;
import java.io.IOException;
import java.io.Writer;

public class ExtendedTaxonomyCsvExporter {
    private static final ImmutableList<String> HEADER_LINE = ImmutableList.of("Order", "Family", "Genus", "Species", "Subspecies", "Common", "Alternate Common", "Alternate Scientific", "Range", "Status", "Notes", "Account ID", new String[0]);
    private static final ImmutableList<String> HEADER_LINE_WITH_CHECKLISTS = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(HEADER_LINE)).add("Location Codes")).build();
    private static final Joiner ALTERNATE_NAME_JOINER = Joiner.on('/');
    private static final Joiner LOCATION_CODE_JOINER = Joiner.on(',');
    private static final ImmutableSet<Taxon.Type> NOT_EXPORTED_TYPES = ImmutableSet.of(Taxon.Type.classTaxon, Taxon.Type.phylum, Taxon.Type.group, Taxon.Type.genus);
    static final String EXTENDED_TAXONOMY_ROOT = "extended-taxonomy";

    public void writeExtendedTaxonomy(final Taxonomy extendedTaxonomy, ExtendedTaxonomyChecklists checklists, Writer out) throws IOException {
        String accountLinkTitle;
        String accountUrl;
        final ExportLines export = CsvExportLines.fromWriter(out);
        export.nextLine(new String[]{"Taxonomy ID", extendedTaxonomy.getId()});
        export.nextLine(new String[]{"Name", extendedTaxonomy.getName()});
        ImmutableList<String> additionalCredits = ImmutableList.copyOf(extendedTaxonomy.additionalCredits());
        if (!additionalCredits.isEmpty()) {
            export.nextLine(new String[]{"Credits", Joiner.on('\n').join(additionalCredits)});
        }
        if ((accountUrl = extendedTaxonomy.getTaxonAccountUrl("d33db33f")) != null) {
            export.nextLine(new String[]{"Account URL Format", accountUrl.replace("d33db33f", "{id}")});
        }
        if ((accountLinkTitle = extendedTaxonomy.getAccountLinkTitle()) != null) {
            export.nextLine(new String[]{"Account Link Title", accountLinkTitle});
        }
        final boolean hasChecklists = checklists != null && !checklists.getChecklists().isEmpty();
        final String[] header = hasChecklists ? HEADER_LINE_WITH_CHECKLISTS.toArray(new String[0]) : HEADER_LINE.toArray(new String[0]);
        export.nextLine(header);
        final TreeMultimap<String, String> transposedChecklists = hasChecklists ? ExtendedTaxonomyParsing.buildTransposedChecklistWithStatuses(checklists.getChecklists(), extendedTaxonomy) : null;
        class State
        implements TaxonVisitor {
            String currentOrder;
            String currentFamily;
            String currentGenus;
            String currentSpecies;

            State() {
            }

            void run() {
                TaxonUtils.visitTaxa(extendedTaxonomy.getRoot(), (TaxonVisitor)this);
            }

            @Override
            public boolean visitTaxon(Taxon taxon) {
                if (NOT_EXPORTED_TYPES.contains((Object)taxon.getType())) {
                    return true;
                }
                String[] line = new String[header.length];
                if (taxon.getCommonName() != null) {
                    line[5] = taxon.getCommonName();
                }
                line[11] = taxon.getAccountId();
                if (taxon.getType() == Taxon.Type.order) {
                    this.currentOrder = line[0] = taxon.getName();
                } else if (taxon.getType() == Taxon.Type.family) {
                    this.currentFamily = line[1] = taxon.getName();
                    line[5] = taxon.getCommonName();
                } else {
                    Taxon species;
                    Preconditions.checkArgument(taxon.getType().compareTo(Taxon.Type.species) <= 0);
                    Taxon genus = TaxonUtils.getParentOfTypeOrNull(taxon, Taxon.Type.genus);
                    if (!genus.getName().equals(this.currentGenus)) {
                        Taxon order;
                        this.currentGenus = line[2] = genus.getName();
                        Taxon family = TaxonUtils.getParentOfTypeOrNull(taxon, Taxon.Type.family);
                        if (family != null && !family.getName().equals(this.currentFamily)) {
                            this.currentFamily = line[1] = family.getName();
                        }
                        if ((order = TaxonUtils.getParentOfTypeOrNull(taxon, Taxon.Type.order)) != null && !order.getName().equals(this.currentOrder)) {
                            this.currentOrder = line[0] = order.getName();
                        }
                    }
                    if (taxon.getType() == Taxon.Type.subspecies) {
                        species = TaxonUtils.getParentOfTypeOrNull(taxon, Taxon.Type.species);
                        if (species != null && !species.getName().equals(this.currentSpecies)) {
                            this.currentSpecies = line[3] = species.getName();
                        }
                        line[4] = taxon.getName();
                    } else if (taxon.getType() == Taxon.Type.species) {
                        this.currentSpecies = line[3] = taxon.getName();
                    }
                    if (taxon instanceof Species) {
                        String notes;
                        Species.Status status;
                        species = (Species)taxon;
                        if (species.getRange() != null) {
                            line[8] = species.getRange();
                        }
                        if ((status = species.getStatus()) != Species.Status.LC) {
                            line[9] = status.name();
                        }
                        if ((notes = species.getTaxonomicInfo()) != null) {
                            line[10] = notes;
                        }
                        line[6] = ALTERNATE_NAME_JOINER.join(species.getAlternateCommonNames());
                        line[7] = ALTERNATE_NAME_JOINER.join(species.getAlternateNames());
                        if (hasChecklists) {
                            line[12] = LOCATION_CODE_JOINER.join(transposedChecklists.get(taxon.getId()));
                        }
                    }
                }
                try {
                    export.nextLine(line);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return true;
            }
        }
        new State().run();
    }
}

