/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.taxonomy;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.checklist.ExtendedTaxonomyChecklists;
import com.scythebill.birdlist.model.export.FullReportExport;
import com.scythebill.birdlist.model.io.PartialIO;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.SightingTaxons;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.taxa.TaxonomyImpl;
import com.scythebill.birdlist.model.taxa.names.LocalNames;
import com.scythebill.birdlist.model.taxa.names.NamesPreferences;
import com.scythebill.birdlist.model.util.TaxonomyIndexer;
import com.scythebill.birdlist.ui.events.TaxonomyStore;
import com.scythebill.birdlist.ui.imports.TaxonPossibilities;
import com.scythebill.birdlist.ui.imports.TaxonResolver;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.FilePreferences;
import com.scythebill.birdlist.ui.taxonomy.TaxonomyWithChecklists;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.FileDialogs;
import com.scythebill.birdlist.ui.util.UIUtils;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import javax.swing.filechooser.FileFilter;
import org.joda.time.LocalDate;

public class ExtendedTaxonomyAdder {
    private final TaxonomyStore taxonomyStore;
    private final ReportSet reportSet;
    private final Alerts alerts;
    private final FileDialogs fileDialogs;
    private final NamesPreferences namesPreferences;

    @Inject
    ExtendedTaxonomyAdder(TaxonomyStore taxonomyStore, ReportSet reportSet, FileDialogs fileDialogs, Alerts alerts, NamesPreferences namesPreferences) {
        this.taxonomyStore = taxonomyStore;
        this.reportSet = reportSet;
        this.fileDialogs = fileDialogs;
        this.alerts = alerts;
        this.namesPreferences = namesPreferences;
    }

    public void addTaxonomy(Component component, TaxonomyWithChecklists taxonomyWithChecklists) {
        this.addTaxonomy(component, taxonomyWithChecklists.taxonomy, taxonomyWithChecklists.checklists);
    }

    private void addTaxonomy(Component component, Taxonomy taxonomy, ExtendedTaxonomyChecklists checklists) {
        new TaxonomyIndexer(Futures.immediateFuture(taxonomy)).load(MoreExecutors.newDirectExecutorService());
        ((TaxonomyImpl)taxonomy).setLocalNames(LocalNames.trival(this.namesPreferences));
        if (this.reportSet.getExtendedTaxonomy(taxonomy.getId()) != null) {
            this.upgradeTaxonomies(component, this.reportSet.getExtendedTaxonomy(taxonomy.getId()), taxonomy, checklists);
        } else {
            this.reportSet.addExtendedTaxonomy(taxonomy, checklists);
            if (taxonomy.additionalCredits().isEmpty()) {
                this.alerts.showMessage((Object)component, Messages.Name.ADDED_TAXONOMY_SUCCESSFULLY_TITLE, Messages.Name.ADDED_TAXONOMY_SUCCESSFULLY_MESSAGE, taxonomy.getName(), taxonomy.getSpeciesCount());
            } else {
                this.alerts.showMessage((Object)component, Messages.Name.ADDED_TAXONOMY_SUCCESSFULLY_TITLE, Messages.Name.ADDED_TAXONOMY_SUCCESSFULLY_WITH_CREDITS_MESSAGE, taxonomy.getName(), taxonomy.getSpeciesCount(), Joiner.on('\n').join(taxonomy.additionalCredits()));
            }
            this.taxonomyStore.extendedTaxonomiesChanged();
            this.reportSet.markDirty();
        }
    }

    private void upgradeTaxonomies(Component component, Taxonomy fromTaxonomy, Taxonomy toTaxonomy, ExtendedTaxonomyChecklists checklists) {
        ArrayList<Sighting> existingSightings = Lists.newArrayList(this.reportSet.getSightings(fromTaxonomy));
        if (existingSightings.isEmpty()) {
            this.reportSet.removeExtendedTaxonomy(fromTaxonomy);
            this.reportSet.addExtendedTaxonomy(toTaxonomy, checklists);
        } else {
            TaxonResolver taxonResolver = new TaxonResolver(toTaxonomy);
            ArrayList<Sighting> upgradedSightings = Lists.newArrayList();
            ArrayList<Sighting> failedUpgrades = Lists.newArrayList();
            for (Sighting sighting : existingSightings) {
                SightingTaxon upgradedTaxon;
                SightingTaxon.Resolved resolved = sighting.getTaxon().resolve(fromTaxonomy);
                if (resolved.getType() == SightingTaxon.Type.SINGLE) {
                    SightingTaxon toTaxon = this.resolveTaxon(taxonResolver, resolved.getTaxon(), toTaxonomy);
                    if (toTaxon == null) {
                        failedUpgrades.add(sighting);
                        continue;
                    }
                    Sighting upgradedSighting = sighting.asBuilder().setTaxon(toTaxon).setTaxonomy(toTaxonomy).build();
                    upgradedSightings.add(upgradedSighting);
                    continue;
                }
                LinkedHashSet<String> taxonIds = Sets.newLinkedHashSet();
                for (Taxon taxon : resolved.getTaxa()) {
                    SightingTaxon toTaxon = this.resolveTaxon(taxonResolver, taxon, toTaxonomy);
                    if (toTaxon == null) continue;
                    taxonIds.addAll(toTaxon.getIds());
                }
                if (taxonIds.isEmpty()) {
                    failedUpgrades.add(sighting);
                    continue;
                }
                if (taxonIds.size() == 1) {
                    String id = (String)taxonIds.iterator().next();
                    upgradedTaxon = SightingTaxons.newSightingTaxon(id);
                } else {
                    upgradedTaxon = resolved.getType() == SightingTaxon.Type.HYBRID ? SightingTaxons.newHybridTaxon(taxonIds) : SightingTaxons.newSpTaxon(taxonIds);
                }
                Sighting upgradedSighting = sighting.asBuilder().setTaxon(upgradedTaxon).setTaxonomy(toTaxonomy).build();
                upgradedSightings.add(upgradedSighting);
            }
            Preconditions.checkState(failedUpgrades.size() + upgradedSightings.size() == existingSightings.size(), "Not all sightings upgraded");
            if (!failedUpgrades.isEmpty()) {
                int showOkCancel = this.alerts.showOkCancel((Object)component, Messages.Name.ADDED_TAXONOMY_SOME_SIGHTINGS_NOT_UPGRADED_TITLE, Messages.Name.ADDED_TAXONOMY_SOME_SIGHTINGS_NOT_UPGRADED_MESSAGE, fromTaxonomy.getName(), failedUpgrades.size(), upgradedSightings.size());
                if (showOkCancel != 0) {
                    return;
                }
                String defaultName = String.format("failed-%s-%s.csv", fromTaxonomy.getId(), PartialIO.toString(new LocalDate()));
                File saveFile = this.fileDialogs.saveFile(UIUtils.findFrame(component), Messages.getMessage(Messages.Name.SAVE_SIGHTINGS_THAT_FAILED_UPGRADE), defaultName, new FileFilter(){

                    @Override
                    public String getDescription() {
                        return Messages.getMessage(Messages.Name.CSV_FILES);
                    }

                    @Override
                    public boolean accept(File f) {
                        return f.getName().endsWith(".csv");
                    }
                }, FilePreferences.FileType.OTHER);
                if (saveFile == null) {
                    return;
                }
                try {
                    new FullReportExport().exportExplicitSightings(Files.asByteSink(saveFile, new FileWriteMode[0]), this.reportSet, fromTaxonomy, failedUpgrades);
                }
                catch (IOException e) {
                    this.alerts.showError((Object)component, (Throwable)e, Messages.Name.SAVING_FAILED_TITLE, Messages.Name.SAVE_FAILED_ABORTING_UPGRADE, new Object[0]);
                    return;
                }
            }
            this.reportSet.mutator().removing(existingSightings).mutate();
            this.reportSet.removeExtendedTaxonomy(fromTaxonomy);
            this.reportSet.addExtendedTaxonomy(toTaxonomy, checklists);
            this.reportSet.mutator().adding(upgradedSightings).mutate();
        }
        if (this.taxonomyStore.getTaxonomy() == fromTaxonomy) {
            this.taxonomyStore.setTaxonomy(toTaxonomy);
        } else {
            this.taxonomyStore.extendedTaxonomiesChanged();
        }
        this.reportSet.markDirty();
        this.alerts.showMessage((Object)component, Messages.Name.UPGRADED_TAXONOMY_SUCCESSFULLY_TITLE, Messages.Name.UPGRADED_TAXONOMY_SUCCESSFULLY_MESSAGE, toTaxonomy.getName(), toTaxonomy.getSpeciesCount());
    }

    private SightingTaxon resolveTaxon(TaxonResolver taxonResolver, Taxon taxon, Taxonomy toTaxonomy) {
        String subspecies;
        String sciName;
        Taxon species = TaxonUtils.getParentOfType(taxon, Taxon.Type.species);
        String commonName = species.getCommonName();
        TaxonPossibilities possibilities = taxonResolver.map(commonName, sciName = TaxonUtils.getFullName(species), subspecies = taxon.getType() == Taxon.Type.subspecies ? taxon.getName() : null);
        if (possibilities == null) {
            return null;
        }
        return possibilities.choose(null, toTaxonomy);
    }
}

