/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.prefs;

import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.util.Types;
import com.scythebill.birdlist.ui.prefs.ReportPreferencesManager;
import com.scythebill.birdlist.ui.prefs.ReportSetPreference;
import java.lang.reflect.Type;

public class ReportSetPreferencesModule<T>
extends AbstractModule {
    private final Class<T> clazz;

    private ReportSetPreferencesModule(Class<T> clazz) {
        this.clazz = clazz;
    }

    public static <T> Module forType(Class<T> clazz) {
        return new ReportSetPreferencesModule<T>(clazz);
    }

    @Override
    protected void configure() {
        final Provider<ReportPreferencesManager> managerProvider = this.getProvider(ReportPreferencesManager.class);
        this.bind(this.preferenceOf()).toProvider(new Provider<ReportSetPreference<T>>(){

            @Override
            public ReportSetPreference<T> get() {
                ReportPreferencesManager manager = (ReportPreferencesManager)managerProvider.get();
                Object value = manager.getPreference(ReportSetPreferencesModule.this.clazz);
                return new ReportSetPreference(value, manager);
            }
        });
        this.bind(this.clazz).toProvider(new Provider<T>(){

            @Override
            public T get() {
                ReportPreferencesManager manager = (ReportPreferencesManager)managerProvider.get();
                return manager.getPreference(ReportSetPreferencesModule.this.clazz);
            }
        });
    }

    Key<ReportSetPreference<T>> preferenceOf() {
        TypeLiteral<?> preferenceType = TypeLiteral.get(Types.newParameterizedType(ReportSetPreference.class, new Type[]{this.clazz}));
        return Key.get(preferenceType);
    }
}

