/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.prefs;

import com.google.common.base.Strings;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.MutableClassToInstanceMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.annotations.Preference;
import com.scythebill.birdlist.model.annotations.SerializeAsJson;
import com.scythebill.birdlist.model.sighting.ReportSet;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReportPreferencesManager {
    private static final Logger logger = Logger.getLogger(ReportPreferencesManager.class.getName());
    private final ClassToInstanceMap<Object> instances = MutableClassToInstanceMap.create();
    private final Gson gson;
    private final JsonObject json;
    private final ReportSet reportSet;

    @Inject
    public ReportPreferencesManager(ReportSet reportSet, Gson gson) {
        this.gson = gson;
        this.reportSet = reportSet;
        String preferencesJson = reportSet.getPreferencesJson();
        JsonObject json = new JsonObject();
        if (!Strings.isNullOrEmpty(preferencesJson)) {
            try {
                json = JsonParser.parseString(reportSet.getPreferencesJson()).getAsJsonObject();
            }
            catch (JsonParseException e) {
                logger.log(Level.WARNING, "Invalid JSON", e);
            }
        }
        this.json = json;
    }

    public synchronized <T> T getPreference(Class<T> type) {
        T instance = this.instances.getInstance(type);
        if (instance == null) {
            try {
                Constructor<T> constructor = type.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                instance = constructor.newInstance(new Object[0]);
                if (this.serializeTypeAsJson(type)) {
                    String classKey = type.getCanonicalName();
                    if (this.json.has(classKey)) {
                        JsonObject classPrefs = this.json.getAsJsonObject(type.getCanonicalName());
                        try {
                            instance = this.gson.fromJson((JsonElement)classPrefs, type);
                        }
                        catch (JsonParseException e) {
                            logger.log(Level.WARNING, "Failure parsing " + classKey, e);
                        }
                    }
                } else {
                    this.readPreferences(type, instance);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        this.instances.putInstance(type, instance);
        return instance;
    }

    public synchronized void save(boolean markDirty) {
        for (Map.Entry entry : this.instances.entrySet()) {
            try {
                this.savePreferences((Class)entry.getKey(), entry.getValue());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        this.reportSet.setPreferencesJson(this.gson.toJson(this.json), markDirty);
    }

    private void savePreferences(Class<?> type, Object instance) throws IllegalAccessException {
        String classKey = type.getCanonicalName();
        if (this.serializeTypeAsJson(type)) {
            JsonElement jsonTree = this.gson.toJsonTree(instance);
            this.json.add(classKey, jsonTree);
        } else {
            if (!this.json.has(classKey)) {
                this.json.add(classKey, new JsonObject());
            }
            JsonObject classPrefs = this.json.getAsJsonObject(classKey);
            for (Field f : type.getDeclaredFields()) {
                f.setAccessible(true);
                String fieldKey = f.getName();
                Preference annotation = f.getAnnotation(Preference.class);
                if (annotation == null) continue;
                Object value = f.get(instance);
                if (value == null) {
                    classPrefs.remove(fieldKey);
                    continue;
                }
                if (f.getType() == String.class) {
                    classPrefs.addProperty(fieldKey, (String)value);
                    continue;
                }
                if (f.getType().isEnum()) {
                    Enum enumValue = (Enum)value;
                    classPrefs.addProperty(fieldKey, enumValue.name());
                    continue;
                }
                if (f.getType() == Boolean.class || f.getType() == Boolean.TYPE) {
                    Boolean boolValue = (Boolean)value;
                    classPrefs.addProperty(fieldKey, boolValue);
                    continue;
                }
                if (f.getType() == Integer.class || f.getType() == Integer.TYPE) {
                    Integer intValue = (Integer)value;
                    classPrefs.addProperty(fieldKey, intValue);
                    continue;
                }
                if (f.getType() == Long.class || f.getType() == Long.TYPE) {
                    Long longValue = (Long)value;
                    classPrefs.addProperty(fieldKey, longValue);
                    continue;
                }
                if (this.serializeTypeAsJson(f.getType())) {
                    JsonElement jsonTree = this.gson.toJsonTree(value);
                    classPrefs.add(fieldKey, jsonTree);
                    continue;
                }
                throw new IllegalStateException("Unsupported preference type: " + f.getType().getSimpleName());
            }
        }
    }

    private void readPreferences(Class<?> type, Object instance) throws IllegalAccessException {
        String classKey = type.getCanonicalName();
        if (this.json.has(classKey)) {
            JsonObject classPrefs = this.json.getAsJsonObject(classKey);
            for (Field f : type.getDeclaredFields()) {
                f.setAccessible(true);
                String fieldKey = f.getName();
                Preference annotation = f.getAnnotation(Preference.class);
                if (annotation == null || !classPrefs.has(fieldKey)) continue;
                JsonElement fieldJson = classPrefs.get(fieldKey);
                if (f.getType() == String.class) {
                    String value = fieldJson.getAsString();
                    f.set(instance, value);
                    continue;
                }
                if (f.getType().isEnum()) {
                    Class<?> enumType = f.getType();
                    String stringValue = fieldJson.getAsString();
                    try {
                        Object enumValue = Enum.valueOf(enumType, stringValue);
                        f.set(instance, enumValue);
                    }
                    catch (IllegalArgumentException e) {
                        logger.warning("Ignoring preference (" + fieldKey + ") invalid value (" + stringValue + ")");
                    }
                    continue;
                }
                if (f.getType() == Boolean.class || f.getType() == Boolean.TYPE) {
                    try {
                        boolean boolValue = fieldJson.getAsBoolean();
                        f.set(instance, boolValue);
                    }
                    catch (IllegalArgumentException e) {
                        logger.log(Level.WARNING, "Ignoring preference (" + fieldKey + ")", e);
                    }
                    continue;
                }
                if (f.getType() == Integer.class || f.getType() == Integer.TYPE) {
                    try {
                        int intValue = fieldJson.getAsInt();
                        f.set(instance, intValue);
                    }
                    catch (IllegalArgumentException e) {
                        logger.log(Level.WARNING, "Ignoring preference (" + fieldKey + ")", e);
                    }
                    continue;
                }
                if (f.getType() == Long.class || f.getType() == Long.TYPE) {
                    try {
                        long longValue = fieldJson.getAsLong();
                        f.set(instance, longValue);
                    }
                    catch (IllegalArgumentException e) {
                        logger.log(Level.WARNING, "Ignoring preference (" + fieldKey + ")", e);
                    }
                    continue;
                }
                if (this.serializeTypeAsJson(f.getType())) {
                    try {
                        Object value = this.gson.fromJson(fieldJson, f.getType());
                        f.set(instance, value);
                    }
                    catch (JsonParseException e) {
                        logger.log(Level.WARNING, "Ignoring preference (" + fieldKey + ")", e);
                    }
                    continue;
                }
                throw new IllegalStateException("Unsupported preference type: " + f.getType().getSimpleName());
            }
        }
    }

    private boolean serializeTypeAsJson(Class<?> type) {
        return type.isAnnotationPresent(SerializeAsJson.class);
    }
}

