/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.prefs;

import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.MutableClassToInstanceMap;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.scythebill.birdlist.model.annotations.Preference;
import com.scythebill.birdlist.model.annotations.SerializeAsJson;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

@Singleton
public class PreferencesManager {
    private static final Logger logger = Logger.getLogger(PreferencesManager.class.getName());
    private final ClassToInstanceMap<Object> instances = MutableClassToInstanceMap.create();
    private final Gson gson;

    @Inject
    public PreferencesManager(Gson gson) {
        this.gson = gson;
    }

    public synchronized <T> T getPreference(Class<T> type) {
        T instance = this.instances.getInstance(type);
        if (instance == null) {
            try {
                Constructor<T> constructor = type.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                instance = constructor.newInstance(new Object[0]);
                this.readPreferences(type, instance);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        this.instances.putInstance(type, instance);
        return instance;
    }

    public synchronized <T> T getPreference(Class<T> type, Supplier<T> supplier) {
        T instance = this.instances.getInstance(type);
        if (instance == null) {
            try {
                instance = supplier.get();
                this.readPreferences(type, instance);
            }
            catch (IllegalAccessException | SecurityException e) {
                throw new RuntimeException(e);
            }
        }
        this.instances.putInstance(type, instance);
        return instance;
    }

    public synchronized void save() {
        for (Map.Entry entry : this.instances.entrySet()) {
            try {
                this.savePreferences((Class)entry.getKey(), entry.getValue());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (BackingStoreException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void savePreferences(Class<?> type, Object instance) throws IllegalAccessException, BackingStoreException {
        Preferences preferences = Preferences.userNodeForPackage(type);
        for (Field f : type.getDeclaredFields()) {
            String json;
            Object value;
            f.setAccessible(true);
            String key = this.getPreferenceKey(type, f);
            Preference annotation = f.getAnnotation(Preference.class);
            if (annotation == null) continue;
            if (f.getAnnotation(SerializeAsJson.class) != null) {
                value = f.get(instance);
                if (value == null) continue;
                json = this.gson.toJson(value);
                preferences.put(key, json);
                continue;
            }
            if (f.getType() == String.class) {
                value = (String)f.get(instance);
                if (value == null) {
                    preferences.remove(key);
                    continue;
                }
                preferences.put(key, (String)value);
                continue;
            }
            if (f.getType().isEnum()) {
                Enum enumValue = (Enum)f.get(instance);
                preferences.put(key, enumValue.name());
                continue;
            }
            if (f.getType() == Boolean.class || f.getType() == Boolean.TYPE) {
                Boolean boolValue = (Boolean)f.get(instance);
                if (boolValue == null) continue;
                preferences.putBoolean(key, boolValue);
                continue;
            }
            if (f.getType() == Integer.class || f.getType() == Integer.TYPE) {
                Integer intValue = (Integer)f.get(instance);
                if (intValue == null) continue;
                preferences.putInt(key, intValue);
                continue;
            }
            if (f.getType() == Long.class || f.getType() == Long.TYPE) {
                Long longValue = (Long)f.get(instance);
                if (longValue == null) continue;
                preferences.putLong(key, longValue);
                continue;
            }
            if (this.serializeTypeAsJson(f.getType())) {
                value = f.get(instance);
                if (value == null) continue;
                json = this.gson.toJson(value);
                preferences.put(key, json);
                continue;
            }
            throw new IllegalStateException("Unsupported preference type: " + f.getType().getSimpleName());
        }
        preferences.flush();
    }

    private void readPreferences(Class<?> type, Object instance) throws IllegalAccessException {
        Preferences preferences = Preferences.userNodeForPackage(type);
        for (Field f : type.getDeclaredFields()) {
            Object value;
            f.setAccessible(true);
            String key = this.getPreferenceKey(type, f);
            Preference annotation = f.getAnnotation(Preference.class);
            if (annotation == null) continue;
            Object defaultValue = f.get(instance);
            if (f.getAnnotation(SerializeAsJson.class) != null) {
                String stringValue = preferences.get(key, "");
                if (stringValue.isEmpty()) continue;
                try {
                    value = this.gson.fromJson(stringValue, f.getGenericType());
                    f.set(instance, value);
                }
                catch (JsonSyntaxException e) {
                    logger.warning("Ignoring preference (" + key + ") invalid value (" + stringValue + ")");
                }
                continue;
            }
            if (f.getType() == String.class) {
                String value2 = preferences.get(key, (String)defaultValue);
                f.set(instance, value2);
                continue;
            }
            if (f.getType().isEnum()) {
                Class<?> enumType = f.getType();
                Enum enumDefaultValue = (Enum)defaultValue;
                String stringValue = preferences.get(key, enumDefaultValue == null ? null : enumDefaultValue.name());
                try {
                    Object enumValue = stringValue == null ? null : Enum.valueOf(enumType, stringValue);
                    f.set(instance, enumValue);
                }
                catch (IllegalArgumentException e) {
                    logger.warning("Ignoring preference (" + key + ") invalid value (" + stringValue + ")");
                }
                continue;
            }
            if (f.getType() == Boolean.class || f.getType() == Boolean.TYPE) {
                try {
                    boolean boolValue = preferences.getBoolean(key, (Boolean)defaultValue);
                    f.set(instance, boolValue);
                }
                catch (IllegalArgumentException e) {
                    logger.log(Level.WARNING, "Ignoring preference (" + key + ")", e);
                }
                continue;
            }
            if (f.getType() == Integer.class || f.getType() == Integer.TYPE) {
                try {
                    int intValue = preferences.getInt(key, (Integer)defaultValue);
                    f.set(instance, intValue);
                }
                catch (IllegalArgumentException e) {
                    logger.log(Level.WARNING, "Ignoring preference (" + key + ")", e);
                }
                continue;
            }
            if (f.getType() == Long.class || f.getType() == Long.TYPE) {
                try {
                    long longValue = preferences.getLong(key, (Long)defaultValue);
                    f.set(instance, longValue);
                }
                catch (IllegalArgumentException e) {
                    logger.log(Level.WARNING, "Ignoring preference (" + key + ")", e);
                }
                continue;
            }
            if (this.serializeTypeAsJson(f.getType())) {
                try {
                    String stringValue = preferences.get(key, "");
                    if (stringValue.isEmpty()) continue;
                    value = this.gson.fromJson(stringValue, f.getGenericType());
                    f.set(instance, value);
                }
                catch (IllegalArgumentException e) {
                    logger.log(Level.WARNING, "Ignoring preference (" + key + ")", e);
                }
                catch (JsonSyntaxException e) {
                    logger.log(Level.WARNING, "Ignoring preference (" + key + ")", e);
                }
                continue;
            }
            throw new IllegalStateException("Unsupported preference type: " + f.getType().getSimpleName());
        }
    }

    private boolean serializeTypeAsJson(Class<?> type) {
        return type.isAnnotationPresent(SerializeAsJson.class);
    }

    private String getPreferenceKey(Class<?> type, Field f) {
        return type.getSimpleName() + "_" + f.getName();
    }
}

