/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.trips;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.checklist.ChecklistSynthesizer;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.io.PartialIO;
import com.scythebill.birdlist.model.query.QueryDefinition;
import com.scythebill.birdlist.model.query.QueryProcessor;
import com.scythebill.birdlist.model.query.QueryResults;
import com.scythebill.birdlist.model.query.SightingComparators;
import com.scythebill.birdlist.model.query.SightingPredicates;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.Trip;
import com.scythebill.birdlist.model.sighting.Trips;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.util.Indexer;
import com.scythebill.birdlist.model.util.ToString;
import com.scythebill.birdlist.ui.actions.ReturnAction;
import com.scythebill.birdlist.ui.app.NavigableFrame;
import com.scythebill.birdlist.ui.app.Titled;
import com.scythebill.birdlist.ui.components.DepthChooser;
import com.scythebill.birdlist.ui.components.IndexerPanel;
import com.scythebill.birdlist.ui.components.NewLocationDialog;
import com.scythebill.birdlist.ui.components.SpeciesIndexerPanelConfigurer;
import com.scythebill.birdlist.ui.components.TripInfoBrowsePanel;
import com.scythebill.birdlist.ui.events.EventBusRegistrar;
import com.scythebill.birdlist.ui.events.TaxonomyChangedEvent;
import com.scythebill.birdlist.ui.events.TaxonomyStore;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.BrowsePreferences;
import com.scythebill.birdlist.ui.panels.reports.QueryExecutor;
import com.scythebill.birdlist.ui.panels.reports.QueryPreferences;
import com.scythebill.birdlist.ui.panels.reports.ReportHints;
import com.scythebill.birdlist.ui.panels.reports.ReportsActionFactory;
import com.scythebill.birdlist.ui.panels.reports.ReportsBrowserPanel;
import com.scythebill.birdlist.ui.panels.trips.AutomaticTripsDialog;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.FileDialogs;
import com.scythebill.birdlist.ui.util.ListListModel;
import com.scythebill.birdlist.ui.util.LocationScorer;
import com.scythebill.birdlist.ui.util.OpenMapUrl;
import com.scythebill.birdlist.ui.util.VisibilityDetector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.joda.time.ReadablePartial;

public class TripsBrowsePanel
extends JPanel
implements Titled,
FontManager.FontsUpdatedListener {
    private final ReportSet reportSet;
    private final FontManager fontManager;
    private final QueryPreferences queryPreferences;
    private final Alerts alerts;
    private final TaxonomyStore taxonomyStore;
    private final BrowsePreferences browsePreferences;
    private JButton returnButton;
    private JScrollPane tripScrollPane;
    private JList<Trip> tripList;
    private JButton createAutomaticTrips;
    private JButton deleteTrip;
    private JButton mergeTrips;
    private JButton tripReport;
    private AutomaticTripsDialog automaticTripsDialog;
    private ReportsBrowserPanel reportsBrowserPanel;
    private JScrollPane reportsScrollPane;
    private Timer showTripTimer;
    private ReportsActionFactory reportsActionFactory;
    private JComponent tripContent;
    private NewLocationDialog newLocationDialog;
    private PredefinedLocations predefinedLocations;
    private OpenMapUrl openMapUrl;
    private JLabel noTripsLabel;
    private JLabel totalSpeciesLabel;
    private NavigableFrame navigableFrame;
    private JLabel depthLabel;
    private DepthChooser depthChooser;
    private FileDialogs fileDialogs;
    private final LocationScorer locationScorer;
    private JCheckBox highlightLifers;
    private IndexerPanel<Trip> tripIndexerPanel;
    private JButton tripJumpButton;
    private IndexerPanel<String> speciesIndexPanel;
    private JButton speciesJumpButton;
    private SpeciesIndexerPanelConfigurer speciesIndexerPanelConfigurer;
    private Checklists checklists;
    private ChecklistSynthesizer checklistSynthesizer;

    @Inject
    public TripsBrowsePanel(ReportSet reportSet, ReportsBrowserPanel reportsBrowserPanel, AutomaticTripsDialog automaticTripsDialog, QueryPreferences queryPreferences, BrowsePreferences browsePreferences, Alerts alerts, FileDialogs fileDialogs, TaxonomyStore taxonomyStore, EventBusRegistrar eventBusRegistrar, ReturnAction returnAction, ReportsActionFactory reportsActionFactory, FontManager fontManager, VisibilityDetector visibilityDetector, NewLocationDialog newLocationDialog, PredefinedLocations predefinedLocations, OpenMapUrl openMapUrl, NavigableFrame navigableFrame, LocationScorer locationScorer, SpeciesIndexerPanelConfigurer speciesIndexerPanelConfigurer, Checklists checklists, ChecklistSynthesizer checklistSynthesizer) {
        this.reportSet = reportSet;
        this.reportsBrowserPanel = reportsBrowserPanel;
        this.automaticTripsDialog = automaticTripsDialog;
        this.queryPreferences = queryPreferences;
        this.browsePreferences = browsePreferences;
        this.alerts = alerts;
        this.fileDialogs = fileDialogs;
        this.taxonomyStore = taxonomyStore;
        this.reportsActionFactory = reportsActionFactory;
        this.fontManager = fontManager;
        this.newLocationDialog = newLocationDialog;
        this.predefinedLocations = predefinedLocations;
        this.openMapUrl = openMapUrl;
        this.navigableFrame = navigableFrame;
        this.locationScorer = locationScorer;
        this.speciesIndexerPanelConfigurer = speciesIndexerPanelConfigurer;
        this.checklists = checklists;
        this.checklistSynthesizer = checklistSynthesizer;
        this.initGUI();
        this.hookUpContents(returnAction);
        visibilityDetector.install(this.returnButton);
        eventBusRegistrar.registerWhenInHierarchy(this);
        this.taxonomyChanged(null);
    }

    private void initGUI() {
        this.returnButton = new JButton();
        this.noTripsLabel = new JLabel();
        this.noTripsLabel.putClientProperty("birdlist.plainLabel", true);
        this.noTripsLabel.putClientProperty("birdlist.textSize", (Object)FontManager.TextSize.LARGE);
        this.noTripsLabel.setText(Messages.getFormattedMessage(Messages.Name.NO_TRIPS_EXPLANATION_FORMAT, Messages.getMessage(Messages.Name.AUTOMATICALLY_CREATE_TRIPS), Messages.getMessage(Messages.Name.BROWSE_BY_LOCATION), Messages.getMessage(Messages.Name.CREATE_TRIP)));
        this.depthLabel = new JLabel(Messages.getMessage(Messages.Name.SHOW_LABEL));
        this.depthChooser = new DepthChooser();
        this.depthChooser.setDepth(this.browsePreferences.depth);
        this.highlightLifers = new JCheckBox(Messages.getMessage(Messages.Name.HIGHLIGHT_LIFERS_QUESTION));
        this.tripIndexerPanel = new IndexerPanel();
        this.tripIndexerPanel.setPreviewText(Messages.Name.START_TYPING_A_TRIP);
        this.tripJumpButton = new JButton(Messages.getMessage(Messages.Name.JUMP_TO_BUTTON));
        this.tripJumpButton.setEnabled(false);
        this.tripList = new JList();
        this.tripList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Trip trip = (Trip)value;
                if (trip.name() != null) {
                    value = Trips.nameWithDate(trip, this.getLocale());
                } else {
                    ReadablePartial startDate = trip.startDate();
                    ReadablePartial endDate = trip.startDate();
                    Location location = trip.locationId() == null ? null : TripsBrowsePanel.this.reportSet.getLocations().getLocation(trip.locationId());
                    String dateString = startDate.equals(endDate) ? PartialIO.toUserString(startDate, this.getLocale()) : String.format("%s-%s", PartialIO.toUserString(startDate, this.getLocale()), PartialIO.toUserString(endDate, this.getLocale()));
                    value = location == null ? dateString : String.format("%s %s", location.getDisplayName(), dateString);
                }
                return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
        });
        this.tripScrollPane = new JScrollPane(this.tripList);
        this.reportsScrollPane = new JScrollPane(this.reportsBrowserPanel);
        this.updateTripModel();
        this.createAutomaticTrips = new JButton(Messages.getMessage(Messages.Name.AUTOMATICALLY_CREATE_TRIPS));
        this.speciesJumpButton = new JButton(Messages.getMessage(Messages.Name.JUMP_TO_BUTTON));
        this.speciesJumpButton.setVisible(false);
        this.speciesJumpButton.setEnabled(false);
        this.speciesIndexPanel = new IndexerPanel();
        this.speciesIndexPanel.setVisible(false);
        this.totalSpeciesLabel = new JLabel();
        this.mergeTrips = new JButton(Messages.getMessage(Messages.Name.MERGE_TRIPS));
        this.deleteTrip = new JButton(Messages.getMessage(Messages.Name.DELETE_TRIP));
        this.tripReport = new JButton(Messages.getMessage(Messages.Name.CREATE_TRIP_REPORT));
        this.mergeTrips.setEnabled(false);
        this.deleteTrip.setEnabled(false);
        this.tripReport.setEnabled(false);
        this.reportsBrowserPanel.setEditableSightings(true);
        this.reportsBrowserPanel.setEditableWhere(true);
        this.tripContent = new JPanel();
        this.tripContent.setLayout(new BorderLayout());
        this.fontManager.applyTo(this);
    }

    private void updateTripModel() {
        ArrayList<Trip> trips = new ArrayList<Trip>(this.reportSet.getTrips().allTrips());
        Collections.sort(trips, Comparator.comparing(Trip::startDate, SightingComparators::comparePartials).reversed());
        this.tripList.setModel(new ListListModel<Trip>(trips));
        if (trips.isEmpty()) {
            this.tripScrollPane.setVisible(false);
            this.reportsScrollPane.setVisible(false);
            this.noTripsLabel.setVisible(true);
        } else {
            this.tripScrollPane.setVisible(true);
            this.reportsScrollPane.setVisible(true);
            this.noTripsLabel.setVisible(false);
        }
        this.tripIndexerPanel.clearValue();
        this.tripIndexerPanel.removeAllIndexerGroups();
        Indexer<Trip> tripIndexer = new Indexer<Trip>(10);
        for (Trip trip : trips) {
            tripIndexer.add(trip.name(), trip);
        }
        this.tripIndexerPanel.addIndexerGroup(new ToString<Trip>(){

            @Override
            public String getString(Trip t) {
                return t.name();
            }
        }, tripIndexer);
    }

    private void hookUpContents(ReturnAction returnAction) {
        this.showTripTimer = new Timer(200, e -> this.showTrips());
        this.showTripTimer.setRepeats(false);
        this.createAutomaticTrips.addActionListener(e -> this.automaticTripsDialog.showDialog(SwingUtilities.getWindowAncestor(this), this.reportSet, e2 -> this.updateTripModel()));
        this.depthChooser.addPropertyChangeListener("depth", e -> {
            this.browsePreferences.depth = this.depthChooser.getDepth();
            this.showTripTimer.stop();
            this.showTrips();
        });
        this.tripList.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.showTripTimer.restart();
            this.selectedTripsUpdated();
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent event) {
                TripsBrowsePanel.this.showTripTimer.stop();
            }
        });
        this.highlightLifers.addActionListener(e -> {
            this.showTripTimer.stop();
            this.showTrips();
        });
        this.deleteTrip.addActionListener(e -> this.deleteTrips());
        this.mergeTrips.addActionListener(e -> this.mergeTrips());
        this.tripReport.addActionListener(this::createTripReport);
        this.tripIndexerPanel.addPropertyChangeListener("value", e -> this.tripJumpButton.setEnabled(this.tripIndexerPanel.getValue() != null));
        this.tripIndexerPanel.addActionListener(e -> this.tripJumpButton.doClick(100));
        this.tripJumpButton.addActionListener(e -> {
            Trip value = this.tripIndexerPanel.getValue();
            if (value != null) {
                this.tripList.setSelectedValue(value, true);
            }
        });
        this.speciesIndexPanel.addPropertyChangeListener("value", e -> this.speciesJumpButton.setEnabled(e.getNewValue() != null));
        this.speciesIndexPanel.addActionListener(e -> this.speciesJumpButton.doClick(100));
        this.speciesJumpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Taxon taxon;
                String id = TripsBrowsePanel.this.speciesIndexPanel.getValue();
                if (id != null && (taxon = TripsBrowsePanel.this.taxonomyStore.getTaxonomy().getTaxon(id)) != null) {
                    TripsBrowsePanel.this.reportsBrowserPanel.selectTaxon(taxon);
                    TripsBrowsePanel.this.reportsBrowserPanel.requestFocusInWindow();
                }
            }
        });
        this.returnButton.setAction(returnAction);
    }

    private void createTripReport(ActionEvent e) {
        final List<Trip> trips = this.tripList.getSelectedValuesList();
        if (trips == null || trips.isEmpty()) {
            return;
        }
        final Location locationRoot = Trips.getLocationRoot(this.reportSet, trips);
        final Collection<String> checklistCodes = Checklists.getCountryChecklistCodes(this.reportSet, trips);
        QueryExecutor executor = new QueryExecutor(){
            private boolean onlyCountable = false;
            private boolean includeIncompatibleSightings = false;

            @Override
            public QueryExecutor onlyCountable() {
                this.onlyCountable = true;
                return this;
            }

            @Override
            public QueryExecutor includeIncompatibleSightings() {
                this.includeIncompatibleSightings = true;
                return this;
            }

            @Override
            public Location getRootLocation() {
                return locationRoot;
            }

            @Override
            public Optional<String> getReportName() {
                return Optional.absent();
            }

            @Override
            public Set<ReportHints> getReportHints() {
                return ImmutableSet.of();
            }

            @Override
            public Optional<String> getReportAbbreviation() {
                return Optional.absent();
            }

            @Override
            public QueryResults executeQuery(Taxon.Type depthOverride, @Nullable Taxonomy taxonomyOverride) {
                LinkedHashMap<Taxonomy, Checklist> incompatibleTaxonomyChecklists;
                Taxonomy taxonomy = taxonomyOverride == null ? TripsBrowsePanel.this.taxonomyStore.getTaxonomy() : taxonomyOverride;
                Checklist checklist = TripsBrowsePanel.this.checklists.getChecklist(TripsBrowsePanel.this.reportSet, taxonomy, TripsBrowsePanel.this.checklistSynthesizer, checklistCodes);
                if (this.includeIncompatibleSightings) {
                    Object birdChecklist;
                    incompatibleTaxonomyChecklists = new LinkedHashMap<Taxonomy, Checklist>();
                    if (!taxonomy.isBuiltIn() && (birdChecklist = TripsBrowsePanel.this.checklists.getChecklist(TripsBrowsePanel.this.reportSet, TripsBrowsePanel.this.taxonomyStore.getClements(), TripsBrowsePanel.this.checklistSynthesizer, checklistCodes)) != null) {
                        incompatibleTaxonomyChecklists.put(TripsBrowsePanel.this.taxonomyStore.getClements(), (Checklist)birdChecklist);
                    }
                    for (Taxonomy extendedTaxonomy : TripsBrowsePanel.this.reportSet.extendedTaxonomies()) {
                        Checklist extendedChecklist;
                        if (extendedTaxonomy == taxonomy || (extendedChecklist = TripsBrowsePanel.this.checklists.getChecklist(TripsBrowsePanel.this.reportSet, extendedTaxonomy, TripsBrowsePanel.this.checklistSynthesizer, checklistCodes)) == null) continue;
                        incompatibleTaxonomyChecklists.put(extendedTaxonomy, extendedChecklist);
                    }
                } else {
                    incompatibleTaxonomyChecklists = null;
                }
                QueryProcessor processor = new QueryProcessor(TripsBrowsePanel.this.reportSet, taxonomy, checklist, incompatibleTaxonomyChecklists);
                if (this.includeIncompatibleSightings) {
                    processor.includingIncompatibleSightings();
                }
                if (this.onlyCountable) {
                    processor.onlyIncludeCountableSightings();
                }
                CollectNonLiferTaxa collectNonLiferTaxa = TripsBrowsePanel.this.collectNonLiferTaxa(trips);
                QueryDefinition queryDefinition = TripsBrowsePanel.this.tripsQueryDefinition(trips, collectNonLiferTaxa);
                Predicate<Sighting> countablePredicate = TripsBrowsePanel.this.queryPreferences.getCountablePredicate(taxonomy, false, null);
                return processor.runQuery(queryDefinition, countablePredicate, depthOverride == null ? TripsBrowsePanel.this.depthChooser.getDepth() : depthOverride);
            }
        };
        this.reportsActionFactory.saveAsTripReport(executor, trips).actionPerformed(e);
    }

    private void selectedTripsUpdated() {
        Trip singleSelectedTrip = this.getSingleSelectedTrip();
        if (singleSelectedTrip != null) {
            this.mergeTrips.setEnabled(false);
            this.tripContent.removeAll();
            this.tripContent.add("Center", new TripInfoBrowsePanel(this.reportSet, singleSelectedTrip, this.alerts, this.fileDialogs, this.fontManager, new TripInfoBrowsePanel.UpdatedListener(){

                @Override
                public void tripUpdated(Trip trip) {
                    int indexOf = TripsBrowsePanel.this.getTripsAsList().indexOf(trip);
                    if (indexOf > 0) {
                        TripsBrowsePanel.this.getTripsAsList().set(indexOf, trip);
                    }
                }
            }, this.newLocationDialog, this.predefinedLocations, this.openMapUrl, this.navigableFrame, this.locationScorer, new ReturnToTripAction(this.navigableFrame, singleSelectedTrip)));
        } else {
            this.tripContent.removeAll();
        }
        this.fontManager.applyTo(this);
        this.deleteTrip.setEnabled(this.tripList.getSelectedIndices().length > 0);
        this.deleteTrip.setText(this.tripList.getSelectedIndices().length > 1 ? Messages.getMessage(Messages.Name.DELETE_TRIPS) : Messages.getMessage(Messages.Name.DELETE_TRIP));
        this.tripReport.setEnabled(this.tripList.getSelectedIndices().length > 0);
        this.mergeTrips.setEnabled(this.tripList.getSelectedIndices().length > 1);
    }

    private void mergeTrips() {
        int[] selectedIndices = this.tripList.getSelectedIndices();
        if (selectedIndices.length < 2) {
            return;
        }
        List<Trip> tripsAsList = this.getTripsAsList();
        Trip mergedTrip = Trips.mergeTrips(this.reportSet, this.tripList.getSelectedValuesList());
        int newIndex = selectedIndices[selectedIndices.length - 1] + 1;
        tripsAsList.add(newIndex, mergedTrip);
        this.tripList.setSelectedIndex(newIndex);
        this.selectedTripsUpdated();
    }

    private void deleteTrips() {
        List<Trip> trips = this.tripList.getSelectedValuesList();
        if (trips == null || trips.isEmpty()) {
            return;
        }
        if (0 == this.alerts.showConfirm((Object)this, trips.size() == 1 ? Messages.Name.DELETE_TRIP_TITLE : Messages.Name.DELETE_TRIPS_TITLE, trips.size() == 1 ? Messages.Name.DELETE_TRIP_TEXT : Messages.Name.DELETE_TRIPS_TEXT, new Object[0])) {
            this.reportSet.deleteTrips(trips, null);
            List<Trip> tripsAsList = this.getTripsAsList();
            tripsAsList.removeAll(trips);
            if (tripsAsList.isEmpty()) {
                this.updateTripModel();
            }
        }
    }

    private List<Trip> getTripsAsList() {
        return ((ListListModel)this.tripList.getModel()).asList();
    }

    private Trip getSingleSelectedTrip() {
        Trip trip = this.tripList.getSelectedValue();
        if (trip == null || this.tripList.getSelectedIndices().length != 1) {
            return null;
        }
        return trip;
    }

    private CollectNonLiferTaxa collectNonLiferTaxa(List<Trip> trips) {
        ReadablePartial earliestDate = (ReadablePartial)trips.stream().map(Trip::startDate).collect(Collectors.minBy(SightingComparators::comparePartials)).get();
        Predicate<Sighting> nonLiferPredicate = SightingPredicates.before(earliestDate);
        return new CollectNonLiferTaxa(this.taxonomyStore.getTaxonomy(), nonLiferPredicate, this.depthChooser.getDepth());
    }

    private void showTrips() {
        List<Trip> trips = this.tripList.getSelectedValuesList();
        if (trips == null || trips.isEmpty()) {
            this.reportsBrowserPanel.setModel(null);
            this.totalSpeciesLabel.setText("");
            this.speciesIndexPanel.setVisible(false);
            this.speciesJumpButton.setVisible(false);
        } else {
            Taxonomy taxonomy = this.taxonomyStore.getTaxonomy();
            Predicate<Sighting> countablePredicate = this.queryPreferences.getCountablePredicate(taxonomy, false, null);
            Location locationRoot = Trips.getLocationRoot(this.reportSet, trips);
            Collection<String> checklistCodes = Checklists.getCountryChecklistCodes(this.reportSet, trips);
            Checklist checklist = this.checklists.getChecklist(this.reportSet, taxonomy, this.checklistSynthesizer, checklistCodes);
            QueryProcessor queryProcessor = new QueryProcessor(this.reportSet, taxonomy, checklist, null);
            CollectNonLiferTaxa collectNonLiferTaxa = this.collectNonLiferTaxa(trips);
            QueryDefinition queryDefinition = this.tripsQueryDefinition(trips, collectNonLiferTaxa);
            QueryResults results = queryProcessor.runQuery(queryDefinition, countablePredicate, this.depthChooser.getDepth());
            int liferCount = Sets.difference(results.getCountableSpeciesIds(taxonomy), collectNonLiferTaxa.nonLiferTaxa).size();
            int speciesCount = results.getCountableSpeciesSize(taxonomy, false);
            int endemicCount = 0;
            int endemicsSeen = 0;
            if (checklist != null) {
                ImmutableSet<SightingTaxon> endemics = checklist.getTaxa(taxonomy, Checklist.Status.ENDEMIC);
                endemicCount = endemics.size();
                for (SightingTaxon endemic : endemics) {
                    if (!results.isCountable(endemic.resolveInternal(taxonomy))) continue;
                    ++endemicsSeen;
                }
            }
            if (endemicCount > 0 && endemicsSeen > 0) {
                if (liferCount > 0) {
                    this.totalSpeciesLabel.setText(Messages.getFormattedMessage(Messages.Name.TRIP_TOTALS_COUNT_AND_LIFERS_AND_ENDEMICS, speciesCount, liferCount, endemicsSeen, endemicCount));
                } else {
                    this.totalSpeciesLabel.setText(Messages.getFormattedMessage(Messages.Name.TRIP_TOTALS_COUNT_AND_ENDEMICS, speciesCount, endemicsSeen, endemicCount));
                }
            } else if (liferCount > 0) {
                this.totalSpeciesLabel.setText(Messages.getFormattedMessage(Messages.Name.TRIP_TOTALS_COUNT_AND_LIFERS, speciesCount, liferCount));
            } else {
                this.totalSpeciesLabel.setText(Messages.getFormattedMessage(Messages.Name.TOTAL_SPECIES_FORMAT_NO_CHECKLIST, speciesCount));
            }
            this.reportsBrowserPanel.setLocationRoot(locationRoot);
            this.reportsBrowserPanel.setQueryResults(results, true, ImmutableList.of(), true);
            this.reportsBrowserPanel.revalidate();
            this.speciesIndexPanel.clearValue();
            this.speciesJumpButton.setEnabled(false);
            this.speciesIndexPanel.setVisible(true);
            this.speciesJumpButton.setVisible(true);
            this.speciesIndexerPanelConfigurer.configureQuery(this.speciesIndexPanel, results);
        }
    }

    private QueryDefinition tripsQueryDefinition(final List<Trip> trips, final CollectNonLiferTaxa collectNonLiferTaxa) {
        QueryDefinition queryDefinition = new QueryDefinition(){

            @Override
            public Optional<QueryDefinition.Preprocessor> preprocessor() {
                return Optional.of(collectNonLiferTaxa);
            }

            @Override
            public Predicate<Sighting> predicate() {
                return Predicates.or(trips.stream().map(trip -> Trips.tripPredicate(TripsBrowsePanel.this.reportSet, trip, null)).collect(ImmutableList.toImmutableList()));
            }

            @Override
            public Optional<QueryDefinition.QueryAnnotation> annotate(Sighting sighting, SightingTaxon mappedTaxon) {
                if (TripsBrowsePanel.this.highlightLifers.isSelected() && collectNonLiferTaxa.isLifer(sighting, mappedTaxon)) {
                    return Optional.of(QueryDefinition.QueryAnnotation.LIFER);
                }
                return Optional.absent();
            }
        };
        return queryDefinition;
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        GroupLayout layout = new GroupLayout(this);
        layout.setAutoCreateContainerGaps(true);
        this.setLayout(layout);
        layout.setHonorsVisibility(this.tripScrollPane, false);
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createBaselineGroup(false, false).addComponent(this.createAutomaticTrips).addComponent(this.depthLabel).addComponent(this.depthChooser).addComponent(this.speciesIndexPanel).addComponent(this.speciesJumpButton).addComponent(this.tripReport)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createBaselineGroup(false, false).addComponent(this.tripIndexerPanel).addComponent(this.tripJumpButton).addComponent(this.totalSpeciesLabel).addComponent(this.highlightLifers)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup().addComponent(this.noTripsLabel).addComponent(this.tripScrollPane, fontManager.scale(200), fontManager.scale(480), Integer.MAX_VALUE).addComponent(this.tripContent, fontManager.scale(200), fontManager.scale(480), Integer.MAX_VALUE).addComponent(this.reportsScrollPane, fontManager.scale(200), fontManager.scale(480), Integer.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createBaselineGroup(false, false).addComponent(this.deleteTrip).addComponent(this.mergeTrips).addComponent(this.returnButton)));
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.createAutomaticTrips)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGap(fontManager.scale(20)).addComponent(this.noTripsLabel)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.tripIndexerPanel, fontManager.scale(150), fontManager.scale(200), fontManager.scale(200)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tripJumpButton)).addComponent(this.tripScrollPane, fontManager.scale(150), fontManager.scale(250), fontManager.scale(300))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.depthLabel).addComponent(this.depthChooser, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.speciesIndexPanel, fontManager.scale(150), fontManager.scale(200), fontManager.scale(200)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.speciesJumpButton)).addGroup(layout.createSequentialGroup().addComponent(this.totalSpeciesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.highlightLifers)).addComponent(this.reportsScrollPane, fontManager.scale(400), -2, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup().addComponent(this.tripReport).addComponent(this.tripContent, fontManager.scale(200), fontManager.scale(350), fontManager.scale(400)))).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.deleteTrip).addComponent(this.mergeTrips)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.returnButton, -2, -2, -2)));
        Dimension size = fontManager.scale(this.reportSet.getTrips().allTrips().isEmpty() ? new Dimension(960, 800) : new Dimension(1280, 800));
        this.setPreferredSize(size);
    }

    @Override
    public String getTitle() {
        return Messages.getMessage(Messages.Name.BROWSE_BY_TRIPS);
    }

    @Subscribe
    public void taxonomyChanged(TaxonomyChangedEvent event) {
        Taxonomy taxonomy = this.taxonomyStore.getTaxonomy();
        this.reportsBrowserPanel.setTaxonomy(taxonomy);
        this.updateSpeciesIndexer(taxonomy);
        this.showTrips();
    }

    private void updateSpeciesIndexer(Taxonomy taxonomy) {
        this.speciesIndexerPanelConfigurer.configure(this.speciesIndexPanel, taxonomy);
        this.speciesIndexerPanelConfigurer.addSimpleTaxa(this.speciesIndexPanel, taxonomy, TaxonUtils.getDescendantsOfType(taxonomy.getRoot(), Taxon.Type.family));
    }

    private static class ReturnToTripAction
    extends AbstractAction {
        private final NavigableFrame navigableFrame;
        private final Trip trip;

        ReturnToTripAction(NavigableFrame navigableFrame, Trip trip) {
            this.navigableFrame = navigableFrame;
            this.trip = trip;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPanel navigateTo = this.navigableFrame.navigateTo("browseTrips");
            if (navigateTo != null) {
                TripsBrowsePanel tripsBrowsePanel = (TripsBrowsePanel)navigateTo;
                tripsBrowsePanel.tripList.setSelectedValue(this.trip, true);
                tripsBrowsePanel.showTrips();
            }
        }
    }

    static class CollectNonLiferTaxa
    implements QueryDefinition.Preprocessor {
        final Set<String> nonLiferTaxa = new HashSet<String>();
        private final Taxonomy taxonomy;
        private final Predicate<Sighting> nonLiferPredicate;
        private Taxon.Type depth;

        public CollectNonLiferTaxa(Taxonomy taxonomy, Predicate<Sighting> nonLiferPredicate, Taxon.Type depth) {
            this.taxonomy = taxonomy;
            this.nonLiferPredicate = nonLiferPredicate;
            this.depth = depth;
        }

        @Override
        public void reset() {
            this.nonLiferTaxa.clear();
        }

        @Override
        public void preprocess(Sighting sighting, Predicate<Sighting> countablePredicate) {
            if (!countablePredicate.apply(sighting)) {
                return;
            }
            if (!this.nonLiferPredicate.apply(sighting)) {
                return;
            }
            if (!TaxonUtils.areCompatible(sighting.getTaxonomy(), this.taxonomy)) {
                return;
            }
            SightingTaxon.Resolved resolved = sighting.getTaxon().resolve(this.taxonomy);
            switch (this.depth) {
                case subspecies: {
                    SightingTaxon subspeciesTaxon = resolved.getParentOfAtLeastType(Taxon.Type.subspecies);
                    if (subspeciesTaxon.getType() == SightingTaxon.Type.SINGLE) {
                        this.nonLiferTaxa.add(subspeciesTaxon.getId());
                    }
                }
                case group: {
                    SightingTaxon groupTaxon = resolved.getParentOfAtLeastType(Taxon.Type.group);
                    if (groupTaxon.getType() != SightingTaxon.Type.SINGLE) break;
                    this.nonLiferTaxa.add(groupTaxon.getId());
                }
            }
            SightingTaxon speciesTaxon = resolved.getParentOfAtLeastType(Taxon.Type.species);
            if (speciesTaxon.getType() == SightingTaxon.Type.SINGLE) {
                this.nonLiferTaxa.add(speciesTaxon.getId());
            }
        }

        public boolean isLifer(Sighting sighting, SightingTaxon mappedTaxon) {
            if (!TaxonUtils.areCompatible(sighting.getTaxonomy(), this.taxonomy)) {
                return false;
            }
            SightingTaxon taxonAtDepth = mappedTaxon.resolveInternal(this.taxonomy).getParentOfAtLeastType(Taxon.Type.species);
            if (taxonAtDepth.getType() != SightingTaxon.Type.SINGLE) {
                return false;
            }
            return !this.nonLiferTaxa.contains(taxonAtDepth.getId());
        }
    }
}

