/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.trips;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Range;
import com.google.common.collect.TreeRangeSet;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.query.PartialPredicates;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.Trip;
import com.scythebill.birdlist.model.sighting.Trips;
import com.scythebill.birdlist.model.sighting.VisitInfo;
import com.scythebill.birdlist.model.sighting.VisitInfoKey;
import com.scythebill.birdlist.model.sighting.VisitInfoKeyOrdering;
import com.scythebill.birdlist.ui.components.ChipsTextPanel;
import com.scythebill.birdlist.ui.components.IndexerPanel;
import com.scythebill.birdlist.ui.components.OkCancelPanel;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.util.LocationIdToString;
import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;

public class AutomaticTripsDialog {
    private FontManager fontManager;

    @Inject
    public AutomaticTripsDialog(FontManager fontManager) {
        this.fontManager = fontManager;
    }

    public void showDialog(Window parent, final ReportSet reportSet, final ActionListener listener) {
        Dialog.ModalityType modality = Toolkit.getDefaultToolkit().isModalityTypeSupported(Dialog.ModalityType.DOCUMENT_MODAL) ? Dialog.ModalityType.DOCUMENT_MODAL : Dialog.ModalityType.APPLICATION_MODAL;
        final JDialog dialog = new JDialog(parent, Messages.getMessage(Messages.Name.AUTOMATICALLY_CREATE_TRIPS_TITLE), modality);
        final AutomaticTripsPanel automaticTripsPanel = new AutomaticTripsPanel(reportSet);
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        };
        final AbstractAction okAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ImmutableSet<String> locationIdsToExclude = ImmutableSet.copyOf(automaticTripsPanel.locationChips.getChips());
                boolean anyTrips = AutomaticTripsDialog.this.buildTrips(reportSet, locationIdsToExclude, AutomaticTripsDialog.this::addTrip);
                dialog.dispose();
                if (anyTrips) {
                    listener.actionPerformed(event);
                }
            }
        };
        ChipsTextPanel.ChipsChangedListener excludedLocationsChanged = new ChipsTextPanel.ChipsChangedListener(){

            @Override
            public void chipsChanged() {
                ImmutableSet<String> locationIdsToExclude = ImmutableSet.copyOf(automaticTripsPanel.locationChips.getChips());
                CountTripCreations countTripCreations = new CountTripCreations();
                AutomaticTripsDialog.this.buildTrips(reportSet, locationIdsToExclude, countTripCreations);
                if (countTripCreations.foundCount == 1) {
                    okAction.putValue("Name", Messages.getMessage(Messages.Name.CREATE_ONE_TRIP));
                } else if (countTripCreations.foundCount == 0) {
                    okAction.putValue("Name", Messages.getMessage(Messages.Name.NO_TRIPS_TO_CREATE));
                } else {
                    okAction.putValue("Name", Messages.getFormattedMessage(Messages.Name.CREATE_TRIPS_FORMAT, countTripCreations.foundCount));
                }
                okAction.setEnabled(countTripCreations.foundCount != 0);
            }
        };
        automaticTripsPanel.locationChips.addChipsChangedListener(excludedLocationsChanged);
        excludedLocationsChanged.chipsChanged();
        OkCancelPanel okCancel = new OkCancelPanel(okAction, cancelAction, automaticTripsPanel, null);
        this.fontManager.applyTo(okCancel);
        dialog.setContentPane(okCancel);
        dialog.pack();
        dialog.setVisible(true);
    }

    /*
     * WARNING - void declaration
     */
    private boolean buildTrips(ReportSet reportSet, Set<String> parentLocationIdsToExclude, TripCreator tripCreator) {
        void var8_15;
        LocationSet locations = reportSet.getLocations();
        HashSet<String> fullLocationIdsToExclude = new HashSet<String>();
        for (String string : parentLocationIdsToExclude) {
            Location location = locations.getLocation(string);
            this.addAllLocationContents(locations, fullLocationIdsToExclude, location);
        }
        TreeRangeSet<Integer> tripRanges = TreeRangeSet.create();
        for (Trip trip : reportSet.getTrips().allTrips()) {
            tripRanges.add(Trips.dateRange(trip));
        }
        TreeSet<VisitInfoKey> treeSet = new TreeSet<VisitInfoKey>(new VisitInfoKeyOrdering());
        for (Sighting sighting : reportSet.getSightings()) {
            VisitInfoKey key = VisitInfoKey.forSighting(sighting);
            if (key == null) continue;
            treeSet.add(key);
        }
        boolean bl = false;
        VisitInfoKey startOfCurrentTrip = null;
        VisitInfoKey endOfCurrentTrip = null;
        Location tripLocation = null;
        for (VisitInfoKey key : treeSet) {
            boolean excluded;
            Range<Integer> visitRange = Trips.dateRange(key.date(), key.date());
            int keyDate = visitRange.lowerEndpoint();
            boolean bl2 = excluded = fullLocationIdsToExclude.contains(key.locationId()) || tripRanges.contains(keyDate);
            if (excluded) {
                if (startOfCurrentTrip == null) continue;
                tripCreator.foundTrip(reportSet, startOfCurrentTrip, endOfCurrentTrip, tripLocation);
                ++var8_15;
                startOfCurrentTrip = null;
                endOfCurrentTrip = null;
                tripLocation = null;
                continue;
            }
            if (startOfCurrentTrip == null) {
                startOfCurrentTrip = key;
                endOfCurrentTrip = key;
                tripLocation = locations.getLocation(key.locationId());
                continue;
            }
            if (keyDate - Trips.dateRange(endOfCurrentTrip.date(), endOfCurrentTrip.date()).lowerEndpoint() >= 100) {
                tripCreator.foundTrip(reportSet, startOfCurrentTrip, endOfCurrentTrip, tripLocation);
                ++var8_15;
                startOfCurrentTrip = key;
                endOfCurrentTrip = key;
                tripLocation = locations.getLocation(key.locationId());
                continue;
            }
            Location newTripLocation = Locations.getCommonAncestor(tripLocation, locations.getLocation(key.locationId()));
            if (newTripLocation == null) {
                tripCreator.foundTrip(reportSet, startOfCurrentTrip, endOfCurrentTrip, tripLocation);
                ++var8_15;
                startOfCurrentTrip = key;
                endOfCurrentTrip = key;
                tripLocation = locations.getLocation(key.locationId());
                continue;
            }
            tripLocation = newTripLocation;
            endOfCurrentTrip = key;
        }
        return var8_15 > 0;
    }

    private void addTrip(ReportSet reportSet, VisitInfoKey start, VisitInfoKey end, Location location) {
        LocalTime endTime;
        if (end.startTime().isPresent()) {
            endTime = end.startTime().get();
            VisitInfo visitInfo = reportSet.getVisitInfo(end);
            if (visitInfo != null && visitInfo.duration().isPresent()) {
                LocalTime endTimePlusDuration = endTime.plusMinutes((int)visitInfo.duration().get().getStandardMinutes());
                endTime = endTimePlusDuration.isBefore(endTime) ? null : endTimePlusDuration;
            }
        } else {
            endTime = null;
        }
        String dateString = Trips.rangeToUserString(start.date(), end.date(), Locale.getDefault());
        ReadablePartial startDate = start.date();
        LocalTime startTime = start.startTime().orNull();
        ReadablePartial endDate = end.date();
        if (PartialPredicates.isStrictSuperset(startDate, endDate) && PartialPredicates.comparePartialsSubset(startDate, endDate) == 0) {
            endDate = startDate;
            endTime = null;
        }
        String name = dateString == null ? location.getDisplayName() : String.format("%s, %s", location.getDisplayName(), dateString);
        reportSet.getTrips().newTripBuilder().withStartDate(startDate).withStartTime(startTime).withEndDate(endDate).withEndTime(endTime).withLocationId(location.getId()).withName(name).build();
        reportSet.markDirty();
    }

    private void addAllLocationContents(LocationSet locationSet, Set<String> fullLocationIdsToExclude, Location location) {
        fullLocationIdsToExclude.add(location.getId());
        for (Location content : location.contents()) {
            this.addAllLocationContents(locationSet, fullLocationIdsToExclude, content);
        }
    }

    class AutomaticTripsPanel
    extends JPanel {
        private JButton addLocation;
        private IndexerPanel<String> locationIndexer;
        private ChipsTextPanel<String> locationChips;
        private LocationIdToString locationIdToString;
        private JLabel explanationLabel = new JLabel(Messages.getMessage(Messages.Name.CREATE_TRIPS_EXPLANATION));

        public AutomaticTripsPanel(ReportSet reportSet) {
            this.explanationLabel.putClientProperty("birdlist.plainLabel", true);
            this.locationIdToString = new LocationIdToString(reportSet.getLocations(), null);
            this.locationIdToString.setNullName("");
            this.locationIndexer = new IndexerPanel();
            this.locationIndexer.addIndexerGroup(this.locationIdToString, this.locationIdToString.createIndexer(false));
            this.locationIndexer.setPreviewText(Messages.Name.START_TYPING_A_LOCATION);
            this.locationChips = new ChipsTextPanel<String>(this.locationIdToString::getString, AutomaticTripsDialog.this.fontManager);
            this.addLocation = new JButton(Messages.getMessage(Messages.Name.EXCLUDE));
            this.addLocation.setEnabled(false);
            this.locationIndexer.addPropertyChangeListener("value", e -> this.addLocation.setEnabled(e.getNewValue() != null));
            ActionListener addAction = e -> {
                String value = this.locationIndexer.getValue();
                if (value != null) {
                    this.locationChips.addChip(value);
                    this.locationIndexer.setValue(null);
                    this.locationIndexer.requestFocusInWindow();
                }
            };
            this.locationIndexer.addActionListener(addAction);
            this.addLocation.addActionListener(addAction);
            GroupLayout layout = new GroupLayout(this);
            layout.setAutoCreateContainerGaps(true);
            this.setLayout(layout);
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.explanationLabel).addGap(AutomaticTripsDialog.this.fontManager.scale(40)).addGroup(layout.createBaselineGroup(false, false).addComponent(this.locationIndexer).addComponent(this.addLocation)).addGroup(layout.createParallelGroup().addComponent(this.locationChips, AutomaticTripsDialog.this.fontManager.scale(80), AutomaticTripsDialog.this.fontManager.scale(80), AutomaticTripsDialog.this.fontManager.scale(80))));
            layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.explanationLabel, -2, -2, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.locationIndexer).addComponent(this.addLocation, -2, -2, -2)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.locationChips, -2, -2, Short.MAX_VALUE)));
        }
    }

    static interface TripCreator {
        public void foundTrip(ReportSet var1, VisitInfoKey var2, VisitInfoKey var3, Location var4);
    }

    static class CountTripCreations
    implements TripCreator {
        int foundCount = 0;

        CountTripCreations() {
        }

        @Override
        public void foundTrip(ReportSet reportSet, VisitInfoKey start, VisitInfoKey end, Location location) {
            ++this.foundCount;
        }
    }
}

