/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.base.Predicate;
import com.scythebill.birdlist.model.io.PartialIO;
import com.scythebill.birdlist.model.query.QueryDefinition;
import com.scythebill.birdlist.model.query.QueryProcessor;
import com.scythebill.birdlist.model.query.QueryResults;
import com.scythebill.birdlist.model.query.SightingComparators;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.ReadablePartial;

class YearComparisonProcessor {
    private static final int MAXIMUM_YEAR_SPAN = 100;
    private Predicate<Sighting> countablePredicate;
    private ReportSet reportSet;
    private Taxonomy taxonomy;
    private QueryDefinition queryDefinition;

    public YearComparisonProcessor(ReportSet reportSet, Taxonomy taxonomy, QueryDefinition queryDefinition, Predicate<Sighting> countablePredicate) {
        this.reportSet = reportSet;
        this.taxonomy = taxonomy;
        this.queryDefinition = queryDefinition;
        this.countablePredicate = countablePredicate;
    }

    public <K> ComparisonResult<K> process(Predicate<Sighting> additionalPredicate, Function<Sighting, K> splitFunction) {
        QueryProcessor queryProcessor = new QueryProcessor(this.reportSet, this.taxonomy);
        queryProcessor.onlyIncludeCountableSightings().dontIncludeFamilyNames();
        if (additionalPredicate != null) {
            queryProcessor = queryProcessor.withAdditionalPredicate(additionalPredicate);
        }
        QueryResults queryResults = queryProcessor.runQuery(this.queryDefinition, this.countablePredicate, Taxon.Type.species);
        int latestYear = Integer.MIN_VALUE;
        int earliestYear = Integer.MAX_VALUE;
        for (Sighting sighting : queryResults.getAllSightings()) {
            int endYear;
            int startYear;
            ReadablePartial startDate = sighting.getStartDateAsPartial();
            ReadablePartial endDate = sighting.getEndDateAsPartial();
            if (startDate == null || endDate == null || !startDate.isSupported(DateTimeFieldType.year()) || !endDate.isSupported(DateTimeFieldType.year()) || (startYear = startDate.get(DateTimeFieldType.year())) != (endYear = endDate.get(DateTimeFieldType.year()))) continue;
            if (startYear > latestYear) {
                latestYear = startYear;
            }
            if (startYear >= earliestYear) continue;
            earliestYear = startYear;
        }
        if (latestYear == Integer.MIN_VALUE) {
            int currentYear = new DateTime().getYear();
            return new ComparisonResult(currentYear, currentYear);
        }
        latestYear = Math.min(latestYear, earliestYear + 100);
        ComparisonResult comparisonResult = new ComparisonResult(earliestYear, latestYear);
        for (SightingTaxon.Resolved resolved : queryResults.getTaxaAsList()) {
            ComparisonResult.SpeciesResult speciesResult = comparisonResult.addSpeciesResult(resolved);
            Collection<Sighting> sightings = queryResults.getAllSightings(resolved);
            for (Sighting sighting : sightings) {
                if (!this.countablePredicate.test(sighting)) continue;
                speciesResult.addSighting(sighting, splitFunction);
            }
        }
        return comparisonResult;
    }

    private static boolean lessThanIgnoringYear(ReadablePartial a, ReadablePartial b) {
        int bMonth;
        int aMonth = a.isSupported(DateTimeFieldType.monthOfYear()) ? a.get(DateTimeFieldType.monthOfYear()) : 13;
        int n = bMonth = b.isSupported(DateTimeFieldType.monthOfYear()) ? b.get(DateTimeFieldType.monthOfYear()) : 13;
        if (aMonth < bMonth) {
            return true;
        }
        if (aMonth > bMonth) {
            return false;
        }
        int aDay = a.isSupported(DateTimeFieldType.dayOfMonth()) ? a.get(DateTimeFieldType.dayOfMonth()) : 32;
        int bDay = b.isSupported(DateTimeFieldType.dayOfMonth()) ? b.get(DateTimeFieldType.dayOfMonth()) : 32;
        return aDay < bDay;
    }

    private static boolean greaterThanIgnoringYear(ReadablePartial a, ReadablePartial b) {
        int bMonth;
        int aMonth = a.isSupported(DateTimeFieldType.monthOfYear()) ? a.get(DateTimeFieldType.monthOfYear()) : -1;
        int n = bMonth = b.isSupported(DateTimeFieldType.monthOfYear()) ? b.get(DateTimeFieldType.monthOfYear()) : -1;
        if (aMonth > bMonth) {
            return true;
        }
        if (aMonth < bMonth) {
            return false;
        }
        int aDay = a.isSupported(DateTimeFieldType.dayOfMonth()) ? a.get(DateTimeFieldType.dayOfMonth()) : -1;
        int bDay = b.isSupported(DateTimeFieldType.dayOfMonth()) ? b.get(DateTimeFieldType.dayOfMonth()) : -1;
        return aDay > bDay;
    }

    public static class ComparisonResult<K> {
        private final int earliestYear;
        private final int latestYear;
        private final List<SpeciesResult> speciesResults = new ArrayList<SpeciesResult>();

        public ComparisonResult(int earliestYear, int latestYear) {
            this.earliestYear = earliestYear;
            this.latestYear = latestYear;
        }

        private SpeciesResult addSpeciesResult(SightingTaxon.Resolved resolved) {
            SpeciesResult speciesResult = new SpeciesResult(resolved);
            this.speciesResults.add(speciesResult);
            return speciesResult;
        }

        public int taxaCount() {
            return this.speciesResults.size();
        }

        public int getEarliestYear() {
            return this.earliestYear;
        }

        public int getLatestYear() {
            return this.latestYear;
        }

        public SpeciesResult getSpeciesResult(int i) {
            return this.speciesResults.get(i);
        }

        public class SpeciesResult {
            final SightingTaxon.Resolved resolved;
            final Map<K, YearResult[]> yearMap = new LinkedHashMap();

            public SpeciesResult(SightingTaxon.Resolved resolved) {
                this.resolved = resolved;
            }

            private YearResult[] getYearResultArray(K key) {
                YearResult[] yearResults = this.yearMap.get(key);
                if (yearResults == null) {
                    yearResults = new YearResult[ComparisonResult.this.getLatestYear() - ComparisonResult.this.earliestYear + 1];
                    this.yearMap.put(key, yearResults);
                }
                return yearResults;
            }

            public void addSighting(Sighting sighting, Function<Sighting, K> splitFunction) {
                int year;
                if (sighting.getStartDateAsPartial() != null && sighting.getEndDateAsPartial() != null && sighting.getStartDateAsPartial().isSupported(DateTimeFieldType.year()) && sighting.getEndDateAsPartial().isSupported(DateTimeFieldType.year()) && sighting.getStartDateAsPartial().get(DateTimeFieldType.year()) == sighting.getEndDateAsPartial().get(DateTimeFieldType.year()) && (year = sighting.getStartDateAsPartial().get(DateTimeFieldType.year())) >= ComparisonResult.this.earliestYear && year <= ComparisonResult.this.getLatestYear()) {
                    int index;
                    Object key = splitFunction.apply(sighting);
                    if (key == null) {
                        return;
                    }
                    YearResult[] years = this.getYearResultArray(key);
                    YearResult result = years[index = year - ComparisonResult.this.earliestYear];
                    if (result == null) {
                        years[index] = new YearResult(sighting);
                    } else {
                        result.addSighting(sighting);
                    }
                }
            }

            public String outputAsText() {
                StringBuilder builder = new StringBuilder(this.resolved.getCommonName());
                for (Object key : this.yearMap.keySet()) {
                    YearResult[] years;
                    for (YearResult year : years = this.getYearResultArray(key)) {
                        builder.append(",");
                        if (year == null) continue;
                        builder.append(year.outputAsText());
                    }
                }
                return builder.toString();
            }

            public SightingTaxon.Resolved getResolved() {
                return this.resolved;
            }

            public YearResult getYearResult(K key, int year) {
                return this.getYearResultArray(key)[year - ComparisonResult.this.earliestYear];
            }

            public YearResult total(K key) {
                int frequency = 0;
                ReadablePartial earliest = null;
                ReadablePartial latest = null;
                for (YearResult year : this.getYearResultArray(key)) {
                    if (year == null) continue;
                    frequency += year.frequency();
                    if (earliest == null) {
                        earliest = year.earliest();
                    } else if (year.earliest() != null && YearComparisonProcessor.lessThanIgnoringYear(year.earliest(), earliest)) {
                        earliest = year.earliest();
                    }
                    if (latest == null) {
                        latest = year.latest();
                        continue;
                    }
                    if (year.latest() == null || !YearComparisonProcessor.greaterThanIgnoringYear(year.latest(), latest)) continue;
                    latest = year.latest();
                }
                return new YearResult(earliest, latest, frequency);
            }
        }
    }

    public static class YearResult {
        private ReadablePartial earliest;
        private ReadablePartial latest;
        private int frequency;

        private YearResult(ReadablePartial earliest, ReadablePartial latest, int frequency) {
            this.earliest = earliest;
            this.latest = latest;
            this.frequency = frequency;
        }

        private YearResult(Sighting sighting) {
            if (sighting.getStartDateAsPartial().isSupported(DateTimeFieldType.monthOfYear()) && sighting.getEndDateAsPartial().isSupported(DateTimeFieldType.monthOfYear()) && sighting.getStartDateAsPartial().get(DateTimeFieldType.monthOfYear()) == sighting.getEndDateAsPartial().get(DateTimeFieldType.monthOfYear())) {
                this.earliest = this.latest = sighting.getStartDateAsPartial();
            }
            this.frequency = 1;
        }

        private void addSighting(Sighting sighting) {
            ++this.frequency;
            if (sighting.getStartDateAsPartial().isSupported(DateTimeFieldType.monthOfYear()) && sighting.getEndDateAsPartial().isSupported(DateTimeFieldType.monthOfYear()) && sighting.getStartDateAsPartial().get(DateTimeFieldType.monthOfYear()) == sighting.getEndDateAsPartial().get(DateTimeFieldType.monthOfYear())) {
                ReadablePartial date = sighting.getStartDateAsPartial();
                if (this.earliest == null) {
                    this.earliest = date;
                } else if (SightingComparators.comparePartials(date, this.earliest) < 0) {
                    this.earliest = date;
                }
                if (this.latest == null) {
                    this.latest = date;
                } else if (SightingComparators.comparePartials(date, this.latest) > 0) {
                    this.latest = date;
                }
            }
        }

        public ReadablePartial earliest() {
            return this.earliest;
        }

        public ReadablePartial latest() {
            return this.latest;
        }

        public int frequency() {
            return this.frequency;
        }

        public String outputAsText() {
            return String.format("%d [%s -> %s]", this.frequency, PartialIO.toString(this.earliest), PartialIO.toString(this.latest));
        }
    }
}

