/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.query.SightingPredicates;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.app.NavigableFrame;
import com.scythebill.birdlist.ui.app.Titled;
import com.scythebill.birdlist.ui.components.AutoSelectJFormattedTextField;
import com.scythebill.birdlist.ui.components.YearFormatter;
import com.scythebill.birdlist.ui.events.EventBusRegistrar;
import com.scythebill.birdlist.ui.events.TaxonomyChangedEvent;
import com.scythebill.birdlist.ui.events.TaxonomyStore;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.FilePreferences;
import com.scythebill.birdlist.ui.panels.reports.QueryFieldFactory;
import com.scythebill.birdlist.ui.panels.reports.QueryPanel;
import com.scythebill.birdlist.ui.panels.reports.QueryPanelFactory;
import com.scythebill.birdlist.ui.panels.reports.QueryPreferences;
import com.scythebill.birdlist.ui.panels.reports.YearComparisonProcessor;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.FileDialogs;
import com.scythebill.birdlist.ui.util.UIUtils;
import java.awt.Desktop;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.function.Function;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellUtil;
import org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.joda.time.DateTimeFieldType;
import org.joda.time.Partial;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.GJChronology;
import org.joda.time.format.DateTimeFormatterBuilder;

public class YearComparisonPanel
extends JPanel
implements FontManager.FontsUpdatedListener,
Titled {
    private final ReportSet reportSet;
    private final QueryPanelFactory queryPanelFactory;
    private final TaxonomyStore taxonomyStore;
    private final QueryPreferences queryPreferences;
    private final FileDialogs fileDialogs;
    private final NavigableFrame navigableFrame;
    private JFormattedTextField fromYearField;
    private JFormattedTextField toYearField;
    private QueryPanel queryPanel;
    private JButton saveSpreadsheetButton;
    private JButton returnButton;
    private JLabel yearComparisonLabel;
    private JLabel yearComparisonExplanation;
    private JLabel yearComparisonTitle;
    private Alerts alerts;
    private JLabel fromYearLabel;
    private JLabel toYearLabel;
    private JCheckBox splitYearCheckbox;

    @Inject
    YearComparisonPanel(ReportSet reportSet, QueryPanelFactory queryPanelFactory, TaxonomyStore taxonomyStore, EventBusRegistrar eventBusRegistrar, FontManager fontManager, QueryPreferences queryPreferences, NavigableFrame navigableFrame, FileDialogs fileDialogs, Alerts alerts) {
        this.reportSet = reportSet;
        this.queryPanelFactory = queryPanelFactory;
        this.taxonomyStore = taxonomyStore;
        this.queryPreferences = queryPreferences;
        this.navigableFrame = navigableFrame;
        this.fileDialogs = fileDialogs;
        this.alerts = alerts;
        this.initGUI();
        this.attachListeners();
        fontManager.applyTo(this);
        eventBusRegistrar.registerWhenInHierarchy(this);
        this.taxonomyChanged(null);
    }

    private void attachListeners() {
        this.returnButton.addActionListener(e -> this.navigableFrame.navigateTo("extendedReportsMenu"));
        this.queryPanel.addPredicateChangedListener(e -> this.showQueryResults());
        this.fromYearField.addPropertyChangeListener("value", e -> this.showQueryResults());
        this.toYearField.addPropertyChangeListener("value", e -> this.showQueryResults());
        this.splitYearCheckbox.addActionListener(e -> this.showQueryResults());
        this.saveSpreadsheetButton.addActionListener(e -> this.saveSpreadsheet());
    }

    private void initGUI() {
        this.queryPanel = this.queryPanelFactory.newQueryPanel(QueryFieldFactory.QueryFieldType.SUBSPECIES_ALLOCATED, QueryFieldFactory.QueryFieldType.TIMES_SIGHTED);
        this.fromYearField = new AutoSelectJFormattedTextField(new YearFormatter());
        this.fromYearField.setColumns(5);
        this.toYearField = new AutoSelectJFormattedTextField(new YearFormatter());
        this.toYearField.setColumns(5);
        this.fromYearLabel = new JLabel(Messages.getMessage(Messages.Name.FROM_LABEL));
        this.toYearLabel = new JLabel(Messages.getMessage(Messages.Name.TO_LABEL));
        this.fromYearField.putClientProperty("JTextField.placeholderText", Messages.getMessage(Messages.Name.YEAR_PROMPT));
        this.toYearField.putClientProperty("JTextField.placeholderText", Messages.getMessage(Messages.Name.YEAR_PROMPT));
        this.splitYearCheckbox = new JCheckBox(Messages.getMessage(Messages.Name.SPLIT_YEARS_CHECKBOX));
        this.yearComparisonExplanation = new JLabel();
        this.yearComparisonExplanation.putClientProperty("birdlist.plainLabel", true);
        this.yearComparisonExplanation.setText("<html>" + Messages.getMessage(Messages.Name.YEAR_COMPARISON_FULL_EXPLANATION));
        this.yearComparisonTitle = new JLabel(Messages.getMessage(Messages.Name.TOTAL_SPECIES_TEXT));
        this.yearComparisonTitle.putClientProperty("birdlist.textSize", (Object)FontManager.TextSize.LARGE);
        this.yearComparisonLabel = new JLabel();
        this.yearComparisonLabel.putClientProperty("birdlist.textSize", (Object)FontManager.TextSize.LARGE);
        this.returnButton = new JButton(Messages.getMessage(Messages.Name.BACK_TO_SPECIAL_REPORTS));
        this.saveSpreadsheetButton = new JButton(Messages.getMessage(Messages.Name.SAVE_AS_SPREADSHEET));
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        this.setBorder(new EmptyBorder(fontManager.scale(20), fontManager.scale(20), fontManager.scale(20), fontManager.scale(20)));
        GroupLayout layout = new GroupLayout(this);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.queryPanel, -2, -2, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.fromYearLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fromYearField, -2, fontManager.scale(70), -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.toYearLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.toYearField, -2, fontManager.scale(70), -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.splitYearCheckbox)).addComponent(this.yearComparisonTitle).addComponent(this.yearComparisonLabel).addComponent(this.yearComparisonExplanation).addGroup(layout.createSequentialGroup().addComponent(this.saveSpreadsheetButton)).addComponent(this.returnButton, GroupLayout.Alignment.TRAILING));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.yearComparisonExplanation).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createBaselineGroup(false, false).addComponent(this.fromYearLabel).addComponent(this.fromYearField).addComponent(this.toYearLabel).addComponent(this.toYearField).addComponent(this.splitYearCheckbox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.queryPanel, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.yearComparisonTitle).addComponent(this.yearComparisonLabel).addGap(fontManager.scale(10), fontManager.scale(10), Short.MAX_VALUE).addGroup(layout.createBaselineGroup(false, false).addComponent(this.saveSpreadsheetButton).addComponent(this.returnButton)));
        this.setLayout(layout);
    }

    @Subscribe
    public void taxonomyChanged(TaxonomyChangedEvent event) {
        this.queryPanel.taxonomyUpdated();
        this.showQueryResults();
    }

    private void showQueryResults() {
        YearComparisonProcessor.ComparisonResult<SplitYearKey> yearComparisonResults = this.computeYearComparison();
        this.yearComparisonLabel.setText(NumberFormat.getIntegerInstance().format(yearComparisonResults.taxaCount()));
    }

    private YearComparisonProcessor.ComparisonResult<SplitYearKey> computeYearComparison() {
        Taxonomy taxonomy = this.taxonomyStore.getTaxonomy();
        Predicate<Sighting> countablePredicate = this.queryPreferences.getCountablePredicate(taxonomy, this.queryPanel.containsQueryFieldType(QueryFieldFactory.QueryFieldType.SIGHTING_STATUS), this.queryPanel.getBooleanValueIfPresent(QueryFieldFactory.QueryFieldType.ALLOW_HEARD_ONLY));
        Predicate<Sighting> yearRangePredicate = null;
        if (!this.fromYearField.getText().isEmpty()) {
            int fromYear = (Integer)this.fromYearField.getValue();
            Partial fromDate = new Partial(GJChronology.getInstance()).with(DateTimeFieldType.year(), fromYear);
            yearRangePredicate = SightingPredicates.afterOrEquals(fromDate);
        }
        if (!this.toYearField.getText().isEmpty()) {
            int toYear = (Integer)this.toYearField.getValue();
            Partial toDate = new Partial(GJChronology.getInstance()).with(DateTimeFieldType.year(), toYear);
            Predicate<Sighting> toPredicate = SightingPredicates.beforeOrEquals(toDate);
            yearRangePredicate = yearRangePredicate == null ? toPredicate : Predicates.and(yearRangePredicate, toPredicate);
        }
        Function<Sighting, SplitYearKey> splitFunction = this.splitYearCheckbox.isSelected() ? s -> {
            ReadablePartial startDate = s.getStartDateAsPartial();
            if (startDate == null || !startDate.isSupported(DateTimeFieldType.monthOfYear())) {
                return null;
            }
            ReadablePartial endDate = s.getEndDateAsPartial();
            if (endDate == null || !endDate.isSupported(DateTimeFieldType.monthOfYear())) {
                return null;
            }
            int startMonth = startDate.get(DateTimeFieldType.monthOfYear());
            int endMonth = endDate.get(DateTimeFieldType.monthOfYear());
            if (startMonth <= 6 && endMonth <= 6) {
                return SplitYearKey.H1;
            }
            if (startMonth > 6 && endMonth > 6) {
                return SplitYearKey.H2;
            }
            return null;
        } : s -> SplitYearKey.WHOLE_YEAR;
        return new YearComparisonProcessor(this.reportSet, taxonomy, this.queryPanel.queryDefinition(taxonomy, Taxon.Type.species), countablePredicate).process(yearRangePredicate, splitFunction);
    }

    private void saveSpreadsheet() {
        Optional<String> reportName = this.queryPanel.getQueryAbbreviation();
        String fileName = reportName.isPresent() ? String.format("year-comparison-%s.xlsx", reportName.get()) : String.format("year-comparison.xlsx", new Object[0]);
        File out = this.fileDialogs.saveFile(UIUtils.findFrame(this), Messages.getMessage(Messages.Name.PICK_FILE_TITLE), fileName, new FileNameExtensionFilter(Messages.getMessage(Messages.Name.XLSX_FILES), "xlsx"), FilePreferences.FileType.OTHER);
        if (out != null) {
            int i;
            int i2;
            SplitYearKey[] splitYearKeyArray;
            int yearSplits;
            YearComparisonProcessor.ComparisonResult<SplitYearKey> result = this.computeYearComparison();
            int earliestYear = result.getEarliestYear();
            int latestYear = result.getLatestYear();
            int yearCount = latestYear - earliestYear + 1;
            boolean splitYear = this.splitYearCheckbox.isSelected();
            int n = yearSplits = splitYear ? 2 : 1;
            if (splitYear) {
                SplitYearKey[] splitYearKeyArray2 = new SplitYearKey[2];
                splitYearKeyArray2[0] = SplitYearKey.H1;
                splitYearKeyArray = splitYearKeyArray2;
                splitYearKeyArray2[1] = SplitYearKey.H2;
            } else {
                SplitYearKey[] splitYearKeyArray3 = new SplitYearKey[1];
                splitYearKeyArray = splitYearKeyArray3;
                splitYearKeyArray3[0] = SplitYearKey.WHOLE_YEAR;
            }
            SplitYearKey[] keys = splitYearKeyArray;
            int totalColumnsWidth = (yearCount > 1 ? 4 : 0) * yearSplits;
            XSSFWorkbook workbook = new XSSFWorkbook();
            CellStyle headerStyle = workbook.createCellStyle();
            Font headerFont = workbook.createFont();
            headerFont.setBold(true);
            headerStyle.setFont(headerFont);
            CellStyle centerHeaderStyle = workbook.createCellStyle();
            centerHeaderStyle.cloneStyleFrom(headerStyle);
            centerHeaderStyle.setAlignment(HorizontalAlignment.CENTER);
            CellStyle rotatedHeaderStyle = workbook.createCellStyle();
            rotatedHeaderStyle.cloneStyleFrom(headerStyle);
            rotatedHeaderStyle.setRotation((short)90);
            CellStyle blankColoredCell = workbook.createCellStyle();
            ((XSSFCellStyle)blankColoredCell).setFillPattern(FillPatternType.SOLID_FOREGROUND);
            ((XSSFCellStyle)blankColoredCell).setFillForegroundColor(new XSSFColor(IndexedColors.YELLOW, (IndexedColorMap)new DefaultIndexedColorMap()));
            blankColoredCell.setBorderLeft(BorderStyle.THIN);
            blankColoredCell.setBorderRight(BorderStyle.THIN);
            Sheet sheet = workbook.createSheet();
            Row prefaceHeader = sheet.createRow(0);
            Location rootLocation = this.queryPanel.getRootLocation();
            if (rootLocation != null) {
                CellUtil.createCell(prefaceHeader, 0, rootLocation.getDisplayName(), headerStyle);
            }
            for (int i3 = 0; i3 < yearCount * yearSplits + (yearSplits - 1); ++i3) {
                CellUtil.createCell(prefaceHeader, i3 * 4 + 4, "", blankColoredCell);
            }
            Row yearRow = sheet.createRow(1);
            if (yearCount > 1) {
                for (i2 = 0; i2 < yearSplits; ++i2) {
                    CellUtil.createCell(yearRow, i2 * 4 + 1, keys[i2].titleString(), centerHeaderStyle);
                    sheet.addMergedRegion(new CellRangeAddress(1, 1, i2 * 4 + 1, i2 * 4 + 3));
                    CellUtil.createCell(yearRow, i2 * 4 + 4, "", blankColoredCell);
                }
            }
            for (i2 = 0; i2 < yearCount * yearSplits; ++i2) {
                String yearName = earliestYear + i2 / yearSplits + keys[i2 % yearSplits].suffixString();
                CellUtil.createCell(yearRow, i2 * 4 + 1 + totalColumnsWidth, yearName, centerHeaderStyle);
                sheet.addMergedRegion(new CellRangeAddress(1, 1, i2 * 4 + 1 + totalColumnsWidth, i2 * 4 + 3 + totalColumnsWidth));
                CellUtil.createCell(yearRow, i2 * 4 + totalColumnsWidth, "", blankColoredCell);
            }
            Row headerRow = sheet.createRow(2);
            CellUtil.createCell(headerRow, 0, Messages.getMessage(Messages.Name.SPECIES_TEXT), rotatedHeaderStyle);
            for (int i4 = 0; i4 < (yearCount == 1 ? 1 : yearCount + 1) * yearSplits; ++i4) {
                CellUtil.createCell(headerRow, i4 * 4 + 1, Messages.getMessage(Messages.Name.FIRST_SEEN), rotatedHeaderStyle);
                CellUtil.createCell(headerRow, i4 * 4 + 2, Messages.getMessage(Messages.Name.LAST_SEEN), rotatedHeaderStyle);
                CellUtil.createCell(headerRow, i4 * 4 + 3, Messages.getMessage(Messages.Name.NUMBER_TEXT), rotatedHeaderStyle);
                if (i4 >= (yearCount + 1) * yearSplits - 1) continue;
                CellUtil.createCell(headerRow, i4 * 4 + 4, "", blankColoredCell);
            }
            int[] yearTotals = new int[(yearCount == 1 ? 1 : yearCount + 1) * yearSplits];
            for (i = 0; i < result.taxaCount(); ++i) {
                Cell frequencyCell;
                Row row = sheet.createRow(3 + i);
                YearComparisonProcessor.ComparisonResult.SpeciesResult speciesResult = result.getSpeciesResult(i);
                SightingTaxon.Resolved resolved = speciesResult.getResolved();
                CellUtil.createCell(row, 0, resolved.getCommonName());
                if (yearCount > 1) {
                    for (int yearSplit = 0; yearSplit < yearSplits; ++yearSplit) {
                        YearComparisonProcessor.YearResult total = speciesResult.total(keys[yearSplit]);
                        if (total.frequency() > 0) {
                            if (total.earliest() != null) {
                                CellUtil.createCell(row, 4 * yearSplit + 1, String.format("%s (%s)", this.toUserStringWithoutYear(total.earliest()), total.earliest().get(DateTimeFieldType.year())));
                            }
                            if (total.latest() != null) {
                                CellUtil.createCell(row, 4 * yearSplit + 2, String.format("%s (%s)", this.toUserStringWithoutYear(total.latest()), total.latest().get(DateTimeFieldType.year())));
                            }
                            frequencyCell = row.createCell(4 * yearSplit + 3, CellType.NUMERIC);
                            frequencyCell.setCellValue(total.frequency());
                            int n2 = yearSplit;
                            yearTotals[n2] = yearTotals[n2] + 1;
                        }
                        CellUtil.createCell(row, 4 * yearSplit + 4, "", blankColoredCell);
                    }
                }
                for (int j = 0; j < yearCount * yearSplits; ++j) {
                    YearComparisonProcessor.YearResult yearResult = speciesResult.getYearResult(keys[j % yearSplits], earliestYear + j / yearSplits);
                    if (yearResult != null) {
                        CellUtil.createCell(row, j * 4 + 1 + totalColumnsWidth, this.toUserStringWithoutYear(yearResult.earliest()));
                        CellUtil.createCell(row, j * 4 + 2 + totalColumnsWidth, this.toUserStringWithoutYear(yearResult.latest()));
                        frequencyCell = row.createCell(j * 4 + 3 + totalColumnsWidth, CellType.NUMERIC);
                        frequencyCell.setCellValue(yearResult.frequency());
                        int n3 = yearCount == 1 ? j : j + yearSplits;
                        yearTotals[n3] = yearTotals[n3] + 1;
                    }
                    CellUtil.createCell(row, j * 4 + 4 * yearSplits, "", blankColoredCell);
                }
            }
            for (i = 0; i < yearTotals.length; ++i) {
                CellUtil.createCell(prefaceHeader, i * 4 + 1, Messages.getFormattedMessage(Messages.Name.SPECIES_WITH_NUMBER, yearTotals[i]));
                sheet.addMergedRegion(new CellRangeAddress(0, 0, i * 4 + 1, i * 4 + 3));
            }
            sheet.autoSizeColumn(0);
            for (i = 0; i < yearTotals.length - 1; ++i) {
                sheet.setColumnWidth(i * 4 + 4, 128);
            }
            if (yearCount > 1) {
                for (int yearSplit = 0; yearSplit < yearSplits; ++yearSplit) {
                    sheet.autoSizeColumn(1 + 4 * yearSplit);
                    sheet.autoSizeColumn(2 + 4 * yearSplit);
                }
            }
            sheet.createFreezePane(4 * yearSplits, 3);
            try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(out));){
                workbook.write(stream);
                workbook.close();
            }
            catch (IOException e) {
                FileDialogs.showFileSaveError(this.alerts, e, out);
                return;
            }
            try {
                Desktop.getDesktop().open(out);
            }
            catch (IOException e) {
                this.alerts.showError((Object)this, (Throwable)e, Messages.Name.OPENING_FAILED, Messages.Name.NO_APPLICATION_FOR_XLS_FILES, new Object[0]);
                return;
            }
        }
    }

    private String toUserStringWithoutYear(ReadablePartial p) {
        if (p == null) {
            return "";
        }
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        if (p.isSupported(DateTimeFieldType.dayOfMonth())) {
            builder.appendDayOfMonth(1);
            builder.appendLiteral(' ');
        }
        if (p.isSupported(DateTimeFieldType.monthOfYear())) {
            builder.appendShortText(DateTimeFieldType.monthOfYear());
        }
        StringBuffer buffer = new StringBuffer();
        builder.toPrinter().printTo(buffer, p, Locale.getDefault());
        return buffer.toString();
    }

    @Override
    public String getTitle() {
        return Messages.getMessage(Messages.Name.YEAR_COMPARISONS);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum SplitYearKey {
        WHOLE_YEAR{

            @Override
            public String suffixString() {
                return "";
            }

            @Override
            public String titleString() {
                return "";
            }
        }
        ,
        H1{

            @Override
            public String suffixString() {
                return " H1";
            }

            @Override
            public String titleString() {
                return "H1";
            }
        }
        ,
        H2{

            @Override
            public String suffixString() {
                return " H2";
            }

            @Override
            public String titleString() {
                return "H2";
            }
        };


        public abstract String suffixString();

        public abstract String titleString();
    }
}

