/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.scythebill.birdlist.model.query.PredicateQueryDefinition;
import com.scythebill.birdlist.model.query.QueryDefinition;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.VisitInfo;
import com.scythebill.birdlist.model.sighting.VisitInfoKey;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.reports.AbstractQueryField;
import com.scythebill.birdlist.ui.panels.reports.QueryFieldFactory;
import java.util.function.Function;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class VisitCommentsQueryField
extends AbstractQueryField {
    private final JComboBox<QueryType> options = new JComboBox<QueryType>(QueryType.values());
    private final JTextField text;
    private Timer timer;
    private static final Gson GSON = new Gson();

    public VisitCommentsQueryField() {
        super(QueryFieldFactory.QueryFieldType.VISIT_COMMENTS);
        this.options.addActionListener(e -> this.firePredicateUpdated());
        this.text = new JTextField(20);
        this.timer = new Timer(200, e -> this.firePredicateUpdated());
        this.timer.setRepeats(false);
        this.text.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                VisitCommentsQueryField.this.timer.restart();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                VisitCommentsQueryField.this.timer.restart();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                VisitCommentsQueryField.this.timer.restart();
            }
        });
    }

    @Override
    public JComponent getComparisonChooser() {
        return this.options;
    }

    @Override
    public JComponent getValueField() {
        return this.text;
    }

    @Override
    public QueryDefinition queryDefinition(ReportSet reportSet, Taxon.Type depth) {
        return new PredicateQueryDefinition(this.predicate(reportSet, depth));
    }

    private Predicate<Sighting> predicate(ReportSet reportSet, Taxon.Type depth) {
        QueryType whenOption = (QueryType)((Object)this.options.getSelectedItem());
        boolean isCaseSensitive = whenOption.isCaseSensitive();
        final String containsText = isCaseSensitive ? this.text.getText() : this.text.getText().toLowerCase();
        final Function<Sighting, String> extractText = input -> {
            VisitInfoKey key = VisitInfoKey.forSighting(input);
            if (key == null) {
                return null;
            }
            VisitInfo visitInfo = reportSet.getVisitInfo(key);
            if (visitInfo == null) {
                return null;
            }
            if (!visitInfo.comments().isPresent()) {
                return null;
            }
            String comments = visitInfo.comments().get();
            if (!isCaseSensitive) {
                comments = comments.toLowerCase();
            }
            return comments;
        };
        if (whenOption == QueryType.IS_EXACTLY || whenOption == QueryType.IS_EXACTLY_CASE_SENSITIVE) {
            return new Predicate<Sighting>(){

                @Override
                public boolean apply(Sighting input) {
                    String comments = (String)extractText.apply(input);
                    if (comments == null) {
                        return false;
                    }
                    return comments.equals(containsText);
                }
            };
        }
        if (whenOption == QueryType.STARTS_WITH_WORD || whenOption == QueryType.STARTS_WTIH_WORD_CASE_SENSITIVE) {
            return new Predicate<Sighting>(){

                @Override
                public boolean apply(Sighting input) {
                    String comments = (String)extractText.apply(input);
                    if (comments == null) {
                        return false;
                    }
                    if (!comments.startsWith(containsText)) {
                        return false;
                    }
                    if (comments.length() == containsText.length()) {
                        return true;
                    }
                    return !Character.isLetter(comments.charAt(containsText.length()));
                }
            };
        }
        Predicate<Sighting> containsPredicate = new Predicate<Sighting>(){

            @Override
            public boolean apply(Sighting input) {
                String comments = (String)extractText.apply(input);
                if (comments == null) {
                    return false;
                }
                return comments.contains(containsText);
            }
        };
        if (whenOption == QueryType.DOES_NOT_CONTAIN || whenOption == QueryType.DOES_NOT_CONTAIN_CASE_SENSITIVE) {
            return Predicates.not(containsPredicate);
        }
        return containsPredicate;
    }

    @Override
    public boolean isNoOp() {
        return false;
    }

    @Override
    public JsonElement persist() {
        Persisted persisted = new Persisted((QueryType)((Object)this.options.getSelectedItem()), this.text.getText());
        return GSON.toJsonTree(persisted);
    }

    @Override
    public void restore(JsonElement json) {
        Persisted persisted = GSON.fromJson(json, Persisted.class);
        this.options.setSelectedItem((Object)persisted.type);
        this.text.setText(persisted.text);
    }

    private static enum QueryType {
        CONTAINS(Messages.Name.DESCRIPTION_CONTAINS, false),
        DOES_NOT_CONTAIN(Messages.Name.DESCRIPTION_DOESNT_CONTAIN, false),
        IS_EXACTLY(Messages.Name.DESCRIPTION_IS_EXACTLY, false),
        STARTS_WITH_WORD(Messages.Name.DESCRIPTION_STARTS_WITH_WORD, false),
        CONTAINS_CASE_SENSITIVE(Messages.Name.DESCRIPTION_CONTAINS_CASE_SENSITIVE, true),
        DOES_NOT_CONTAIN_CASE_SENSITIVE(Messages.Name.DESCRIPTION_DOESNT_CONTAIN_CASE_SENSITIVE, true),
        IS_EXACTLY_CASE_SENSITIVE(Messages.Name.DESCRIPTION_IS_EXACTLY_CASE_SENSITIVE, true),
        STARTS_WTIH_WORD_CASE_SENSITIVE(Messages.Name.DESCRIPTION_STARTS_WITH_WORD_CASE_SENSITIVE, true);

        private final Messages.Name text;
        private final boolean caseSensitive;

        private QueryType(Messages.Name text, boolean caseSensitive) {
            this.text = text;
            this.caseSensitive = caseSensitive;
        }

        public String toString() {
            return Messages.getMessage(this.text);
        }

        boolean isCaseSensitive() {
            return this.caseSensitive;
        }
    }

    static class Persisted {
        QueryType type;
        String text;

        public Persisted(QueryType type, String text) {
            this.type = type;
            this.text = text;
        }
    }
}

