/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.scythebill.birdlist.model.query.SightingPredicates;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.user.User;
import com.scythebill.birdlist.model.user.UserSet;
import com.scythebill.birdlist.model.util.Indexer;
import com.scythebill.birdlist.model.util.ToString;
import com.scythebill.birdlist.ui.components.IndexerPanel;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.reports.AbstractQueryField;
import com.scythebill.birdlist.ui.panels.reports.QueryFieldFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;

class UserQueryField
extends AbstractQueryField {
    private final JComboBox<QueryType> userOptions = new JComboBox<QueryType>(QueryType.values());
    private final IndexerPanel<User> userIndexer;
    private final UserSet userSet;
    private static final Gson GSON = new Gson();

    public UserQueryField(UserSet userSet) {
        super(QueryFieldFactory.QueryFieldType.USER);
        this.userSet = userSet;
        this.userIndexer = new IndexerPanel();
        this.userIndexer.setColumns(15);
        this.userIndexer.setLayoutStrategy(IndexerPanel.LayoutStrategy.BELOW);
        if (userSet == null) {
            this.userIndexer.setVisible(false);
        } else {
            Indexer<User> indexer = new Indexer<User>(4);
            for (User user : userSet.allUsers()) {
                if (user.name() != null) {
                    indexer.add(user.name(), user);
                    continue;
                }
                indexer.add(user.abbreviation(), user);
            }
            ToString<User> toString = new ToString<User>(){

                @Override
                public String getString(User user) {
                    return user.name() != null ? user.name() : user.abbreviation();
                }
            };
            this.userIndexer.addIndexerGroup(toString, indexer);
            this.userIndexer.setPreviewText(Messages.Name.OBSERVER_NAME);
            this.userIndexer.addPropertyChangeListener("value", e -> this.firePredicateUpdated());
            this.userOptions.addActionListener(e -> this.firePredicateUpdated());
            this.userOptions.addActionListener(e -> this.userIndexer.setVisible(this.userOptions.getSelectedItem() != QueryType.ARE_EMPTY));
        }
    }

    @Override
    public JComponent getComparisonChooser() {
        return this.userOptions;
    }

    @Override
    public JComponent getValueField() {
        return this.userIndexer;
    }

    public void setUser(User user) {
        this.userIndexer.setValue(user);
        this.userOptions.setSelectedItem((Object)QueryType.INCLUDES);
    }

    @Override
    public Predicate<Sighting> predicate(Taxon.Type depth) {
        Object selectedItem = this.userOptions.getSelectedItem();
        if (QueryType.ARE_EMPTY.equals(selectedItem)) {
            return SightingPredicates.usersAreExactly(ImmutableSet.of());
        }
        User user = this.userIndexer.getValue();
        if (user == null) {
            return Predicates.alwaysTrue();
        }
        if (QueryType.INCLUDES.equals(selectedItem)) {
            return SightingPredicates.includesUser(user);
        }
        if (QueryType.DOES_NOT_INCLUDE.equals(selectedItem)) {
            return Predicates.not(SightingPredicates.includesUser(user));
        }
        if (QueryType.IS_ONLY.equals(selectedItem)) {
            return SightingPredicates.usersAreExactly(ImmutableSet.of(user));
        }
        throw new IllegalStateException("Unknown location option: " + selectedItem);
    }

    @Override
    public boolean isNoOp() {
        return this.userIndexer.getValue() == null;
    }

    @Override
    public Optional<String> abbreviation() {
        User user = this.userIndexer.getValue();
        if (user != null) {
            if (user.abbreviation() != null) {
                return Optional.of(user.abbreviation());
            }
            if (user.name() != null) {
                return Optional.of(user.name());
            }
        }
        return Optional.absent();
    }

    @Override
    public Optional<String> name() {
        User user = this.userIndexer.getValue();
        if (user != null) {
            if (user.name() != null) {
                return Optional.of(user.name());
            }
            if (user.abbreviation() != null) {
                return Optional.of(user.abbreviation());
            }
        }
        return Optional.absent();
    }

    @Override
    public JsonElement persist() {
        User user = this.userIndexer.getValue();
        Persisted persisted = new Persisted((QueryType)((Object)this.userOptions.getSelectedItem()), user == null ? null : user.id());
        return GSON.toJsonTree(persisted);
    }

    @Override
    public void restore(JsonElement json) {
        Persisted persisted = GSON.fromJson(json, Persisted.class);
        this.userOptions.setSelectedItem((Object)persisted.type);
        if (persisted.id == null) {
            this.userIndexer.setValue(null);
        } else {
            if (this.userSet == null) {
                throw new JsonSyntaxException("No users");
            }
            try {
                this.userIndexer.setValue(this.userSet.userById(persisted.id));
            }
            catch (IllegalArgumentException e) {
                throw new JsonSyntaxException("User " + persisted.id + " not found");
            }
        }
    }

    private static enum QueryType {
        INCLUDES(Messages.Name.USER_INCLUDES),
        DOES_NOT_INCLUDE(Messages.Name.USER_DOES_NOT_INCLUDE),
        IS_ONLY(Messages.Name.USER_IS_ONLY),
        ARE_EMPTY(Messages.Name.USER_ARE_EMPTY);

        private final Messages.Name text;

        private QueryType(Messages.Name text) {
            this.text = text;
        }

        public String toString() {
            return Messages.getMessage(this.text);
        }
    }

    static class Persisted {
        QueryType type;
        String id;

        public Persisted(QueryType type, String id) {
            this.type = type;
            this.id = id;
        }
    }
}

