/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.SightingTaxons;
import com.scythebill.birdlist.model.taxa.MappedTaxonomy;
import com.scythebill.birdlist.model.taxa.Species;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.TaxonVisitor;
import com.scythebill.birdlist.model.taxa.Taxonomy;

@Singleton
public class UndescribedTaxa {
    private final LoadingCache<Taxonomy, ImmutableSet<SightingTaxon>> undescribedTaxaCache = CacheBuilder.newBuilder().build(new CacheLoader<Taxonomy, ImmutableSet<SightingTaxon>>(){

        @Override
        public ImmutableSet<SightingTaxon> load(Taxonomy taxonomy) throws Exception {
            final ImmutableSet.Builder undescribedTaxa = ImmutableSet.builder();
            if (taxonomy instanceof MappedTaxonomy) {
                final MappedTaxonomy mappedTaxonomy = (MappedTaxonomy)taxonomy;
                TaxonUtils.visitTaxa(mappedTaxonomy, new TaxonVisitor(){

                    @Override
                    public boolean visitTaxon(Taxon taxon) {
                        SightingTaxon mapping;
                        if (taxon.getStatus() == Species.Status.UN && (mapping = mappedTaxonomy.getExactMapping(taxon)) != null) {
                            undescribedTaxa.add(mapping);
                        }
                        return true;
                    }
                });
            } else {
                TaxonUtils.visitTaxa(taxonomy, new TaxonVisitor(){

                    @Override
                    public boolean visitTaxon(Taxon taxon) {
                        if (taxon.getStatus() == Species.Status.UN) {
                            undescribedTaxa.add(SightingTaxons.newSightingTaxon(taxon.getId()));
                        }
                        return true;
                    }
                });
            }
            return undescribedTaxa.build();
        }
    });

    @Inject
    UndescribedTaxa() {
    }

    public ImmutableSet<SightingTaxon> undescribedTaxa(Taxonomy taxonomy) {
        return this.undescribedTaxaCache.getUnchecked(taxonomy);
    }
}

