/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.inject.Inject;
import com.scythebill.birdlist.model.taxa.names.NamesPreferences;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.reports.TripReportPreferences;
import com.scythebill.birdlist.ui.util.Alerts;
import java.awt.Component;
import javax.annotation.Nullable;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

class TripReportDialog {
    private Alerts alerts;
    private TripReportPreferences tripReportPreferences;
    private FontManager fontManager;
    private NamesPreferences namesPreferences;
    private boolean speciesTableDisabled;
    private boolean multipleTaxonomiesDisabled;

    @Inject
    TripReportDialog(Alerts alerts, TripReportPreferences tripReportPreferences, NamesPreferences namesPreferences, FontManager fontManager) {
        this.alerts = alerts;
        this.tripReportPreferences = tripReportPreferences;
        this.namesPreferences = namesPreferences;
        this.fontManager = fontManager;
    }

    public void disableSpeciesTable() {
        this.speciesTableDisabled = true;
    }

    public void disableMultipleTaxonomies() {
        this.multipleTaxonomiesDisabled = true;
    }

    @Nullable
    public TripReportPreferences getConfiguration(Component parent) {
        TripReportConfigurationPanel panel = new TripReportConfigurationPanel();
        this.fontManager.applyTo(panel);
        String formattedMessage = this.alerts.getFormattedDialogMessage(Messages.Name.TRIP_REPORT_OPTIONS, Messages.Name.TRIP_REPORT_OPTIONS_MESSAGE, new Object[0]);
        int okCancel = this.alerts.showOkCancelWithPanel(SwingUtilities.getWindowAncestor(parent), formattedMessage, panel);
        if (okCancel != 0) {
            return null;
        }
        panel.updatePreferences();
        if (this.speciesTableDisabled) {
            TripReportPreferences cloned = this.tripReportPreferences.clone();
            cloned.includeSpeciesTable = false;
            return cloned;
        }
        return this.tripReportPreferences;
    }

    public NamesPreferences.ScientificOrCommon getScientificOrCommonFromConfiguration(TripReportPreferences prefs) {
        NamesPreferences.ScientificOrCommon scientificOrCommon = this.namesPreferences.scientificOrCommon;
        if (prefs.includeScientific) {
            if (scientificOrCommon == NamesPreferences.ScientificOrCommon.COMMON_ONLY) {
                return NamesPreferences.ScientificOrCommon.COMMON_FIRST;
            }
        } else {
            switch (scientificOrCommon) {
                case SCIENTIFIC_ONLY: 
                case COMMON_FIRST: 
                case SCIENTIFIC_FIRST: {
                    return NamesPreferences.ScientificOrCommon.COMMON_ONLY;
                }
            }
        }
        return scientificOrCommon;
    }

    class TripReportConfigurationPanel
    extends JPanel {
        private JCheckBox includeScientific;
        private JCheckBox includeItinerary;
        private JCheckBox includeSpeciesTable;
        private JCheckBox includeSpeciesList;
        private JCheckBox includeFavoritePhotos;
        private JCheckBox showAllTaxonomies;
        private JCheckBox showStatus;

        TripReportConfigurationPanel() {
            GroupLayout layout = new GroupLayout(this);
            this.setLayout(layout);
            this.includeScientific = new JCheckBox(Messages.getMessage(Messages.Name.SCIENTIFIC_NAME_QUESTION));
            this.includeScientific.setSelected(TripReportDialog.this.tripReportPreferences.includeScientific);
            if (TripReportDialog.this.namesPreferences.scientificOrCommon == NamesPreferences.ScientificOrCommon.COMMON_ONLY) {
                this.includeScientific.setSelected(false);
            } else if (TripReportDialog.this.namesPreferences.scientificOrCommon == NamesPreferences.ScientificOrCommon.SCIENTIFIC_ONLY) {
                this.includeScientific.setSelected(true);
            }
            this.includeItinerary = new JCheckBox(Messages.getMessage(Messages.Name.INCLUDE_ITINERARY_QUESTION));
            this.includeItinerary.setSelected(TripReportDialog.this.tripReportPreferences.includeItinerary);
            this.includeSpeciesTable = new JCheckBox(Messages.getMessage(Messages.Name.INCLUDE_SPECIES_TABLE_QUESTION));
            if (TripReportDialog.this.speciesTableDisabled) {
                this.includeSpeciesTable.setSelected(false);
                this.includeSpeciesTable.setEnabled(false);
            } else {
                this.includeSpeciesTable.setSelected(TripReportDialog.this.tripReportPreferences.includeSpeciesTable);
            }
            this.includeSpeciesList = new JCheckBox(Messages.getMessage(Messages.Name.INCLUDE_SPECIES_LIST_QUESTION));
            this.includeSpeciesList.setSelected(TripReportDialog.this.tripReportPreferences.includeSpeciesList);
            this.showStatus = new JCheckBox(Messages.getMessage(Messages.Name.SHOW_THREATENED_STATUS_QUESTION));
            this.showStatus.setSelected(TripReportDialog.this.tripReportPreferences.showStatus);
            this.showAllTaxonomies = new JCheckBox(Messages.getMessage(Messages.Name.INCLUDE_OTHER_TAXONOMIES_QUESTION));
            this.showAllTaxonomies.setSelected(TripReportDialog.this.tripReportPreferences.showAllTaxonomies);
            this.includeFavoritePhotos = new JCheckBox(Messages.getMessage(Messages.Name.INCLUDE_FAVORITE_PHOTOS_QUESTION));
            this.includeFavoritePhotos.setSelected(TripReportDialog.this.tripReportPreferences.includeFavoritePhotos);
            layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.includeScientific).addComponent(this.includeItinerary).addComponent(this.includeSpeciesTable).addComponent(this.includeSpeciesList).addComponent(this.showStatus).addComponent(this.showAllTaxonomies).addComponent(this.includeFavoritePhotos));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.includeScientific).addComponent(this.includeItinerary).addComponent(this.includeSpeciesTable).addComponent(this.includeSpeciesList).addComponent(this.showStatus).addComponent(this.showAllTaxonomies).addComponent(this.includeFavoritePhotos));
            this.includeFavoritePhotos.setEnabled(this.includeSpeciesList.isSelected());
            this.showStatus.setEnabled(this.includeSpeciesList.isSelected());
            this.includeSpeciesList.addActionListener(e -> {
                this.includeFavoritePhotos.setEnabled(this.includeSpeciesList.isSelected());
                this.showStatus.setEnabled(this.includeSpeciesList.isSelected());
            });
            if (TripReportDialog.this.multipleTaxonomiesDisabled) {
                this.showAllTaxonomies.setEnabled(false);
            } else {
                this.showAllTaxonomies.setEnabled(this.includeSpeciesList.isSelected());
                this.includeSpeciesList.addActionListener(e -> this.showAllTaxonomies.setEnabled(this.includeSpeciesList.isSelected()));
            }
        }

        void updatePreferences() {
            TripReportDialog.this.tripReportPreferences.includeScientific = this.includeScientific.isSelected();
            TripReportDialog.this.tripReportPreferences.includeItinerary = this.includeItinerary.isSelected();
            if (!TripReportDialog.this.speciesTableDisabled) {
                TripReportDialog.this.tripReportPreferences.includeSpeciesTable = this.includeSpeciesTable.isSelected();
            }
            TripReportDialog.this.tripReportPreferences.includeSpeciesList = this.includeSpeciesList.isSelected();
            TripReportDialog.this.tripReportPreferences.showStatus = this.showStatus.isSelected();
            TripReportDialog.this.tripReportPreferences.showAllTaxonomies = this.showAllTaxonomies.isSelected();
            TripReportDialog.this.tripReportPreferences.includeFavoritePhotos = this.includeFavoritePhotos.isSelected();
        }
    }
}

