/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.scythebill.birdlist.model.query.QueryDefinition;
import com.scythebill.birdlist.model.query.QueryProcessor;
import com.scythebill.birdlist.model.query.QueryResults;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.Taxonomy;

public class TotalTicksProcessor {
    private static final ImmutableMap<String, String> STATE_TO_COUNTRY = ImmutableMap.builder().put("EC-W", "EC").put("PM", "FR").put("CO-SAP", "CO").build();
    private static final ImmutableMap<String, String> COUNTRY_TO_STATE = ImmutableMap.builder().put("AU-TAS-Macquarie", "AU-TAS").put("CL-VS-JuanFernandez", "CL-VS").put("CL-VS-Easter", "CL-VS").put("YE-HD-SOC", "YE-HD").put("ZA-WC-EdwardMarion", "ZA-WC").build();
    private static final ImmutableMap<String, String> PSEUDO_COUNTRY_TO_COUNTRY = ImmutableMap.builder().put("AX", "FI").put("AC", "AU").put("CS", "AU").put("CC", "AU").put("CX", "AU").put("NF", "AU").put("HM", "AU").put("BV", "NO").put("SJ", "NO").put("UM", "US").build();

    TotalTicksProcessor() {
    }

    public Multimap<String, String> computeTotalTicks(ReportSet reportSet, PredefinedLocations predefinedLocations, TotalTickType type, Taxonomy taxonomy, QueryDefinition queryDefinition, Predicate<Sighting> countablePredicate) {
        QueryProcessor queryProcessor = new QueryProcessor(reportSet, taxonomy);
        queryProcessor.onlyIncludeCountableSightings().dontIncludeFamilyNames();
        QueryResults results = queryProcessor.runQuery(queryDefinition, countablePredicate, Taxon.Type.species);
        LinkedHashMultimap<String, String> totalTicksMultimap = LinkedHashMultimap.create();
        for (Sighting sighting : results.getAllSightings()) {
            SightingTaxon species;
            String eBirdCode;
            Location location;
            Location locationBucket;
            if (sighting.getLocationId() == null || (locationBucket = type.bucketLocation(location = reportSet.getLocations().getLocation(sighting.getLocationId()), reportSet, predefinedLocations)) == null) continue;
            reportSet.getLocations().ensureAdded(locationBucket);
            String bucketId = locationBucket.getId();
            if (type == TotalTickType.COUNTRY && (eBirdCode = locationBucket.getEbirdCode()) != null) {
                int hyphenIndex = eBirdCode.indexOf(45);
                if (hyphenIndex > 0) {
                    eBirdCode = eBirdCode.substring(0, hyphenIndex);
                }
                eBirdCode = PSEUDO_COUNTRY_TO_COUNTRY.getOrDefault(eBirdCode, eBirdCode);
                Location locationByCode = reportSet.getLocations().getLocationByCode(eBirdCode);
                if (locationByCode != null) {
                    bucketId = locationByCode.getId();
                }
            }
            if ((species = sighting.getTaxon().resolve(taxonomy).getParentOfAtLeastType(Taxon.Type.species)).getType() == SightingTaxon.Type.HYBRID || species.getType() == SightingTaxon.Type.SP) continue;
            totalTicksMultimap.put(species.getId(), bucketId);
        }
        return totalTicksMultimap;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum TotalTickType {
        COUNTRY("Country"){

            @Override
            Location bucketLocation(Location in, ReportSet reportSet, PredefinedLocations predefinedLocations) {
                String countryCode;
                String stateCode;
                Location state;
                if (in == null) {
                    return null;
                }
                Location country = Locations.getAncestorOfType(in, Location.Type.country);
                if (country == null && (state = Locations.getAncestorOfType(in, Location.Type.state)) != null && (stateCode = Locations.getLocationCode(state)) != null && (countryCode = STATE_TO_COUNTRY.get(stateCode)) != null) {
                    country = reportSet.getLocations().getLocationByCode(countryCode);
                }
                return country;
            }
        }
        ,
        STATE("State"){

            @Override
            Location bucketLocation(Location in, ReportSet reportSet, PredefinedLocations predefinedLocations) {
                String countryCode;
                String stateCode;
                Location country;
                if (in == null) {
                    return null;
                }
                Location state = Locations.getAncestorOfType(in, Location.Type.state);
                if (state == null && (country = Locations.getAncestorOfType(in, Location.Type.country)) != null && (stateCode = COUNTRY_TO_STATE.get(countryCode = Locations.getLocationCode(country))) != null) {
                    state = Locations.getLocationByCodePossiblyCreating(reportSet.getLocations(), predefinedLocations, stateCode);
                }
                return state;
            }
        }
        ,
        COUNTY("County"){

            @Override
            Location bucketLocation(Location in, ReportSet reportSet, PredefinedLocations predefinedLocations) {
                if (in == null) {
                    return null;
                }
                return Locations.getAncestorOfType(in, Location.Type.county);
            }
        };

        private final String text;

        private TotalTickType(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }

        abstract Location bucketLocation(Location var1, ReportSet var2, PredefinedLocations var3);

        String reportName() {
            return this.text + " Total Ticks";
        }
    }
}

