/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.query.QueryProcessor;
import com.scythebill.birdlist.model.query.QueryResults;
import com.scythebill.birdlist.model.query.SightingPredicates;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.taxa.names.LocalNames;
import com.scythebill.birdlist.ui.actions.ActionBroker;
import com.scythebill.birdlist.ui.actions.Attachable;
import com.scythebill.birdlist.ui.actions.ForwardingAction;
import com.scythebill.birdlist.ui.app.NavigableFrame;
import com.scythebill.birdlist.ui.app.Titled;
import com.scythebill.birdlist.ui.events.EventBusRegistrar;
import com.scythebill.birdlist.ui.events.TaxonomyChangedEvent;
import com.scythebill.birdlist.ui.events.TaxonomyStore;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.FilePreferences;
import com.scythebill.birdlist.ui.panels.reports.QueryFieldFactory;
import com.scythebill.birdlist.ui.panels.reports.QueryPanel;
import com.scythebill.birdlist.ui.panels.reports.QueryPanelFactory;
import com.scythebill.birdlist.ui.panels.reports.QueryPreferences;
import com.scythebill.birdlist.ui.panels.reports.ReportsBrowserPanel;
import com.scythebill.birdlist.ui.panels.reports.ShowTotalTicksMap;
import com.scythebill.birdlist.ui.panels.reports.StoredQueries;
import com.scythebill.birdlist.ui.panels.reports.TotalTicksProcessor;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.FileDialogs;
import com.scythebill.birdlist.ui.util.FocusTracker;
import com.scythebill.birdlist.ui.util.ListListModel;
import com.scythebill.birdlist.ui.util.LocationIdToString;
import com.scythebill.birdlist.ui.util.UIUtils;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellUtil;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class TotalTicksPanel
extends JPanel
implements FontManager.FontsUpdatedListener,
Titled {
    private final ReportSet reportSet;
    private final PredefinedLocations predefinedLocations;
    private final QueryPanelFactory queryPanelFactory;
    private final TaxonomyStore taxonomyStore;
    private final StoredQueries storedQueries;
    private final QueryPreferences queryPreferences;
    private final ReportsBrowserPanel reportsBrowserPanel;
    private final FileDialogs fileDialogs;
    private final NavigableFrame navigableFrame;
    private QueryPanel queryPanel;
    private JButton saveSpreadsheetButton;
    private JButton showMapButton;
    private JButton rememberButton;
    private JButton returnButton;
    private JComboBox<TotalTicksProcessor.TotalTickType> typeComboBox;
    private JLabel totalTicksLabel;
    private JLabel totalTicksExplanation;
    private JLabel totalTicksTitle;
    private JList<TotalTicksResult> totalTicksResultList;
    private JScrollPane totalTicksResultScrollPane;
    private JScrollPane reportsScrollPane;
    private Timer showTotalTicksTimer;
    private Alerts alerts;
    private TotalTicksProcessor totalTicksProcessor;
    private final ActionBroker actionBroker;

    @Inject
    TotalTicksPanel(ReportSet reportSet, PredefinedLocations predefinedLocations, QueryPanelFactory queryPanelFactory, ReportsBrowserPanel reportsBrowserPanel, TaxonomyStore taxonomyStore, EventBusRegistrar eventBusRegistrar, FontManager fontManager, StoredQueries storedQueries, QueryPreferences queryPreferences, NavigableFrame navigableFrame, FileDialogs fileDialogs, ActionBroker actionBroker, Alerts alerts) {
        this.reportSet = reportSet;
        this.predefinedLocations = predefinedLocations;
        this.queryPanelFactory = queryPanelFactory;
        this.reportsBrowserPanel = reportsBrowserPanel;
        this.taxonomyStore = taxonomyStore;
        this.storedQueries = storedQueries;
        this.queryPreferences = queryPreferences;
        this.navigableFrame = navigableFrame;
        this.fileDialogs = fileDialogs;
        this.actionBroker = actionBroker;
        this.alerts = alerts;
        this.totalTicksProcessor = new TotalTicksProcessor();
        this.initGUI();
        this.attachListeners();
        fontManager.applyTo(this);
        eventBusRegistrar.registerWhenInHierarchy(this);
        this.taxonomyChanged(null);
    }

    private void attachListeners() {
        this.returnButton.addActionListener(e -> this.navigableFrame.navigateTo("extendedReportsMenu"));
        this.queryPanel.addPredicateChangedListener(e -> this.showQueryResults());
        this.typeComboBox.addActionListener(e -> this.showQueryResults());
        this.saveSpreadsheetButton.addActionListener(e -> this.saveSpreadsheet());
        this.rememberButton.addActionListener(e -> this.rememberQuery());
        this.showMapButton.addActionListener(e -> this.showMap());
        this.showTotalTicksTimer = new Timer(200, e -> this.showSingleTotalTicks());
        this.showTotalTicksTimer.setRepeats(false);
        this.totalTicksResultList.addListSelectionListener(e -> this.showTotalTicksTimer.restart());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent event) {
                TotalTicksPanel.this.showTotalTicksTimer.stop();
            }
        });
        this.totalTicksResultList.setDragEnabled(true);
        this.totalTicksResultList.setTransferHandler(new TransferHandler(){

            @Override
            protected Transferable createTransferable(JComponent c) {
                if (TotalTicksPanel.this.totalTicksResultList.isSelectionEmpty()) {
                    return null;
                }
                String totalTicksAsText = IntStream.of(TotalTicksPanel.this.totalTicksResultList.getSelectedIndices()).sorted().mapToObj(i -> TotalTicksPanel.this.totalTicksResultList.getModel().getElementAt(i).toString()).collect(Collectors.joining("\n"));
                return new StringSelection(totalTicksAsText);
            }

            @Override
            public int getSourceActions(JComponent c) {
                return 1;
            }
        });
        new FocusTracker(this.totalTicksResultList){
            private final Action copy;
            {
                this.copy = new CopyActionWrapper(TransferHandler.getCopyAction());
            }

            @Override
            protected void focusGained(Component child) {
                TotalTicksPanel.this.actionBroker.publishAction("copy", this.copy);
            }

            @Override
            protected void focusLost(Component child) {
                TotalTicksPanel.this.actionBroker.unpublishAction("copy", this.copy);
            }
        };
    }

    private void showSingleTotalTicks() {
        TotalTicksResult result = this.totalTicksResultList.getSelectedValue();
        if (result == null) {
            this.reportsBrowserPanel.setModel(null);
        } else {
            ArrayList<Location> locations = new ArrayList<Location>();
            Location location = this.reportSet.getLocations().getLocation(result.getLocationId());
            String code = Locations.getLocationCode(location);
            if (code == null) {
                locations.add(location);
            } else {
                locations.addAll(this.reportSet.getLocations().getLocationsByCode(code));
                if (code.equals("US")) {
                    locations.removeIf(l -> l.getParent().getModelName().equals("West Indies"));
                }
            }
            Taxonomy taxonomy = this.taxonomyStore.getTaxonomy();
            Predicate<Sighting> countablePredicate = this.queryPreferences.getCountablePredicate(this.taxonomyStore.getTaxonomy(), this.queryPanel.containsQueryFieldType(QueryFieldFactory.QueryFieldType.SIGHTING_STATUS), this.queryPanel.getBooleanValueIfPresent(QueryFieldFactory.QueryFieldType.ALLOW_HEARD_ONLY));
            QueryProcessor queryProcessor = new QueryProcessor(this.reportSet, this.taxonomyStore.getTaxonomy()).onlyIncludeCountableSightings().withAdditionalPredicate(Predicates.or(locations.stream().map(l -> SightingPredicates.in(l, this.reportSet.getLocations())).collect(ImmutableList.toImmutableList())));
            QueryResults results = queryProcessor.runQuery(this.queryPanel.queryDefinition(taxonomy, Taxon.Type.species), countablePredicate, Taxon.Type.species);
            this.reportsBrowserPanel.setLocationRoot(location);
            this.reportsBrowserPanel.setQueryResults(results, true);
            this.reportsBrowserPanel.revalidate();
        }
    }

    private void rememberQuery() {
        String name;
        TotalTicksProcessor.TotalTickType totalTickType = this.totalTickType();
        Object defaultName = totalTickType.reportName();
        Optional<String> queryName = this.queryPanel.getQueryName();
        if (queryName.isPresent()) {
            defaultName = queryName.get() + " " + (String)defaultName;
        }
        if ((name = this.storedQueries.chooseName(this, (String)defaultName)) != null) {
            this.storedQueries.addTotalTicksQuery(name, totalTickType, this.queryPanel.persist());
        }
    }

    private void initGUI() {
        this.queryPanel = this.queryPanelFactory.newQueryPanel(QueryFieldFactory.QueryFieldType.SP_OR_HYBRID, QueryFieldFactory.QueryFieldType.SUBSPECIES_ALLOCATED, QueryFieldFactory.QueryFieldType.TIMES_SIGHTED);
        this.typeComboBox = new JComboBox<TotalTicksProcessor.TotalTickType>(TotalTicksProcessor.TotalTickType.values());
        this.totalTicksExplanation = new JLabel();
        this.totalTicksExplanation.putClientProperty("birdlist.plainLabel", true);
        this.totalTicksTitle = new JLabel(Messages.getMessage(Messages.Name.TOTAL_TICKS_LABEL));
        this.totalTicksTitle.putClientProperty("birdlist.textSize", (Object)FontManager.TextSize.VERY_LARGE);
        this.totalTicksLabel = new JLabel();
        this.totalTicksLabel.putClientProperty("birdlist.textSize", (Object)FontManager.TextSize.VERY_LARGE);
        this.totalTicksResultList = new JList(new ListListModel());
        this.totalTicksResultScrollPane = new JScrollPane(this.totalTicksResultList, 20, 31);
        this.reportsScrollPane = new JScrollPane(this.reportsBrowserPanel);
        this.reportsBrowserPanel.setEditableSightings(true);
        this.returnButton = new JButton(Messages.getMessage(Messages.Name.BACK_TO_SPECIAL_REPORTS));
        this.saveSpreadsheetButton = new JButton(Messages.getMessage(Messages.Name.SAVE_AS_SPREADSHEET));
        this.showMapButton = new JButton(Messages.getMessage(Messages.Name.TOTAL_TICKS_MAP));
        this.rememberButton = new JButton(Messages.getMessage(Messages.Name.REMEMBER_MENU));
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        this.setBorder(new EmptyBorder(fontManager.scale(20), fontManager.scale(20), fontManager.scale(20), fontManager.scale(20)));
        GroupLayout layout = new GroupLayout(this);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.typeComboBox, -2, -2, -2).addComponent(this.queryPanel, -2, -2, Short.MAX_VALUE).addComponent(this.totalTicksTitle).addComponent(this.totalTicksLabel).addGroup(layout.createSequentialGroup().addComponent(this.totalTicksResultScrollPane).addComponent(this.reportsScrollPane)).addComponent(this.totalTicksExplanation).addGroup(layout.createSequentialGroup().addComponent(this.saveSpreadsheetButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showMapButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rememberButton)).addComponent(this.returnButton, GroupLayout.Alignment.TRAILING));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.typeComboBox, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.queryPanel, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.totalTicksTitle).addComponent(this.totalTicksLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.totalTicksExplanation).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup().addComponent(this.totalTicksResultScrollPane, -2, -2, Short.MAX_VALUE).addComponent(this.reportsScrollPane, -2, -2, Short.MAX_VALUE)).addGap(fontManager.scale(10), fontManager.scale(10), fontManager.scale(10)).addGroup(layout.createBaselineGroup(false, false).addComponent(this.saveSpreadsheetButton).addComponent(this.showMapButton).addComponent(this.rememberButton).addComponent(this.returnButton)));
        this.setLayout(layout);
        Dimension preferredSize = fontManager.scale(new Dimension(760, 680));
        preferredSize.width += 200;
        this.setPreferredSize(preferredSize);
    }

    @Subscribe
    public void taxonomyChanged(TaxonomyChangedEvent event) {
        this.reportsBrowserPanel.setTaxonomy(this.taxonomyStore.getTaxonomy());
        this.queryPanel.taxonomyUpdated();
        this.showQueryResults();
    }

    private void showQueryResults() {
        TotalTicksProcessor.TotalTickType type = this.totalTickType();
        switch (type) {
            case COUNTRY: {
                this.totalTicksExplanation.setText(Messages.getMessage(Messages.Name.TOTAL_TICKS_COUNTRY_EXPLANATION));
                break;
            }
            case COUNTY: {
                this.totalTicksExplanation.setText(Messages.getMessage(Messages.Name.TOTAL_TICKS_COUNTY_EXPLANATION));
                break;
            }
            case STATE: {
                this.totalTicksExplanation.setText(Messages.getMessage(Messages.Name.TOTAL_TICKS_STATE_EXPLANATION));
            }
        }
        Multimap<String, String> totalTicks = this.computeTotalTicks();
        this.totalTicksLabel.setText(NumberFormat.getIntegerInstance().format(totalTicks.size()));
        this.saveSpreadsheetButton.setEnabled(totalTicks.size() > 0);
        this.showMapButton.setEnabled(totalTicks.size() > 0 && type != TotalTicksProcessor.TotalTickType.COUNTY);
        this.showTotalTicksTimer.stop();
        this.reportsBrowserPanel.setModel(null);
        ArrayListMultimap inverted = Multimaps.invertFrom(totalTicks, ArrayListMultimap.create());
        ArrayList list = inverted.asMap().entrySet().stream().sorted(Comparator.comparing(entry -> ((Collection)entry.getValue()).size()).reversed()).map(e -> new TotalTicksResult((String)e.getKey(), ((Collection)e.getValue()).size())).collect(Collectors.toCollection(ArrayList::new));
        this.totalTicksResultList.setModel(new ListListModel(list));
    }

    private Multimap<String, String> computeTotalTicks() {
        Taxonomy taxonomy = this.taxonomyStore.getTaxonomy();
        Predicate<Sighting> countablePredicate = this.queryPreferences.getCountablePredicate(taxonomy, this.queryPanel.containsQueryFieldType(QueryFieldFactory.QueryFieldType.SIGHTING_STATUS), this.queryPanel.getBooleanValueIfPresent(QueryFieldFactory.QueryFieldType.ALLOW_HEARD_ONLY));
        return this.totalTicksProcessor.computeTotalTicks(this.reportSet, this.predefinedLocations, this.totalTickType(), taxonomy, this.queryPanel.queryDefinition(taxonomy, Taxon.Type.species), countablePredicate);
    }

    private void showMap() {
        Multimap<String, String> totalTicks = this.computeTotalTicks();
        ArrayListMultimap<String, String> inverted = Multimaps.invertFrom(totalTicks, ArrayListMultimap.create());
        try {
            new ShowTotalTicksMap(PredefinedLocations.loadAndParse(), this.reportSet).showRange(inverted, this.totalTickType(), this.queryPanel.getQueryName().or(""));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void saveSpreadsheet() {
        Optional<String> reportName = this.queryPanel.getQueryAbbreviation();
        String tickType = this.totalTickType().name().toLowerCase();
        String fileName = reportName.isPresent() ? String.format("%s-ticks-%s.xlsx", tickType, reportName.get()) : String.format("%s-ticks.xlsx", tickType);
        File out = this.fileDialogs.saveFile(UIUtils.findFrame(this), Messages.getMessage(Messages.Name.PICK_FILE_TITLE), fileName, new FileNameExtensionFilter(Messages.getMessage(Messages.Name.XLSX_FILES), "xlsx"), FilePreferences.FileType.OTHER);
        if (out != null) {
            Multimap<String, String> totalTicks = this.computeTotalTicks();
            ArrayListMultimap inverted = Multimaps.invertFrom(totalTicks, ArrayListMultimap.create());
            List sortedTaxa = totalTicks.keySet().stream().map(this.taxonomyStore.getTaxonomy()::getTaxon).distinct().sorted(Comparator.comparing(Taxon::getTaxonomyIndex)).collect(Collectors.toCollection(ArrayList::new));
            Comparator<Location> speciesCountComparator = Comparator.comparingInt(location -> inverted.get(location.getId()).size());
            List sortedLocations = totalTicks.values().stream().distinct().map(this.reportSet.getLocations()::getLocation).sorted(speciesCountComparator.reversed()).collect(Collectors.toCollection(ArrayList::new));
            XSSFWorkbook workbook = new XSSFWorkbook();
            CellStyle headerStyle = workbook.createCellStyle();
            Font headerFont = workbook.createFont();
            headerFont.setBold(true);
            headerStyle.setFont(headerFont);
            Sheet sheet = workbook.createSheet();
            Row locationHeader = sheet.createRow(0);
            for (int i = 0; i < sortedLocations.size(); ++i) {
                CellUtil.createCell(locationHeader, i + 1, ((Location)sortedLocations.get(i)).getDisplayName(), headerStyle);
            }
            Row totalRow = sheet.createRow(1);
            for (int i = 0; i < sortedLocations.size() + 1; ++i) {
                Cell cell = totalRow.createCell(i + 1);
                CellRangeAddress cellRangeAddress = new CellRangeAddress(2, sortedTaxa.size() + 1, i + 1, i + 1);
                cell.setCellFormula(String.format("SUM(%s)", cellRangeAddress.formatAsString()));
            }
            LocalNames localNames = this.taxonomyStore.getTaxonomy().getLocalNames();
            for (int i = 0; i < sortedTaxa.size(); ++i) {
                Row taxonRow = sheet.createRow(i + 2);
                Taxon taxon = (Taxon)sortedTaxa.get(i);
                taxonRow.createCell(0).setCellValue(localNames.compoundName(taxon, true));
                for (int j = 0; j < sortedLocations.size(); ++j) {
                    if (!totalTicks.containsEntry(taxon.getId(), ((Location)sortedLocations.get(j)).getId())) continue;
                    Cell cell = taxonRow.createCell(j + 1);
                    cell.setCellValue(1.0);
                }
                Cell totalCell = taxonRow.createCell(sortedLocations.size() + 1);
                CellRangeAddress cellRangeAddress = new CellRangeAddress(i + 2, i + 2, 1, sortedLocations.size());
                totalCell.setCellFormula(String.format("SUM(%s)", cellRangeAddress.formatAsString()));
            }
            sheet.autoSizeColumn(0);
            sheet.createFreezePane(1, 2);
            try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(out));){
                workbook.write(stream);
            }
            catch (IOException e) {
                FileDialogs.showFileSaveError(this.alerts, e, out);
                return;
            }
            try {
                Desktop.getDesktop().open(out);
            }
            catch (IOException e) {
                this.alerts.showError((Object)this, (Throwable)e, Messages.Name.OPENING_FAILED, Messages.Name.NO_APPLICATION_FOR_XLS_FILES, new Object[0]);
                return;
            }
        }
    }

    private TotalTicksProcessor.TotalTickType totalTickType() {
        return (TotalTicksProcessor.TotalTickType)((Object)this.typeComboBox.getSelectedItem());
    }

    public void restoreQuery(StoredQueries.StoredQuery localQuery) {
        TotalTicksProcessor.TotalTickType totalTickType = localQuery.getTotalTickType();
        this.typeComboBox.setSelectedItem((Object)totalTickType);
        this.queryPanel.restore(localQuery.queryJson());
    }

    @Override
    public String getTitle() {
        return Messages.getMessage(Messages.Name.TOTAL_TICKS);
    }

    class TotalTicksResult {
        private final int size;
        private final String locationId;

        public TotalTicksResult(String locationId, int size) {
            this.locationId = locationId;
            this.size = size;
        }

        public String toString() {
            String locationText;
            Location location = TotalTicksPanel.this.reportSet.getLocations().getLocation(this.getLocationId());
            if (location.getType() == Location.Type.country) {
                locationText = location.getDisplayName();
            } else {
                Location rootLocation = TotalTicksPanel.this.queryPanel.getRootLocation();
                locationText = LocationIdToString.getString(TotalTicksPanel.this.reportSet.getLocations(), this.getLocationId(), true, rootLocation);
            }
            return "%s: \t%d".formatted(locationText, this.size);
        }

        public String getLocationId() {
            return this.locationId;
        }
    }

    private class CopyActionWrapper
    extends ForwardingAction
    implements Attachable,
    ListSelectionListener {
        public CopyActionWrapper(Action wrapped) {
            super(TotalTicksPanel.this.totalTicksResultList, wrapped);
        }

        @Override
        public void attach() {
            TotalTicksPanel.this.totalTicksResultList.addListSelectionListener(this);
            this.updateEnabled();
        }

        @Override
        public void unattach() {
            TotalTicksPanel.this.totalTicksResultList.removeListSelectionListener(this);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabled();
        }

        private void updateEnabled() {
            this.setEnabled(!TotalTicksPanel.this.totalTicksResultList.isSelectionEmpty());
        }
    }
}

