/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.scythebill.birdlist.model.query.QueryDefinition;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.ui.components.AutoSelectJFormattedTextField;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.reports.AbstractQueryField;
import com.scythebill.birdlist.ui.panels.reports.QueryFieldFactory;
import java.text.NumberFormat;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.text.NumberFormatter;

class TimesSightedQueryField
extends AbstractQueryField {
    private final JComboBox<QueryType> typeOptions = new JComboBox<QueryType>(QueryType.values());
    private final JFormattedTextField countField;
    private static final Gson GSON = new Gson();

    public TimesSightedQueryField() {
        super(QueryFieldFactory.QueryFieldType.TIMES_SIGHTED);
        this.typeOptions.addActionListener(e -> this.firePredicateUpdated());
        NumberFormatter formatter = new NumberFormatter(NumberFormat.getIntegerInstance());
        formatter.setValueClass(Integer.class);
        formatter.setMinimum(Integer.valueOf(1));
        this.countField = new AutoSelectJFormattedTextField(formatter);
        this.countField.setValue(1);
        this.countField.setColumns(3);
        this.countField.addPropertyChangeListener("value", e -> this.firePredicateUpdated());
    }

    @Override
    public JComponent getComparisonChooser() {
        return this.typeOptions;
    }

    @Override
    public JComponent getValueField() {
        return this.countField;
    }

    @Override
    public boolean isSingleLine() {
        return true;
    }

    @Override
    public QueryDefinition queryDefinition(ReportSet reportSet, Taxon.Type depth) {
        return new TimesSightedQueryDefinition((QueryType)((Object)this.typeOptions.getSelectedItem()), this.getCount());
    }

    @Override
    public boolean isNoOp() {
        return false;
    }

    @Override
    public Optional<String> name() {
        return Optional.absent();
    }

    @Override
    public Optional<String> abbreviation() {
        return Optional.absent();
    }

    private int getCount() {
        return (Integer)this.countField.getValue();
    }

    @Override
    public JsonElement persist() {
        Persisted persisted = new Persisted((QueryType)((Object)this.typeOptions.getSelectedItem()), this.getCount());
        return GSON.toJsonTree(persisted);
    }

    @Override
    public void restore(JsonElement json) {
        Persisted persisted = GSON.fromJson(json, Persisted.class);
        this.typeOptions.setSelectedItem((Object)persisted.type);
        this.countField.setValue(persisted.count);
    }

    private static enum QueryType {
        EXACTLY(Messages.Name.EXACTLY),
        AT_MOST(Messages.Name.AT_MOST),
        AT_LEAST(Messages.Name.AT_LEAST),
        LESS_THAN(Messages.Name.LESS_THAN),
        MORE_THAN(Messages.Name.MORE_THAN);

        private final Messages.Name text;

        private QueryType(Messages.Name text) {
            this.text = text;
        }

        public String toString() {
            return Messages.getMessage(this.text);
        }
    }

    static class TimesSightedQueryDefinition
    implements QueryDefinition,
    QueryDefinition.PostProcessor {
        private final QueryType type;
        private final int count;

        public TimesSightedQueryDefinition(QueryType type, int count) {
            this.type = Preconditions.checkNotNull(type);
            this.count = count;
        }

        @Override
        public Optional<QueryDefinition.Preprocessor> preprocessor() {
            return Optional.absent();
        }

        @Override
        public Predicate<Sighting> predicate() {
            return Predicates.alwaysTrue();
        }

        @Override
        public Optional<QueryDefinition.QueryAnnotation> annotate(Sighting sighting, SightingTaxon taxon) {
            return Optional.absent();
        }

        @Override
        public Optional<QueryDefinition.PostProcessor> postprocessor() {
            return Optional.of(this);
        }

        @Override
        public boolean acceptTaxon(SightingTaxon sightingTaxon, Collection<Sighting> sightings, @Nullable Predicate<Sighting> countablePredicate) {
            int size = countablePredicate == null ? sightings.size() : (int)sightings.stream().filter(countablePredicate).count();
            switch (this.type) {
                case EXACTLY: {
                    return size == this.count;
                }
                case AT_MOST: {
                    return size <= this.count;
                }
                case AT_LEAST: {
                    return size >= this.count;
                }
                case LESS_THAN: {
                    return size < this.count;
                }
                case MORE_THAN: {
                    return size > this.count;
                }
            }
            throw new AssertionError((Object)("Unknown type " + this.type));
        }
    }

    static class Persisted {
        QueryType type;
        int count;

        public Persisted(QueryType type, int count) {
            this.type = type;
            this.count = count;
        }
    }
}

