/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.base.Predicate;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.Species;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.ui.events.TaxonomyStore;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.reports.AbstractQueryField;
import com.scythebill.birdlist.ui.panels.reports.QueryFieldFactory;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

class SubspeciesAllocatedQueryField
extends AbstractQueryField {
    private final JComboBox<QueryType> queryOptions = new JComboBox<QueryType>(QueryType.values());
    private final JPanel statusOptions = new JPanel();
    private final TaxonomyStore taxonomyStore;
    private static final Gson GSON = new Gson();

    public SubspeciesAllocatedQueryField(TaxonomyStore taxonomyStore) {
        super(QueryFieldFactory.QueryFieldType.SUBSPECIES_ALLOCATED);
        this.taxonomyStore = taxonomyStore;
        this.queryOptions.addActionListener(e -> this.firePredicateUpdated());
    }

    @Override
    public JComponent getComparisonChooser() {
        return this.queryOptions;
    }

    @Override
    public JComponent getValueField() {
        return this.statusOptions;
    }

    @Override
    public Predicate<Sighting> predicate(Taxon.Type depth) {
        final boolean isAllocated = QueryType.IS == this.queryOptions.getSelectedItem();
        Predicate<Sighting> predicate = new Predicate<Sighting>(){

            @Override
            public boolean apply(Sighting sighting) {
                if (!TaxonUtils.areCompatible(SubspeciesAllocatedQueryField.this.taxonomyStore.getTaxonomy(), sighting.getTaxonomy())) {
                    return false;
                }
                SightingTaxon.Resolved resolved = sighting.getTaxon().resolve(SubspeciesAllocatedQueryField.this.taxonomyStore.getTaxonomy());
                if (resolved.getType() == SightingTaxon.Type.HYBRID || resolved.getType() == SightingTaxon.Type.SP) {
                    return false;
                }
                Taxon taxon = resolved.getTaxon();
                if (isAllocated) {
                    return taxon.getContents().isEmpty() && taxon.getType() != Taxon.Type.species;
                }
                return SubspeciesAllocatedQueryField.hasTrueChildren(taxon);
            }
        };
        return predicate;
    }

    @Override
    public boolean isNoOp() {
        return false;
    }

    private static boolean hasTrueChildren(Taxon taxon) {
        List<Taxon> contents = taxon.getContents();
        if (contents.isEmpty()) {
            return false;
        }
        for (int i = 0; i < contents.size(); ++i) {
            Taxon child = contents.get(i);
            Species.Status status = child.getStatus();
            if (status == Species.Status.IN || status == Species.Status.DO) continue;
            return true;
        }
        return false;
    }

    @Override
    public JsonElement persist() {
        Persisted persisted = new Persisted((QueryType)((Object)this.queryOptions.getSelectedItem()));
        return GSON.toJsonTree(persisted);
    }

    @Override
    public void restore(JsonElement json) {
        Persisted persisted = GSON.fromJson(json, Persisted.class);
        this.queryOptions.setSelectedItem((Object)persisted.type);
    }

    private static enum QueryType {
        IS(Messages.Name.SUBSPECIES_IS_ALLOCATED),
        IS_NOT(Messages.Name.SUBSPECIES_IS_NOT_ALLOCATED);

        private final Messages.Name text;

        private QueryType(Messages.Name text) {
            this.text = text;
        }

        public String toString() {
            return Messages.getMessage(this.text);
        }
    }

    static class Persisted {
        QueryType type;

        public Persisted(QueryType type) {
            this.type = type;
        }
    }
}

