/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.gson.JsonParseException;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.query.QueryDefinition;
import com.scythebill.birdlist.model.query.QueryProcessor;
import com.scythebill.birdlist.model.query.QueryResults;
import com.scythebill.birdlist.model.query.SightingPredicates;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.app.NavigableFrame;
import com.scythebill.birdlist.ui.components.TextLink;
import com.scythebill.birdlist.ui.components.table.DeleteColumn;
import com.scythebill.birdlist.ui.events.DefaultUserChangedEvent;
import com.scythebill.birdlist.ui.events.DefaultUserStore;
import com.scythebill.birdlist.ui.events.EventBusRegistrar;
import com.scythebill.birdlist.ui.events.TaxonomyChangedEvent;
import com.scythebill.birdlist.ui.events.TaxonomyStore;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.reports.QueryFieldFactory;
import com.scythebill.birdlist.ui.panels.reports.QueryPreferences;
import com.scythebill.birdlist.ui.panels.reports.ReportsPanel;
import com.scythebill.birdlist.ui.panels.reports.StoredQueries;
import com.scythebill.birdlist.ui.panels.reports.TotalTicksPanel;
import com.scythebill.birdlist.ui.panels.reports.TotalTicksProcessor;
import com.scythebill.birdlist.ui.util.Alerts;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class StoredQueriesPanel
extends JPanel
implements FontManager.FontsUpdatedListener {
    private static final Logger logger = Logger.getLogger(StoredQueriesPanel.class.getName());
    private final StoredQueries storedQueries;
    private final QueryPreferences queryPreferences;
    private final ListeningExecutorService executorService;
    private final ReportSet reportSet;
    private final PredefinedLocations predefinedLocations;
    private final NavigableFrame navigableFrame;
    private final Alerts alerts;
    private final FontManager fontManager;
    private final DefaultUserStore defaultUserStore;
    private Taxonomy taxonomy;
    private List<Future<?>> futures = Lists.newArrayList();
    private List<TextLink> labels = Lists.newArrayList();
    private List<JLabel> deletes = Lists.newArrayList();
    private List<JLabel> results = Lists.newArrayList();

    @Inject
    public StoredQueriesPanel(ReportSet reportSet, PredefinedLocations predefinedLocations, StoredQueries storedQueries, QueryPreferences queryPreferences, ListeningExecutorService executorService, TaxonomyStore taxonomyStore, DefaultUserStore defaultUserStore, EventBusRegistrar registrar, NavigableFrame navigableFrame, Alerts alerts, FontManager fontManager) {
        this.reportSet = reportSet;
        this.predefinedLocations = predefinedLocations;
        this.storedQueries = storedQueries;
        this.queryPreferences = queryPreferences;
        this.executorService = executorService;
        this.defaultUserStore = defaultUserStore;
        this.navigableFrame = navigableFrame;
        this.alerts = alerts;
        this.fontManager = fontManager;
        registrar.registerWhenInHierarchy(this);
        this.setTaxonomy(taxonomyStore.getTaxonomy());
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent e) {
            }

            @Override
            public void ancestorMoved(AncestorEvent e) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent e) {
                StoredQueriesPanel.this.cancelAllFutures();
            }
        });
    }

    @Subscribe
    public void taxonomyChanged(TaxonomyChangedEvent event) {
        this.setTaxonomy(event.getTaxonomy());
        this.fontsUpdated(this.fontManager);
    }

    @Subscribe
    public void defaultUserChanged(DefaultUserChangedEvent event) {
        this.recreateQueriesAndComponents();
        this.fontsUpdated(this.fontManager);
    }

    private void setTaxonomy(Taxonomy taxonomy) {
        this.taxonomy = taxonomy;
        this.recreateQueriesAndComponents();
    }

    private void recreateQueriesAndComponents() {
        this.removeAll();
        this.cancelAllFutures();
        this.labels.clear();
        this.results.clear();
        this.deletes.clear();
        if (this.storedQueries.getStoredQueries().isEmpty()) {
            return;
        }
        for (StoredQueries.StoredQuery storedQuery : this.storedQueries.getStoredQueries()) {
            Optional<StoredQueries.RestoredQuery> optionalRestored = storedQuery.restore();
            if (!optionalRestored.isPresent()) continue;
            StoredQueries.RestoredQuery restoredQuery = optionalRestored.get();
            StoredQueries.StoredQueryType storedQueryType = storedQuery.storedQueryType;
            final StoredQueries.StoredQuery localQuery = storedQuery;
            TextLink label = new TextLink(storedQuery.getName() + ":");
            label.setToolTipText(Messages.getFormattedMessage(Messages.Name.SHOW_THE_FULL_REPORT_FORMAT, storedQuery.getName()));
            label.addActionListener(e -> {
                if (storedQueryType == StoredQueries.StoredQueryType.REPORTS) {
                    ReportsPanel reports = (ReportsPanel)this.navigableFrame.navigateTo("reports");
                    if (reports != null) {
                        reports.restoreQuery(restoredQuery);
                    }
                } else if (storedQueryType == StoredQueries.StoredQueryType.TOTAL_TICKS) {
                    TotalTicksPanel totalTicks = (TotalTicksPanel)this.navigableFrame.navigateTo("totalTicks");
                    totalTicks.restoreQuery(localQuery);
                }
            });
            this.labels.add(label);
            final JLabel resultLabel = new JLabel("...");
            resultLabel.putClientProperty("birdlist.plainLabel", true);
            resultLabel.setHorizontalAlignment(4);
            this.results.add(resultLabel);
            SwingUtilities.invokeLater(() -> {
                try {
                    Predicate<Sighting> sightingPredicate = this.defaultUserStore.getUser() != null && !restoredQuery.containsQueryFieldType(QueryFieldFactory.QueryFieldType.USER) ? SightingPredicates.includesUser(this.defaultUserStore.getUser()) : Predicates.alwaysTrue();
                    QueryDefinition queryDefinition = restoredQuery.getQueryDefinition(this.taxonomy, this.reportSet, this.queryPreferences, Taxon.Type.species, sightingPredicate);
                    Predicate<Sighting> countablePredicate = restoredQuery.countablePredicate(this.taxonomy, this.queryPreferences);
                    Future future = storedQueryType == StoredQueries.StoredQueryType.REPORTS ? this.executorService.submit(() -> {
                        QueryProcessor processor = new QueryProcessor(this.reportSet, this.taxonomy);
                        processor.dontIncludeFamilyNames();
                        QueryResults queryResults = processor.runQuery(queryDefinition, countablePredicate, Taxon.Type.species);
                        return queryResults.getCountableSpeciesSize(this.taxonomy, false);
                    }) : this.executorService.submit(() -> {
                        TotalTicksProcessor.TotalTickType type = localQuery.getTotalTickType();
                        Multimap<String, String> computedTotalTicks = new TotalTicksProcessor().computeTotalTicks(this.reportSet, this.predefinedLocations, type, this.taxonomy, queryDefinition, countablePredicate);
                        return computedTotalTicks.size();
                    });
                    Futures.addCallback(future, new FutureCallback<Integer>(){

                        @Override
                        public void onFailure(Throwable t) {
                            if (!(t instanceof CancellationException)) {
                                logger.log(Level.WARNING, "Couldn't execute " + localQuery.name, t);
                            }
                        }

                        @Override
                        public void onSuccess(Integer count) {
                            SwingUtilities.invokeLater(() -> resultLabel.setText(NumberFormat.getInstance().format(count)));
                        }
                    }, this.executorService);
                    this.futures.add(future);
                }
                catch (JsonParseException e) {
                    logger.log(Level.WARNING, "Couldn't execute " + localQuery.name, e);
                }
            });
            JLabel deleteLabel = DeleteColumn.createDeleteLabel();
            this.deletes.add(deleteLabel);
            deleteLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int okCancel = StoredQueriesPanel.this.alerts.showOkCancel((Object)StoredQueriesPanel.this, Messages.Name.DELETE_REMEMBERED_REPORT_TITLE, Messages.Name.DELETE_REMEMBERED_REPORT_FORMAT, localQuery.name);
                    if (okCancel == 0) {
                        StoredQueriesPanel.this.storedQueries.removeQuery(localQuery);
                        StoredQueriesPanel.this.recreateQueriesAndComponents();
                    }
                }
            });
        }
        this.fontsUpdated(this.fontManager);
    }

    private void cancelAllFutures() {
        for (Future<?> future : this.futures) {
            future.cancel(true);
        }
        this.futures.clear();
    }

    public boolean isEmpty() {
        return this.storedQueries.getStoredQueries().isEmpty();
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        GroupLayout layout = new GroupLayout(this);
        GroupLayout.SequentialGroup verticalGroup = layout.createSequentialGroup();
        GroupLayout.SequentialGroup horizontalGroup = layout.createSequentialGroup();
        GroupLayout.ParallelGroup labelGroup = layout.createParallelGroup();
        GroupLayout.ParallelGroup resultGroup = layout.createParallelGroup();
        GroupLayout.ParallelGroup deleteGroup = layout.createParallelGroup();
        horizontalGroup.addGroup(labelGroup).addGap(fontManager.scale(40)).addGroup(resultGroup).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(deleteGroup);
        for (int i = 0; i < this.labels.size(); ++i) {
            TextLink label = this.labels.get(i);
            JLabel result = this.results.get(i);
            JLabel delete = this.deletes.get(i);
            verticalGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(label).addComponent(result).addComponent(delete));
            labelGroup.addComponent(label);
            resultGroup.addComponent(result);
            deleteGroup.addComponent(delete);
        }
        if (!this.results.isEmpty()) {
            layout.linkSize(this.results.toArray(new Component[this.results.size()]));
        }
        layout.setHorizontalGroup(horizontalGroup);
        layout.setVerticalGroup(verticalGroup);
        this.setLayout(layout);
    }
}

