/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.scythebill.birdlist.model.query.QueryDefinition;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.reports.CompositeQueryDefinition;
import com.scythebill.birdlist.ui.panels.reports.QueryFieldFactory;
import com.scythebill.birdlist.ui.panels.reports.QueryPreferences;
import com.scythebill.birdlist.ui.panels.reports.StoredQueriesPreferences;
import com.scythebill.birdlist.ui.panels.reports.StoredReportSetQueriesPreferences;
import com.scythebill.birdlist.ui.panels.reports.TotalTicksProcessor;
import com.scythebill.birdlist.ui.prefs.ReportSetPreference;
import com.scythebill.birdlist.ui.util.Alerts;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class StoredQueries {
    private static final Logger logger = Logger.getLogger(StoredQueries.class.getName());
    private final List<StoredQuery> queries = Lists.newArrayList();
    private final QueryFieldFactory factory;
    private final StoredQueriesPreferences preferences;
    private final ReportSetPreference<StoredReportSetQueriesPreferences> reportSetPreferences;
    private String defaultQuery;
    private final Alerts alerts;

    StoredQueries(QueryFieldFactory factory, Alerts alerts, StoredQueriesPreferences storedQueriesPreferences, @Nullable ReportSetPreference<StoredReportSetQueriesPreferences> reportSetPreferences) {
        this.factory = factory;
        this.alerts = alerts;
        this.preferences = storedQueriesPreferences;
        this.reportSetPreferences = reportSetPreferences;
        try {
            this.restoreFromPreferences();
        }
        catch (RuntimeException e) {
            logger.warning("Could not restore from preferences: " + this.preferences.storedQueries);
        }
    }

    public void setDefaultQuery(String defaultQuery) {
        this.defaultQuery = defaultQuery;
    }

    public String getDefaultQuery() {
        return this.defaultQuery;
    }

    public List<StoredQuery> getStoredQueries() {
        return Collections.unmodifiableList(this.queries);
    }

    public String chooseName(Component parentComponent, String defaultName) {
        String name;
        while (true) {
            if ((name = this.alerts.getInput(parentComponent, Messages.Name.NAME_THIS_REPORT_TITLE, Messages.Name.NAME_THIS_REPORT_MESSAGE, defaultName)) == null) {
                return null;
            }
            if (name.isEmpty()) {
                this.alerts.showMessage((Object)parentComponent, Messages.Name.NAME_CANT_BE_EMPTY_TITLE, Messages.Name.NAME_CANT_BE_EMPTY_MESSAGE, new Object[0]);
                continue;
            }
            boolean nameExists = false;
            for (StoredQuery query : this.getStoredQueries()) {
                if (!query.name.equals(name)) continue;
                int showOkCancel = this.alerts.showOkCancel((Object)parentComponent, Messages.Name.NAME_ALREADY_TAKEN_TITLE, Messages.Name.NAME_ALREADY_TAKEN_MESSAGE, name);
                if (showOkCancel == 0) break;
                nameExists = true;
                defaultName = name;
                break;
            }
            if (!nameExists) break;
        }
        return name;
    }

    public void addTotalTicksQuery(String name, TotalTicksProcessor.TotalTickType totalTickType, String persistedJson) {
        String typePlusQuery = totalTickType.name() + "/" + persistedJson;
        this.addQuery(name, StoredQueryType.TOTAL_TICKS, typePlusQuery);
    }

    public void addReportsQuery(String name, String persistedJson) {
        this.addQuery(name, StoredQueryType.REPORTS, persistedJson);
    }

    private void addQuery(String name, StoredQueryType storedQueryType, String persistedJson) {
        for (StoredQuery query : this.queries) {
            if (!name.equals(query.name)) continue;
            query.persistedQuery = persistedJson;
            query.storedQueryType = storedQueryType;
            this.updatePreferences();
            return;
        }
        StoredQuery storedQuery = new StoredQuery(name, persistedJson, storedQueryType);
        this.queries.add(storedQuery);
        this.updatePreferences();
    }

    public void removeQuery(StoredQuery query) {
        this.queries.remove(query);
        this.updatePreferences();
    }

    public String persist(List<QueryFieldFactory.QueryField> fields, List<CompositeQueryDefinition.BooleanOperation> booleanOperations) {
        Preconditions.checkState(fields.size() == booleanOperations.size());
        JsonArray array = new JsonArray();
        for (int i = 0; i < fields.size(); ++i) {
            QueryFieldFactory.QueryField field = fields.get(i);
            CompositeQueryDefinition.BooleanOperation booleanOperation = booleanOperations.get(i);
            JsonObject object = new JsonObject();
            object.addProperty("type", field.getType().name());
            object.add("value", field.persist());
            object.addProperty("bool", booleanOperation.name());
            array.add(object);
        }
        JsonObject query = new JsonObject();
        query.add("fields", array);
        return new Gson().toJson(query);
    }

    public Optional<RestoredQuery> restore(String json) throws JsonParseException {
        JsonObject query = JsonParser.parseString(json).getAsJsonObject();
        CompositeQueryDefinition.BooleanOperation legacyBooleanOperation = null;
        if (query.has("type")) {
            try {
                legacyBooleanOperation = CompositeQueryDefinition.BooleanOperation.valueOf(query.get("type").getAsString());
            }
            catch (IllegalArgumentException e) {
                logger.log(Level.WARNING, "Invalid JSON: " + query, e);
                return Optional.absent();
            }
        }
        JsonArray array = query.get("fields").getAsJsonArray();
        Iterator<JsonElement> elements = array.iterator();
        ArrayList<QueryFieldFactory.QueryField> fields = Lists.newArrayList();
        ArrayList<CompositeQueryDefinition.BooleanOperation> queryTypes = Lists.newArrayList();
        while (elements.hasNext()) {
            JsonObject object = elements.next().getAsJsonObject();
            try {
                QueryFieldFactory.QueryFieldType fieldType = QueryFieldFactory.QueryFieldType.valueOf(object.get("type").getAsString());
                QueryFieldFactory.QueryField queryField = this.factory.newField(fieldType);
                queryField.restore(object.get("value"));
                CompositeQueryDefinition.BooleanOperation booleanOperation = legacyBooleanOperation;
                if (object.has("bool")) {
                    try {
                        booleanOperation = CompositeQueryDefinition.BooleanOperation.valueOf(object.get("bool").getAsString());
                    }
                    catch (IllegalArgumentException e) {
                        logger.log(Level.WARNING, "Invalid JSON: " + query, e);
                        return Optional.absent();
                    }
                }
                if (booleanOperation == null) {
                    booleanOperation = CompositeQueryDefinition.BooleanOperation.ALL;
                }
                queryTypes.add(booleanOperation);
                fields.add(queryField);
            }
            catch (RuntimeException e) {
                logger.log(Level.WARNING, "Invalid JSON: " + object, e);
                return Optional.absent();
            }
        }
        return Optional.of(new RestoredQuery(queryTypes, fields));
    }

    private void updatePreferences() {
        JsonArray array = new JsonArray();
        for (StoredQuery query : this.queries) {
            JsonObject object = new JsonObject();
            object.addProperty("name", query.name);
            object.addProperty("json", query.persistedQuery);
            object.addProperty("type", query.storedQueryType.name());
            array.add(object);
        }
        this.saveStoredJson(array);
        this.reportSetPreferences.save(true);
    }

    private void restoreFromPreferences() {
        JsonArray array;
        String storedJson = this.getStoredJson();
        if (!Strings.isNullOrEmpty(storedJson)) {
            try {
                array = JsonParser.parseString(storedJson).getAsJsonArray();
                this.queries.clear();
                Iterator<JsonElement> iterator = array.iterator();
                while (iterator.hasNext()) {
                    JsonObject jsonObject = iterator.next().getAsJsonObject();
                    String name = jsonObject.getAsJsonPrimitive("name").getAsString();
                    String json = jsonObject.getAsJsonPrimitive("json").getAsString();
                    StoredQueryType type = StoredQueryType.REPORTS;
                    if (jsonObject.has("type")) {
                        try {
                            type = StoredQueryType.valueOf(jsonObject.getAsJsonPrimitive("type").getAsString());
                        }
                        catch (IllegalArgumentException e) {
                            logger.log(Level.WARNING, "Couldn't parse query type", e);
                        }
                    } else if (json.startsWith("COUNTRY/") || json.startsWith("STATE/") || json.startsWith("COUNTY/")) {
                        type = StoredQueryType.TOTAL_TICKS;
                    }
                    this.queries.add(new StoredQuery(name, json, type));
                }
            }
            catch (JsonParseException e) {
                logger.log(Level.WARNING, "Could not parse saved queries", e);
            }
        }
        array = new JsonArray();
        for (StoredQuery query : this.queries) {
            JsonObject object = new JsonObject();
            object.addProperty("name", query.name);
            object.addProperty("json", query.persistedQuery);
            array.add(object);
        }
        this.saveStoredJson(array);
    }

    private String getStoredJson() {
        String storedJson;
        String string = storedJson = this.reportSetPreferences == null ? null : this.reportSetPreferences.get().storedQueries;
        if (Strings.isNullOrEmpty(storedJson)) {
            storedJson = this.preferences.storedQueries;
        }
        return storedJson;
    }

    private void saveStoredJson(JsonArray array) {
        String json = new Gson().toJson(array);
        if (this.reportSetPreferences != null) {
            this.reportSetPreferences.get().storedQueries = json;
        }
        this.preferences.storedQueries = json;
    }

    public class StoredQuery {
        final String name;
        private String persistedQuery;
        StoredQueryType storedQueryType;

        StoredQuery(String name, String persistedQuery, StoredQueryType storedQueryType) {
            this.name = Preconditions.checkNotNull(name);
            this.persistedQuery = Preconditions.checkNotNull(persistedQuery);
            this.storedQueryType = Preconditions.checkNotNull(storedQueryType);
        }

        public Optional<RestoredQuery> restore() {
            return StoredQueries.this.restore(this.queryJson());
        }

        public TotalTicksProcessor.TotalTickType getTotalTickType() {
            if (this.storedQueryType != StoredQueryType.TOTAL_TICKS) {
                throw new IllegalStateException("Type is " + this.storedQueryType);
            }
            int slashIndex = this.persistedQuery.indexOf(47);
            if (slashIndex < 0) {
                throw new IllegalStateException("Could not find ticks type in " + this.persistedQuery);
            }
            return TotalTicksProcessor.TotalTickType.valueOf(this.persistedQuery.substring(0, slashIndex));
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StoredQuery)) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            StoredQuery that = (StoredQuery)obj;
            return Objects.equal(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hashCode(this.name);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("name", this.name).add("persistedQuery", this.persistedQuery).toString();
        }

        public String queryJson() {
            if (this.storedQueryType == StoredQueryType.REPORTS) {
                return this.persistedQuery;
            }
            if (this.storedQueryType == StoredQueryType.TOTAL_TICKS) {
                int slashIndex = this.persistedQuery.indexOf(47);
                if (slashIndex < 0) {
                    throw new IllegalStateException("Could not find ticks type in " + this.persistedQuery);
                }
                return this.persistedQuery.substring(slashIndex + 1);
            }
            throw new IllegalStateException("Unexpected query type: " + this.storedQueryType);
        }
    }

    public static enum StoredQueryType {
        REPORTS,
        TOTAL_TICKS;

    }

    public static class RestoredQuery {
        final ImmutableList<CompositeQueryDefinition.BooleanOperation> booleanOperations;
        final ImmutableList<QueryFieldFactory.QueryField> fields;

        RestoredQuery(List<CompositeQueryDefinition.BooleanOperation> booleanOperations, List<QueryFieldFactory.QueryField> fields) {
            this.booleanOperations = ImmutableList.copyOf(booleanOperations);
            this.fields = ImmutableList.copyOf(fields);
        }

        public boolean containsQueryFieldType(QueryFieldFactory.QueryFieldType type) {
            return this.fields.stream().anyMatch(field -> field.getType() == type);
        }

        public QueryDefinition getQueryDefinition(Taxonomy taxonomy, ReportSet reportSet, QueryPreferences queryPreferences, Taxon.Type depth, Predicate<Sighting> additionalPredicate) {
            final CompositeQueryDefinition queryDefinition = new CompositeQueryDefinition(reportSet, this.fields, this.booleanOperations, taxonomy, depth);
            Predicate<Sighting> countablePredicate = this.countablePredicate(taxonomy, queryPreferences);
            final Predicate<Sighting> intersection = countablePredicate == null ? additionalPredicate : Predicates.and(additionalPredicate, countablePredicate);
            return new QueryDefinition(){

                @Override
                public Optional<QueryDefinition.Preprocessor> preprocessor() {
                    return queryDefinition.preprocessor();
                }

                @Override
                public Predicate<Sighting> predicate() {
                    return Predicates.and(queryDefinition.predicate(), intersection);
                }

                @Override
                public Optional<QueryDefinition.QueryAnnotation> annotate(Sighting sighting, SightingTaxon taxon) {
                    return queryDefinition.annotate(sighting, taxon);
                }

                @Override
                public Optional<QueryDefinition.PostProcessor> postprocessor() {
                    return queryDefinition.postprocessor();
                }
            };
        }

        Predicate<Sighting> countablePredicate(Taxonomy taxonomy, QueryPreferences queryPreferences) {
            boolean skipStatusIntersection = false;
            Optional<Boolean> heardOnlyQuery = null;
            for (int i = 0; i < this.fields.size(); ++i) {
                QueryFieldFactory.QueryField field = (QueryFieldFactory.QueryField)this.fields.get(i);
                if (field.getType() == QueryFieldFactory.QueryFieldType.SIGHTING_STATUS) {
                    skipStatusIntersection = true;
                }
                if (field.getType() != QueryFieldFactory.QueryFieldType.ALLOW_HEARD_ONLY || !(heardOnlyQuery = field.getBooleanValue()).isPresent() || this.booleanOperations.get(i) != CompositeQueryDefinition.BooleanOperation.NEVER && this.booleanOperations.get(i) != CompositeQueryDefinition.BooleanOperation.NEVER_ALL) continue;
                heardOnlyQuery = Optional.of(heardOnlyQuery.get() == false);
            }
            return queryPreferences.getCountablePredicate(taxonomy, skipStatusIntersection, heardOnlyQuery);
        }
    }
}

