/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.primitives.Ints;
import com.scythebill.birdlist.model.io.CsvImportLines;
import com.scythebill.birdlist.model.io.ImportLines;
import com.scythebill.birdlist.model.query.QueryDefinition;
import com.scythebill.birdlist.model.query.QueryProcessor;
import com.scythebill.birdlist.model.query.QueryResults;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.MappedTaxonomy;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.TaxonVisitor;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

class SplitsAndLumpsProcessor {
    private static final String CLEMENTS_REPORT_NAME_PATTERN = "/report-%s.csv";
    private static final String IOC_REPORT_NAME_PATTERN = "/report-ioc-%s.csv";
    private static final Splitter SLASH_SPLITTER = Splitter.on('/');

    public SplitsAndLumpsResult process(ReportSet reportSet, Taxonomy taxonomy, QueryDefinition queryDefinition, Predicate<Sighting> countablePredicate, String version) {
        String name = String.format(taxonomy instanceof MappedTaxonomy ? IOC_REPORT_NAME_PATTERN : CLEMENTS_REPORT_NAME_PATTERN, version);
        ParsedReport parsedReport = new ParsedReport();
        try {
            parsedReport.parse(taxonomy, name);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        QueryProcessor queryProcessor = new QueryProcessor(reportSet, taxonomy);
        queryProcessor.onlyIncludeCountableSightings().dontIncludeFamilyNames();
        QueryResults queryResults = queryProcessor.runQuery(queryDefinition, countablePredicate, Taxon.Type.species);
        TreeMap<Integer, BundleResult> bundleResults = new TreeMap<Integer, BundleResult>();
        for (Sighting sighting : queryResults.getAllSightings()) {
            Integer bundleIndex;
            SightingTaxon.Resolved speciesResolved;
            SightingTaxon.Resolved resolved = sighting.getTaxon().resolve(taxonomy);
            SightingTaxon sightingTaxon = resolved.getSightingTaxon();
            if ((sightingTaxon.getType() == SightingTaxon.Type.HYBRID || sightingTaxon.getType() == SightingTaxon.Type.SP) && (resolved.getSmallestTaxonType() == Taxon.Type.species || (speciesResolved = resolved.resolveParentOfType(Taxon.Type.species)).getType() == SightingTaxon.Type.SP || speciesResolved.getType() == SightingTaxon.Type.HYBRID) || (bundleIndex = parsedReport.getBundleIndex(sightingTaxon)) == null) continue;
            BundleDefinition bundleDefinition = Preconditions.checkNotNull(parsedReport.bundlesByIndex.get(bundleIndex));
            BundleResult result = bundleResults.computeIfAbsent(bundleIndex, index -> new BundleResult(bundleDefinition));
            result.processResolved(resolved);
        }
        SplitsAndLumpsResult results = new SplitsAndLumpsResult();
        for (BundleResult bundleResult : bundleResults.values()) {
            results.addBundle(bundleResult);
        }
        return results;
    }

    private static class ParsedReport {
        private Map<Integer, BundleDefinition> bundlesByIndex = new LinkedHashMap<Integer, BundleDefinition>();
        private Map<String, Integer> currentIdToBundleIndex = new LinkedHashMap<String, Integer>();

        private ParsedReport() {
        }

        void parse(Taxonomy taxonomy, String resourceName) throws IOException {
            String[] line;
            URL resource = Preconditions.checkNotNull(this.getClass().getResource(resourceName), "Could not load %s", (Object)resourceName);
            ImportLines importLines = CsvImportLines.fromUrl(resource, StandardCharsets.UTF_8);
            importLines.nextLine();
            while ((line = importLines.nextLine()) != null) {
                final Integer index = Ints.tryParse(line[0]);
                if (index == null) {
                    throw new IllegalStateException("Could not parse index " + line[0]);
                }
                final BundleDefinition bundle = this.bundlesByIndex.computeIfAbsent(index, __ -> new BundleDefinition());
                List<String> currentIds = SLASH_SPLITTER.splitToList(line[4]);
                List<String> oldCommonNames = SLASH_SPLITTER.splitToList(line[2]);
                List<String> oldSciNames = SLASH_SPLITTER.splitToList(line[3]);
                Preconditions.checkState(oldCommonNames.size() == oldSciNames.size());
                for (int i = 0; i < oldCommonNames.size(); ++i) {
                    bundle.oldSciToOldCommon.put(oldSciNames.get(i), oldCommonNames.get(i));
                }
                if (line[1].equals("simple")) {
                    final String oldSciName = Iterables.getOnlyElement(oldSciNames);
                    for (String currentId : currentIds) {
                        TaxonUtils.visitTaxa(taxonomy.getTaxon(currentId), new TaxonVisitor(){

                            @Override
                            public boolean visitTaxon(Taxon taxon) {
                                bundle.currentIdsToOldSci.put(taxon.getId(), oldSciName);
                                currentIdToBundleIndex.put(taxon.getId(), index);
                                return true;
                            }
                        });
                    }
                    continue;
                }
                if (line[1].equals("complex")) {
                    for (String currentId : currentIds) {
                        for (String oldSciName : oldSciNames) {
                            bundle.currentIdsToOldSci.put(currentId, oldSciName);
                            this.currentIdToBundleIndex.put(currentId, index);
                        }
                    }
                    continue;
                }
                throw new IllegalStateException("unexpected type " + line[1]);
            }
        }

        Integer getBundleIndex(SightingTaxon sightingTaxon) {
            String id = sightingTaxon.getIds().iterator().next();
            return this.currentIdToBundleIndex.get(id);
        }
    }

    private static class BundleDefinition {
        private Multimap<String, String> currentIdsToOldSci = LinkedHashMultimap.create();
        private Map<String, String> oldSciToOldCommon = new LinkedHashMap<String, String>();

        private BundleDefinition() {
        }
    }

    private static class BundleResult {
        final Set<String> currentTaxaInBundle = new LinkedHashSet<String>();
        final Set<String> knownOldSci = new LinkedHashSet<String>();
        final Set<String> possibleOldSci = new LinkedHashSet<String>();
        final BundleDefinition bundleDefinition;

        BundleResult(BundleDefinition bundleDefinition) {
            this.bundleDefinition = bundleDefinition;
        }

        public void processResolved(SightingTaxon.Resolved resolved) {
            SightingTaxon sightingTaxon = resolved.getSightingTaxon();
            LinkedHashSet<String> oldTaxa = new LinkedHashSet<String>();
            for (String id : sightingTaxon.getIds()) {
                oldTaxa.addAll(this.bundleDefinition.currentIdsToOldSci.get(id));
            }
            SightingTaxon.Resolved parent = resolved.resolveParentOfType(Taxon.Type.species);
            this.currentTaxaInBundle.add(parent.getSightingTaxon().getId());
            if (oldTaxa.size() == 1) {
                this.knownOldSci.addAll(oldTaxa);
                this.possibleOldSci.removeAll(oldTaxa);
            } else {
                oldTaxa.removeAll(this.knownOldSci);
                this.possibleOldSci.addAll(oldTaxa);
            }
        }
    }

    static class SplitsAndLumpsResult {
        List<SingleResult> splits = new ArrayList<SingleResult>();
        List<SingleResult> lumps = new ArrayList<SingleResult>();
        List<SingleResult> possibleSplits = new ArrayList<SingleResult>();
        List<SingleResult> possibleLumps = new ArrayList<SingleResult>();
        List<SingleResult> possibleLumpOrSplit = new ArrayList<SingleResult>();
        int knownSplitCount = 0;
        int knownLumpCount = 0;
        int possibleSplitCount = 0;
        int possibleLumpCount = 0;
        boolean reverse = false;

        SplitsAndLumpsResult() {
        }

        public SplitsAndLumpsResult reverse() {
            SplitsAndLumpsResult reversed = new SplitsAndLumpsResult();
            reversed.knownLumpCount = this.knownSplitCount;
            reversed.knownSplitCount = this.knownLumpCount;
            reversed.possibleSplitCount = this.possibleLumpCount;
            reversed.possibleLumpCount = this.possibleSplitCount;
            reversed.splits.addAll(this.lumps);
            reversed.lumps.addAll(this.splits);
            reversed.possibleSplits.addAll(this.possibleLumps);
            reversed.possibleLumpOrSplit.addAll(this.possibleLumpOrSplit);
            reversed.reverse = true;
            return reversed;
        }

        public boolean isEmpty() {
            return this.splits.isEmpty() && this.lumps.isEmpty() && this.possibleSplits.isEmpty() && this.possibleLumps.isEmpty() && this.possibleLumpOrSplit.isEmpty();
        }

        private void addBundle(BundleResult bundleResult) {
            int currentSize = bundleResult.currentTaxaInBundle.size();
            int knownOldSize = bundleResult.knownOldSci.size();
            int possibleOldSize = bundleResult.possibleOldSci.size();
            if (knownOldSize == 0) {
                knownOldSize = 1;
                --possibleOldSize;
            }
            if (bundleResult.knownOldSci.size() == 0 && bundleResult.possibleOldSci.size() == 1) {
                bundleResult.knownOldSci.addAll(bundleResult.possibleOldSci);
                bundleResult.possibleOldSci.clear();
            }
            if (possibleOldSize == 0) {
                if (currentSize == knownOldSize) {
                    return;
                }
                SingleResult result = new SingleResult();
                result.currentTaxa = ImmutableList.copyOf(bundleResult.currentTaxaInBundle);
                result.oldTaxa = bundleResult.knownOldSci.stream().map(oldSci -> new OldSpecies((String)oldSci, bundleResult.bundleDefinition)).collect(ImmutableList.toImmutableList());
                result.possibleOldTaxa = ImmutableList.of();
                if (currentSize < knownOldSize) {
                    this.lumps.add(result);
                    this.knownLumpCount += knownOldSize - currentSize;
                } else {
                    this.splits.add(result);
                    this.knownSplitCount += currentSize - knownOldSize;
                }
            } else {
                SingleResult result = new SingleResult();
                result.currentTaxa = ImmutableList.copyOf(bundleResult.currentTaxaInBundle);
                result.oldTaxa = bundleResult.knownOldSci.stream().map(oldSci -> new OldSpecies((String)oldSci, bundleResult.bundleDefinition)).collect(ImmutableList.toImmutableList());
                result.possibleOldTaxa = bundleResult.possibleOldSci.stream().map(oldSci -> new OldSpecies((String)oldSci, bundleResult.bundleDefinition)).collect(ImmutableList.toImmutableList());
                if (currentSize < knownOldSize) {
                    if (currentSize + possibleOldSize > knownOldSize) {
                        this.possibleLumpOrSplit.add(result);
                        this.possibleLumpCount += knownOldSize - currentSize;
                        this.possibleSplitCount += currentSize + possibleOldSize - knownOldSize;
                    } else if (currentSize + possibleOldSize == knownOldSize) {
                        this.possibleLumps.add(result);
                        this.possibleLumpCount += possibleOldSize;
                    } else {
                        this.knownLumpCount += knownOldSize - (currentSize + possibleOldSize);
                        this.possibleLumpCount += possibleOldSize;
                        this.possibleLumps.add(result);
                    }
                } else if (currentSize == knownOldSize) {
                    this.possibleLumpCount += possibleOldSize;
                    this.possibleLumps.add(result);
                } else {
                    this.knownSplitCount += currentSize - knownOldSize - possibleOldSize;
                    this.possibleSplitCount += possibleOldSize;
                    if (currentSize > knownOldSize + possibleOldSize) {
                        this.splits.add(result);
                    } else {
                        this.possibleSplits.add(result);
                    }
                }
            }
        }

        static class SingleResult {
            List<String> currentTaxa;
            List<OldSpecies> oldTaxa;
            List<OldSpecies> possibleOldTaxa;

            SingleResult() {
            }
        }

        static class OldSpecies {
            final String scientific;
            final String common;

            private OldSpecies(String oldSci, BundleDefinition bundleDefinition) {
                this.scientific = oldSci;
                this.common = bundleDefinition.oldSciToOldCommon.get(oldSci);
            }
        }
    }
}

