/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.taxa.MappedTaxonomy;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.app.NavigableFrame;
import com.scythebill.birdlist.ui.app.Titled;
import com.scythebill.birdlist.ui.events.EventBusRegistrar;
import com.scythebill.birdlist.ui.events.TaxonomyChangedEvent;
import com.scythebill.birdlist.ui.events.TaxonomyStore;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.reports.QueryFieldFactory;
import com.scythebill.birdlist.ui.panels.reports.QueryPanel;
import com.scythebill.birdlist.ui.panels.reports.QueryPanelFactory;
import com.scythebill.birdlist.ui.panels.reports.QueryPreferences;
import com.scythebill.birdlist.ui.panels.reports.SplitsAndLumpsProcessor;
import com.scythebill.birdlist.ui.util.Alerts;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.border.EmptyBorder;

public class SplitsAndLumpsPanel
extends JPanel
implements FontManager.FontsUpdatedListener,
Titled {
    private final ReportSet reportSet;
    private final QueryPanelFactory queryPanelFactory;
    private final TaxonomyStore taxonomyStore;
    private final QueryPreferences queryPreferences;
    private final NavigableFrame navigableFrame;
    private QueryPanel queryPanel;
    private JButton returnButton;
    private JLabel splitsAndLumpsExplanation;
    private JEditorPane splitsAndLumpsText;
    private JScrollPane splitsAndLumpsScrollPane;
    private JLabel versionLabel;
    private JComboBox<Version> versionCombobox;
    private JLabel splitsAndLumpsTotal;
    private static final String CURRENT_CLEMENTS_VERSION = "2025";
    private static final String CURRENT_IOC_VERSION = "15.1";
    private static final ImmutableList<Version> IOC_VERSIONS = Arrays.stream(Version.values()).filter(v -> v.name().startsWith("IOC_")).collect(ImmutableList.toImmutableList());
    private static final ImmutableList<Version> CLEMENTS_VERSIONS = Arrays.stream(Version.values()).filter(v -> v.name().startsWith("CLEMENTS_")).collect(ImmutableList.toImmutableList());

    @Inject
    SplitsAndLumpsPanel(ReportSet reportSet, QueryPanelFactory queryPanelFactory, TaxonomyStore taxonomyStore, EventBusRegistrar eventBusRegistrar, FontManager fontManager, QueryPreferences queryPreferences, NavigableFrame navigableFrame, Alerts alerts) {
        this.reportSet = reportSet;
        this.queryPanelFactory = queryPanelFactory;
        this.taxonomyStore = taxonomyStore;
        this.queryPreferences = queryPreferences;
        this.navigableFrame = navigableFrame;
        this.initGUI();
        this.attachListeners();
        fontManager.applyTo(this);
        eventBusRegistrar.registerWhenInHierarchy(this);
        this.taxonomyChanged(null);
    }

    private void attachListeners() {
        this.returnButton.addActionListener(e -> this.navigableFrame.navigateTo("extendedReportsMenu"));
        this.queryPanel.addPredicateChangedListener(e -> this.showQueryResults());
        this.versionCombobox.addActionListener(e -> this.showQueryResults());
    }

    private void initGUI() {
        this.queryPanel = this.queryPanelFactory.newQueryPanel(QueryFieldFactory.QueryFieldType.SUBSPECIES_ALLOCATED, QueryFieldFactory.QueryFieldType.FIRST_SIGHTINGS, QueryFieldFactory.QueryFieldType.SP_OR_HYBRID, QueryFieldFactory.QueryFieldType.TIMES_SIGHTED);
        this.splitsAndLumpsTotal = new JLabel();
        this.splitsAndLumpsExplanation = new JLabel();
        this.splitsAndLumpsExplanation.putClientProperty("birdlist.plainLabel", true);
        this.splitsAndLumpsExplanation.setText("<html>" + Messages.getMessage(Messages.Name.SPLITS_AND_LUMPS_FULL_EXPLANATION));
        this.returnButton = new JButton(Messages.getMessage(Messages.Name.BACK_TO_SPECIAL_REPORTS));
        this.versionLabel = new JLabel(Messages.getMessage(Messages.Name.TAXONOMY_LABEL));
        this.versionCombobox = new JComboBox();
        this.splitsAndLumpsText = new JEditorPane("text/html", "");
        this.splitsAndLumpsScrollPane = new JScrollPane(this.splitsAndLumpsText);
        this.splitsAndLumpsText.setEditable(false);
        this.splitsAndLumpsText.putClientProperty("JEditorPane.honorDisplayProperties", true);
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        Dimension size = fontManager.scale(new Dimension(1200, 720));
        this.setPreferredSize(size);
        this.setBorder(new EmptyBorder(fontManager.scale(20), fontManager.scale(20), fontManager.scale(20), fontManager.scale(20)));
        GroupLayout layout = new GroupLayout(this);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.versionLabel).addComponent(this.versionCombobox, -2, -2, -2)).addComponent(this.queryPanel, -2, -2, Short.MAX_VALUE).addComponent(this.splitsAndLumpsExplanation).addComponent(this.splitsAndLumpsTotal).addComponent(this.splitsAndLumpsScrollPane).addComponent(this.returnButton, GroupLayout.Alignment.TRAILING));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createBaselineGroup(false, false).addComponent(this.versionLabel).addComponent(this.versionCombobox, -2, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.queryPanel, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.splitsAndLumpsExplanation).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.splitsAndLumpsTotal).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.splitsAndLumpsScrollPane, fontManager.scale(80), -2, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createBaselineGroup(false, false).addComponent(this.returnButton)));
        this.setLayout(layout);
    }

    @Subscribe
    public void taxonomyChanged(TaxonomyChangedEvent event) {
        Version[] versions = (this.taxonomyStore.getTaxonomy() instanceof MappedTaxonomy ? IOC_VERSIONS : CLEMENTS_VERSIONS).toArray(new Version[0]);
        this.queryPanel.taxonomyUpdated();
        this.versionCombobox.setModel(new DefaultComboBoxModel<Version>(versions));
        this.showQueryResults();
    }

    private void showQueryResults() {
        SplitsAndLumpsProcessor.SplitsAndLumpsResult result = this.computeSplitsAndLumps();
        StringBuilder builder = new StringBuilder("<html>");
        if (result.isEmpty()) {
            builder.append(Messages.getMessage(Messages.Name.NO_SPLITS_OR_LUMPS_FOUND));
            this.splitsAndLumpsTotal.setText("");
        } else {
            StringBuilder total = new StringBuilder();
            total.append(Messages.getFormattedMessage(Messages.Name.GAINED_FORMAT, result.knownSplitCount));
            if (result.possibleSplitCount > 0) {
                total.append(" ");
                total.append(Messages.getFormattedMessage(Messages.Name.PLUS_POSSIBLE_FORMAT, result.possibleSplitCount));
            }
            total.append(" ");
            total.append(Messages.getFormattedMessage(Messages.Name.LOST_FORMAT, result.knownLumpCount));
            if (result.possibleLumpCount > 0) {
                total.append(" ");
                total.append(Messages.getFormattedMessage(Messages.Name.PLUS_POSSIBLE_FORMAT, result.possibleLumpCount));
            }
            this.splitsAndLumpsTotal.setText(total.toString());
            if (!result.splits.isEmpty()) {
                builder.append("<h1>").append(Messages.getMessage(Messages.Name.SPLITS_TEXT)).append("</h1>");
                builder.append("<ul>\n");
                for (SplitsAndLumpsProcessor.SplitsAndLumpsResult.SingleResult split : result.splits) {
                    builder.append("<li>");
                    builder.append(result.reverse ? this.singleResultAsStringReversed(split) : this.singleResultAsString(split));
                }
                builder.append("</ul>\n");
            }
            if (!result.possibleSplits.isEmpty()) {
                builder.append("<h1>").append(Messages.getMessage(Messages.Name.POSSIBLE_SPLITS)).append("</h1>");
                builder.append("<ul>\n");
                for (SplitsAndLumpsProcessor.SplitsAndLumpsResult.SingleResult possibleSplit : result.possibleSplits) {
                    builder.append("<li>");
                    builder.append(result.reverse ? this.singleResultAsStringReversed(possibleSplit) : this.singleResultAsString(possibleSplit));
                }
                builder.append("</ul>\n");
            }
            if (!result.lumps.isEmpty()) {
                builder.append("<h1>").append(Messages.getMessage(Messages.Name.LUMPS_TEXT)).append("</h1>");
                builder.append("<ul>\n");
                for (SplitsAndLumpsProcessor.SplitsAndLumpsResult.SingleResult lump : result.lumps) {
                    builder.append("<li>");
                    builder.append(result.reverse ? this.singleResultAsStringReversed(lump) : this.singleResultAsString(lump));
                }
                builder.append("</ul>\n");
            }
            if (!result.possibleLumps.isEmpty()) {
                builder.append("<h1>").append(Messages.getMessage(Messages.Name.POSSIBLE_LUMPS)).append("</h1>");
                builder.append("<ul>\n");
                for (SplitsAndLumpsProcessor.SplitsAndLumpsResult.SingleResult possibleLump : result.possibleLumps) {
                    builder.append("<li>");
                    builder.append(result.reverse ? this.singleResultAsStringReversed(possibleLump) : this.singleResultAsString(possibleLump));
                }
                builder.append("</ul>\n");
            }
            if (!result.possibleLumpOrSplit.isEmpty()) {
                builder.append("<h1>").append(Messages.getMessage(Messages.Name.UNKNOWN_LUMPS_OR_SPLITS)).append("</h1>");
                builder.append("<ul>\n");
                for (SplitsAndLumpsProcessor.SplitsAndLumpsResult.SingleResult shrug : result.possibleLumpOrSplit) {
                    builder.append("<li>");
                    builder.append(result.reverse ? this.singleResultAsStringReversed(shrug) : this.singleResultAsString(shrug));
                }
                builder.append("</ul>\n");
            }
        }
        this.splitsAndLumpsText.setText(builder.toString());
        this.splitsAndLumpsText.setCaretPosition(0);
    }

    private String singleResultAsString(SplitsAndLumpsProcessor.SplitsAndLumpsResult.SingleResult result) {
        HashSet<String> encounteredGenera = new HashSet<String>();
        String newTaxa = Messages.join(result.currentTaxa, currentTaxon -> this.currentTaxonAsString((String)currentTaxon, (Set<String>)encounteredGenera));
        if (result.oldTaxa.isEmpty()) {
            String possibleOldTaxa = Messages.join(result.possibleOldTaxa, oldSpecies -> this.oldSpeciesAsString((SplitsAndLumpsProcessor.SplitsAndLumpsResult.OldSpecies)oldSpecies, (Set<String>)encounteredGenera));
            Messages.Name name = result.possibleOldTaxa.size() == 1 ? Messages.Name.SOME_OR_ALL_OF_IS_NOW_FORMAT : Messages.Name.SOME_OR_ALL_OF_ARE_NOW_FORMAT;
            return Messages.getFormattedMessage(name, possibleOldTaxa, newTaxa);
        }
        String oldTaxa = Messages.join(result.oldTaxa, oldSpecies -> this.oldSpeciesAsString((SplitsAndLumpsProcessor.SplitsAndLumpsResult.OldSpecies)oldSpecies, (Set<String>)encounteredGenera));
        if (!result.possibleOldTaxa.isEmpty()) {
            if (result.possibleOldTaxa.size() == 1) {
                Messages.Name name = result.oldTaxa.size() == 1 ? Messages.Name.SOME_OR_ALL_OF_AND_POSSIBLY_IS_NOW_FORMAT : Messages.Name.SOME_OR_ALL_OF_AND_POSSIBLY_ARE_NOW_FORMAT;
                return Messages.getFormattedMessage(name, oldTaxa, this.oldSpeciesAsString(result.possibleOldTaxa.get(0), encounteredGenera), newTaxa);
            }
            Messages.Name name = result.oldTaxa.size() == 1 ? Messages.Name.SOME_OR_ALL_OF_AND_SOME_NONE_ALL_IS_NOW_FORMAT : Messages.Name.SOME_OR_ALL_OF_AND_SOME_NONE_ALL_ARE_NOW_FORMAT;
            String possibleOldTaxa = Messages.join(result.possibleOldTaxa, oldSpecies -> this.oldSpeciesAsString((SplitsAndLumpsProcessor.SplitsAndLumpsResult.OldSpecies)oldSpecies, (Set<String>)encounteredGenera));
            return Messages.getFormattedMessage(name, oldTaxa, possibleOldTaxa, newTaxa);
        }
        Messages.Name name = result.oldTaxa.size() == 1 ? Messages.Name.IS_NOW_FORMAT : Messages.Name.ARE_NOW_FORMAT;
        return Messages.getFormattedMessage(name, oldTaxa, newTaxa);
    }

    private String singleResultAsStringReversed(SplitsAndLumpsProcessor.SplitsAndLumpsResult.SingleResult result) {
        HashSet encounteredGenera = new HashSet();
        String newTaxa = Messages.join(result.currentTaxa, currentTaxon -> this.currentTaxonAsString((String)currentTaxon, encounteredGenera));
        String oldTaxa = Messages.join(result.oldTaxa, oldSpecies -> this.oldSpeciesAsString((SplitsAndLumpsProcessor.SplitsAndLumpsResult.OldSpecies)oldSpecies, encounteredGenera));
        String possibleOldTaxa = Messages.join(result.possibleOldTaxa, oldSpecies -> this.oldSpeciesAsString((SplitsAndLumpsProcessor.SplitsAndLumpsResult.OldSpecies)oldSpecies, encounteredGenera));
        if (result.oldTaxa.isEmpty()) {
            Messages.Name name = result.possibleOldTaxa.size() == 1 ? Messages.Name.IS_NOW_SOME_OR_ALL_OF_FORMAT : Messages.Name.ARE_NOW_SOME_OR_ALL_OF_FORMAT;
            return Messages.getFormattedMessage(name, newTaxa, possibleOldTaxa);
        }
        if (!result.possibleOldTaxa.isEmpty()) {
            if (result.possibleOldTaxa.size() == 1) {
                Messages.Name name = result.currentTaxa.size() == 1 ? Messages.Name.IS_NOW_SOME_OR_ALL_OF_AND_POSSIBLY_FORMAT : Messages.Name.ARE_NOW_SOME_OR_ALL_OF_AND_POSSIBLY_FORMAT;
                return Messages.getFormattedMessage(name, newTaxa, oldTaxa, possibleOldTaxa);
            }
            Messages.Name name = result.currentTaxa.size() == 1 ? Messages.Name.IS_NOW_SOME_OR_ALL_OF_AND_SOME_NONE_ALL_FORMAT : Messages.Name.ARE_NOW_SOME_OR_ALL_OF_AND_SOME_NONE_ALL_FORMAT;
            return Messages.getFormattedMessage(name, newTaxa, oldTaxa, possibleOldTaxa);
        }
        Messages.Name name = result.currentTaxa.size() == 1 ? Messages.Name.IS_NOW_FORMAT : Messages.Name.ARE_NOW_FORMAT;
        return Messages.getFormattedMessage(name, newTaxa, oldTaxa);
    }

    private String oldSpeciesAsString(SplitsAndLumpsProcessor.SplitsAndLumpsResult.OldSpecies oldSpecies, Set<String> encounteredGenera) {
        Object sci = oldSpecies.scientific;
        String currentGenus = ((String)sci).substring(0, ((String)sci).indexOf(32));
        if (!encounteredGenera.add(currentGenus)) {
            sci = currentGenus.charAt(0) + ". " + ((String)sci).substring(((String)sci).indexOf(32) + 1);
        }
        return String.format("<b>%s</b> (<i>%s</i>)", oldSpecies.common, sci);
    }

    private String currentTaxonAsString(String id, Set<String> encounteredGenera) {
        Taxon taxon = this.taxonomyStore.getTaxonomy().getTaxon(id);
        Taxon genus = TaxonUtils.getParentOfType(taxon, Taxon.Type.genus);
        String sciName = encounteredGenera.add(genus.getName()) ? TaxonUtils.getFullName(taxon) : TaxonUtils.getAbbreviatedName(taxon);
        return String.format("<b>%s</b> (<i>%s</i>)", taxon.getCommonName(), sciName);
    }

    private SplitsAndLumpsProcessor.SplitsAndLumpsResult computeSplitsAndLumps() {
        Taxonomy taxonomy = this.taxonomyStore.getTaxonomy();
        Predicate<Sighting> countablePredicate = this.queryPreferences.getCountablePredicate(taxonomy, this.queryPanel.containsQueryFieldType(QueryFieldFactory.QueryFieldType.SIGHTING_STATUS), this.queryPanel.getBooleanValueIfPresent(QueryFieldFactory.QueryFieldType.ALLOW_HEARD_ONLY));
        Version version = (Version)((Object)this.versionCombobox.getSelectedItem());
        if (version == null) {
            return new SplitsAndLumpsProcessor.SplitsAndLumpsResult();
        }
        SplitsAndLumpsProcessor processor = new SplitsAndLumpsProcessor();
        SplitsAndLumpsProcessor.SplitsAndLumpsResult result = processor.process(this.reportSet, taxonomy, this.queryPanel.queryDefinition(taxonomy, Taxon.Type.species), countablePredicate, version.id);
        if (version.reversed) {
            return result.reverse();
        }
        return result;
    }

    @Override
    public String getTitle() {
        return Messages.getMessage(Messages.Name.SPLITS_AND_LUMPS);
    }

    static enum Version {
        CLEMENTS_2024("2024", "2024", "2025"),
        CLEMENTS_AVILIST("AviList 2025", "avilist", "2025", true),
        CLEMENTS_2023("2023", "2023", "2025"),
        CLEMENTS_2022("2022", "2022", "2025"),
        CLEMENTS_2021("2021", "2021", "2025"),
        CLEMENTS_2019("2019", "2019", "2025"),
        CLEMENTS_2018("2018", "2018", "2025"),
        CLEMENTS_2017("2017", "2017", "2025"),
        CLEMENTS_2016("2016", "2016", "2025"),
        CLEMENTS_2015("2015", "2015", "2025"),
        CLEMENTS_69("6.9 (August 2014)", "69", "2025"),
        CLEMENTS_68("6.8 (August 2013)", "68", "2025"),
        CLEMENTS_67("6.7 (September 2012)", "67", "2025"),
        CLEMENTS_66("6.6 (August 2011)", "66", "2025"),
        CLEMENTS_65("6.5 (December 2010)", "65", "2025"),
        IOC_AVILIST("AviList 2025", "avilist", "15.1", true),
        IOC_142("14.2 (August 2024)", "142", "15.1"),
        IOC_141("14.1 (December 2023)", "141", "15.1"),
        IOC_132("13.2 (July 2023)", "132", "15.1"),
        IOC_131("13.1 (January 2023)", "131", "15.1"),
        IOC_122("12.2 (August 2022)", "122", "15.1"),
        IOC_121("12.1 (January 2022)", "121", "15.1"),
        IOC_112("11.2 (July 2021)", "112", "15.1"),
        IOC_111("11.1 (January 2021)", "111", "15.1"),
        IOC_102("10.2 (July 2020)", "102", "15.1"),
        IOC_101("10.1 (January 2020)", "101", "15.1"),
        IOC_92("9.2 (June 2019)", "92", "15.1"),
        IOC_91("9.1 (January 2019)", "91", "15.1"),
        IOC_82("8.2 (June 2018)", "82", "15.1"),
        IOC_81("8.1 (January 2018)", "81", "15.1"),
        IOC_71("7.1 (January 2017)", "71", "15.1"),
        IOC_61("6.1 (January 2016)", "61", "15.1"),
        IOC_51("5.1 (January 2015)", "51", "15.1");

        private final String text;
        private final String id;
        private final String currentVersion;
        private final boolean reversed;

        private Version(String text, String id, String currentVersion, boolean reversed) {
            this.text = text;
            this.id = id;
            this.currentVersion = currentVersion;
            this.reversed = reversed;
        }

        private Version(String text, String id, String currentVersion) {
            this(text, id, currentVersion, false);
        }

        public String toString() {
            if (this.reversed) {
                return Messages.getFormattedMessage(Messages.Name.VERSUS_FORMAT, this.currentVersion, this.text);
            }
            return Messages.getFormattedMessage(Messages.Name.VERSUS_FORMAT, this.text, this.currentVersion);
        }
    }
}

