/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.Species;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.events.TaxonomyStore;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.reports.AbstractQueryField;
import com.scythebill.birdlist.ui.panels.reports.QueryFieldFactory;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;

class SpeciesStatusQueryField
extends AbstractQueryField {
    private final JComboBox<QueryType> queryOptions = new JComboBox<QueryType>(QueryType.values());
    private final JComboBox<String> statusOptions = new JComboBox<String>(SpeciesStatusQueryField.getStatusText());
    private final TaxonomyStore taxonomyStore;
    private static final Gson GSON = new Gson();

    public SpeciesStatusQueryField(TaxonomyStore taxonomyStore) {
        super(QueryFieldFactory.QueryFieldType.SPECIES_STATUS);
        this.taxonomyStore = taxonomyStore;
        this.queryOptions.addActionListener(e -> this.firePredicateUpdated());
        this.statusOptions.addActionListener(e -> this.firePredicateUpdated());
        this.statusOptions.setMaximumRowCount(this.statusOptions.getItemCount());
    }

    private static String[] getStatusText() {
        return (String[])SpeciesStatusQueryField.getValidStatuses().stream().map(Messages::getText).toArray(String[]::new);
    }

    private static List<Species.Status> getValidStatuses() {
        ArrayList<Species.Status> statusValues = Lists.newArrayList(Species.Status.values());
        statusValues.remove((Object)Species.Status.IN);
        statusValues.remove((Object)Species.Status.DO);
        statusValues.remove((Object)Species.Status.UN);
        return statusValues;
    }

    @Override
    public JComponent getComparisonChooser() {
        return this.queryOptions;
    }

    @Override
    public JComponent getValueField() {
        return this.statusOptions;
    }

    @Override
    public Predicate<Sighting> predicate(final Taxon.Type depth) {
        final Species.Status status = SpeciesStatusQueryField.getValidStatuses().get(this.statusOptions.getSelectedIndex());
        final boolean isOrWorse = QueryType.IS_OR_WORSE.equals(this.queryOptions.getSelectedItem());
        Predicate<Sighting> predicate = new Predicate<Sighting>(){

            @Override
            public boolean apply(Sighting sighting) {
                Species.Status taxonStatus;
                Taxonomy taxonomy = SpeciesStatusQueryField.this.taxonomyStore.getTaxonomy();
                if (!TaxonUtils.areCompatible(taxonomy, sighting.getTaxonomy())) {
                    return false;
                }
                SightingTaxon.Resolved resolved = sighting.getTaxon().resolve(taxonomy);
                if (resolved.getSmallestTaxonType().isLowerLevelThan(depth)) {
                    resolved = resolved.getParentOfAtLeastType(depth).resolveInternal(taxonomy);
                }
                if ((taxonStatus = resolved.getTaxonStatus()) == Species.Status.IN || taxonStatus == Species.Status.DO || taxonStatus == Species.Status.UN) {
                    return false;
                }
                return isOrWorse ? taxonStatus.compareTo(status) >= 0 : taxonStatus == status;
            }
        };
        if (QueryType.IS_NOT.equals(this.queryOptions.getSelectedItem())) {
            predicate = Predicates.not(predicate);
        }
        return predicate;
    }

    @Override
    public boolean isNoOp() {
        return false;
    }

    @Override
    public JsonElement persist() {
        Species.Status status = SpeciesStatusQueryField.getValidStatuses().get(this.statusOptions.getSelectedIndex());
        Persisted persisted = new Persisted((QueryType)((Object)this.queryOptions.getSelectedItem()), status.name());
        return GSON.toJsonTree(persisted);
    }

    @Override
    public void restore(JsonElement json) {
        Persisted persisted = GSON.fromJson(json, Persisted.class);
        this.queryOptions.setSelectedItem((Object)persisted.type);
        try {
            Species.Status status = Species.Status.valueOf(persisted.statusId);
            this.statusOptions.setSelectedItem(Messages.getText(status));
        }
        catch (IllegalArgumentException e) {
            throw new JsonSyntaxException("Invalid species status: " + persisted.statusId);
        }
    }

    private static enum QueryType {
        IS(Messages.Name.STATUS_IS),
        IS_NOT(Messages.Name.STATUS_IS_NOT),
        IS_OR_WORSE(Messages.Name.STATUS_IS_OR_WORSE);

        private final Messages.Name text;

        private QueryType(Messages.Name text) {
            this.text = text;
        }

        public String toString() {
            return Messages.getMessage(this.text);
        }
    }

    static class Persisted {
        QueryType type;
        String statusId;

        public Persisted(QueryType type, String statusId) {
            this.type = type;
            this.statusId = statusId;
        }
    }
}

