/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.ui.events.TaxonomyStore;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.reports.AbstractQueryField;
import com.scythebill.birdlist.ui.panels.reports.QueryFieldFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;

class SpOrHybridStatusQueryField
extends AbstractQueryField {
    private final JComboBox<QueryType> queryOptions = new JComboBox<QueryType>(QueryType.values());
    private final JComboBox<StatusType> typeOptions = new JComboBox<StatusType>(StatusType.values());
    private final TaxonomyStore taxonomyStore;
    private static final Gson GSON = new Gson();

    public SpOrHybridStatusQueryField(TaxonomyStore taxonomyStore) {
        super(QueryFieldFactory.QueryFieldType.SP_OR_HYBRID);
        this.taxonomyStore = taxonomyStore;
        this.queryOptions.addActionListener(e -> this.firePredicateUpdated());
        this.typeOptions.addActionListener(e -> this.firePredicateUpdated());
    }

    @Override
    public JComponent getComparisonChooser() {
        return this.queryOptions;
    }

    @Override
    public JComponent getValueField() {
        return this.typeOptions;
    }

    @Override
    public Predicate<Sighting> predicate(final Taxon.Type depth) {
        StatusType statusType = (StatusType)((Object)this.typeOptions.getSelectedItem());
        final SightingTaxon.Type type = statusType.getType();
        Predicate<Sighting> predicate = new Predicate<Sighting>(){

            @Override
            public boolean apply(Sighting sighting) {
                if (!TaxonUtils.areCompatible(SpOrHybridStatusQueryField.this.taxonomyStore.getTaxonomy(), sighting.getTaxonomy())) {
                    return false;
                }
                SightingTaxon.Resolved resolved = sighting.getTaxon().resolve(SpOrHybridStatusQueryField.this.taxonomyStore.getTaxonomy());
                SightingTaxon parentOfAtLeastType = resolved.getParentOfAtLeastType(depth);
                return type == this.mapAwaySingleWithSubspecies(parentOfAtLeastType.getType());
            }

            private SightingTaxon.Type mapAwaySingleWithSubspecies(SightingTaxon.Type type2) {
                if (type2 == SightingTaxon.Type.SINGLE_WITH_SECONDARY_SUBSPECIES) {
                    return SightingTaxon.Type.SINGLE;
                }
                return type2;
            }
        };
        if (QueryType.IS_NOT.equals(this.queryOptions.getSelectedItem())) {
            predicate = Predicates.not(predicate);
        }
        return predicate;
    }

    @Override
    public boolean isNoOp() {
        return false;
    }

    @Override
    public JsonElement persist() {
        Persisted persisted = new Persisted((QueryType)((Object)this.queryOptions.getSelectedItem()), (StatusType)((Object)this.typeOptions.getSelectedItem()));
        return GSON.toJsonTree(persisted);
    }

    @Override
    public void restore(JsonElement json) {
        Persisted persisted = GSON.fromJson(json, Persisted.class);
        this.queryOptions.setSelectedItem((Object)persisted.type);
        this.typeOptions.setSelectedItem((Object)persisted.statusType);
    }

    private static enum QueryType {
        IS(Messages.Name.SPECIES_IS),
        IS_NOT(Messages.Name.SPECIES_IS_NOT);

        private final Messages.Name text;

        private QueryType(Messages.Name text) {
            this.text = text;
        }

        public String toString() {
            return Messages.getMessage(this.text);
        }
    }

    private static enum StatusType {
        SP(Messages.Name.SPUH_LABEL, SightingTaxon.Type.SP),
        HYBRID(Messages.Name.HYBRID_LABEL, SightingTaxon.Type.HYBRID),
        NEITHER(Messages.Name.NEITHER_TEXT, SightingTaxon.Type.SINGLE);

        private final Messages.Name text;
        private final SightingTaxon.Type type;

        private StatusType(Messages.Name text, SightingTaxon.Type type) {
            this.text = text;
            this.type = type;
        }

        public SightingTaxon.Type getType() {
            return this.type;
        }

        public String toString() {
            return Messages.getMessage(this.text);
        }
    }

    static class Persisted {
        QueryType type;
        StatusType statusType;

        public Persisted(QueryType type, StatusType statusType) {
            this.type = type;
            this.statusType = statusType;
        }
    }
}

