/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.collect.Ordering;
import com.scythebill.birdlist.model.query.SightingComparators;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.ui.messages.Messages;

enum SortType {
    DEFAULT(Messages.Name.SORT_BY_DEFAULT, SightingComparators.preferNotHeardOnly().compound(SightingComparators.preferNotIntroduced()).compound(SightingComparators.preferEarlier())),
    BY_DATE(Messages.Name.SORT_BY_DATE, SightingComparators.preferEarlier()),
    BY_DATE_DESCENDING(Messages.Name.SORT_BY_DATE_DESCENDING, SightingComparators.preferEarlier().reverse()),
    BY_DAY_OF_YEAR(Messages.Name.SORT_BY_DAY_OF_YEAR, SightingComparators.preferEarlierInTheYear()),
    BY_DAY_OF_YEAR_DESCENDING(Messages.Name.SORT_BY_DAY_OF_YEAR_DESCENDING, SightingComparators.preferEarlierInTheYear().reverse()),
    BY_SIGHTING_COUNT(Messages.Name.SORT_BY_NUMBER_RECORDED, SightingComparators.preferHigherCounts());

    private final Messages.Name text;
    private final Ordering<Sighting> ordering;

    private SortType(Messages.Name text, Ordering<Sighting> sightingOrdering) {
        this.text = text;
        this.ordering = sightingOrdering;
    }

    public String toString() {
        return Messages.getMessage(this.text);
    }

    public Ordering<Sighting> ordering() {
        return this.ordering;
    }
}

