/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.scythebill.birdlist.model.query.SightingPredicates;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingInfo;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.reports.AbstractQueryField;
import com.scythebill.birdlist.ui.panels.reports.QueryFieldFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.JComboBox;
import javax.swing.JComponent;

class SightingStatusQueryField
extends AbstractQueryField {
    private final JComboBox<QueryType> queryOptions = new JComboBox<QueryType>(QueryType.values());
    private final JComboBox<String> statusOptions = new JComboBox<String>(SightingStatusQueryField.getStatusText());
    private static final Gson GSON = new Gson();

    public SightingStatusQueryField() {
        super(QueryFieldFactory.QueryFieldType.SIGHTING_STATUS);
        this.queryOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SightingStatusQueryField.this.statusOptions.setEnabled(!QueryType.ANY.equals(SightingStatusQueryField.this.queryOptions.getSelectedItem()));
                SightingStatusQueryField.this.firePredicateUpdated();
            }
        });
        this.statusOptions.addActionListener(e -> this.firePredicateUpdated());
        this.statusOptions.setMaximumRowCount(this.statusOptions.getItemCount());
    }

    private static String[] getStatusText() {
        return (String[])Arrays.stream(SightingInfo.SightingStatus.values()).map(Messages::getText).toArray(String[]::new);
    }

    @Override
    public JComponent getComparisonChooser() {
        return this.queryOptions;
    }

    @Override
    public JComponent getValueField() {
        return this.statusOptions;
    }

    @Override
    public Predicate<Sighting> predicate(Taxon.Type depth) {
        if (QueryType.ANY.equals(this.queryOptions.getSelectedItem())) {
            return Predicates.alwaysTrue();
        }
        SightingInfo.SightingStatus status = SightingInfo.SightingStatus.values()[this.statusOptions.getSelectedIndex()];
        Predicate<Sighting> predicate = SightingPredicates.sightingStatusIsIn(ImmutableSet.of(status));
        if (QueryType.IS_NOT.equals(this.queryOptions.getSelectedItem())) {
            predicate = Predicates.not(predicate);
        }
        return predicate;
    }

    @Override
    public boolean isNoOp() {
        return QueryType.ANY.equals(this.queryOptions.getSelectedItem());
    }

    @Override
    public JsonElement persist() {
        SightingInfo.SightingStatus status = SightingInfo.SightingStatus.values()[this.statusOptions.getSelectedIndex()];
        Persisted persisted = new Persisted((QueryType)((Object)this.queryOptions.getSelectedItem()), status.getId());
        return GSON.toJsonTree(persisted);
    }

    @Override
    public void restore(JsonElement json) {
        Persisted persisted = GSON.fromJson(json, Persisted.class);
        this.queryOptions.setSelectedItem((Object)persisted.type);
        SightingInfo.SightingStatus sightingStatus = SightingInfo.SightingStatus.forId(persisted.statusId);
        if (sightingStatus == null) {
            throw new JsonSyntaxException("Invalid sighting status: " + persisted.statusId);
        }
        this.statusOptions.setSelectedItem(Messages.getText(sightingStatus));
    }

    private static enum QueryType {
        IS(Messages.Name.STATUS_IS),
        IS_NOT(Messages.Name.STATUS_IS_NOT),
        ANY(Messages.Name.STATUS_ANY);

        private final Messages.Name text;

        private QueryType(Messages.Name text) {
            this.text = text;
        }

        public String toString() {
            return Messages.getMessage(this.text);
        }
    }

    static class Persisted {
        QueryType type;
        String statusId;

        public Persisted(QueryType type, String statusId) {
            this.type = type;
            this.statusId = statusId;
        }
    }
}

