/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.io.Resources;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.ui.panels.reports.TotalTicksProcessor;
import com.scythebill.birdlist.ui.util.DesktopUtils;
import com.scythebill.birdlist.ui.util.GoogleGeocharts;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.text.StringEscapeUtils;

public class ShowTotalTicksMap {
    private final LocationSet locations;
    private final GoogleGeocharts googleGeocharts;

    @Inject
    public ShowTotalTicksMap(PredefinedLocations predefinedLocations, ReportSet reportSet) {
        this.locations = reportSet.getLocations();
        this.googleGeocharts = new GoogleGeocharts(this.locations, predefinedLocations);
    }

    public void showRange(Multimap<String, String> locationToSpecies, TotalTicksProcessor.TotalTickType totalTickType, String reportName) throws IOException {
        if (totalTickType == TotalTicksProcessor.TotalTickType.COUNTY) {
            throw new UnsupportedOperationException("Total tick maps not supported for counties");
        }
        File file = File.createTempFile("totalticks", ".html");
        try (FileWriter writer = new FileWriter(file);){
            this.writeRange(locationToSpecies, totalTickType, reportName, writer);
        }
        DesktopUtils.openHtmlFileInBrowser(file);
    }

    private void writeRange(Multimap<String, String> locationToSpecies, TotalTicksProcessor.TotalTickType totalTickType, String reportName, Writer writer) throws IOException {
        String startTemplate = Resources.toString(Resources.getResource(this.getClass(), "ticksmap.start.html.template"), StandardCharsets.UTF_8);
        String endTemplate = Resources.toString(Resources.getResource(this.getClass(), "ticksmap.end.html.template"), StandardCharsets.UTF_8);
        LinkedHashSet<String> codes = new LinkedHashSet<String>();
        writer.write(String.format(startTemplate, reportName, totalTickType.toString()));
        LinkedHashMap<String, Integer> codeToCount = new LinkedHashMap<String, Integer>();
        for (String string : locationToSpecies.keySet()) {
            Location location = this.locations.getLocation(string);
            String locationCode = Locations.getLocationCode(location);
            if (locationCode == null) continue;
            locationCode = GoogleGeocharts.EBIRD_STATE_TO_GOOGLE_STATE.getOrDefault(locationCode, locationCode);
            codes.add(locationCode);
            int count = locationToSpecies.get(string).size();
            codeToCount.put(locationCode, count + codeToCount.getOrDefault(locationCode, 0));
        }
        for (Map.Entry entry : codeToCount.entrySet()) {
            writer.write(this.dataFormat((Integer)entry.getValue(), (String)entry.getKey(), this.googleGeocharts.getNameForGoogle((String)entry.getKey())));
        }
        ArrayList<String> optionsList = new ArrayList<String>();
        if (totalTickType == TotalTicksProcessor.TotalTickType.COUNTRY) {
            ImmutableSet<GoogleGeocharts.Subcontinent> immutableSet = this.googleGeocharts.subcontinents(codes);
            ImmutableSet<GoogleGeocharts.Continent> continents = this.googleGeocharts.continents(immutableSet);
            if (continents.size() > 1) {
                optionsList.add("<option value=\"\">Zoom to world, or...</option>");
            }
            if (immutableSet.size() == 1) {
                optionsList.add(((GoogleGeocharts.Subcontinent)immutableSet.iterator().next()).asOption());
            } else {
                for (GoogleGeocharts.Continent continent : continents) {
                    if (immutableSet.size() > 1) {
                        optionsList.add(continent.asOption());
                    }
                    for (GoogleGeocharts.Subcontinent subcontinent : continent.subcontinents()) {
                        if (!immutableSet.contains(subcontinent)) continue;
                        optionsList.add(subcontinent.asOption());
                    }
                }
            }
        } else if (totalTickType == TotalTicksProcessor.TotalTickType.STATE) {
            Set<String> set = this.normalizeCountries(codes);
            TreeMap<String, String> countryNamesToCodes = new TreeMap<String, String>();
            for (String country : set) {
                String nameForGoogle = this.googleGeocharts.getNameForGoogle(country);
                if (nameForGoogle == null) continue;
                countryNamesToCodes.put(nameForGoogle, country);
            }
            countryNamesToCodes.forEach((name, id) -> optionsList.add(String.format("<option value=\"?%s\">%s</option>", id, name)));
        }
        String string = totalTickType == TotalTicksProcessor.TotalTickType.COUNTRY ? "countries" : "provinces";
        writer.write(String.format(endTemplate, string, Joiner.on('\n').join(optionsList)));
    }

    private String dataFormat(int count, String country, String countryName) {
        return String.format("[{v:\"%s\",f:\"%s\"}, {v:%d, f:\"%s\"}],", country, StringEscapeUtils.escapeJson(countryName), count, count);
    }

    private Set<String> normalizeCountries(Iterable<String> statesAndCountries) {
        HashSet<String> set = Sets.newHashSet();
        for (String value : statesAndCountries) {
            int indexOf;
            if (GoogleGeocharts.EBIRD_TO_GOOGLE_COUNTRIES.containsKey(value)) {
                value = (String)GoogleGeocharts.EBIRD_TO_GOOGLE_COUNTRIES.get(value);
            }
            if ((indexOf = value.indexOf(45)) < 0) {
                set.add(value);
                continue;
            }
            set.add(value.substring(0, indexOf));
        }
        return set;
    }
}

