/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.base.Predicate;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.reports.AbstractQueryField;
import com.scythebill.birdlist.ui.panels.reports.QueryFieldFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

class SexAgeQueryField
extends AbstractQueryField {
    private final JComboBox<QueryType> queryOptions = new JComboBox<QueryType>(QueryType.values());
    private final JPanel emptyValueField = new JPanel();
    private static final Gson GSON = new Gson();

    public SexAgeQueryField() {
        super(QueryFieldFactory.QueryFieldType.SEX_AGE);
        this.queryOptions.addActionListener(e -> this.firePredicateUpdated());
    }

    @Override
    public JComponent getComparisonChooser() {
        return this.queryOptions;
    }

    @Override
    public JComponent getValueField() {
        return this.emptyValueField;
    }

    @Override
    public Predicate<Sighting> predicate(Taxon.Type depth) {
        QueryType type = (QueryType)((Object)this.queryOptions.getSelectedItem());
        switch (type) {
            case IS_FEMALE: {
                return sighting -> sighting.hasSightingInfo() && sighting.getSightingInfo().isFemale();
            }
            case IS_MALE: {
                return sighting -> sighting.hasSightingInfo() && sighting.getSightingInfo().isMale();
            }
            case IS_ADULT: {
                return sighting -> sighting.hasSightingInfo() && sighting.getSightingInfo().isAdult();
            }
            case IS_IMMATURE: {
                return sighting -> sighting.hasSightingInfo() && sighting.getSightingInfo().isImmature();
            }
        }
        throw new AssertionError((Object)("Unexpected type: " + type));
    }

    @Override
    public boolean isNoOp() {
        return false;
    }

    @Override
    public JsonElement persist() {
        Persisted persisted = new Persisted((QueryType)((Object)this.queryOptions.getSelectedItem()));
        return GSON.toJsonTree(persisted);
    }

    @Override
    public void restore(JsonElement json) {
        Persisted persisted = GSON.fromJson(json, Persisted.class);
        this.queryOptions.setSelectedItem((Object)persisted.type);
    }

    private static enum QueryType {
        IS_FEMALE(Messages.Name.SEX_IS_FEMALE),
        IS_MALE(Messages.Name.SEX_IS_MALE),
        IS_ADULT(Messages.Name.AGE_IS_ADULT),
        IS_IMMATURE(Messages.Name.AGE_IS_IMMATURE);

        private final Messages.Name text;

        private QueryType(Messages.Name text) {
            this.text = text;
        }

        public String toString() {
            return Messages.getMessage(this.text);
        }
    }

    static class Persisted {
        QueryType type;

        public Persisted(QueryType type) {
            this.type = type;
        }
    }
}

