/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.base.Optional;
import com.google.common.io.ByteSink;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.scythebill.birdlist.model.export.FullReportExport;
import com.scythebill.birdlist.model.io.PartialIO;
import com.scythebill.birdlist.model.query.QueryResults;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.ui.events.TaxonomyStore;
import com.scythebill.birdlist.ui.imports.ImportPreferences;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.FilePreferences;
import com.scythebill.birdlist.ui.panels.reports.QueryExecutor;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.FileDialogs;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.joda.time.LocalDate;
import org.joda.time.chrono.GJChronology;

public class ScythebillCsvExportAction
extends AbstractAction {
    private final FileDialogs fileDialogs;
    private final ReportSet reportSet;
    private final TaxonomyStore taxonomyStore;
    private final Alerts alerts;
    private final String reportSetFileName;
    private final QueryExecutor queryExecutor;
    private final ImportPreferences importPreferences;

    public ScythebillCsvExportAction(FileDialogs fileDialogs, ReportSet reportSet, String reportSetFileName, TaxonomyStore taxonomyStore, QueryExecutor queryExecutor, ImportPreferences importPreferences, Alerts alerts) {
        this.fileDialogs = fileDialogs;
        this.reportSet = reportSet;
        this.reportSetFileName = reportSetFileName;
        this.taxonomyStore = taxonomyStore;
        this.queryExecutor = queryExecutor;
        this.importPreferences = importPreferences;
        this.alerts = alerts;
    }

    private static Frame getParentFrame(Object object) {
        for (Component c = (Component)object; c != null; c = c.getParent()) {
            if (!(c instanceof Frame)) continue;
            return (Frame)c;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String exportFileName;
        Optional<String> reportName = this.queryExecutor.getReportAbbreviation();
        if (reportName.isPresent()) {
            exportFileName = String.format("export-%s-%s.csv", this.reportSetFileName, reportName.get());
        } else {
            String today = PartialIO.toString(new LocalDate(GJChronology.getInstance()));
            exportFileName = String.format("export-%s-%s.csv", this.reportSetFileName, today);
        }
        File file = this.fileDialogs.saveFile(ScythebillCsvExportAction.getParentFrame(event.getSource()), Messages.getMessage(Messages.Name.SAVE_AS_SCYTHEBILL_CSV), exportFileName, new FileNameExtensionFilter(Messages.getMessage(Messages.Name.CSV_FILES), "csv"), FilePreferences.FileType.OTHER);
        if (file != null) {
            QueryResults queryResults = this.queryExecutor.executeQuery(null, null);
            ByteSink outSupplier = Files.asByteSink(file, new FileWriteMode[0]);
            try {
                FullReportExport export = new FullReportExport();
                if (this.importPreferences.excelCompatibleCsv) {
                    export.useExcelCompatibleCsv();
                }
                export.exportReportSet(outSupplier, this.reportSet, this.taxonomyStore.getTaxonomy(), queryResults);
            }
            catch (IOException e) {
                FileDialogs.showFileSaveError(this.alerts, e, file);
            }
        }
    }
}

