/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.base.Optional;
import com.scythebill.birdlist.model.query.QueryResults;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.ui.io.ReportXlsOutput;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.FilePreferences;
import com.scythebill.birdlist.ui.panels.reports.QueryExecutor;
import com.scythebill.birdlist.ui.panels.reports.ReportHints;
import com.scythebill.birdlist.ui.panels.reports.ReportSpreadsheetPreferences;
import com.scythebill.birdlist.ui.panels.reports.ReportXlsDialog;
import com.scythebill.birdlist.ui.panels.reports.SortType;
import com.scythebill.birdlist.ui.panels.reports.UserOutput;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.FileDialogs;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.filechooser.FileNameExtensionFilter;

class SaveAsXlsAction
extends AbstractAction {
    private final QueryExecutor queryExecutor;
    private final FileDialogs fileDialogs;
    private final ReportSet reportSet;
    private final Alerts alerts;
    private final ReportXlsDialog reportXlsDialog;

    public SaveAsXlsAction(FileDialogs fileDialogs, ReportSet reportSet, QueryExecutor queryExecutor, Alerts alerts, ReportXlsDialog reportXlsDialog) {
        this.fileDialogs = fileDialogs;
        this.reportSet = reportSet;
        this.queryExecutor = queryExecutor;
        this.alerts = alerts;
        this.reportXlsDialog = reportXlsDialog;
    }

    private static Frame getParentFrame(Component c) {
        while (c != null) {
            if (c instanceof Frame) {
                return (Frame)c;
            }
            c = c.getParent();
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Optional<String> reportName = this.queryExecutor.getReportAbbreviation();
        String fileName = reportName.isPresent() ? String.format("report-%s.xls", reportName.get()) : "report.xls";
        File out = this.fileDialogs.saveFile(SaveAsXlsAction.getParentFrame((Component)event.getSource()), Messages.getMessage(Messages.Name.PICK_FILE_TITLE), fileName, new FileNameExtensionFilter(Messages.getMessage(Messages.Name.XLS_FILES), "xls"), FilePreferences.FileType.OTHER);
        if (out == null) {
            return;
        }
        ReportSpreadsheetPreferences prefs = this.reportXlsDialog.getConfiguration((Component)event.getSource(), !this.reportSet.extendedTaxonomies().isEmpty());
        if (prefs == null) {
            return;
        }
        QueryExecutor executor = this.queryExecutor;
        if (prefs.onlyCountable) {
            executor = executor.onlyCountable();
        }
        if (prefs.showAllTaxonomies) {
            executor = executor.includeIncompatibleSightings();
        }
        QueryResults queryResults = executor.executeQuery(null, null);
        ReportXlsOutput reportXlsOutput = new ReportXlsOutput(out, queryResults, this.reportSet.getLocations());
        reportXlsOutput.setScientificOrCommon(this.reportXlsDialog.getScientificOrCommonFromConfiguration(prefs));
        Set<ReportHints> reportHints = this.queryExecutor.getReportHints();
        reportXlsOutput.setShowFamilies(prefs.showFamilies);
        reportXlsOutput.setShowFamilyTotals(!reportHints.contains((Object)ReportHints.SPECIES_STATUS_RESTRICTION));
        reportXlsOutput.setRootLocation(this.queryExecutor.getRootLocation());
        reportXlsOutput.setSightingsCount(prefs.maximumSightings);
        reportXlsOutput.setShowStatus(prefs.showStatus);
        reportXlsOutput.setShowNotes(prefs.showNotes);
        reportXlsOutput.setShowAllTaxonomies(prefs.showAllTaxonomies);
        reportXlsOutput.setOmitSpAndHybrid(prefs.omitSpAndHybrid);
        reportXlsOutput.setUserOutput(this.reportSet.getUserSet() == null ? UserOutput.NONE : prefs.userOutput);
        if (prefs.sortType != SortType.DEFAULT) {
            reportXlsOutput.setSortAllSightings(true);
        }
        try {
            reportXlsOutput.writeSpeciesList(prefs.sortType.ordering(), prefs.sortSightingsType.ordering());
        }
        catch (IOException e) {
            FileDialogs.showFileSaveError(this.alerts, e, out);
            return;
        }
        try {
            Desktop.getDesktop().open(out);
        }
        catch (IOException e) {
            this.alerts.showError((Object)((Component)event.getSource()), Messages.Name.OPENING_FAILED, Messages.Name.NO_APPLICATION_FOR_XLS_FILES, new Object[0]);
        }
    }
}

