/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.inject.Provider;
import com.scythebill.birdlist.model.query.QueryResults;
import com.scythebill.birdlist.model.query.SightingPredicates;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.Trip;
import com.scythebill.birdlist.ui.components.HtmlResultPanel;
import com.scythebill.birdlist.ui.components.OkCancelPanel;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.io.TripReportDocOutput;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.reports.QueryExecutor;
import com.scythebill.birdlist.ui.panels.reports.ReportHints;
import com.scythebill.birdlist.ui.panels.reports.TripReportDialog;
import com.scythebill.birdlist.ui.panels.reports.TripReportPreferences;
import com.scythebill.birdlist.ui.util.Alerts;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import javax.annotation.Nullable;
import javax.swing.AbstractAction;

class SaveAsTripReportAction
extends AbstractAction {
    private static final int MAX_VISIT_SIZE_FOR_SPECIES_TABLE = 200;
    private final QueryExecutor queryExecutor;
    private final ReportSet reportSet;
    private final Alerts alerts;
    private final Provider<TripReportDialog> tripReportDialog;
    private FontManager fontManager;
    private final ImmutableList<Trip> trips;

    public SaveAsTripReportAction(ReportSet reportSet, QueryExecutor queryExecutor, Alerts alerts, Provider<TripReportDialog> tripReportDialog, @Nullable Iterable<Trip> trips, FontManager fontManager) {
        this.reportSet = reportSet;
        this.queryExecutor = queryExecutor;
        this.alerts = alerts;
        this.tripReportDialog = tripReportDialog;
        this.trips = trips == null ? null : ImmutableList.copyOf(trips);
        this.fontManager = fontManager;
    }

    private static Frame getParentFrame(Component c) {
        while (c != null) {
            if (c instanceof Frame) {
                return (Frame)c;
            }
            c = c.getParent();
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Frame source;
        TripReportPreferences prefs;
        QueryResults queryResults = this.queryExecutor.includeIncompatibleSightings().executeQuery(null, null);
        TripReportDialog dialog = this.tripReportDialog.get();
        if (queryResults.getAllVisitInfoKeys().size() > 200 || queryResults.getAllVisitInfoKeys().isEmpty()) {
            dialog.disableSpeciesTable();
        }
        if (queryResults.getIncompatibleTaxonomies().isEmpty()) {
            dialog.disableMultipleTaxonomies();
        }
        if ((prefs = dialog.getConfiguration(source = SaveAsTripReportAction.getParentFrame((Component)event.getSource()))) == null) {
            return;
        }
        TripReportDocOutput tripReportOutput = new TripReportDocOutput(queryResults, this.reportSet, this.queryExecutor.getRootLocation());
        this.queryExecutor.getReportName().toJavaUtil().ifPresent(tripReportOutput::setName);
        tripReportOutput.setScientificOrCommon(dialog.getScientificOrCommonFromConfiguration(prefs));
        tripReportOutput.setWriteItinerary(prefs.includeItinerary);
        tripReportOutput.setWriteSpeciesList(prefs.includeSpeciesList);
        tripReportOutput.setWriteSpeciesTable(prefs.includeSpeciesTable);
        tripReportOutput.setShowStatus(prefs.showStatus);
        tripReportOutput.setShowAllTaxonomies(prefs.showAllTaxonomies);
        tripReportOutput.setIncludeFavoritePhotos(prefs.includeFavoritePhotos);
        tripReportOutput.setQueryHasDateRestriction(this.queryExecutor.getReportHints().contains((Object)ReportHints.DATE_RESTRICTION));
        tripReportOutput.setTrips(this.trips == null ? this.matchingTrips(queryResults) : this.trips);
        try (StringWriter out = new StringWriter();){
            String plainText = tripReportOutput.writeReport(out);
            HtmlResultPanel htmlResultPanel = new HtmlResultPanel(Messages.Name.TRIP_REPORT_EXPLANATION, out.toString(), this.fontManager);
            htmlResultPanel.setPlainText(plainText);
            htmlResultPanel.copyToClipboard();
            Optional<String> reportName = this.queryExecutor.getReportName();
            if (reportName.isPresent()) {
                htmlResultPanel.setDocumentName(reportName.get());
            }
            OkCancelPanel okCancelPanel = new OkCancelPanel(OkCancelPanel.CLOSE_WINDOW_ACTION, htmlResultPanel.printAction(), htmlResultPanel, null);
            okCancelPanel.showInDialog(source, this.fontManager);
        }
        catch (IOException e) {
            this.alerts.showError((Object)source, (Throwable)e, Messages.Name.SAVING_FAILED_TITLE, Messages.Name.COULD_NOT_SAVE_REPORT, new Object[0]);
            return;
        }
    }

    private Collection<Trip> matchingTrips(QueryResults queryResults) {
        LinkedHashSet<Trip> matchingTrips = new LinkedHashSet<Trip>();
        int tripCount = this.reportSet.getTrips().allTrips().size();
        ArrayList<Trip> trips = new ArrayList<Trip>(tripCount);
        ArrayList<Predicate<Sighting>> predicates = new ArrayList<Predicate<Sighting>>(tripCount);
        for (Trip trip : this.reportSet.getTrips().allTrips()) {
            trips.add(trip);
            predicates.add(this.tripPredicate(trip));
        }
        for (Sighting sighting : queryResults.getAllSightings()) {
            int i;
            if (sighting.getTrip() != null) {
                if (matchingTrips.contains(sighting.getTrip())) continue;
                matchingTrips.add(sighting.getTrip());
                for (i = 0; i < tripCount; ++i) {
                    if (trips.get(i) != sighting.getTrip()) continue;
                    trips.set(i, null);
                    predicates.set(i, null);
                }
                continue;
            }
            for (i = 0; i < tripCount; ++i) {
                Predicate predicate = (Predicate)predicates.get(i);
                if (predicate == null || !predicate.apply(sighting)) continue;
                matchingTrips.add((Trip)trips.get(i));
                trips.set(i, null);
                predicates.set(i, null);
            }
        }
        return matchingTrips;
    }

    private Predicate<Sighting> tripPredicate(Trip trip) {
        Predicate<Sighting> predicate = Predicates.and(SightingPredicates.afterOrEquals(trip.startDate()), SightingPredicates.beforeOrEquals(trip.endDate()));
        if (trip.locationId() != null) {
            Location location = this.reportSet.getLocations().getLocation(trip.locationId());
            predicate = Predicates.and(predicate, SightingPredicates.in(location, this.reportSet.getLocations()));
        }
        return predicate;
    }
}

