/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.base.Optional;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.query.QueryResults;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.components.HtmlResultPanel;
import com.scythebill.birdlist.ui.components.OkCancelPanel;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.io.FamilyReportOutput;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.reports.FamilyReportDialog;
import com.scythebill.birdlist.ui.panels.reports.FamilyReportPreferences;
import com.scythebill.birdlist.ui.panels.reports.QueryExecutor;
import com.scythebill.birdlist.ui.panels.reports.QueryPreferences;
import com.scythebill.birdlist.ui.util.Alerts;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.StringWriter;
import javax.swing.AbstractAction;

class SaveAsFamilyReportAction
extends AbstractAction {
    private final QueryExecutor queryExecutor;
    private final Alerts alerts;
    private final FontManager fontManager;
    private final QueryPreferences queryPreferences;
    private final Taxonomy taxonomy;
    private final ReportSet reportSet;
    private final FamilyReportDialog familyReportDialog;
    private final Checklists checklists;

    public SaveAsFamilyReportAction(QueryExecutor queryExecutor, Alerts alerts, FamilyReportDialog familyReportDialog, FontManager fontManager, ReportSet reportSet, Taxonomy taxonomy, QueryPreferences queryPreferences, Checklists checklists) {
        this.queryExecutor = queryExecutor;
        this.alerts = alerts;
        this.familyReportDialog = familyReportDialog;
        this.fontManager = fontManager;
        this.reportSet = reportSet;
        this.taxonomy = taxonomy;
        this.queryPreferences = queryPreferences;
        this.checklists = checklists;
    }

    private static Frame getParentFrame(Component c) {
        while (c != null) {
            if (c instanceof Frame) {
                return (Frame)c;
            }
            c = c.getParent();
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Location rootLocation;
        QueryResults queryResults = this.queryExecutor.executeQuery(null, null);
        Frame source = SaveAsFamilyReportAction.getParentFrame((Component)event.getSource());
        FamilyReportPreferences prefs = this.familyReportDialog.getConfiguration(source);
        if (prefs == null) {
            return;
        }
        FamilyReportOutput familyReportOutput = new FamilyReportOutput(queryResults, this.taxonomy, this.queryPreferences);
        familyReportOutput.setScientificOrCommon(this.familyReportDialog.getScientificOrCommonFromConfiguration(prefs));
        Checklist checklist = queryResults.getChecklist(this.taxonomy);
        if (checklist == null && (rootLocation = this.queryExecutor.getRootLocation()) != null) {
            checklist = this.checklists.getNearestBuiltInChecklist(this.taxonomy, this.reportSet, rootLocation);
        }
        familyReportOutput.setChecklist(checklist);
        familyReportOutput.setSortBy(prefs.sortBy);
        try (StringWriter out = new StringWriter();){
            familyReportOutput.writeReport(out);
            String plainText = familyReportOutput.writeToTabDelimitedText();
            HtmlResultPanel htmlResultPanel = new HtmlResultPanel(Messages.Name.FAMILY_REPORT_EXPLANATION, out.toString(), this.fontManager);
            htmlResultPanel.setPlainText(plainText);
            htmlResultPanel.copyToClipboard();
            Optional<String> reportName = this.queryExecutor.getReportName();
            if (reportName.isPresent()) {
                htmlResultPanel.setDocumentName(reportName.get());
            }
            OkCancelPanel okCancelPanel = new OkCancelPanel(OkCancelPanel.CLOSE_WINDOW_ACTION, htmlResultPanel.printAction(), htmlResultPanel, null);
            okCancelPanel.showInDialog(source, this.fontManager);
        }
        catch (IOException e) {
            this.alerts.showError((Object)source, (Throwable)e, Messages.Name.SAVING_FAILED_TITLE, Messages.Name.COULD_NOT_SAVE_REPORT, new Object[0]);
            return;
        }
    }
}

