/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.query.PredicateQueryDefinition;
import com.scythebill.birdlist.model.query.QueryDefinition;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.MappedTaxonomy;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.ui.actions.ActionBroker;
import com.scythebill.birdlist.ui.components.SightingBulkEditDialog;
import com.scythebill.birdlist.ui.components.SpeciesIndexerPanelConfigurer;
import com.scythebill.birdlist.ui.events.EventBusRegistrar;
import com.scythebill.birdlist.ui.events.TaxonomyStore;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.imports.FinishedImport;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.reports.QueryPanelFactory;
import com.scythebill.birdlist.ui.panels.reports.QueryPreferences;
import com.scythebill.birdlist.ui.panels.reports.ReportsActionFactory;
import com.scythebill.birdlist.ui.panels.reports.ReportsBrowserPanel;
import com.scythebill.birdlist.ui.panels.reports.ReportsPanel;
import com.scythebill.birdlist.ui.panels.reports.StoredQueries;
import com.scythebill.birdlist.ui.panels.reports.StoredQueriesPreferences;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.VisibilityDetector;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ResolveTaxaPanel
extends ReportsPanel {
    private ImmutableSet<SightingTaxon> spsToResolve;

    @Inject
    public ResolveTaxaPanel(@FinishedImport Action finishedResolution, TaxonomyStore taxonomyStore, ReportSet reportSet, QueryPanelFactory queryPanelFactory, ReportsBrowserPanel reportsBrowserPanel, FontManager fontManager, ReportsActionFactory reportsActionFactory, ActionBroker actionBroker, EventBusRegistrar eventBusRegistrar, SightingBulkEditDialog sightingBulkEditDialog, SpeciesIndexerPanelConfigurer speciesIndexerPanelConfigurer, Checklists checklists, Alerts alerts, QueryPreferences queryPreferences, VisibilityDetector visibilityDetector) {
        super(ResolveTaxaPanel.undoResolveTaxonomy(finishedResolution, taxonomyStore), ResolveTaxaPanel.forceResolveTaxonomy(taxonomyStore, reportSet), reportSet, queryPanelFactory, reportsBrowserPanel, fontManager, reportsActionFactory, actionBroker, eventBusRegistrar, sightingBulkEditDialog, speciesIndexerPanelConfigurer, checklists, new StoredQueries(queryPanelFactory.newQueryFieldFactory(), alerts, new StoredQueriesPreferences(), null), queryPreferences, visibilityDetector);
        if (!taxonomyStore.isBirdTaxonomy()) {
            throw new IllegalStateException("ResolveTaxaPanel requires a bird taxonomy!");
        }
        this.spsToResolve = Preconditions.checkNotNull(reportSet.getSpsToResolve());
        Taxon.Type depth = Taxon.Type.species;
        for (SightingTaxon taxon : this.spsToResolve) {
            SightingTaxon.Resolved resolved = taxon.resolve(taxonomyStore.getTaxonomy());
            if (resolved == null) {
                throw new IllegalStateException("Could not resolve " + taxon + " into " + taxonomyStore.getTaxonomy().getName());
            }
            Taxon.Type taxonType = resolved.getSmallestTaxonType();
            if (taxonType.compareTo(depth) >= 0) continue;
            depth = taxonType;
        }
        this.simplifyForResolution(depth);
    }

    private static Action undoResolveTaxonomy(final Action finishedResolution, final TaxonomyStore taxonomyStore) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                taxonomyStore.restoreRememberedTaxonomy();
                finishedResolution.actionPerformed(e);
            }
        };
    }

    private static TaxonomyStore forceResolveTaxonomy(TaxonomyStore taxonomyStore, ReportSet reportSet) {
        taxonomyStore.rememberCurrentTaxonomy();
        if (reportSet.getResolveTaxonomy() != null) {
            taxonomyStore.setTaxonomy(reportSet.getResolveTaxonomy());
            return taxonomyStore;
        }
        return taxonomyStore.switchToPreferredBirdTaxonomy();
    }

    @Override
    protected JComponent getHelpLabel() {
        JPanel panel = new JPanel();
        BoxLayout layout = new BoxLayout(panel, 1);
        panel.setLayout(layout);
        panel.add(new JLabel(Messages.getMessage(Messages.Name.RESOLVE_SELECT_EACH_SPECIES)));
        JLabel dontNeedToFinish = new JLabel(Messages.getMessage(Messages.Name.RESOLVE_DONT_NEED_TO_FINISH));
        dontNeedToFinish.putClientProperty("birdlist.plainLabel", true);
        panel.add(dontNeedToFinish);
        return panel;
    }

    @Override
    public String getTitle() {
        return "Resolve splits";
    }

    @Override
    protected QueryDefinition getQueryDefinition(Taxon.Type depth) {
        Predicate<Sighting> predicate = this.getCurrentTaxonomy() instanceof MappedTaxonomy ? new Predicate<Sighting>(){

            @Override
            public boolean apply(Sighting sighting) {
                if (!ResolveTaxaPanel.this.spsToResolve.contains(sighting.getTaxon())) {
                    return false;
                }
                SightingTaxon sightingTaxon = sighting.getTaxon().resolve(ResolveTaxaPanel.this.getCurrentTaxonomy()).getSightingTaxon();
                return sightingTaxon.getType() == SightingTaxon.Type.SP;
            }
        } : new Predicate<Sighting>(){

            @Override
            public boolean apply(Sighting sighting) {
                return ResolveTaxaPanel.this.spsToResolve.contains(sighting.getTaxon());
            }
        };
        return new PredicateQueryDefinition(predicate);
    }
}

