/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.google.common.primitives.Ints;
import com.scythebill.birdlist.model.query.QueryResults;
import com.scythebill.birdlist.model.query.SightingComparators;
import com.scythebill.birdlist.model.query.SightingPredicates;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.Trip;
import com.scythebill.birdlist.model.sighting.VisitInfoKey;
import com.scythebill.birdlist.model.sighting.VisitInfoKeyOrdering;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.ui.util.BaseTreeModel;
import com.scythebill.birdlist.ui.util.ResolvedWithKey;
import com.scythebill.birdlist.ui.util.ResolvedWithSighting;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.TreePath;

public class ReportsTreeModel
extends BaseTreeModel {
    private static final Object ROOT = new Object();
    private final QueryResults queryResults;
    private final LoadingCache<SightingTaxon.Resolved, List<? extends Object>> sortedSightingsCache;
    private final LoadingCache<VisitInfoKey, List<? extends Object>> visitInfoKeyChildCache;
    private final LoadingCache<VisitInfoKey, List<Sighting>> visitInfoKeySightingCache;
    private final LoadingCache<Trip, List<? extends Object>> tripChildrenCache;
    private final LoadingCache<Trip, List<Sighting>> tripSightingCache;
    private final LocationSet locationSet;
    private ImmutableList<VisitInfoKeyNode> visitInfoKeyNodes;
    private ImmutableList<TripNode> tripNodes;
    private final boolean shortcutSingleSightingColumns;
    private static final int MAX_INLINE_VISIT_INFO_KEYS = 5;
    private static final int MAX_INLINE_TRIPS = 5;
    private static final Comparator<Trip> TRIP_COMPARATOR = Comparator.comparing(Trip::startDate, SightingComparators::comparePartials).reversed();
    private static final Comparator<TripNode> TRIP_NODE_COMPARATOR = Comparator.comparing(TripNode::getTrip, TRIP_COMPARATOR);

    public ReportsTreeModel(QueryResults queryResults, LocationSet locationSet, boolean showVisits) {
        this(queryResults, locationSet, showVisits, null, false);
    }

    public ReportsTreeModel(QueryResults queryResults, LocationSet locationSet, boolean showVisits, Collection<Trip> trips, boolean shortcutSingleSightingColumns) {
        this.queryResults = queryResults;
        this.locationSet = locationSet;
        this.visitInfoKeyNodes = showVisits ? queryResults.getAllVisitInfoKeys().stream().sorted(new VisitInfoKeyOrdering().reverse()).map(VisitInfoKeyNode::new).collect(ImmutableList.toImmutableList()) : null;
        this.sortedSightingsCache = CacheBuilder.newBuilder().softValues().build(new CacheLoader<SightingTaxon.Resolved, List<? extends Object>>(){

            @Override
            public List<? extends Object> load(SightingTaxon.Resolved taxon) throws Exception {
                return ReportsTreeModel.this.getTaxonChildren(taxon);
            }
        });
        this.visitInfoKeyChildCache = CacheBuilder.newBuilder().softValues().build(new CacheLoader<VisitInfoKey, List<? extends Object>>(){

            @Override
            public List<? extends Object> load(VisitInfoKey visitInfoKey) throws Exception {
                return ReportsTreeModel.this.getVisitInfoKeyChildren(visitInfoKey);
            }
        });
        this.visitInfoKeySightingCache = CacheBuilder.newBuilder().softValues().build(new CacheLoader<VisitInfoKey, List<Sighting>>(){

            @Override
            public List<Sighting> load(VisitInfoKey visitInfoKey) throws Exception {
                return ReportsTreeModel.this.getVisitInfoKeySightings(visitInfoKey);
            }
        });
        this.tripChildrenCache = CacheBuilder.newBuilder().softValues().build(new CacheLoader<Trip, List<? extends Object>>(){

            @Override
            public List<? extends Object> load(Trip trip) throws Exception {
                return ReportsTreeModel.this.getTripChildren(trip);
            }
        });
        this.tripSightingCache = CacheBuilder.newBuilder().softValues().build(new CacheLoader<Trip, List<Sighting>>(){

            @Override
            public List<Sighting> load(Trip trip) throws Exception {
                return ReportsTreeModel.this.getTripSightings(trip);
            }
        });
        this.tripNodes = trips == null ? null : trips.stream().sorted(TRIP_COMPARATOR).map(TripNode::new).collect(ImmutableList.toImmutableList());
        this.shortcutSingleSightingColumns = shortcutSingleSightingColumns;
    }

    @Override
    public Object getChild(Object node, int index) {
        return this.getChildNodes(node).get(index);
    }

    @Override
    public int getChildCount(Object node) {
        return this.getChildNodes(node).size();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return this.getChildNodes(parent).indexOf(child);
    }

    @Override
    public Object getRoot() {
        return ROOT;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node instanceof Sighting || node instanceof ResolvedWithSighting || node instanceof VisitInfoKey || node instanceof Trip) {
            return true;
        }
        if (node instanceof VisitInfoKeyNode || node instanceof TripNode) {
            return false;
        }
        if (node == ROOT) {
            return false;
        }
        if (node instanceof VisitsNode) {
            return this.visitInfoKeyNodes.size() <= 5;
        }
        if (node instanceof TripsNode) {
            return this.tripNodes.size() <= 5;
        }
        if (node instanceof ResolvedWithKey) {
            return this.getChildCount(node) <= 1;
        }
        SightingTaxon.Resolved taxon = (SightingTaxon.Resolved)node;
        if (taxon.getLargestTaxonType().compareTo(Taxon.Type.species) > 0) {
            return true;
        }
        return this.getChildCount(node) == 0;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        if (newValue instanceof Trip) {
            while (path != null) {
                Object object = path.getLastPathComponent();
                if (object instanceof TripNode) {
                    TripNode tripNode = (TripNode)object;
                    int index = this.getIndexOfChild(path.getParentPath().getLastPathComponent(), tripNode);
                    if (index >= 0) {
                        this.fireTreeNodesChanged(new TreeModelEvent((Object)this, path.getParentPath(), new int[]{index}, new Object[]{tripNode}));
                    }
                    return;
                }
                path = path.getParentPath();
            }
        }
    }

    public void invalidateState() {
        this.sortedSightingsCache.invalidateAll();
        this.visitInfoKeyChildCache.invalidateAll();
        this.tripChildrenCache.invalidateAll();
        this.visitInfoKeySightingCache.invalidateAll();
        this.tripSightingCache.invalidateAll();
    }

    public void removeVisitInfo(VisitInfoKey visitInfoKey) {
        if (this.visitInfoKeyNodes == null) {
            return;
        }
        int index = this.visitInfoKeyNodes.indexOf(new VisitInfoKeyNode(visitInfoKey));
        if (index < 0) {
            return;
        }
        int tripNodeCount = this.rootTripNodeCount();
        this.visitInfoKeyNodes = this.visitInfoKeyNodes.stream().filter(node -> !node.getVisitInfoKey().equals(visitInfoKey)).collect(ImmutableList.toImmutableList());
        int newSize = this.visitInfoKeyNodes.size();
        if (newSize == 0) {
            this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, new TreePath(ROOT), new int[]{tripNodeCount, tripNodeCount + 1}, new Object[]{new VisitsNode(1), new VisitInfoKeyNode(visitInfoKey)}));
        } else if (newSize < 5) {
            this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, new TreePath(ROOT), new int[]{tripNodeCount + index + 1}, new Object[]{new VisitInfoKeyNode(visitInfoKey)}));
        } else if (newSize == 5) {
            this.fireTreeStructureChanged(new TreeModelEvent((Object)this, new TreePath(ROOT)));
        } else {
            this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, new TreePath(new Object[]{ROOT, new VisitsNode(newSize + 1)}), new int[]{index}, new Object[]{new VisitInfoKeyNode(visitInfoKey)}));
            this.fireTreeNodesChanged(new TreeModelEvent((Object)this, new TreePath(ROOT), new int[]{tripNodeCount}, new Object[]{new VisitsNode(newSize)}));
        }
    }

    private int rootTripNodeCount() {
        if (this.tripNodes == null || this.tripNodes.isEmpty()) {
            return 0;
        }
        if (this.tripNodes.size() <= 5) {
            return this.tripNodes.size();
        }
        return 1;
    }

    public void addVisitInfo(VisitInfoKey visitInfoKey) {
        if (this.visitInfoKeyNodes == null) {
            return;
        }
        VisitInfoKeyNode newNode = new VisitInfoKeyNode(visitInfoKey);
        if (this.visitInfoKeyNodes.contains(newNode)) {
            return;
        }
        this.visitInfoKeyNodes = Stream.concat(this.visitInfoKeyNodes.stream().map(VisitInfoKeyNode::getVisitInfoKey), Stream.of(visitInfoKey)).sorted(new VisitInfoKeyOrdering().reverse()).map(VisitInfoKeyNode::new).collect(ImmutableList.toImmutableList());
        int tripNodeCount = this.rootTripNodeCount();
        int insertedIndex = this.visitInfoKeyNodes.indexOf(newNode);
        int newSize = this.visitInfoKeyNodes.size();
        if (newSize == 1) {
            this.fireTreeNodesInserted(new TreeModelEvent((Object)this, new TreePath(ROOT), new int[]{tripNodeCount, tripNodeCount + 1}, new Object[]{new VisitsNode(1), newNode}));
        } else if (newSize <= 5) {
            this.fireTreeNodesInserted(new TreeModelEvent((Object)this, new TreePath(ROOT), new int[]{tripNodeCount + insertedIndex + 1}, new Object[]{newNode}));
        } else if (newSize == 6) {
            this.fireTreeStructureChanged(new TreeModelEvent((Object)this, new TreePath(ROOT)));
        } else {
            this.fireTreeNodesInserted(new TreeModelEvent((Object)this, new TreePath(new Object[]{ROOT, new VisitsNode(newSize)}), new int[]{insertedIndex}, new Object[]{newNode}));
            this.fireTreeNodesChanged(new TreeModelEvent((Object)this, new TreePath(ROOT), new int[]{tripNodeCount}, new Object[]{new VisitsNode(newSize)}));
        }
    }

    public void addTrip(Trip trip) {
        TripNode newTripNode = new TripNode(trip);
        if (this.tripNodes == null || this.tripNodes.isEmpty()) {
            this.tripNodes = ImmutableList.of(newTripNode);
            this.fireTreeNodesInserted(new TreeModelEvent((Object)this, new TreePath(ROOT), new int[]{0, 1}, new Object[]{new TripsNode(1), newTripNode}));
        } else {
            this.tripNodes = ImmutableList.sortedCopyOf(TRIP_NODE_COMPARATOR, Iterables.concat(this.tripNodes, ImmutableList.of(newTripNode)));
            int insertedIndex = this.tripNodes.indexOf(newTripNode);
            if (this.tripNodes.size() <= 5) {
                this.fireTreeNodesInserted(new TreeModelEvent((Object)this, new TreePath(ROOT), new int[]{insertedIndex + 1}, new Object[]{newTripNode}));
            } else if (this.tripNodes.size() == 6) {
                this.fireTreeStructureChanged(new TreeModelEvent((Object)this, new TreePath(ROOT)));
            } else {
                this.fireTreeNodesInserted(new TreeModelEvent((Object)this, new TreePath(new Object[]{ROOT, new TripsNode(this.tripNodes.size())}), new int[]{insertedIndex}, new Object[]{trip}));
                this.fireTreeNodesChanged(new TreeModelEvent((Object)this, new TreePath(ROOT), new int[]{0}, new Object[]{new TripsNode(this.tripNodes.size())}));
            }
        }
    }

    public void sightingsRemoved(TreePath parentPath, List<Sighting> sightings, List<Integer> originalIndices) {
        int[] indices = new int[originalIndices.size()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = originalIndices.get(i);
        }
        Arrays.sort(indices);
        Object[] values = sightings.toArray();
        this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, parentPath, indices, values));
    }

    public void sightingAdded(TreePath parentPath, Sighting sighting, boolean updateTaxaInQueryResults) {
        this.sightingsAdded(parentPath, ImmutableList.of(sighting), updateTaxaInQueryResults);
    }

    public void sightingsAdded(TreePath parentPath, Collection<Sighting> sightings, boolean updateTaxaInQueryResults) {
        this.queryResults.updateSightings(ImmutableList.of(), sightings, updateTaxaInQueryResults);
        this.invalidateState();
        int childCount = this.getChildCount(parentPath.getLastPathComponent());
        if (childCount == sightings.size() || parentPath.getLastPathComponent() instanceof ResolvedWithKey && childCount == sightings.size() + 1) {
            this.fireTreeStructureChanged(new TreeModelEvent((Object)this, parentPath));
        }
        int[] indices = new int[sightings.size()];
        Object[] objects = sightings.toArray();
        for (int i = 0; i < objects.length; ++i) {
            int index = this.getIndexOfSighting(parentPath.getLastPathComponent(), (Sighting)objects[i]);
            if (index < 0) {
                this.fireTreeStructureChanged(new TreeModelEvent((Object)this, parentPath));
                return;
            }
            indices[i] = index;
        }
        this.fireTreeNodesInserted(new TreeModelEvent((Object)this, parentPath, indices, objects));
    }

    public void taxaRemoved(TreePath parentPath, List<Object> values, List<Integer> originalIndices) {
        int[] indices = new int[originalIndices.size()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = originalIndices.get(i);
        }
        this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, parentPath, indices, values.toArray()));
    }

    public void sightingsReplaced(TreePath parent, List<Sighting> oldSightings, List<Sighting> newSightings, int[] oldIndices) {
        HashSet<SightingTaxon.Resolved> oldResolved = new HashSet<SightingTaxon.Resolved>();
        HashSet oldVisitInfoKeys = new HashSet();
        for (Sighting oldSighting : oldSightings) {
            oldResolved.add(this.queryResults.resolveToType(oldSighting.getTaxon()));
            VisitInfoKey visitInfoKey = VisitInfoKey.forSighting(oldSighting);
            if (visitInfoKey == null) continue;
            oldVisitInfoKeys.add(visitInfoKey);
        }
        HashSet<SightingTaxon.Resolved> newResolved = new HashSet<SightingTaxon.Resolved>();
        HashSet<VisitInfoKey> newVisitInfoKeys = new HashSet<VisitInfoKey>();
        for (Sighting sighting : newSightings) {
            newResolved.add(this.queryResults.resolveToType(sighting.getTaxon()));
            VisitInfoKey visitInfoKey = VisitInfoKey.forSighting(sighting);
            if (visitInfoKey == null) continue;
            newVisitInfoKeys.add(visitInfoKey);
        }
        newResolved.removeAll(this.queryResults.getTaxaAsList());
        if (this.visitInfoKeyNodes != null) {
            for (VisitInfoKeyNode visitInfoKeyNode : this.visitInfoKeyNodes) {
                newVisitInfoKeys.remove(visitInfoKeyNode.getVisitInfoKey());
            }
        }
        this.queryResults.updateSightings(oldSightings, newSightings, !newResolved.isEmpty());
        oldVisitInfoKeys.removeAll(this.queryResults.getAllVisitInfoKeys());
        oldResolved.removeAll(this.queryResults.getTaxaAsList());
        for (VisitInfoKey visitInfoKey : oldVisitInfoKeys) {
            this.removeVisitInfo(visitInfoKey);
        }
        for (VisitInfoKey visitInfoKey : newVisitInfoKeys) {
            this.addVisitInfo(visitInfoKey);
        }
        this.invalidateState();
        if (!oldResolved.isEmpty() || !newResolved.isEmpty()) {
            this.fireTreeStructureChanged(new TreeModelEvent((Object)this, new Object[]{ROOT}));
            return;
        }
        ArrayList<Object> changedSightings = Lists.newArrayList();
        ArrayList<Integer> arrayList = Lists.newArrayList();
        for (int i = 0; i < oldIndices.length; ++i) {
            int newIndex = this.getIndexOfSighting(parent.getLastPathComponent(), newSightings.get(i));
            SightingTaxon.Resolved resolved = this.queryResults.resolveToType(oldSightings.get(i).getTaxon());
            if (parent.getLastPathComponent() == ROOT) {
                if (newIndex == oldIndices[i]) {
                    changedSightings.add(new ResolvedWithSighting(resolved, newSightings.get(i)));
                    arrayList.add(newIndex);
                    continue;
                }
                this.fireTreeStructureChanged(new TreeModelEvent((Object)this, new Object[]{ROOT}));
                return;
            }
            if (newIndex < 0) {
                this.fireTreeStructureChanged(new TreeModelEvent((Object)this, new Object[]{ROOT}));
                return;
            }
            if (newIndex == oldIndices[i]) {
                changedSightings.add(newSightings.get(i));
                arrayList.add(newIndex);
                continue;
            }
            this.fireTreeStructureChanged(new TreeModelEvent((Object)this, new Object[]{ROOT}));
            return;
        }
        if (!changedSightings.isEmpty()) {
            this.fireTreeNodesChanged(new TreeModelEvent((Object)this, parent, Ints.toArray(arrayList), changedSightings.toArray()));
        }
    }

    public int getIndexOfSighting(Object parentNode, Sighting sighting) {
        List<? extends Object> childNodes = this.getChildNodes(parentNode);
        for (int i = 0; i < childNodes.size(); ++i) {
            ResolvedWithKey rwk;
            List<Sighting> sightings;
            Object o = childNodes.get(i);
            if (o == sighting) {
                return i;
            }
            if (o instanceof ResolvedWithSighting && ((ResolvedWithSighting)o).getSighting() == sighting) {
                return i;
            }
            if (!(o instanceof ResolvedWithKey) || (sightings = this.getChildren(rwk = (ResolvedWithKey)o)).size() != 1 || sightings.get(0) != sighting) continue;
            return i;
        }
        return -1;
    }

    private List<? extends Object> getChildNodes(Object node) {
        if (node instanceof SightingTaxon.Resolved) {
            return this.sortedSightingsCache.getUnchecked((SightingTaxon.Resolved)node);
        }
        if (node instanceof Sighting || node instanceof ResolvedWithSighting || node instanceof VisitInfoKey) {
            return ImmutableList.of();
        }
        if (node == ROOT) {
            AbstractCollection tripChildNodes;
            if ((this.visitInfoKeyNodes == null || this.visitInfoKeyNodes.isEmpty()) && (this.tripNodes == null || this.tripNodes.isEmpty())) {
                return this.allTaxaInQueryResults();
            }
            if (this.tripNodes != null && !this.tripNodes.isEmpty()) {
                if (this.tripNodes.size() <= 5) {
                    tripChildNodes = new ArrayList(this.tripNodes.size() + 1);
                    tripChildNodes.add(new TripsNode(this.tripNodes.size()));
                    tripChildNodes.addAll(this.tripNodes);
                } else {
                    tripChildNodes = ImmutableList.of(new TripsNode(this.tripNodes.size()));
                }
            } else {
                tripChildNodes = ImmutableList.of();
            }
            if (this.visitInfoKeyNodes.size() > 5) {
                return ImmutableList.copyOf(Iterables.concat(tripChildNodes, ImmutableList.of(new VisitsNode(this.visitInfoKeyNodes.size())), this.allTaxaInQueryResults()));
            }
            if (!this.visitInfoKeyNodes.isEmpty()) {
                return ImmutableList.copyOf(Iterables.concat(tripChildNodes, ImmutableList.of(new VisitsNode(this.visitInfoKeyNodes.size())), this.visitInfoKeyNodes, this.allTaxaInQueryResults()));
            }
            return ImmutableList.copyOf(Iterables.concat(tripChildNodes, this.allTaxaInQueryResults()));
        }
        if (node instanceof VisitsNode) {
            return this.visitInfoKeyNodes;
        }
        if (node instanceof TripsNode) {
            return this.tripNodes;
        }
        if (node instanceof TripNode) {
            TripNode tripNode = (TripNode)node;
            return this.tripChildrenCache.getUnchecked(tripNode.getTrip());
        }
        if (node instanceof VisitInfoKeyNode) {
            VisitInfoKeyNode visitInfoKeyNode = (VisitInfoKeyNode)node;
            return this.visitInfoKeyChildCache.getUnchecked(visitInfoKeyNode.getVisitInfoKey());
        }
        if (node instanceof ResolvedWithKey) {
            ResolvedWithKey rwk = (ResolvedWithKey)node;
            return this.getChildren(rwk);
        }
        throw new IllegalArgumentException("Unexpected node type " + node);
    }

    public List<Sighting> getChildren(ResolvedWithKey rwk) {
        ArrayList<Sighting> children = new ArrayList<Sighting>();
        List<Sighting> sightings = rwk.getVisitInfoKey() != null ? this.visitInfoKeySightingCache.getUnchecked(rwk.getVisitInfoKey()) : this.tripSightingCache.getUnchecked(rwk.getTrip());
        for (Sighting sighting : sightings) {
            if (!this.queryResults.resolveToType(sighting.getTaxon()).equals(rwk.getResolved())) continue;
            children.add(sighting);
        }
        return children;
    }

    private List<? extends Object> allTaxaInQueryResults() {
        List<SightingTaxon.Resolved> taxa = this.queryResults.getTaxaAsList();
        if (!this.shortcutSingleSightingColumns) {
            return taxa;
        }
        ArrayList<Object> taxaOrSightingWithResolved = new ArrayList<Object>(taxa.size());
        for (SightingTaxon.Resolved taxon : taxa) {
            if (taxon.getLargestTaxonType() == Taxon.Type.family) {
                taxaOrSightingWithResolved.add(taxon);
                continue;
            }
            Collection<Sighting> allSightings = this.queryResults.getAllSightings(taxon);
            if (allSightings.size() == 1) {
                taxaOrSightingWithResolved.add(new ResolvedWithSighting(taxon, allSightings.iterator().next()));
                continue;
            }
            taxaOrSightingWithResolved.add(taxon);
        }
        return taxaOrSightingWithResolved;
    }

    private List<Sighting> getTaxonChildren(SightingTaxon.Resolved taxon) {
        Collection<Sighting> collection = this.queryResults.getAllSightings(taxon);
        return SightingComparators.preferEarlier().immutableSortedCopy(collection);
    }

    private List<Object> getVisitInfoKeyChildren(VisitInfoKey visitInfoKey) {
        return Stream.concat(Stream.of(visitInfoKey), this.visitInfoKeySightingCache.getUnchecked(visitInfoKey).stream().map(sighting -> new ResolvedWithKey(this.queryResults.resolveToType(sighting.getTaxon()), visitInfoKey)).sorted()).collect(ImmutableList.toImmutableList());
    }

    private List<Sighting> getVisitInfoKeySightings(VisitInfoKey visitInfoKey) {
        return Streams.stream(this.queryResults.getAllSightings()).filter(visitInfoKey::matches).sorted(SightingComparators.preferMoreRecent().reversed()).collect(ImmutableList.toImmutableList());
    }

    private List<Object> getTripChildren(Trip trip) {
        ImmutableList.Builder children = ImmutableList.builder();
        children.add(trip);
        return Stream.concat(Stream.of(trip), this.tripSightingCache.getUnchecked(trip).stream().map(sighting -> new ResolvedWithKey(this.queryResults.resolveToType(sighting.getTaxon()), trip)).sorted().distinct()).collect(ImmutableList.toImmutableList());
    }

    private List<Sighting> getTripSightings(Trip trip) {
        ImmutableList.Builder children = ImmutableList.builder();
        children.add(trip);
        return Streams.stream(this.queryResults.getAllSightings()).filter(SightingPredicates.isPartOfTrip(trip, this.locationSet)).sorted(SightingComparators.preferMoreRecent().reversed()).collect(ImmutableList.toImmutableList());
    }

    public static class VisitInfoKeyNode {
        private final VisitInfoKey visitInfoKey;

        VisitInfoKeyNode(VisitInfoKey visitInfoKey) {
            this.visitInfoKey = visitInfoKey;
        }

        public VisitInfoKey getVisitInfoKey() {
            return this.visitInfoKey;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VisitInfoKeyNode)) {
                return false;
            }
            VisitInfoKeyNode that = (VisitInfoKeyNode)o;
            return that.getVisitInfoKey().equals(this.getVisitInfoKey());
        }

        public int hashCode() {
            return this.getVisitInfoKey().hashCode();
        }
    }

    public static class TripNode {
        private final Trip trip;

        TripNode(Trip trip) {
            this.trip = trip;
        }

        public Trip getTrip() {
            return this.trip;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TripNode)) {
                return false;
            }
            TripNode that = (TripNode)o;
            return that.getTrip().equals(this.getTrip());
        }

        public int hashCode() {
            return this.getTrip().hashCode();
        }
    }

    public static class VisitsNode {
        private final int visitCount;

        VisitsNode(int visitCount) {
            this.visitCount = visitCount;
        }

        public int getVisitCount() {
            return this.visitCount;
        }

        public boolean equals(Object that) {
            return that instanceof VisitsNode;
        }

        public int hashCode() {
            return VisitsNode.class.hashCode();
        }
    }

    public static class TripsNode {
        private final int tripCount;

        TripsNode(int tripCount) {
            this.tripCount = tripCount;
        }

        public int getTripCount() {
            return this.tripCount;
        }

        public boolean equals(Object that) {
            return that instanceof TripsNode;
        }

        public int hashCode() {
            return TripsNode.class.hashCode();
        }
    }
}

