/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.query.QueryDefinition;
import com.scythebill.birdlist.model.query.QueryProcessor;
import com.scythebill.birdlist.model.query.QueryResults;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.actions.ActionBroker;
import com.scythebill.birdlist.ui.app.Titled;
import com.scythebill.birdlist.ui.components.DepthChooser;
import com.scythebill.birdlist.ui.components.IndexerPanel;
import com.scythebill.birdlist.ui.components.SightingBulkEditDialog;
import com.scythebill.birdlist.ui.components.SightingBulkEditPanel;
import com.scythebill.birdlist.ui.components.SpeciesIndexerPanelConfigurer;
import com.scythebill.birdlist.ui.events.EventBusRegistrar;
import com.scythebill.birdlist.ui.events.TaxonomyChangedEvent;
import com.scythebill.birdlist.ui.events.TaxonomyStore;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.imports.FinishedImport;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.reports.QueryExecutor;
import com.scythebill.birdlist.ui.panels.reports.QueryFieldFactory;
import com.scythebill.birdlist.ui.panels.reports.QueryPanel;
import com.scythebill.birdlist.ui.panels.reports.QueryPanelFactory;
import com.scythebill.birdlist.ui.panels.reports.QueryPreferences;
import com.scythebill.birdlist.ui.panels.reports.ReportHints;
import com.scythebill.birdlist.ui.panels.reports.ReportsActionFactory;
import com.scythebill.birdlist.ui.panels.reports.ReportsBrowserPanel;
import com.scythebill.birdlist.ui.panels.reports.StoredQueries;
import com.scythebill.birdlist.ui.util.ResolvedWithKey;
import com.scythebill.birdlist.ui.util.ResolvedWithSighting;
import com.scythebill.birdlist.ui.util.VisibilityDetector;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.tree.TreePath;

public class ReportsPanel
extends JPanel
implements Titled,
FontManager.FontsUpdatedListener {
    private QueryResults queryResults;
    private QueryPanel queryPanel;
    private final TaxonomyStore taxonomyStore;
    private final ReportSet reportSet;
    private JButton returnToMainButton;
    private JLabel totalLabel;
    private final ReportsBrowserPanel reportsBrowserPanel;
    private DepthChooser depthChooser;
    private final FontManager fontManager;
    private final QueryExecutor queryExecutor = new Executor();
    private final ReportsActionFactory reportsActionFactory;
    private final ActionBroker actionBroker;
    private final SightingBulkEditDialog sightingBulkEditDialog;
    private final Checklists checklists;
    private final StoredQueries storedQueries;
    private final QueryPreferences queryPreferences;
    private final SpeciesIndexerPanelConfigurer speciesIndexerPanelConfigurer;
    private Action printAction;
    private JComboBox<ExportOption> exportComboBox;
    private JButton updateReport;
    private JButton editButton;
    private JButton printButton;
    private boolean isSimplifiedForResolution;
    private JLabel depthLabel;
    private JButton rememberButton;
    private QueryDefinition currentQueryDefinition;
    private Action finishedReport;
    private JButton speciesJumpButton;
    private IndexerPanel<String> speciesIndexPanel;
    private QueryPanelFactory queryPanelFactory;

    @Inject
    public ReportsPanel(@FinishedImport Action finishedReport, TaxonomyStore taxonomyStore, ReportSet reportSet, QueryPanelFactory queryPanelFactory, ReportsBrowserPanel reportsBrowserPanel, FontManager fontManager, ReportsActionFactory reportsActionFactory, ActionBroker actionBroker, EventBusRegistrar eventBusRegistrar, SightingBulkEditDialog sightingBulkEditDialog, SpeciesIndexerPanelConfigurer speciesIndexerPanelConfigurer, Checklists checklists, StoredQueries storedQueries, QueryPreferences queryPreferences, VisibilityDetector visibilityDetector) {
        this.finishedReport = finishedReport;
        this.taxonomyStore = taxonomyStore;
        this.reportSet = reportSet;
        this.queryPanelFactory = queryPanelFactory;
        this.reportsBrowserPanel = reportsBrowserPanel;
        this.fontManager = fontManager;
        this.reportsActionFactory = reportsActionFactory;
        this.actionBroker = actionBroker;
        this.sightingBulkEditDialog = sightingBulkEditDialog;
        this.speciesIndexerPanelConfigurer = speciesIndexerPanelConfigurer;
        this.checklists = checklists;
        this.storedQueries = storedQueries;
        this.queryPreferences = queryPreferences;
        eventBusRegistrar.registerWhenInHierarchy(this);
        this.initGUI();
        if (storedQueries.getDefaultQuery() != null) {
            this.restoreQuery(storedQueries.getDefaultQuery());
        }
        this.attachListeners();
        visibilityDetector.install(this.returnToMainButton);
        EventQueue.invokeLater(() -> this.showQueryInList());
    }

    public void restoreQuery(StoredQueries.RestoredQuery restored) {
        this.queryPanel.restore(restored);
    }

    public void restoreQuery(String json) {
        this.queryPanel.restore(json);
    }

    @Override
    public String getTitle() {
        return Messages.getMessage(Messages.Name.SHOW_REPORTS);
    }

    protected void simplifyForResolution(Taxon.Type depth) {
        this.queryPanel.setVisible(false);
        this.exportComboBox.setVisible(false);
        this.rememberButton.setVisible(false);
        this.printButton.setVisible(false);
        this.editButton.setVisible(false);
        this.totalLabel.setVisible(false);
        this.depthChooser.setDepth(depth);
        this.depthChooser.setVisible(false);
        this.depthLabel.setVisible(false);
        this.speciesIndexPanel.setVisible(false);
        this.speciesJumpButton.setVisible(false);
        this.isSimplifiedForResolution = true;
    }

    protected Taxonomy getCurrentTaxonomy() {
        return this.taxonomyStore.getTaxonomy();
    }

    private void initGUI() {
        this.queryPanel = this.queryPanelFactory.newQueryPanel(new QueryFieldFactory.QueryFieldType[0]);
        this.totalLabel = new JLabel();
        JComponent helpLabel = this.getHelpLabel();
        GroupLayout groupLayout = new GroupLayout(this);
        groupLayout.setAutoCreateContainerGaps(true);
        this.setLayout(groupLayout);
        JScrollPane browserScrollPane = new JScrollPane();
        browserScrollPane.setViewportView(this.reportsBrowserPanel);
        this.reportsBrowserPanel.setDragEnabled(false);
        this.reportsBrowserPanel.setEditableSightings(true);
        this.reportsBrowserPanel.setEditableWhere(true);
        this.reportsBrowserPanel.setTaxonomy(this.taxonomyStore.getTaxonomy());
        this.depthLabel = new JLabel(Messages.getMessage(Messages.Name.SHOW_LABEL));
        this.depthChooser = new DepthChooser();
        this.updateReport = new JButton();
        this.updateReport.setText(Messages.getMessage(Messages.Name.UPDATE_REPORT));
        this.updateReport.setVisible(false);
        this.updateReport.addActionListener(e -> this.showQueryInList());
        this.speciesJumpButton = new JButton(Messages.getMessage(Messages.Name.JUMP_TO_BUTTON));
        this.speciesIndexPanel = new IndexerPanel();
        this.speciesIndexPanel.addPropertyChangeListener("value", e -> this.speciesJumpButton.setEnabled(e.getNewValue() != null));
        this.speciesIndexPanel.addActionListener(e -> this.speciesJumpButton.doClick(100));
        this.speciesIndexPanel.setEnabled(false);
        this.speciesJumpButton.setEnabled(false);
        this.speciesJumpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Taxon taxon;
                String id = ReportsPanel.this.speciesIndexPanel.getValue();
                if (id != null && (taxon = ReportsPanel.this.taxonomyStore.getTaxonomy().getTaxon(id)) != null) {
                    ReportsPanel.this.reportsBrowserPanel.selectTaxon(taxon);
                    ReportsPanel.this.reportsBrowserPanel.requestFocusInWindow();
                }
            }
        });
        this.returnToMainButton = new JButton();
        this.returnToMainButton.setText(Messages.getMessage(Messages.Name.RETURN_TO_MAIN_MENU));
        this.exportComboBox = new JComboBox();
        this.exportComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ExportOption exportOption = (ExportOption)((Object)ReportsPanel.this.exportComboBox.getSelectedItem());
                if (exportOption != ExportOption.EXPORT) {
                    ReportsPanel.this.exportComboBox.setSelectedItem((Object)ExportOption.EXPORT);
                }
                switch (exportOption) {
                    case EXPORT: {
                        return;
                    }
                    case EBIRD: {
                        ReportsPanel.this.reportsActionFactory.ebirdExport(ReportsPanel.this.queryExecutor).actionPerformed(event);
                        break;
                    }
                    case EXCEL: {
                        ReportsPanel.this.reportsActionFactory.saveAsXls(ReportsPanel.this.queryExecutor).actionPerformed(event);
                        break;
                    }
                    case INATURALIST: {
                        ReportsPanel.this.reportsActionFactory.iNaturalistExport(ReportsPanel.this.queryExecutor).actionPerformed(event);
                        break;
                    }
                    case BIRDTRACK: {
                        ReportsPanel.this.reportsActionFactory.birdTrackExport(ReportsPanel.this.queryExecutor).actionPerformed(event);
                        break;
                    }
                    case SCYTHEBILL: {
                        ReportsPanel.this.reportsActionFactory.saveAsScythebill(ReportsPanel.this.queryExecutor).actionPerformed(event);
                        break;
                    }
                    case TRIP_REPORT: {
                        ReportsPanel.this.reportsActionFactory.saveAsTripReport(ReportsPanel.this.queryExecutor, null).actionPerformed(event);
                        break;
                    }
                    case FAMILY_REPORT: {
                        ReportsPanel.this.reportsActionFactory.saveAsFamilyReport(ReportsPanel.this.queryExecutor).actionPerformed(event);
                    }
                }
            }
        });
        this.updateExportCombobox();
        this.updateSpeciesIndexer(this.taxonomyStore.getTaxonomy());
        this.printButton = new JButton(this.reportsActionFactory.print(this.queryExecutor));
        this.printButton.setText(Messages.getMessage(Messages.Name.PRINT_MENU));
        this.editButton = new JButton(Messages.getMessage(Messages.Name.BULK_EDIT));
        this.editButton.addActionListener(e -> this.showBulkEdit());
        this.rememberButton = new JButton(Messages.getMessage(Messages.Name.REMEMBER_MENU));
        this.rememberButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String name = this.getName();
                if (name != null) {
                    String persisted = ReportsPanel.this.queryPanel.persist();
                    ReportsPanel.this.storedQueries.addReportsQuery(name, persisted);
                }
            }

            private String getName() {
                String defaultName = Messages.getMessage(Messages.Name.REPORT_DEFAULT_NAME);
                Optional<String> betterName = ReportsPanel.this.queryPanel.getQueryName();
                if (betterName.isPresent()) {
                    defaultName = betterName.get();
                }
                return ReportsPanel.this.storedQueries.chooseName(ReportsPanel.this, defaultName);
            }
        });
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addComponent(helpLabel, -2, -2, -2).addGroup(groupLayout.createBaselineGroup(false, false).addComponent(this.depthLabel).addComponent(this.depthChooser).addComponent(this.updateReport).addComponent(this.speciesIndexPanel).addComponent(this.speciesJumpButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.queryPanel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.totalLabel).addComponent(browserScrollPane).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createBaselineGroup(false, false).addComponent(this.exportComboBox).addComponent(this.printButton).addComponent(this.editButton).addComponent(this.rememberButton).addComponent(this.returnToMainButton)));
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup().addComponent(helpLabel, -2, -2, -2).addGroup(groupLayout.createSequentialGroup().addComponent(this.depthLabel, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.depthChooser, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.speciesIndexPanel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.speciesJumpButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.updateReport)).addComponent(this.queryPanel).addComponent(this.totalLabel).addComponent(browserScrollPane).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addComponent(this.exportComboBox, -2, -2, -2).addComponent(this.printButton, -2, -2, -2).addComponent(this.editButton, -2, -2, -2).addComponent(this.rememberButton, -2, -2, -2)).addComponent(this.returnToMainButton, GroupLayout.Alignment.TRAILING, -2, -2, -2));
        this.fontManager.applyTo(this);
    }

    protected JComponent getHelpLabel() {
        JPanel panel = new JPanel();
        panel.setVisible(false);
        return panel;
    }

    private void attachListeners() {
        this.printAction = this.reportsActionFactory.print(this.queryExecutor);
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent e) {
                ReportsPanel.this.actionBroker.unpublishAction("print", ReportsPanel.this.printAction);
            }

            @Override
            public void ancestorMoved(AncestorEvent e) {
            }

            @Override
            public void ancestorAdded(AncestorEvent e) {
                ReportsPanel.this.actionBroker.publishAction("print", ReportsPanel.this.printAction);
            }
        });
        this.queryPanel.addPredicateChangedListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (ReportsPanel.this.storedQueries != null) {
                    ReportsPanel.this.storedQueries.setDefaultQuery(ReportsPanel.this.queryPanel.persist());
                }
                ReportsPanel.this.showQueryInList();
            }
        });
        this.returnToMainButton.addActionListener(this.finishedReport);
        this.depthChooser.addPropertyChangeListener("depth", e -> this.showQueryInList());
    }

    private void showBulkEdit() {
        SightingBulkEditPanel.UpdatedListener onSaved = new SightingBulkEditPanel.UpdatedListener(){

            @Override
            public void sightingsUpdated(List<Sighting> sightings) {
                ReportsPanel.this.queryResults.updateSightings(sightings, sightings, true);
                ReportsPanel.this.reportsBrowserPanel.invalidateSightings();
            }

            @Override
            public void sightingsSwapped(List<Sighting> oldSightings, List<Sighting> newSightings) {
                ReportsPanel.this.queryResults.updateSightings(oldSightings, newSightings, true);
                ReportsPanel.this.reportsBrowserPanel.invalidateSightings();
            }

            @Override
            public void sightingsRemoved(List<Sighting> sightings) {
                ReportsPanel.this.reportsBrowserPanel.clearSelection();
                ReportsPanel.this.queryResults.removeSightings(sightings);
                ReportsPanel.this.reportsBrowserPanel.invalidateSightings();
                ReportsPanel.this.showQueryInList();
            }
        };
        this.sightingBulkEditDialog.bulkEditSightings(SwingUtilities.getWindowAncestor(this), onSaved, this.taxonomyStore.getTaxonomy(), this.reportSet, ImmutableList.copyOf(this.queryResults.getAllSightings()));
    }

    private void showQueryInList() {
        SightingTaxon.Resolved selectedTaxon;
        TreePath originalSelectionPath = this.reportsBrowserPanel.getSelectionPath();
        if (originalSelectionPath != null && originalSelectionPath.getPathCount() >= 2) {
            Object o = originalSelectionPath.getPathComponent(1);
            if (o instanceof SightingTaxon.Resolved) {
                SightingTaxon.Resolved r;
                selectedTaxon = r = (SightingTaxon.Resolved)o;
            } else if (o instanceof ResolvedWithSighting) {
                ResolvedWithSighting rws = (ResolvedWithSighting)o;
                selectedTaxon = rws.getResolved();
            } else if (o instanceof ResolvedWithKey) {
                ResolvedWithKey rwk = (ResolvedWithKey)o;
                selectedTaxon = rwk.getResolved();
            } else {
                selectedTaxon = null;
            }
        } else {
            selectedTaxon = null;
        }
        Set<ReportHints> reportHints = this.getReportHints();
        this.reportsBrowserPanel.setShowSpeciesStatus(reportHints.contains((Object)ReportHints.SPECIES_STATUS_RESTRICTION));
        this.reportsBrowserPanel.setLocationRoot(this.queryPanel.getRootLocation());
        this.queryResults = this.executeQuery(null, null, false, false);
        this.queryResults.addListener(new QueryResults.Listener(){

            @Override
            public void resultsChanged() {
                ReportsPanel.this.queryResultsUpdated(ReportsPanel.this.queryResults);
            }
        });
        this.queryResultsUpdated(this.queryResults);
        this.reportsBrowserPanel.setQueryResults(this.queryResults, false);
        if (selectedTaxon != null && selectedTaxon.getTaxonomy() == this.taxonomyStore.getTaxonomy() && !this.queryResults.getAllSightings(selectedTaxon).isEmpty()) {
            this.reportsBrowserPanel.selectResolved(selectedTaxon);
        }
        this.speciesIndexerPanelConfigurer.configureQuery(this.speciesIndexPanel, this.queryResults);
    }

    private void queryResultsUpdated(QueryResults updatedQueryResults) {
        this.updateReport.setVisible(updatedQueryResults.isQueryInvalid());
        Taxonomy taxonomy = this.taxonomyStore.getTaxonomy();
        int speciesCount = updatedQueryResults.getCountableSpeciesSize(taxonomy, false);
        Object total = Messages.getFormattedMessage(Messages.Name.TOTAL_SPECIES_FORMAT_NO_CHECKLIST, speciesCount);
        if (this.depthChooser.getDepth() != Taxon.Type.species) {
            int spuhCount;
            int subspeciesCount;
            Object otherTotals = "";
            int groupsAndSpeciesCount = updatedQueryResults.getCountableGroupsAndSpeciesSize(taxonomy, false);
            if (groupsAndSpeciesCount != speciesCount) {
                otherTotals = (String)otherTotals + Messages.getFormattedMessage(Messages.Name.GROUPS_FORMAT, groupsAndSpeciesCount);
            }
            if (this.depthChooser.getDepth() == Taxon.Type.subspecies && (subspeciesCount = updatedQueryResults.getCountableSubspeciesGroupsAndSpeciesSize(taxonomy, false)) != groupsAndSpeciesCount) {
                if (!((String)otherTotals).isEmpty()) {
                    otherTotals = (String)otherTotals + ", ";
                }
                otherTotals = (String)otherTotals + Messages.getFormattedMessage(Messages.Name.SSPS_FORMAT, subspeciesCount);
            }
            if ((spuhCount = this.queryResults.getSpuhCount()) > 0) {
                if (!((String)otherTotals).isEmpty()) {
                    otherTotals = (String)otherTotals + ", ";
                }
                otherTotals = (String)otherTotals + Messages.getFormattedMessage(Messages.Name.SPUHS_FORMAT, spuhCount);
            }
            if (!((String)otherTotals).isEmpty()) {
                total = (String)total + " (" + (String)otherTotals + ")";
            }
        } else {
            int spuhCount = this.queryResults.getSpuhCount();
            if (spuhCount > 0) {
                total = (String)total + " (" + Messages.getFormattedMessage(Messages.Name.SPUHS_FORMAT, spuhCount) + ")";
            }
        }
        if (this.queryPanel.containsQueryFieldTypeThatIsNotANoOp(QueryFieldFactory.QueryFieldType.FIRST_SIGHTINGS)) {
            Set<SightingTaxon.Resolved> lifers = updatedQueryResults.getTaxaWithAnnotation(taxonomy, QueryDefinition.QueryAnnotation.LIFER, Taxon.Type.species);
            if (!lifers.isEmpty()) {
                total = (String)total + "   " + Messages.getFormattedMessage(Messages.Name.LIFERS_FORMAT_2, lifers.size());
            }
            if (this.depthChooser.getDepth() != Taxon.Type.species) {
                int subspeciesCount;
                Object otherTotals = "";
                int groupsAndSpeciesCount = updatedQueryResults.getTaxaWithAnnotation(taxonomy, QueryDefinition.QueryAnnotation.LIFER, Taxon.Type.group).size();
                if (groupsAndSpeciesCount != lifers.size()) {
                    otherTotals = (String)otherTotals + Messages.getFormattedMessage(Messages.Name.GROUPS_FORMAT, groupsAndSpeciesCount);
                }
                if (this.depthChooser.getDepth() == Taxon.Type.subspecies && (subspeciesCount = updatedQueryResults.getTaxaWithAnnotation(taxonomy, QueryDefinition.QueryAnnotation.LIFER, Taxon.Type.subspecies).size()) != groupsAndSpeciesCount) {
                    if (!((String)otherTotals).isEmpty()) {
                        otherTotals = (String)otherTotals + ", ";
                    }
                    otherTotals = (String)otherTotals + Messages.getFormattedMessage(Messages.Name.SSPS_FORMAT, subspeciesCount);
                }
                if (!((String)otherTotals).isEmpty()) {
                    total = (String)total + " (" + (String)otherTotals + ")";
                }
            }
        }
        total = (String)total + ", " + Messages.getFormattedMessage(Messages.Name.FAMILIES_FORMAT, updatedQueryResults.getFamilyCount(this.taxonomyStore.getTaxonomy()));
        this.totalLabel.setText((String)total);
        int sightingsCount = updatedQueryResults.getSightingsCount(taxonomy);
        this.editButton.setEnabled(sightingsCount > 1);
        this.printButton.setEnabled(sightingsCount > 0);
        this.exportComboBox.setEnabled(sightingsCount > 0);
    }

    private Set<ReportHints> getReportHints() {
        EnumSet<ReportHints> set = EnumSet.noneOf(ReportHints.class);
        if (this.queryPanel.containsQueryFieldTypeThatIsNotANoOp(QueryFieldFactory.QueryFieldType.LOCATION)) {
            set.add(ReportHints.LOCATION_RESTRICTION);
        }
        if (this.queryPanel.containsQueryFieldTypeThatIsNotANoOp(QueryFieldFactory.QueryFieldType.SPECIES_STATUS)) {
            set.add(ReportHints.SPECIES_STATUS_RESTRICTION);
        }
        if (this.queryPanel.containsQueryFieldTypeThatIsNotANoOp(QueryFieldFactory.QueryFieldType.DATE)) {
            set.add(ReportHints.DATE_RESTRICTION);
        }
        return set;
    }

    @Subscribe
    public void taxonomyChanged(TaxonomyChangedEvent event) {
        Taxonomy taxonomy = this.taxonomyStore.getTaxonomy();
        this.reportsBrowserPanel.setTaxonomy(taxonomy);
        this.queryPanel.taxonomyUpdated();
        this.updateExportCombobox();
        this.showQueryInList();
        this.updateSpeciesIndexer(taxonomy);
    }

    private void updateSpeciesIndexer(Taxonomy taxonomy) {
        this.speciesIndexerPanelConfigurer.configure(this.speciesIndexPanel, taxonomy);
        this.speciesIndexerPanelConfigurer.addSimpleTaxa(this.speciesIndexPanel, taxonomy, TaxonUtils.getDescendantsOfType(taxonomy.getRoot(), Taxon.Type.family));
    }

    private void updateExportCombobox() {
        ArrayList<ExportOption> options = Lists.newArrayList(ExportOption.values());
        if (!this.taxonomyStore.isBirdTaxonomy()) {
            options.remove((Object)ExportOption.EBIRD);
        }
        this.exportComboBox.setModel(new DefaultComboBoxModel<ExportOption>(options.toArray(new ExportOption[0])));
    }

    private Set<Location> getLocations() {
        return this.queryPanel.getLocations();
    }

    protected QueryDefinition getQueryDefinition(Taxon.Type depth) {
        return this.queryPanel.queryDefinition(this.taxonomyStore.getTaxonomy(), depth);
    }

    private QueryResults executeQuery(@Nullable Taxon.Type depth, @Nullable Taxonomy taxonomyOverride, boolean onlyCountable, boolean includeIncompatibleSightings) {
        Location location;
        depth = MoreObjects.firstNonNull(depth, this.depthChooser.getDepth());
        this.currentQueryDefinition = this.getQueryDefinition(depth);
        Taxonomy taxonomy = MoreObjects.firstNonNull(taxonomyOverride, this.taxonomyStore.getTaxonomy());
        Set<Location> locations = this.getLocations();
        Checklist checklist = null;
        LinkedHashMap<Taxonomy, Checklist> otherTaxonomyChecklists = null;
        if (locations.size() == 1 && (location = Iterables.getOnlyElement(locations)) != null) {
            checklist = this.checklists.getChecklist(this.reportSet, taxonomy, location);
            if (includeIncompatibleSightings) {
                otherTaxonomyChecklists = new LinkedHashMap<Taxonomy, Checklist>();
                if (!taxonomy.isBuiltIn()) {
                    Checklist iocChecklist;
                    Checklist clementsChecklist = this.checklists.getChecklist(this.reportSet, this.taxonomyStore.getClements(), location);
                    if (clementsChecklist != null) {
                        otherTaxonomyChecklists.put(this.taxonomyStore.getClements(), clementsChecklist);
                    }
                    if ((iocChecklist = this.checklists.getChecklist(this.reportSet, this.taxonomyStore.getIoc(), location)) != null) {
                        otherTaxonomyChecklists.put(this.taxonomyStore.getIoc(), iocChecklist);
                    }
                }
                for (Taxonomy extendedTaxonomy : this.reportSet.extendedTaxonomies()) {
                    Checklist extendedTaxonomyChecklist = this.checklists.getChecklist(this.reportSet, extendedTaxonomy, location);
                    if (extendedTaxonomyChecklist == null) continue;
                    otherTaxonomyChecklists.put(extendedTaxonomy, extendedTaxonomyChecklist);
                }
            }
        }
        Set<ReportHints> reportHints = this.getReportHints();
        boolean dontShowFamilyTotals = this.isSimplifiedForResolution || reportHints.contains((Object)ReportHints.LOCATION_RESTRICTION) && checklist == null;
        this.reportsBrowserPanel.setShowFamilyTotals(!dontShowFamilyTotals);
        QueryProcessor processor = new QueryProcessor(this.reportSet, taxonomy, checklist, otherTaxonomyChecklists);
        processor.keepInvalidSightingsAfterUpdate();
        if (this.isSimplifiedForResolution) {
            processor.dontIncludeFamilyNames();
        }
        if (onlyCountable) {
            processor.onlyIncludeCountableSightings();
        }
        if (includeIncompatibleSightings) {
            processor.includingIncompatibleSightings();
        }
        Predicate<Sighting> countablePredicate = this.queryPreferences.getCountablePredicate(taxonomy, this.queryPanel.containsQueryFieldType(QueryFieldFactory.QueryFieldType.SIGHTING_STATUS), this.queryPanel.getBooleanValueIfPresent(QueryFieldFactory.QueryFieldType.ALLOW_HEARD_ONLY));
        return processor.runQuery(this.currentQueryDefinition, countablePredicate, depth);
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        Dimension preferredSize = fontManager.scale(new Dimension(860, 680));
        preferredSize.width += 200;
        if (this.reportSet.getUserSet() != null) {
            preferredSize.height += fontManager.scale(60);
        }
        this.setPreferredSize(preferredSize);
    }

    class Executor
    implements QueryExecutor {
        private boolean onlyCountable;
        private boolean includeIncompatibleSightings;

        Executor() {
        }

        @Override
        public QueryResults executeQuery(Taxon.Type depth, Taxonomy taxonomyOverride) {
            return ReportsPanel.this.executeQuery(depth, taxonomyOverride, this.onlyCountable, this.includeIncompatibleSightings);
        }

        @Override
        public Location getRootLocation() {
            return ReportsPanel.this.queryPanel.getRootLocation();
        }

        @Override
        public Set<ReportHints> getReportHints() {
            return ReportsPanel.this.getReportHints();
        }

        @Override
        public Optional<String> getReportAbbreviation() {
            return ReportsPanel.this.queryPanel.getQueryAbbreviation();
        }

        @Override
        public Optional<String> getReportName() {
            return ReportsPanel.this.queryPanel.getQueryName();
        }

        @Override
        public QueryExecutor onlyCountable() {
            Executor executor = new Executor();
            executor.includeIncompatibleSightings = this.includeIncompatibleSightings;
            executor.onlyCountable = true;
            return executor;
        }

        @Override
        public QueryExecutor includeIncompatibleSightings() {
            Executor executor = new Executor();
            executor.includeIncompatibleSightings = true;
            executor.onlyCountable = this.onlyCountable;
            return executor;
        }
    }

    static enum ExportOption {
        EXPORT(Messages.Name.EXPORT_MENU),
        EBIRD(Messages.Name.EXPORT_TO_EBIRD),
        EXCEL(Messages.Name.EXPORT_TO_SPREADSHEET),
        SCYTHEBILL(Messages.Name.EXPORT_TO_SCYTHEBILL),
        TRIP_REPORT(Messages.Name.EXPORT_TO_TRIP_REPORT),
        FAMILY_REPORT(Messages.Name.EXPORT_TO_FAMILY_REPORT),
        INATURALIST(Messages.Name.EXPORT_TO_INATURALIST),
        BIRDTRACK(Messages.Name.EXPORT_TO_BIRDTRACK);

        private final Messages.Name name;

        private ExportOption(Messages.Name name) {
            this.name = name;
        }

        public String toString() {
            return Messages.getMessage(this.name);
        }
    }
}

