/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.query.QueryDefinition;
import com.scythebill.birdlist.model.query.QueryResults;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.SightingTaxons;
import com.scythebill.birdlist.model.sighting.Trip;
import com.scythebill.birdlist.model.sighting.Trips;
import com.scythebill.birdlist.model.sighting.VisitInfoKey;
import com.scythebill.birdlist.model.taxa.Species;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.TaxonVisitor;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.taxa.names.LocalNames;
import com.scythebill.birdlist.ui.actions.ActionBroker;
import com.scythebill.birdlist.ui.app.NavigableFrame;
import com.scythebill.birdlist.ui.components.BaseTaxonBrowserPanel;
import com.scythebill.birdlist.ui.components.NewLocationDialog;
import com.scythebill.birdlist.ui.components.SightingBrowsePanel;
import com.scythebill.birdlist.ui.components.SightingBulkEditPanel;
import com.scythebill.birdlist.ui.components.VisitInfoPreferences;
import com.scythebill.birdlist.ui.datatransfer.SightingsGroup;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.SpHybridDialog;
import com.scythebill.birdlist.ui.panels.SpeciesInfoDescriber;
import com.scythebill.birdlist.ui.panels.reports.QueryPreferences;
import com.scythebill.birdlist.ui.panels.reports.ReportsTreeModel;
import com.scythebill.birdlist.ui.panels.reports.SortType;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.FileDialogs;
import com.scythebill.birdlist.ui.util.FocusTracker;
import com.scythebill.birdlist.ui.util.LocationIdToString;
import com.scythebill.birdlist.ui.util.LocationScorer;
import com.scythebill.birdlist.ui.util.OpenMapUrl;
import com.scythebill.birdlist.ui.util.ResolvedWithKey;
import com.scythebill.birdlist.ui.util.ResolvedWithSighting;
import com.scythebill.birdlist.ui.util.ScanSeenTaxa;
import com.scythebill.birdlist.ui.util.SightingFlags;
import com.scythebill.birdlist.ui.util.UIUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ReportsBrowserPanel
extends BaseTaxonBrowserPanel {
    private static final Logger logger = Logger.getLogger(ReportsBrowserPanel.class.getName());
    private QueryResults queryResults;
    private boolean showFamilyTotals;
    private boolean editableSightings;
    private boolean showSpeciesStatus;
    private ActionBroker actionBroker;
    private boolean editableWhere;
    private ScanSeenTaxa scanSeenTaxa;
    private final ReportsBrowserFocusTracker reportsBrowserFocusTracker;
    private SortType sortType = SortType.DEFAULT;
    private boolean allowLocationEditing = true;
    private final VisitInfoPreferences visitInfoPreferences;
    private QueryPreferences queryPreferences;
    private String returnPanelName = "reports";

    @Inject
    public ReportsBrowserPanel(FontManager fontManager, ReportSet reportSet, ActionBroker actionBroker, NewLocationDialog newLocationDialog, SpHybridDialog spHybridDialog, PredefinedLocations predefinedLocations, SpeciesInfoDescriber speciesInfoDescriber, OpenMapUrl openMapUrl, VisitInfoPreferences visitInfoPreferences, QueryPreferences queryPreferences, FileDialogs fileDialogs, Alerts alerts, NavigableFrame navigableFrame, LocationScorer locationScorer) {
        super(fontManager, reportSet, newLocationDialog, spHybridDialog, predefinedLocations, speciesInfoDescriber, openMapUrl, fileDialogs, alerts, navigableFrame, locationScorer);
        this.actionBroker = actionBroker;
        this.visitInfoPreferences = visitInfoPreferences;
        this.queryPreferences = queryPreferences;
        this.setSelectionMode(4);
        this.setDragEnabled(true);
        this.setTransferHandler(new ReportsTransferHandler());
        this.reportsBrowserFocusTracker = new ReportsBrowserFocusTracker();
    }

    @Override
    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Object text;
        if (value instanceof VisitInfoKey) {
            return Messages.getMessage(Messages.Name.VISIT_DATA);
        }
        if (value instanceof Trip) {
            return Messages.getMessage(Messages.Name.TRIP_DATA);
        }
        SightingTaxon.Resolved resolved = null;
        if (value instanceof ReportsTreeModel.VisitsNode) {
            ReportsTreeModel.VisitsNode visitNode = (ReportsTreeModel.VisitsNode)value;
            text = Messages.getFormattedMessage(leaf ? Messages.Name.VISITS_CAPITALIZED_FORMAT : Messages.Name.VISITS_FORMAT, visitNode.getVisitCount());
        } else if (value instanceof ReportsTreeModel.TripsNode) {
            ReportsTreeModel.TripsNode tripNode = (ReportsTreeModel.TripsNode)value;
            text = Messages.getFormattedMessage(leaf ? Messages.Name.TRIPS_CAPITALIZED_FORMAT : Messages.Name.TRIPS_FORMAT, tripNode.getTripCount());
        } else if (value instanceof ReportsTreeModel.TripNode) {
            ReportsTreeModel.TripNode tripNode = (ReportsTreeModel.TripNode)value;
            text = Trips.nameWithDate(tripNode.getTrip(), this.getLocale());
        } else if (value instanceof ResolvedWithKey) {
            ResolvedWithKey resolvedWithKey = (ResolvedWithKey)value;
            List<Sighting> sightings = ((ReportsTreeModel)this.getModel()).getChildren(resolvedWithKey);
            Sighting sighting = null;
            if (sightings.size() == 1) {
                sighting = sightings.get(0);
            } else if (this.sortType != SortType.DEFAULT) {
                sighting = this.sortType.ordering().max(sightings);
            }
            text = this.convertResolvedToString(resolvedWithKey.getResolved(), sighting);
        } else if (value instanceof ResolvedWithSighting) {
            ResolvedWithSighting resolvedWithSighting = (ResolvedWithSighting)value;
            text = this.convertResolvedToString(resolvedWithSighting.getResolved(), resolvedWithSighting.getSighting());
            resolved = resolvedWithSighting.getResolved();
        } else {
            if (value instanceof ReportsTreeModel.VisitInfoKeyNode) {
                value = ((ReportsTreeModel.VisitInfoKeyNode)value).getVisitInfoKey();
            }
            if (value instanceof SightingTaxon.Resolved) {
                resolved = (SightingTaxon.Resolved)value;
            }
            text = super.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
        }
        if (resolved != null) {
            if (resolved.getSmallestTaxonType() == Taxon.Type.family) {
                text = ((String)text).toUpperCase();
            }
            if (this.getChecklist() != null && resolved.getType() == SightingTaxon.Type.SINGLE) {
                Checklist.Status status = this.getChecklist().getStatus(resolved.getTaxonomy(), resolved.getParentOfAtLeastType(Taxon.Type.species));
                if (status == Checklist.Status.ENDEMIC) {
                    text = (String)text + " - " + Messages.getMessage(Messages.Name.CHECKLIST_STATUS_ENDEMIC).toLowerCase();
                } else if (status == Checklist.Status.INTRODUCED) {
                    String introduced = Messages.getMessage(Messages.Name.CHECKLIST_STATUS_INTRODUCED).toLowerCase();
                    if (!((String)text).contains(introduced)) {
                        text = (String)text + " - " + introduced;
                    }
                } else if (status == Checklist.Status.ESCAPED) {
                    String notEstablished = Messages.getMessage(Messages.Name.CHECKLIST_STATUS_NOT_ESTABLISHED).toLowerCase();
                    if (!((String)text).contains(notEstablished)) {
                        text = (String)text + " - " + notEstablished;
                    }
                } else if (status == Checklist.Status.RARITY || status == Checklist.Status.RARITY_FROM_INTRODUCED) {
                    text = (String)text + " - " + Messages.getMessage(Messages.Name.CHECKLIST_STATUS_RARITY).toLowerCase();
                } else if (status == Checklist.Status.EXTINCT) {
                    text = (String)text + " - " + Messages.getMessage(Messages.Name.CHECKLIST_STATUS_EXTINCT).toLowerCase();
                }
            }
        } else if (value instanceof VisitInfoKey) {
            VisitInfoKey key = (VisitInfoKey)value;
            Location rootLocation = this.getLocationRoot();
            if (rootLocation != null) {
                if (!rootLocation.getId().equals(key.locationId())) {
                    text = (String)text + " " + LocationIdToString.getString(this.getReportSet().getLocations(), key.locationId(), false, rootLocation);
                }
            } else {
                text = (String)text + " " + LocationIdToString.getString(this.getReportSet().getLocations(), key.locationId(), false, null);
            }
        }
        return text;
    }

    public boolean wouldBeLifer(SightingTaxon.Resolved resolved) {
        Set<String> seenTaxa;
        return this.scanSeenTaxa != null && resolved.getLargestTaxonType().compareTo(Taxon.Type.species) <= 0 && (seenTaxa = this.scanSeenTaxa.getSeenTaxa(resolved.getTaxonomy(), null)) != null && (resolved.getType() == SightingTaxon.Type.SINGLE || resolved.getType() == SightingTaxon.Type.SINGLE_WITH_SECONDARY_SUBSPECIES) && !seenTaxa.contains(resolved.getTaxon().getId());
    }

    public boolean areSightingsInThisReport(SightingTaxon.Resolved resolved) {
        if (this.queryResults == null) {
            return false;
        }
        return !this.queryResults.getAllSightings(resolved).isEmpty();
    }

    @Override
    protected Font deriveTaxonFont(Font base, Taxon taxon, boolean leaf) {
        Set<String> seenTaxa;
        base = super.deriveTaxonFont(base, taxon, leaf);
        if (taxon.getType() == Taxon.Type.family) {
            return base.deriveFont(1);
        }
        if (this.getChecklist() != null && this.scanSeenTaxa != null && (seenTaxa = this.scanSeenTaxa.getSeenTaxa(taxon.getTaxonomy(), null)) != null && !seenTaxa.contains(taxon.getId())) {
            return base.deriveFont(2);
        }
        if (this.queryResults != null && this.queryResults.containsAnnotation(QueryDefinition.QueryAnnotation.LIFER, SightingTaxons.newResolved(taxon))) {
            return base.deriveFont(1);
        }
        return base;
    }

    @Override
    protected Color deriveTaxonForeground(Color foreground, Taxon taxon, boolean leaf, boolean selected, Object value) {
        foreground = super.deriveTaxonForeground(foreground, taxon, leaf, selected, value);
        if (this.getChecklist() != null && taxon.getType() != Taxon.Type.family && leaf && !selected && value instanceof SightingTaxon.Resolved) {
            return Color.gray;
        }
        return foreground;
    }

    @Override
    protected Font deriveOtherFont(Font base, Object value) {
        if (value instanceof ReportsTreeModel.VisitsNode || value instanceof Trip || value instanceof VisitInfoKey || value instanceof ReportsTreeModel.TripsNode) {
            return base.deriveFont(1);
        }
        if (value instanceof Sighting) {
            Sighting sighting = (Sighting)value;
            if (this.queryResults != null && this.queryResults.getSightingsWithAnnotation(QueryDefinition.QueryAnnotation.LIFER).contains(sighting)) {
                return base.deriveFont(1);
            }
        }
        return base;
    }

    public void setEditableSightings(boolean editableSightings) {
        this.editableSightings = editableSightings;
    }

    public void setEditableWhere(boolean editableWhere) {
        this.editableWhere = editableWhere;
    }

    @Override
    protected void customizeSightingPreviewPanel(SightingBrowsePanel panel) {
        panel.setWhereEditable(this.editableWhere);
        panel.setEditable(this.editableSightings);
        panel.setRootLocation(this.getLocationRoot());
    }

    @Override
    protected void customizeSightingPreviewPanel(SightingBulkEditPanel panel) {
        panel.setEditable(this.editableSightings);
    }

    @Override
    protected boolean usePreviewColumn(TreePath[] paths) {
        boolean usePreviewDefault = super.usePreviewColumn(paths);
        if (!usePreviewDefault) {
            return false;
        }
        Object lastPathElement = paths[0].getLastPathComponent();
        return !(lastPathElement instanceof Taxon);
    }

    @Override
    protected String convertTaxonToString(Taxon taxon, @Nullable Sighting sighting) {
        boolean isFamily;
        Species.Status status;
        LocalNames localNames = taxon.getTaxonomy().getLocalNames();
        Object name = taxon.getCommonName() != null || taxon instanceof Species ? localNames.compoundName(taxon, localNames.isCommonNamePreferred() && this.abbreviateGenus(taxon)) : taxon.getName();
        if (this.showSpeciesStatus && taxon instanceof Species && (status = TaxonUtils.getTaxonStatus(taxon)) != Species.Status.LC) {
            name = (String)name + " (" + status + ")";
        }
        if (this.queryResults != null && this.sortType == SortType.DEFAULT) {
            if (sighting == null) {
                sighting = this.queryResults.getBestSighting(taxon, this.sortType.ordering());
            }
            if (sighting != null) {
                name = SightingFlags.appendSightingInfo((String)name, sighting);
            }
        }
        boolean bl = isFamily = taxon.getType() == Taxon.Type.family;
        if (isFamily && this.queryResults != null && this.showFamilyTotals) {
            final HashSet speciesSet = Sets.newHashSet();
            TaxonUtils.visitTaxa(taxon, new TaxonVisitor(){

                @Override
                public boolean visitTaxon(Taxon child) {
                    if (ReportsBrowserPanel.this.queryResults.containsTaxonCountably(child)) {
                        Taxon species = TaxonUtils.getParentOfType(child, Taxon.Type.species);
                        speciesSet.add(species.getId());
                        return false;
                    }
                    return true;
                }
            });
            StringBuilder buffer = new StringBuilder((String)name);
            int speciesCount = TaxonUtils.countChildren(taxon, Taxon.Type.species, this.getChecklist(), this.queryPreferences.excludedChecklistStatuses());
            buffer.append(" (").append(speciesSet.size()).append("/").append(speciesCount).append(")");
            name = buffer.toString();
        }
        return name;
    }

    @Override
    protected boolean abbreviateGenus(Taxon taxon) {
        if (taxon.getType() != Taxon.Type.species) {
            return true;
        }
        Taxon genus = taxon.getParent();
        List<Taxon> speciesList = genus.getContents();
        for (int i = 0; i < speciesList.size(); ++i) {
            Taxon species = speciesList.get(i);
            if (species == taxon) {
                return false;
            }
            if (!this.queryResults.containsTaxon(species)) continue;
            return true;
        }
        throw new AssertionError((Object)"Never found species in its own parent");
    }

    @Override
    protected String convertResolvedToString(SightingTaxon.Resolved taxon, @Nullable Sighting sighting) {
        if (taxon.getType() == SightingTaxon.Type.SINGLE) {
            return this.convertTaxonToString(taxon.getTaxon(), sighting);
        }
        String name = taxon.getPreferredSingleName();
        if (this.queryResults != null && this.sortType == SortType.DEFAULT && sighting == null && (sighting = this.queryResults.getBestSighting(taxon, this.sortType.ordering())) != null) {
            name = SightingFlags.appendSightingInfo(name, sighting);
        }
        return name;
    }

    public QueryResults getQueryResults() {
        return this.queryResults;
    }

    public void setQueryResults(QueryResults queryResults, boolean showVisits) {
        this.setQueryResults(queryResults, showVisits, null, false);
    }

    public void setQueryResults(QueryResults queryResults, boolean showVisits, Collection<Trip> trips, boolean shortcutSingleSightingColumns) {
        this.setModel(new ReportsTreeModel(queryResults, this.getReportSet().getLocations(), showVisits, trips, shortcutSingleSightingColumns));
        this.queryResults = queryResults;
    }

    @Override
    public void setModel(TreeModel newModel) {
        super.setModel(newModel);
        this.queryResults = null;
    }

    @Override
    public void setTaxonomy(Taxonomy taxonomy) {
        this.saveCurrentPreview();
        super.setTaxonomy(taxonomy);
        this.queryResults = null;
    }

    public void setShowFamilyTotals(boolean showFamilyTotals) {
        this.showFamilyTotals = showFamilyTotals;
    }

    public void setShowSpeciesStatus(boolean showSpeciesStatus) {
        this.showSpeciesStatus = showSpeciesStatus;
    }

    @Override
    protected void doMove(SightingsGroup sightings) {
        ReportsTreeModel model = (ReportsTreeModel)this.getModel();
        TreePath path = sightings.getParentPath();
        TreePath parentPath = path.getParentPath();
        if (parentPath == null) {
            return;
        }
        int oldChildCount = model.getChildCount(parentPath.getLastPathComponent());
        int oldIndexOfChild = model.getIndexOfChild(path.getParentPath().getLastPathComponent(), path.getLastPathComponent());
        this.getReportSet().mutator().removing(sightings.getSightings()).mutate();
        this.queryResults.removeSightings(sightings.getSightings());
        model.invalidateState();
        int newChildCount = model.getChildCount(parentPath.getLastPathComponent());
        if (newChildCount >= oldChildCount) {
            if (newChildCount > oldChildCount) {
                logger.log(Level.WARNING, "Child count increased!  Was {0}, now {1}", new Object[]{oldChildCount, newChildCount});
            }
            model.sightingsRemoved(path, sightings.getSightings(), sightings.getOriginalIndices());
        } else if (newChildCount == oldChildCount - 2) {
            model.taxaRemoved(parentPath, ImmutableList.of("", path.getLastPathComponent()), ImmutableList.of(Integer.valueOf(oldIndexOfChild - 1), Integer.valueOf(oldIndexOfChild)));
        } else {
            model.taxaRemoved(parentPath, ImmutableList.of(path.getLastPathComponent()), ImmutableList.of(Integer.valueOf(oldIndexOfChild)));
        }
    }

    public void addSighting(TreePath path, Sighting sighting, boolean updateTaxaInQueryResults) {
        this.getReportSet().mutator().adding(ImmutableList.of(sighting)).mutate();
        ReportsTreeModel model = (ReportsTreeModel)this.getModel();
        model.sightingAdded(path, sighting, updateTaxaInQueryResults);
    }

    public void addTrip(Trip trip) {
        ReportsTreeModel model = (ReportsTreeModel)this.getModel();
        model.addTrip(trip);
    }

    public void addSightings(TreePath path, Collection<Sighting> sightings, boolean updateTaxaInQueryResults) {
        if (sightings.isEmpty()) {
            return;
        }
        this.getReportSet().mutator().adding(sightings).mutate();
        ReportsTreeModel model = (ReportsTreeModel)this.getModel();
        model.sightingsAdded(path, sightings, updateTaxaInQueryResults);
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        for (Sighting sighting : sightings) {
            if (model.getIndexOfChild(path.getLastPathComponent(), sighting) < 0) continue;
            paths.add(path.pathByAddingChild(sighting));
        }
        if (!paths.isEmpty()) {
            SwingUtilities.invokeLater(() -> {
                this.setSelectionPaths((TreePath[])paths.toArray(TreePath[]::new));
                this.requestFocus();
                this.scrollListSelectionsIntoView();
            });
        }
    }

    @Override
    protected boolean canImportSightings() {
        return false;
    }

    public Action getCutAction() {
        return this.reportsBrowserFocusTracker.cut;
    }

    @Override
    protected void sightingsReplaced(TreePath parent, List<Sighting> oldSightings, List<Sighting> newSightings, int[] oldIndices) {
        ((ReportsTreeModel)this.getModel()).sightingsReplaced(parent, oldSightings, newSightings, oldIndices);
    }

    @Override
    protected TreePath pathToSighting(TreePath oldParentPath, Sighting sighting) {
        ResolvedWithKey rwk;
        TreePath tripPath;
        VisitInfoKey visitInfoKey;
        TreeModel model = this.getModel();
        SightingTaxon.Resolved resolved = this.queryResults.resolveToType(sighting.getTaxon());
        if (oldParentPath.getLastPathComponent() instanceof ReportsTreeModel.VisitInfoKeyNode && (visitInfoKey = VisitInfoKey.forSighting(sighting)) != null) {
            ReportsTreeModel.VisitInfoKeyNode node = new ReportsTreeModel.VisitInfoKeyNode(visitInfoKey);
            TreePath pathToNode = model.getIndexOfChild(model.getRoot(), node) < 0 ? new TreePath(new Object[]{model.getRoot(), new ReportsTreeModel.VisitsNode(0), node}) : new TreePath(new Object[]{model.getRoot(), node});
            return pathToNode.pathByAddingChild(new ResolvedWithKey(resolved, visitInfoKey));
        }
        Trip trip = null;
        Object object = oldParentPath.getLastPathComponent();
        if (object instanceof ReportsTreeModel.TripNode) {
            ReportsTreeModel.TripNode tripNode = (ReportsTreeModel.TripNode)object;
            trip = tripNode.getTrip();
        } else if (oldParentPath.getParentPath() != null && (object = oldParentPath.getParentPath().getLastPathComponent()) instanceof ReportsTreeModel.TripNode) {
            ReportsTreeModel.TripNode tripNode = (ReportsTreeModel.TripNode)object;
            trip = tripNode.getTrip();
        }
        if (trip != null && (tripPath = this.pathToTrip(trip)) != null) {
            int childCount = this.getModel().getChildCount(tripPath.getLastPathComponent());
            for (int i = 0; i < childCount; ++i) {
                Object child = this.getModel().getChild(tripPath.getLastPathComponent(), i);
                if (!(child instanceof ResolvedWithKey) || !(rwk = (ResolvedWithKey)child).getResolved().equals(resolved)) continue;
                List<Sighting> rwkSightings = this.getSightingsForResolvedWithKey(rwk);
                if (rwkSightings.size() <= 1) {
                    return tripPath.pathByAddingChild(child);
                }
                return tripPath.pathByAddingChild(child).pathByAddingChild(sighting);
            }
        }
        int childCount = model.getChildCount(model.getRoot());
        for (int i = 0; i < childCount; ++i) {
            Object child = model.getChild(model.getRoot(), i);
            if (child instanceof ResolvedWithSighting) {
                ResolvedWithSighting rws = (ResolvedWithSighting)child;
                if (!rws.getResolved().equals(resolved)) continue;
                return new TreePath(new Object[]{model.getRoot(), child});
            }
            if (child instanceof ResolvedWithKey) {
                rwk = (ResolvedWithKey)child;
                if (!rwk.getResolved().equals(resolved)) continue;
                List<Sighting> rwkSightings = this.getSightingsForResolvedWithKey(rwk);
                if (rwkSightings.size() <= 1) {
                    return new TreePath(new Object[]{model.getRoot(), child});
                }
                return new TreePath(new Object[]{model.getRoot(), child, sighting});
            }
            if (!(child instanceof SightingTaxon.Resolved) || !resolved.equals(child)) continue;
            return new TreePath(new Object[]{model.getRoot(), child, sighting});
        }
        if (oldParentPath.getLastPathComponent() == model.getRoot()) {
            return new TreePath(new Object[]{this.getModel().getRoot(), new ResolvedWithSighting(resolved, sighting)});
        }
        return new TreePath(new Object[]{this.getModel().getRoot(), resolved, sighting});
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        super.fontsUpdated(fontManager);
        this.setFixedCellWidth(fontManager.scale(300));
    }

    public void setSeenTaxa(ScanSeenTaxa scanSeenTaxa) {
        this.scanSeenTaxa = scanSeenTaxa;
    }

    private Checklist getChecklist() {
        if (this.queryResults != null) {
            return this.queryResults.getChecklist(this.getTaxonomy());
        }
        return null;
    }

    public void setSortType(SortType sortType) {
        this.sortType = sortType;
    }

    @Override
    protected boolean allowLocationEditing() {
        return this.allowLocationEditing;
    }

    public void setLocationEditingAllowed(boolean allowLocationEditing) {
        this.allowLocationEditing = allowLocationEditing;
    }

    @Override
    protected VisitInfoPreferences getVisitInfoPreferences() {
        return this.visitInfoPreferences;
    }

    public void addVisitInfoKeyChangedListener(VisitInfoKeyChangedListener listener) {
        this.listenerList.add(VisitInfoKeyChangedListener.class, listener);
    }

    @Override
    protected void replaceVisitInfoKey(VisitInfoKey updatedVisitInfoKey) {
        for (VisitInfoKeyChangedListener listener : (VisitInfoKeyChangedListener[])this.getListeners(VisitInfoKeyChangedListener.class)) {
            listener.newVisitInfoKey(updatedVisitInfoKey);
        }
    }

    @Override
    protected void visitInfoKeyDeleted(VisitInfoKey deletedVisitInfo) {
        ((ReportsTreeModel)this.getModel()).removeVisitInfo(deletedVisitInfo);
        for (VisitInfoKeyChangedListener listener : (VisitInfoKeyChangedListener[])this.getListeners(VisitInfoKeyChangedListener.class)) {
            listener.deletedVisitInfoKey(deletedVisitInfo);
        }
    }

    @Override
    protected int getSightingIndex(Sighting sighting, TreePath parentPath) {
        return ((ReportsTreeModel)this.getModel()).getIndexOfSighting(parentPath.getLastPathComponent(), sighting);
    }

    public void invalidateSightings() {
        ((ReportsTreeModel)this.getModel()).invalidateState();
        TreePath selectionPath = this.getSelectionPath();
        if (selectionPath != null && (selectionPath.getLastPathComponent() instanceof Sighting || selectionPath.getLastPathComponent() instanceof ReportsTreeModel.VisitInfoKeyNode)) {
            this.setSelectionPath(selectionPath.getParentPath());
        }
    }

    public void selectVisitInfo(VisitInfoKey visitInfoKey) {
        TreePath treePath = this.pathToVisitInfoKey(visitInfoKey);
        if (treePath != null) {
            treePath = treePath.pathByAddingChild(visitInfoKey);
            this.setSelectionPath(treePath);
            this.scrollRectToVisible(this.getPathBounds(treePath));
        }
    }

    private TreePath pathToVisitInfoKey(VisitInfoKey visitInfoKey) {
        Object root = this.getModel().getRoot();
        ReportsTreeModel.VisitInfoKeyNode visitInfoKeyNode = new ReportsTreeModel.VisitInfoKeyNode(visitInfoKey);
        int visitInfoIndex = this.getModel().getIndexOfChild(root, visitInfoKeyNode);
        if (visitInfoIndex >= 0) {
            return new TreePath(new Object[]{root, visitInfoKeyNode});
        }
        ReportsTreeModel.VisitsNode dummyVisitNode = new ReportsTreeModel.VisitsNode(0);
        int visitNodeIndex = this.getModel().getIndexOfChild(root, dummyVisitNode);
        if (visitNodeIndex >= 0) {
            Object actualVisitNode = this.getModel().getChild(root, visitNodeIndex);
            visitInfoIndex = this.getModel().getIndexOfChild(actualVisitNode, visitInfoKeyNode);
            if (visitInfoIndex >= 0) {
                return new TreePath(new Object[]{root, actualVisitNode, visitInfoKeyNode});
            }
        }
        return null;
    }

    public void selectTrip(Trip trip) {
        TreePath treePath = this.pathToTrip(trip);
        if (treePath != null) {
            this.setSelectionPath(treePath);
            this.scrollRectToVisible(this.getPathBounds(treePath));
        }
    }

    private TreePath pathToTrip(Trip trip) {
        Object root = this.getModel().getRoot();
        ReportsTreeModel.TripNode tripNode = new ReportsTreeModel.TripNode(trip);
        int tripIndex = this.getModel().getIndexOfChild(root, tripNode);
        if (tripIndex >= 0) {
            return new TreePath(new Object[]{root, tripNode});
        }
        ReportsTreeModel.TripsNode dummyTripNode = new ReportsTreeModel.TripsNode(0);
        int tripNodeIndex = this.getModel().getIndexOfChild(root, dummyTripNode);
        if (tripNodeIndex >= 0) {
            Object actualTripsNode = this.getModel().getChild(root, tripNodeIndex);
            tripIndex = this.getModel().getIndexOfChild(actualTripsNode, tripNode);
            if (tripIndex >= 0) {
                return new TreePath(new Object[]{root, actualTripsNode, tripNode});
            }
        }
        return null;
    }

    public void selectTaxon(Taxon taxon) {
        if (this.getModel() == null) {
            return;
        }
        Object root = this.getModel().getRoot();
        TreePath treePath = null;
        if (this.getModel().getIndexOfChild(root, taxon) < 0) {
            SightingTaxon.Resolved resolved = SightingTaxons.newResolved(taxon);
            this.selectResolved(resolved);
            return;
        }
        treePath = new TreePath(new Object[]{root, taxon});
        if (treePath != null) {
            TreePath selectedTreePath = treePath;
            this.setSelectionPath(selectedTreePath);
            this.scrollListSelectionsIntoView();
        }
    }

    public void selectResolved(SightingTaxon.Resolved selectedTaxon) {
        if (this.getModel() == null) {
            return;
        }
        Object root = this.getModel().getRoot();
        TreePath treePath = null;
        int childCount = this.getModel().getChildCount(root);
        for (int i = 0; i < childCount; ++i) {
            ResolvedWithKey rwk;
            Object child = this.getModel().getChild(root, i);
            if (child instanceof SightingTaxon.Resolved) {
                SightingTaxon.Resolved resolved = (SightingTaxon.Resolved)child;
                if (!resolved.equals(selectedTaxon)) continue;
                treePath = new TreePath(new Object[]{root, child});
                break;
            }
            if (child instanceof ResolvedWithSighting) {
                ResolvedWithSighting rws = (ResolvedWithSighting)child;
                if (!rws.getResolved().equals(selectedTaxon)) continue;
                treePath = new TreePath(new Object[]{root, child});
                break;
            }
            if (!(child instanceof ResolvedWithKey) || !(rwk = (ResolvedWithKey)child).getResolved().equals(selectedTaxon)) continue;
            treePath = new TreePath(new Object[]{root, child});
            break;
        }
        if (treePath != null) {
            TreePath selectedTreePath = treePath;
            this.setSelectionPath(selectedTreePath);
            this.scrollListSelectionsIntoView();
        }
    }

    public boolean isVisitsParentNode(Object node) {
        if (!(node instanceof ReportsTreeModel.VisitsNode)) {
            return false;
        }
        return !this.getModel().isLeaf(node);
    }

    @Override
    protected String getReturnPanelName() {
        return this.returnPanelName;
    }

    public void setReturnPanelName(String returnPanelName) {
        this.returnPanelName = returnPanelName;
    }

    @Override
    protected BaseTaxonBrowserPanel.PostNavigateAction returnToSighting(TreePath oldParentPath, Sighting sighting) {
        return new ReturnToSighting(oldParentPath, sighting);
    }

    private class ReportsTransferHandler
    extends BaseTaxonBrowserPanel.TaxonTransferHandler {
        private ReportsTransferHandler() {
            super(ReportsBrowserPanel.this);
        }

        @Override
        public int getSourceActions(JComponent component) {
            if (ReportsBrowserPanel.this.canImportSightings()) {
                return ReportsBrowserPanel.this.canMoveSightings() ? 3 : 1;
            }
            return ReportsBrowserPanel.this.editableSightings ? (ReportsBrowserPanel.this.canMoveSightings() ? 3 : 1) : 0;
        }
    }

    private class ReportsBrowserFocusTracker
    extends FocusTracker {
        private final Action cut;
        private final Action copy;
        private final Action paste;

        public ReportsBrowserFocusTracker() {
            super(ReportsBrowserPanel.this);
            this.cut = new BaseTaxonBrowserPanel.CutActionWrapper(ReportsBrowserPanel.this, TransferHandler.getCutAction());
            this.copy = new BaseTaxonBrowserPanel.CopyActionWrapper(ReportsBrowserPanel.this, TransferHandler.getCopyAction());
            this.paste = new BaseTaxonBrowserPanel.PasteActionWrapper(ReportsBrowserPanel.this, TransferHandler.getPasteAction());
        }

        @Override
        protected void focusGained(Component child) {
            if (ReportsBrowserPanel.this.editableSightings) {
                ReportsBrowserPanel.this.actionBroker.publishAction("cut", this.cut);
                ReportsBrowserPanel.this.actionBroker.publishAction("copy", this.copy);
                ReportsBrowserPanel.this.actionBroker.publishAction("paste", this.paste);
            }
        }

        @Override
        protected void focusLost(Component child) {
            if (child instanceof JTextComponent) {
                return;
            }
            if (ReportsBrowserPanel.this.editableSightings) {
                ReportsBrowserPanel.this.actionBroker.unpublishAction("cut", this.cut);
                ReportsBrowserPanel.this.actionBroker.unpublishAction("copy", this.copy);
                ReportsBrowserPanel.this.actionBroker.unpublishAction("paste", this.paste);
            }
        }
    }

    public static interface VisitInfoKeyChangedListener
    extends EventListener {
        public void newVisitInfoKey(VisitInfoKey var1);

        public void deletedVisitInfoKey(VisitInfoKey var1);
    }

    static class ReturnToSighting
    implements BaseTaxonBrowserPanel.PostNavigateAction {
        private final Sighting sighting;
        private TreePath oldParentPath;

        public ReturnToSighting(TreePath oldParentPath, Sighting sighting) {
            this.oldParentPath = oldParentPath;
            this.sighting = sighting;
        }

        @Override
        public void postNavigate(JPanel panel) {
            ReportsBrowserPanel reportsBrowserPanel = UIUtils.findChildOfType(panel, ReportsBrowserPanel.class);
            if (reportsBrowserPanel != null) {
                Taxonomy taxonomy = reportsBrowserPanel.getTaxonomy();
                if (TaxonUtils.areCompatible(this.sighting.getTaxonomy(), taxonomy) && reportsBrowserPanel.queryResults != null) {
                    EventQueue.invokeLater(() -> {
                        TreePath pathToSelect;
                        block17: {
                            SightingTaxon.Resolved resolved = reportsBrowserPanel.queryResults.resolveToType(this.sighting.getTaxon());
                            Trip trip = null;
                            VisitInfoKey visitInfoKey = null;
                            for (TreePath oldPath = this.oldParentPath; oldPath != null; oldPath = oldPath.getParentPath()) {
                                Object patt38263$temp = oldPath.getLastPathComponent();
                                if (patt38263$temp instanceof ReportsTreeModel.TripNode) {
                                    ReportsTreeModel.TripNode tripNode = (ReportsTreeModel.TripNode)patt38263$temp;
                                    trip = tripNode.getTrip();
                                    break;
                                }
                                Object patt38443$temp = oldPath.getLastPathComponent();
                                if (!(patt38443$temp instanceof ReportsTreeModel.VisitInfoKeyNode)) continue;
                                ReportsTreeModel.VisitInfoKeyNode visitInfoKeyNode = (ReportsTreeModel.VisitInfoKeyNode)patt38443$temp;
                                visitInfoKey = visitInfoKeyNode.getVisitInfoKey();
                                break;
                            }
                            pathToSelect = null;
                            if (trip != null) {
                                pathToSelect = reportsBrowserPanel.pathToTrip(trip);
                                if (pathToSelect != null) {
                                    int childCount = reportsBrowserPanel.getModel().getChildCount(pathToSelect.getLastPathComponent());
                                    for (int i = 0; i < childCount; ++i) {
                                        List<Sighting> sightings;
                                        ResolvedWithKey rwk;
                                        Object child = reportsBrowserPanel.getModel().getChild(pathToSelect.getLastPathComponent(), i);
                                        if (child instanceof ResolvedWithSighting) {
                                            ResolvedWithSighting rws = (ResolvedWithSighting)child;
                                            if (!rws.getResolved().equals(resolved)) continue;
                                            pathToSelect = pathToSelect.pathByAddingChild(child);
                                            break;
                                        }
                                        if (!(child instanceof ResolvedWithKey) || !(rwk = (ResolvedWithKey)child).getResolved().equals(resolved)) continue;
                                        pathToSelect = pathToSelect.pathByAddingChild(child);
                                        VisitInfoKey visitKey = VisitInfoKey.forSighting(this.sighting);
                                        if (visitKey == null || (sightings = reportsBrowserPanel.getSightingsForResolvedWithKey(rwk)).size() <= 1) break;
                                        for (Sighting sighting : sightings) {
                                            if (!visitKey.equals(VisitInfoKey.forSighting(sighting))) continue;
                                            pathToSelect = pathToSelect.pathByAddingChild(sighting);
                                            break block17;
                                        }
                                        break;
                                    }
                                }
                            } else if (visitInfoKey != null) {
                                pathToSelect = reportsBrowserPanel.pathToVisitInfoKey(visitInfoKey);
                                if (pathToSelect != null) {
                                    int childCount = reportsBrowserPanel.getModel().getChildCount(pathToSelect.getLastPathComponent());
                                    for (int i = 0; i < childCount; ++i) {
                                        ResolvedWithSighting rws;
                                        Object child = reportsBrowserPanel.getModel().getChild(pathToSelect.getLastPathComponent(), i);
                                        if (!(child instanceof ResolvedWithSighting) || !(rws = (ResolvedWithSighting)child).getResolved().equals(resolved)) continue;
                                        pathToSelect = pathToSelect.pathByAddingChild(child);
                                        break;
                                    }
                                }
                            } else {
                                TreePath path;
                                Taxon finalTaxon = resolved.getTaxa().iterator().next();
                                reportsBrowserPanel.selectTaxon(finalTaxon);
                                reportsBrowserPanel.requestFocusInWindow();
                                VisitInfoKey visitKey = VisitInfoKey.forSighting(this.sighting);
                                if (visitKey != null && (path = reportsBrowserPanel.getSelectionPath()) != null) {
                                    int childCount = reportsBrowserPanel.getModel().getChildCount(path.getLastPathComponent());
                                    for (int i = 0; i < childCount; ++i) {
                                        Object child = reportsBrowserPanel.getModel().getChild(path.getLastPathComponent(), i);
                                        if (child instanceof Sighting) {
                                            Sighting childSighting = (Sighting)child;
                                            if (!visitKey.equals(VisitInfoKey.forSighting(childSighting)) && (this.sighting.getTrip() == null || this.sighting.getTrip() != childSighting.getTrip())) continue;
                                            pathToSelect = path.pathByAddingChild(childSighting);
                                        } else {
                                            ResolvedWithSighting resolvedWithSighting;
                                            if (!(child instanceof ResolvedWithSighting) || !visitKey.equals(VisitInfoKey.forSighting((resolvedWithSighting = (ResolvedWithSighting)child).getSighting())) && (this.sighting.getTrip() == null || this.sighting.getTrip() != resolvedWithSighting.getSighting().getTrip())) continue;
                                            pathToSelect = path.pathByAddingChild(resolvedWithSighting);
                                        }
                                        break;
                                    }
                                }
                            }
                        }
                        if (pathToSelect != null) {
                            reportsBrowserPanel.setSelectionPath(pathToSelect);
                            reportsBrowserPanel.scrollListSelectionsIntoView();
                            reportsBrowserPanel.requestFocusInWindow();
                        }
                    });
                }
            }
        }
    }
}

