/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Trip;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.taxa.names.NamesPreferences;
import com.scythebill.birdlist.ui.events.TaxonomyStore;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.guice.Clements;
import com.scythebill.birdlist.ui.imports.ImportPreferences;
import com.scythebill.birdlist.ui.panels.reports.BirdTrackExportAction;
import com.scythebill.birdlist.ui.panels.reports.EbirdExportAction;
import com.scythebill.birdlist.ui.panels.reports.FamilyReportDialog;
import com.scythebill.birdlist.ui.panels.reports.INaturalistExportAction;
import com.scythebill.birdlist.ui.panels.reports.PrintAction;
import com.scythebill.birdlist.ui.panels.reports.QueryExecutor;
import com.scythebill.birdlist.ui.panels.reports.QueryPreferences;
import com.scythebill.birdlist.ui.panels.reports.ReportPrintDialog;
import com.scythebill.birdlist.ui.panels.reports.ReportXlsDialog;
import com.scythebill.birdlist.ui.panels.reports.SaveAsFamilyReportAction;
import com.scythebill.birdlist.ui.panels.reports.SaveAsTripReportAction;
import com.scythebill.birdlist.ui.panels.reports.SaveAsXlsAction;
import com.scythebill.birdlist.ui.panels.reports.ScythebillCsvExportAction;
import com.scythebill.birdlist.ui.panels.reports.TripReportDialog;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.FileDialogs;
import java.awt.event.ActionListener;
import java.io.File;
import javax.annotation.Nullable;
import javax.swing.Action;

public class ReportsActionFactory {
    private final FileDialogs fileDialogs;
    private final ReportSet reportSet;
    private final TaxonomyStore taxonomyStore;
    private final String fileName;
    private final Taxonomy clements;
    private final Alerts alerts;
    private final ReportXlsDialog reportXlsDialog;
    private final Provider<TripReportDialog> tripReportDialog;
    private final ReportPrintDialog reportPrintDialog;
    private final FontManager fontManager;
    private final QueryPreferences queryPreferences;
    private final NamesPreferences namesPreferences;
    private final FamilyReportDialog familyReportDialog;
    private final Checklists checklists;
    private final ImportPreferences importPreferences;

    @Inject
    public ReportsActionFactory(FileDialogs fileDialogs, ReportSet reportSet, TaxonomyStore taxonomyStore, @Clements Taxonomy clements, File reportSetFile, Alerts alerts, FontManager fontManager, ReportXlsDialog reportXlsDialog, ReportPrintDialog reportPrintDialog, Provider<TripReportDialog> tripReportDialog, FamilyReportDialog familyReportDialog, QueryPreferences queryPreferences, NamesPreferences namesPreferences, ImportPreferences importPreferences, Checklists checklists) {
        this.fileDialogs = fileDialogs;
        this.reportSet = reportSet;
        this.taxonomyStore = taxonomyStore;
        this.clements = clements;
        this.alerts = alerts;
        this.fontManager = fontManager;
        this.reportXlsDialog = reportXlsDialog;
        this.reportPrintDialog = reportPrintDialog;
        this.tripReportDialog = tripReportDialog;
        this.familyReportDialog = familyReportDialog;
        this.queryPreferences = queryPreferences;
        this.namesPreferences = namesPreferences;
        this.importPreferences = importPreferences;
        this.checklists = checklists;
        String fileName = reportSetFile.getName();
        if (fileName.lastIndexOf(46) > 0) {
            fileName = fileName.substring(0, fileName.lastIndexOf(46));
        }
        this.fileName = fileName;
    }

    public Action saveAsXls(QueryExecutor queryExecutor) {
        return new SaveAsXlsAction(this.fileDialogs, this.reportSet, queryExecutor, this.alerts, this.reportXlsDialog);
    }

    public Action ebirdExport(QueryExecutor queryExecutor) {
        return new EbirdExportAction(this.fileDialogs, this.reportSet, queryExecutor, this.clements, this.alerts);
    }

    public Action iNaturalistExport(QueryExecutor queryExecutor) {
        return new INaturalistExportAction(this.fileDialogs, this.reportSet, queryExecutor, this.taxonomyStore.getTaxonomy().isBuiltIn() ? this.taxonomyStore.getClements() : this.taxonomyStore.getTaxonomy(), this.importPreferences, this.alerts);
    }

    public Action birdTrackExport(QueryExecutor queryExecutor) {
        return new BirdTrackExportAction(this.fileDialogs, this.reportSet, queryExecutor, this.namesPreferences, this.importPreferences, this.taxonomyStore.getTaxonomy().isBuiltIn() ? this.taxonomyStore.getIoc() : this.taxonomyStore.getTaxonomy(), this.alerts);
    }

    public Action print(QueryExecutor queryExecutor) {
        return new PrintAction(this.fileName, this.reportSet, this.taxonomyStore, queryExecutor, this.alerts, this.reportPrintDialog);
    }

    public ActionListener saveAsScythebill(QueryExecutor queryExecutor) {
        return new ScythebillCsvExportAction(this.fileDialogs, this.reportSet, this.fileName, this.taxonomyStore, queryExecutor, this.importPreferences, this.alerts);
    }

    public Action saveAsTripReport(QueryExecutor queryExecutor, @Nullable Iterable<Trip> trips) {
        return new SaveAsTripReportAction(this.reportSet, queryExecutor, this.alerts, this.tripReportDialog, trips, this.fontManager);
    }

    public Action saveAsFamilyReport(QueryExecutor queryExecutor) {
        return new SaveAsFamilyReportAction(queryExecutor, this.alerts, this.familyReportDialog, this.fontManager, this.reportSet, this.taxonomyStore.getTaxonomy(), this.queryPreferences, this.checklists);
    }
}

