/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.taxa.names.NamesPreferences;
import com.scythebill.birdlist.ui.components.AutoSelectJFormattedTextField;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.reports.ReportSpreadsheetPreferences;
import com.scythebill.birdlist.ui.panels.reports.SortType;
import com.scythebill.birdlist.ui.panels.reports.UserOutput;
import com.scythebill.birdlist.ui.util.Alerts;
import java.awt.Component;
import javax.annotation.Nullable;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.text.NumberFormatter;

class ReportXlsDialog {
    private Alerts alerts;
    private ReportSpreadsheetPreferences reportSpreadsheetPreferences;
    private FontManager fontManager;
    private NamesPreferences namesPreferences;
    private ReportSet reportSet;

    @Inject
    ReportXlsDialog(ReportSet reportSet, Alerts alerts, ReportSpreadsheetPreferences reportSpreadsheetPreferences, NamesPreferences namesPreferences, FontManager fontManager) {
        this.reportSet = reportSet;
        this.alerts = alerts;
        this.reportSpreadsheetPreferences = reportSpreadsheetPreferences;
        this.namesPreferences = namesPreferences;
        this.fontManager = fontManager;
    }

    @Nullable
    public ReportSpreadsheetPreferences getConfiguration(Component parent, boolean allowOtherTaxonomies) {
        XlsConfigurationPanel panel = new XlsConfigurationPanel(allowOtherTaxonomies);
        this.fontManager.applyTo(panel);
        String formattedMessage = this.alerts.getFormattedDialogMessage(Messages.Name.SPREADSHEET_OPTIONS, Messages.Name.SPREADSHEET_OPTIONS_MESSAGE, new Object[0]);
        int okCancel = this.alerts.showOkCancelWithPanel(SwingUtilities.getWindowAncestor(parent), formattedMessage, panel);
        if (okCancel != 0) {
            return null;
        }
        panel.updatePreferences();
        return this.reportSpreadsheetPreferences;
    }

    public NamesPreferences.ScientificOrCommon getScientificOrCommonFromConfiguration(ReportSpreadsheetPreferences prefs) {
        NamesPreferences.ScientificOrCommon scientificOrCommon = this.namesPreferences.scientificOrCommon;
        if (prefs.includeScientific) {
            if (scientificOrCommon == NamesPreferences.ScientificOrCommon.COMMON_ONLY) {
                return NamesPreferences.ScientificOrCommon.COMMON_FIRST;
            }
        } else {
            switch (scientificOrCommon) {
                case SCIENTIFIC_ONLY: 
                case COMMON_FIRST: 
                case SCIENTIFIC_FIRST: {
                    return NamesPreferences.ScientificOrCommon.COMMON_ONLY;
                }
            }
        }
        return scientificOrCommon;
    }

    class XlsConfigurationPanel
    extends JPanel {
        private JCheckBox includeScientific;
        private JCheckBox showFamilies;
        private JCheckBox showNotes;
        private AutoSelectJFormattedTextField maximumSightings;
        private JCheckBox showStatus;
        private JComboBox<SortType> sortSpeciesBy;
        private JComboBox<SortType> sortSightingsBy;
        private JCheckBox onlyCountable;
        private JCheckBox omitSpAndHybrid;
        private JComboBox<UserOutput> userOutput;
        private JCheckBox showAllTaxonomies;

        XlsConfigurationPanel(boolean allowOtherTaxonomies) {
            this.setBorder(new EmptyBorder(ReportXlsDialog.this.fontManager.scale(20), 0, 0, 0));
            GroupLayout layout = new GroupLayout(this);
            this.setLayout(layout);
            this.includeScientific = new JCheckBox(Messages.getMessage(Messages.Name.SCIENTIFIC_NAME_QUESTION));
            this.includeScientific.setSelected(ReportXlsDialog.this.reportSpreadsheetPreferences.includeScientific);
            if (ReportXlsDialog.this.namesPreferences.scientificOrCommon == NamesPreferences.ScientificOrCommon.COMMON_ONLY) {
                this.includeScientific.setSelected(false);
            } else if (ReportXlsDialog.this.namesPreferences.scientificOrCommon == NamesPreferences.ScientificOrCommon.SCIENTIFIC_ONLY) {
                this.includeScientific.setSelected(true);
            }
            this.showFamilies = new JCheckBox(Messages.getMessage(Messages.Name.SHOW_FAMILIES_QUESTION));
            this.showFamilies.setSelected(ReportXlsDialog.this.reportSpreadsheetPreferences.showFamilies);
            this.showStatus = new JCheckBox(Messages.getMessage(Messages.Name.SHOW_THREATENED_STATUS_QUESTION));
            this.showStatus.setSelected(ReportXlsDialog.this.reportSpreadsheetPreferences.showStatus);
            this.showNotes = new JCheckBox(Messages.getMessage(Messages.Name.SHOW_NOTES_COUNT_ETC_QUESTION));
            this.showNotes.setSelected(ReportXlsDialog.this.reportSpreadsheetPreferences.showNotes);
            this.showAllTaxonomies = new JCheckBox(Messages.getMessage(Messages.Name.INCLUDE_ALL_TAXONOMIES_QUESTION));
            this.showAllTaxonomies.setSelected(ReportXlsDialog.this.reportSpreadsheetPreferences.showAllTaxonomies);
            this.showAllTaxonomies.setEnabled(allowOtherTaxonomies);
            this.onlyCountable = new JCheckBox(Messages.getMessage(Messages.Name.ONLY_COUNTABLE_SIGHTINGS_QUESTION));
            this.onlyCountable.setSelected(ReportXlsDialog.this.reportSpreadsheetPreferences.onlyCountable);
            this.omitSpAndHybrid = new JCheckBox(Messages.getMessage(Messages.Name.OMIT_SP_AND_HYBRID_QUESTION));
            this.omitSpAndHybrid.setSelected(ReportXlsDialog.this.reportSpreadsheetPreferences.omitSpAndHybrid);
            NumberFormatter numberFormatter = new NumberFormatter();
            numberFormatter.setValueClass(Integer.class);
            numberFormatter.setMinimum(Integer.valueOf(0));
            numberFormatter.setMaximum(Integer.valueOf(100));
            this.maximumSightings = new AutoSelectJFormattedTextField(numberFormatter);
            this.maximumSightings.setColumns(3);
            this.maximumSightings.setValue(ReportXlsDialog.this.reportSpreadsheetPreferences.maximumSightings);
            JLabel maximumSightingsLabel = new JLabel(Messages.getMessage(Messages.Name.HOW_MANY_SIGHTINGS_QUESTION));
            this.sortSpeciesBy = new JComboBox<SortType>(SortType.values());
            JLabel sortSpeciesByLabel = new JLabel(Messages.getMessage(Messages.Name.SORT_SPECIES_BY));
            this.sortSpeciesBy.setSelectedItem((Object)ReportXlsDialog.this.reportSpreadsheetPreferences.sortType);
            this.showFamilies.setEnabled(this.sortSpeciesBy.getSelectedItem() == SortType.DEFAULT);
            this.sortSpeciesBy.addActionListener(e -> this.showFamilies.setEnabled(this.sortSpeciesBy.getSelectedItem() == SortType.DEFAULT));
            JLabel userOutputLabel = new JLabel(Messages.getMessage(Messages.Name.SHOW_OBSERVERS_QUESTION));
            this.userOutput = new JComboBox<UserOutput>(UserOutput.values());
            this.userOutput.setSelectedItem((Object)ReportXlsDialog.this.reportSpreadsheetPreferences.userOutput);
            userOutputLabel.setVisible(ReportXlsDialog.this.reportSet.getUserSet() != null);
            this.userOutput.setVisible(ReportXlsDialog.this.reportSet.getUserSet() != null);
            JLabel sortSightingsByLabel = new JLabel(Messages.getMessage(Messages.Name.SORT_SIGHTINGS_BY));
            this.sortSightingsBy = new JComboBox<SortType>(SortType.values());
            this.sortSightingsBy.setSelectedItem((Object)ReportXlsDialog.this.reportSpreadsheetPreferences.sortSightingsType);
            JLabel whatData = new JLabel(Messages.getMessage(Messages.Name.WHAT_DATA_QUESTION));
            JLabel whichSpecies = new JLabel(Messages.getMessage(Messages.Name.WHICH_SPECIES_QUESTION));
            JLabel whichSightings = new JLabel(Messages.getMessage(Messages.Name.WHICH_SIGHTINGS_QUESTION));
            this.showFamilies.setEnabled(this.sortSpeciesBy.getSelectedItem() == SortType.DEFAULT);
            this.sortSightingsBy.setEnabled(this.sortSpeciesBy.getSelectedItem() == SortType.DEFAULT);
            sortSightingsByLabel.setEnabled(this.sortSpeciesBy.getSelectedItem() == SortType.DEFAULT);
            this.sortSpeciesBy.addActionListener(e -> {
                this.showFamilies.setEnabled(this.sortSpeciesBy.getSelectedItem() == SortType.DEFAULT);
                this.sortSightingsBy.setEnabled(this.sortSpeciesBy.getSelectedItem() == SortType.DEFAULT);
                sortSightingsByLabel.setEnabled(this.sortSpeciesBy.getSelectedItem() == SortType.DEFAULT);
            });
            Box whichSpeciesOptions = Box.createVerticalBox();
            whichSpeciesOptions.add(this.onlyCountable);
            whichSpeciesOptions.add(this.omitSpAndHybrid);
            JPanel whichSightingsOptions = new JPanel();
            GroupLayout whichSightingsLayout = new GroupLayout(whichSightingsOptions);
            whichSightingsLayout.setHorizontalGroup(whichSightingsLayout.createParallelGroup().addComponent(maximumSightingsLabel).addComponent(this.maximumSightings, -2, -2, -2));
            whichSightingsLayout.setVerticalGroup(whichSightingsLayout.createSequentialGroup().addComponent(maximumSightingsLabel).addComponent(this.maximumSightings, -2, -2, -2));
            whichSightingsOptions.setLayout(whichSightingsLayout);
            layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(whatData).addComponent(this.includeScientific).addComponent(this.showFamilies).addComponent(this.showStatus).addComponent(this.showNotes).addComponent(this.showAllTaxonomies).addComponent(userOutputLabel).addComponent(this.userOutput, -2, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup().addComponent(whichSpecies).addComponent(whichSpeciesOptions).addComponent(sortSpeciesByLabel).addComponent(this.sortSpeciesBy, -2, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup().addComponent(whichSightings).addComponent(whichSightingsOptions).addComponent(sortSightingsByLabel).addComponent(this.sortSightingsBy, -2, -2, -2)));
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(whatData).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.includeScientific).addComponent(this.showFamilies).addComponent(this.showStatus).addComponent(this.showNotes).addComponent(this.showAllTaxonomies).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(userOutputLabel).addComponent(this.userOutput)).addGroup(layout.createSequentialGroup().addComponent(whichSpecies).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(whichSpeciesOptions).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(sortSpeciesByLabel).addComponent(this.sortSpeciesBy, -2, -2, -2)).addGroup(layout.createSequentialGroup().addComponent(whichSightings).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(whichSightingsOptions).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(sortSightingsByLabel).addComponent(this.sortSightingsBy, -2, -2, -2)));
            layout.linkSize(1, whichSightingsOptions, whichSpeciesOptions);
        }

        void updatePreferences() {
            ReportXlsDialog.this.reportSpreadsheetPreferences.includeScientific = this.includeScientific.isSelected();
            ReportXlsDialog.this.reportSpreadsheetPreferences.showFamilies = this.showFamilies.isSelected();
            ReportXlsDialog.this.reportSpreadsheetPreferences.showStatus = this.showStatus.isSelected();
            ReportXlsDialog.this.reportSpreadsheetPreferences.showNotes = this.showNotes.isSelected();
            ReportXlsDialog.this.reportSpreadsheetPreferences.showAllTaxonomies = this.showAllTaxonomies.isSelected();
            ReportXlsDialog.this.reportSpreadsheetPreferences.onlyCountable = this.onlyCountable.isSelected();
            ReportXlsDialog.this.reportSpreadsheetPreferences.omitSpAndHybrid = this.omitSpAndHybrid.isSelected();
            ReportXlsDialog.this.reportSpreadsheetPreferences.maximumSightings = (Integer)this.maximumSightings.getValue();
            ReportXlsDialog.this.reportSpreadsheetPreferences.sortType = (SortType)((Object)this.sortSpeciesBy.getSelectedItem());
            ReportXlsDialog.this.reportSpreadsheetPreferences.sortSightingsType = (SortType)((Object)this.sortSightingsBy.getSelectedItem());
            ReportXlsDialog.this.reportSpreadsheetPreferences.userOutput = (UserOutput)((Object)this.userOutput.getSelectedItem());
        }
    }
}

