/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.inject.Inject;
import com.scythebill.birdlist.model.taxa.names.NamesPreferences;
import com.scythebill.birdlist.ui.components.AutoSelectJFormattedTextField;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.reports.ReportPrintPreferences;
import com.scythebill.birdlist.ui.panels.reports.SortType;
import com.scythebill.birdlist.ui.util.Alerts;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.annotation.Nullable;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.text.NumberFormatter;

class ReportPrintDialog {
    private Alerts alerts;
    private ReportPrintPreferences reportPrintPreferences;
    private FontManager fontManager;
    private NamesPreferences namesPreferences;

    @Inject
    ReportPrintDialog(Alerts alerts, ReportPrintPreferences reportPrintPreferences, NamesPreferences namesPreferences, FontManager fontManager) {
        this.alerts = alerts;
        this.reportPrintPreferences = reportPrintPreferences;
        this.namesPreferences = namesPreferences;
        this.fontManager = fontManager;
    }

    @Nullable
    public ReportPrintPreferences getConfiguration(Component parent) {
        PrintConfigurationPanel panel = new PrintConfigurationPanel();
        this.fontManager.applyTo(panel);
        String formattedMessage = this.alerts.getFormattedDialogMessage(Messages.Name.PRINT_OPTIONS_TITLE, Messages.Name.PRINT_OPTIONS_MESSAGE, new Object[0]);
        int okCancel = this.alerts.showOkCancelWithPanel(SwingUtilities.getWindowAncestor(parent), formattedMessage, panel);
        if (okCancel != 0) {
            return null;
        }
        panel.updatePreferences();
        return this.reportPrintPreferences;
    }

    public NamesPreferences.ScientificOrCommon getScientificOrCommonFromConfiguration(ReportPrintPreferences prefs) {
        NamesPreferences.ScientificOrCommon scientificOrCommon = this.namesPreferences.scientificOrCommon;
        if (prefs.includeScientific) {
            if (scientificOrCommon == NamesPreferences.ScientificOrCommon.COMMON_ONLY) {
                return NamesPreferences.ScientificOrCommon.COMMON_FIRST;
            }
        } else {
            switch (scientificOrCommon) {
                case SCIENTIFIC_ONLY: 
                case COMMON_FIRST: 
                case SCIENTIFIC_FIRST: {
                    return NamesPreferences.ScientificOrCommon.COMMON_ONLY;
                }
            }
        }
        return scientificOrCommon;
    }

    class PrintConfigurationPanel
    extends JPanel {
        private JCheckBox includeScientific;
        private JCheckBox showFamilies;
        private AutoSelectJFormattedTextField maximumSightings;
        private JCheckBox showStatus;
        private JComboBox<SortType> sortSpeciesBy;
        private JComboBox<SortType> sortSightingsBy;
        private JCheckBox compactPrinting;
        private JCheckBox onlyCountable;
        private JCheckBox omitSpAndHybrid;
        private JLabel maximumSightingsLabel;

        PrintConfigurationPanel() {
            this.setBorder(new EmptyBorder(ReportPrintDialog.this.fontManager.scale(20), 0, 0, 0));
            GroupLayout layout = new GroupLayout(this);
            this.setLayout(layout);
            this.includeScientific = new JCheckBox(Messages.getMessage(Messages.Name.SCIENTIFIC_NAME_QUESTION));
            this.includeScientific.setSelected(ReportPrintDialog.this.reportPrintPreferences.includeScientific);
            if (ReportPrintDialog.this.namesPreferences.scientificOrCommon == NamesPreferences.ScientificOrCommon.COMMON_ONLY) {
                this.includeScientific.setSelected(false);
            } else if (ReportPrintDialog.this.namesPreferences.scientificOrCommon == NamesPreferences.ScientificOrCommon.SCIENTIFIC_ONLY) {
                this.includeScientific.setSelected(true);
            }
            this.showFamilies = new JCheckBox(Messages.getMessage(Messages.Name.SHOW_FAMILIES_QUESTION));
            this.showFamilies.setSelected(ReportPrintDialog.this.reportPrintPreferences.showFamilies);
            this.showStatus = new JCheckBox(Messages.getMessage(Messages.Name.SHOW_THREATENED_STATUS_QUESTION));
            this.showStatus.setSelected(ReportPrintDialog.this.reportPrintPreferences.showStatus);
            this.compactPrinting = new JCheckBox(Messages.getMessage(Messages.Name.COMPACT_PRINT_QUESTION));
            this.compactPrinting.setSelected(ReportPrintDialog.this.reportPrintPreferences.compactPrinting);
            this.compactPrinting.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PrintConfigurationPanel.this.maximumSightingsLabel.setEnabled(!PrintConfigurationPanel.this.compactPrinting.isSelected());
                    PrintConfigurationPanel.this.maximumSightings.setEnabled(!PrintConfigurationPanel.this.compactPrinting.isSelected());
                }
            });
            this.onlyCountable = new JCheckBox(Messages.getMessage(Messages.Name.ONLY_COUNTABLE_SIGHTINGS_QUESTION));
            this.onlyCountable.setSelected(ReportPrintDialog.this.reportPrintPreferences.onlyCountable);
            this.omitSpAndHybrid = new JCheckBox(Messages.getMessage(Messages.Name.OMIT_SP_AND_HYBRID_QUESTION));
            this.omitSpAndHybrid.setSelected(ReportPrintDialog.this.reportPrintPreferences.omitSpAndHybrid);
            NumberFormatter numberFormatter = new NumberFormatter();
            numberFormatter.setValueClass(Integer.class);
            numberFormatter.setMinimum(Integer.valueOf(0));
            numberFormatter.setMaximum(Integer.valueOf(100));
            this.maximumSightings = new AutoSelectJFormattedTextField(numberFormatter);
            this.maximumSightings.setColumns(3);
            this.maximumSightings.setValue(ReportPrintDialog.this.reportPrintPreferences.maximumSightings);
            this.maximumSightingsLabel = new JLabel(Messages.getMessage(Messages.Name.HOW_MANY_SIGHTINGS_QUESTION));
            this.sortSpeciesBy = new JComboBox<SortType>(SortType.values());
            JLabel sortSpeciesByLabel = new JLabel(Messages.getMessage(Messages.Name.SORT_SPECIES_BY));
            this.sortSpeciesBy.setSelectedItem((Object)ReportPrintDialog.this.reportPrintPreferences.sortType);
            JLabel sortSightingsByLabel = new JLabel(Messages.getMessage(Messages.Name.SORT_SIGHTINGS_BY));
            this.sortSightingsBy = new JComboBox<SortType>(SortType.values());
            this.sortSightingsBy.setSelectedItem((Object)ReportPrintDialog.this.reportPrintPreferences.sortSightingsType);
            Box whichSpeciesOptions = Box.createVerticalBox();
            whichSpeciesOptions.add(this.onlyCountable);
            whichSpeciesOptions.add(this.omitSpAndHybrid);
            this.showFamilies.setEnabled(this.sortSpeciesBy.getSelectedItem() == SortType.DEFAULT);
            this.sortSpeciesBy.addActionListener(e -> this.showFamilies.setEnabled(this.sortSpeciesBy.getSelectedItem() == SortType.DEFAULT));
            JLabel whatData = new JLabel(Messages.getMessage(Messages.Name.WHAT_DATA_QUESTION));
            JLabel whichSpecies = new JLabel(Messages.getMessage(Messages.Name.WHICH_SPECIES_QUESTION));
            JLabel whichSightings = new JLabel(Messages.getMessage(Messages.Name.WHICH_SIGHTINGS_QUESTION));
            ActionListener nonCompactAndDefaultSpeciesSortOnly = e -> {
                boolean enabled = !this.compactPrinting.isSelected() && this.sortSpeciesBy.getSelectedItem() == SortType.DEFAULT;
                this.sortSightingsBy.setEnabled(enabled);
                sortSightingsByLabel.setEnabled(enabled);
                this.maximumSightings.setEnabled(enabled);
                this.maximumSightingsLabel.setEnabled(enabled);
                whichSightings.setEnabled(enabled);
            };
            this.sortSpeciesBy.addActionListener(nonCompactAndDefaultSpeciesSortOnly);
            this.compactPrinting.addActionListener(nonCompactAndDefaultSpeciesSortOnly);
            nonCompactAndDefaultSpeciesSortOnly.actionPerformed(null);
            JPanel whichSightingsOptions = new JPanel();
            GroupLayout whichSightingsLayout = new GroupLayout(whichSightingsOptions);
            whichSightingsLayout.setHorizontalGroup(whichSightingsLayout.createParallelGroup().addComponent(this.maximumSightingsLabel).addComponent(this.maximumSightings, -2, -2, -2));
            whichSightingsLayout.setVerticalGroup(whichSightingsLayout.createSequentialGroup().addComponent(this.maximumSightingsLabel).addComponent(this.maximumSightings, -2, -2, -2));
            whichSightingsOptions.setLayout(whichSightingsLayout);
            layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(whatData).addComponent(this.compactPrinting).addComponent(this.includeScientific).addComponent(this.showFamilies).addComponent(this.showStatus)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup().addComponent(whichSpecies).addComponent(whichSpeciesOptions).addComponent(sortSpeciesByLabel).addComponent(this.sortSpeciesBy, -2, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup().addComponent(whichSightings).addComponent(whichSightingsOptions).addComponent(sortSightingsByLabel).addComponent(this.sortSightingsBy, -2, -2, -2)));
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(whatData).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.compactPrinting).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.includeScientific).addComponent(this.showFamilies).addComponent(this.showStatus)).addGroup(layout.createSequentialGroup().addComponent(whichSpecies).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(whichSpeciesOptions).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(sortSpeciesByLabel).addComponent(this.sortSpeciesBy, -2, -2, -2)).addGroup(layout.createSequentialGroup().addComponent(whichSightings).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(whichSightingsOptions).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(sortSightingsByLabel).addComponent(this.sortSightingsBy, -2, -2, -2)));
            layout.linkSize(1, whichSightingsOptions, whichSpeciesOptions);
        }

        void updatePreferences() {
            ReportPrintDialog.this.reportPrintPreferences.includeScientific = this.includeScientific.isSelected();
            ReportPrintDialog.this.reportPrintPreferences.showFamilies = this.showFamilies.isSelected();
            ReportPrintDialog.this.reportPrintPreferences.showStatus = this.showStatus.isSelected();
            ReportPrintDialog.this.reportPrintPreferences.compactPrinting = this.compactPrinting.isSelected();
            ReportPrintDialog.this.reportPrintPreferences.onlyCountable = this.onlyCountable.isSelected();
            ReportPrintDialog.this.reportPrintPreferences.omitSpAndHybrid = this.omitSpAndHybrid.isSelected();
            ReportPrintDialog.this.reportPrintPreferences.maximumSightings = (Integer)this.maximumSightings.getValue();
            ReportPrintDialog.this.reportPrintPreferences.sortType = (SortType)((Object)this.sortSpeciesBy.getSelectedItem());
            ReportPrintDialog.this.reportPrintPreferences.sortSightingsType = (SortType)((Object)this.sortSightingsBy.getSelectedItem());
        }
    }
}

