/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.scythebill.birdlist.model.annotations.Preference;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.query.SightingPredicates;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingInfo;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.panels.reports.UndescribedTaxa;
import javax.annotation.Nullable;

public final class QueryPreferences {
    @Preference
    public boolean countIntroduced = true;
    @Preference
    public boolean countHeardOnly = true;
    @Preference
    public boolean countUndescribed = false;
    @Preference
    public boolean countRestrained = false;
    private final UndescribedTaxa undescribedTaxa;
    private static final Predicate<Sighting> DEFAULT_COUNTABLE_POPULATION_STATUS = Predicates.not(SightingPredicates.sightingStatusIsIn(ImmutableSet.of(SightingInfo.SightingStatus.INTRODUCED_NOT_ESTABLISHED, SightingInfo.SightingStatus.ID_UNCERTAIN, SightingInfo.SightingStatus.UNSATISFACTORY_VIEWS, SightingInfo.SightingStatus.DEAD, SightingInfo.SightingStatus.NOT_BY_ME, SightingInfo.SightingStatus.SIGNS, new SightingInfo.SightingStatus[]{SightingInfo.SightingStatus.DOMESTIC, SightingInfo.SightingStatus.RESTRAINED})));
    private static final Predicate<Sighting> COUNTABLE_POPULATION_STATUS_YES_RESTRAINED = Predicates.not(SightingPredicates.sightingStatusIsIn(ImmutableSet.of(SightingInfo.SightingStatus.INTRODUCED_NOT_ESTABLISHED, SightingInfo.SightingStatus.ID_UNCERTAIN, SightingInfo.SightingStatus.UNSATISFACTORY_VIEWS, SightingInfo.SightingStatus.DEAD, SightingInfo.SightingStatus.NOT_BY_ME, SightingInfo.SightingStatus.SIGNS, new SightingInfo.SightingStatus[]{SightingInfo.SightingStatus.DOMESTIC})));
    private static final Predicate<Sighting> NO_INTRODUCED_COUNTABLE_POPULATION_STATUS = Predicates.not(SightingPredicates.sightingStatusIsIn(ImmutableSet.of(SightingInfo.SightingStatus.INTRODUCED_NOT_ESTABLISHED, SightingInfo.SightingStatus.INTRODUCED, SightingInfo.SightingStatus.ID_UNCERTAIN, SightingInfo.SightingStatus.UNSATISFACTORY_VIEWS, SightingInfo.SightingStatus.DEAD, SightingInfo.SightingStatus.NOT_BY_ME, new SightingInfo.SightingStatus[]{SightingInfo.SightingStatus.SIGNS, SightingInfo.SightingStatus.DOMESTIC, SightingInfo.SightingStatus.RESTRAINED})));
    private static final Predicate<Sighting> NO_INTRODUCED_COUNTABLE_POPULATION_STATUS_YES_RESTRAINED = Predicates.not(SightingPredicates.sightingStatusIsIn(ImmutableSet.of(SightingInfo.SightingStatus.INTRODUCED_NOT_ESTABLISHED, SightingInfo.SightingStatus.INTRODUCED, SightingInfo.SightingStatus.ID_UNCERTAIN, SightingInfo.SightingStatus.UNSATISFACTORY_VIEWS, SightingInfo.SightingStatus.DEAD, SightingInfo.SightingStatus.NOT_BY_ME, new SightingInfo.SightingStatus[]{SightingInfo.SightingStatus.SIGNS, SightingInfo.SightingStatus.DOMESTIC})));

    public QueryPreferences(UndescribedTaxa undescribedTaxa) {
        this.undescribedTaxa = undescribedTaxa;
    }

    @Nullable
    public Predicate<Sighting> getCountablePredicate(Taxonomy taxonomy, boolean skipSightingStatus, @Nullable Optional<Boolean> heardOnlyQuery) {
        Predicate<Sighting> countablePredicate;
        if (skipSightingStatus) {
            countablePredicate = null;
        } else if (this.countIntroduced) {
            countablePredicate = this.countRestrained ? COUNTABLE_POPULATION_STATUS_YES_RESTRAINED : DEFAULT_COUNTABLE_POPULATION_STATUS;
        } else {
            Predicate<Sighting> predicate = countablePredicate = this.countRestrained ? NO_INTRODUCED_COUNTABLE_POPULATION_STATUS_YES_RESTRAINED : NO_INTRODUCED_COUNTABLE_POPULATION_STATUS;
        }
        boolean enforceHeardOnly = heardOnlyQuery == null ? !this.countHeardOnly : heardOnlyQuery.isPresent();
        if (enforceHeardOnly) {
            boolean shouldBeHeardOnly;
            if (heardOnlyQuery == null) {
                Preconditions.checkState(!this.countHeardOnly);
                shouldBeHeardOnly = false;
            } else {
                shouldBeHeardOnly = heardOnlyQuery.get();
            }
            Predicate<Sighting> heardOnlyPredicate = shouldBeHeardOnly ? SightingPredicates.isHeardOnly() : Predicates.not(SightingPredicates.isHeardOnly());
            countablePredicate = countablePredicate == null ? heardOnlyPredicate : Predicates.and(countablePredicate, heardOnlyPredicate);
        }
        if (!this.countUndescribed) {
            ImmutableSet<SightingTaxon> undescribedTaxa = this.undescribedTaxa.undescribedTaxa(taxonomy);
            Predicate<Sighting> describedPredicate = sighting -> !undescribedTaxa.contains(sighting.getTaxon());
            countablePredicate = countablePredicate == null ? describedPredicate : Predicates.and(countablePredicate, describedPredicate);
        }
        return countablePredicate;
    }

    public ImmutableSet<Checklist.Status> excludedChecklistStatuses() {
        if (this.countIntroduced) {
            return ImmutableSet.of(Checklist.Status.ESCAPED);
        }
        return ImmutableSet.of(Checklist.Status.ESCAPED, Checklist.Status.INTRODUCED, Checklist.Status.RARITY_FROM_INTRODUCED);
    }
}

