/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.ui.components.VisitInfoPreferences;
import com.scythebill.birdlist.ui.events.DefaultUserStore;
import com.scythebill.birdlist.ui.events.EventBusRegistrar;
import com.scythebill.birdlist.ui.events.TaxonomyStore;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.panels.reports.CompositeQueryDefinition;
import com.scythebill.birdlist.ui.panels.reports.QueryFieldFactory;
import com.scythebill.birdlist.ui.panels.reports.QueryPanel;
import com.scythebill.birdlist.ui.panels.reports.StoredQueries;
import com.scythebill.birdlist.ui.panels.reports.StoredQueriesPreferences;
import com.scythebill.birdlist.ui.panels.reports.StoredReportSetQueriesPreferences;
import com.scythebill.birdlist.ui.prefs.ReportSetPreference;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.LocationScorer;
import java.util.Collection;

public class QueryPanelFactory {
    private final ReportSet reportSet;
    private final StoredQueries storedQueries;
    private final EventBusRegistrar eventBusRegistrar;
    private final FontManager fontManager;
    private final DefaultUserStore defaultUserStore;
    private final TaxonomyStore taxonomyStore;
    private final VisitInfoPreferences visitInfoPreferences;
    private final LocationScorer locationScorer;

    @Inject
    public QueryPanelFactory(ReportSet reportSet, EventBusRegistrar eventBusRegistrar, DefaultUserStore defaultUserStore, FontManager fontManager, TaxonomyStore taxonomyStore, VisitInfoPreferences visitInfoPreferences, LocationScorer locationScorer, Alerts alerts, StoredQueriesPreferences storedQueriesPreferences, ReportSetPreference<StoredReportSetQueriesPreferences> reportSetPreferences) {
        this.reportSet = reportSet;
        this.eventBusRegistrar = eventBusRegistrar;
        this.defaultUserStore = defaultUserStore;
        this.fontManager = fontManager;
        this.taxonomyStore = taxonomyStore;
        this.visitInfoPreferences = visitInfoPreferences;
        this.locationScorer = locationScorer;
        this.storedQueries = new StoredQueries(this.newQueryFieldFactory(), alerts, storedQueriesPreferences, reportSetPreferences);
    }

    public QueryPanel newQueryPanel(QueryFieldFactory.QueryFieldType ... excludedQueryFieldTypes) {
        return this.newQueryPanel(ImmutableList.copyOf(CompositeQueryDefinition.BooleanOperation.values()), false, new QueryFieldFactory.QueryFieldType[0]);
    }

    public QueryPanel newQueryPanel(Collection<CompositeQueryDefinition.BooleanOperation> allowedBooleanOperations, boolean useNullLocationName, QueryFieldFactory.QueryFieldType ... excludedQueryFieldTypes) {
        return new QueryPanel(this.reportSet, this.newQueryFieldFactory(), this.storedQueries, this.eventBusRegistrar, this.defaultUserStore, this.fontManager, allowedBooleanOperations, useNullLocationName, excludedQueryFieldTypes);
    }

    public QueryFieldFactory newQueryFieldFactory() {
        return new QueryFieldFactory(this.reportSet, this.taxonomyStore, this.visitInfoPreferences, this.locationScorer, this);
    }

    public StoredQueries getStoredQueries() {
        return this.storedQueries;
    }
}

