/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.eventbus.Subscribe;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.events.DefaultUserChangedEvent;
import com.scythebill.birdlist.ui.events.DefaultUserStore;
import com.scythebill.birdlist.ui.events.EventBusRegistrar;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.reports.CompositeQueryDefinition;
import com.scythebill.birdlist.ui.panels.reports.LocationQueryField;
import com.scythebill.birdlist.ui.panels.reports.QueryFieldFactory;
import com.scythebill.birdlist.ui.panels.reports.StoredQueries;
import com.scythebill.birdlist.ui.panels.reports.UserQueryField;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.border.TitledBorder;

public class QueryPanel
extends JPanel {
    private static final ImmutableMap<QueryFieldFactory.QueryFieldType, Messages.Name> FIELD_TYPE_TO_TITLE = ImmutableMap.builder().put(QueryFieldFactory.QueryFieldType.LOCATION, Messages.Name.QUERY_LOCATION).put(QueryFieldFactory.QueryFieldType.DATE, Messages.Name.QUERY_DATE).put(QueryFieldFactory.QueryFieldType.USER, Messages.Name.QUERY_OBSERVERS).put(QueryFieldFactory.QueryFieldType.FIRST_SIGHTINGS, Messages.Name.QUERY_FIRST_RECORDS).put(QueryFieldFactory.QueryFieldType.ALLOW_HEARD_ONLY, Messages.Name.QUERY_HEARD_ONLY).put(QueryFieldFactory.QueryFieldType.SPECIES_STATUS, Messages.Name.QUERY_IUCN_READLIST).put(QueryFieldFactory.QueryFieldType.SIGHTING_STATUS, Messages.Name.QUERY_STATUS).put(QueryFieldFactory.QueryFieldType.BREEDING_CODE, Messages.Name.QUERY_BREEDING_CODE).put(QueryFieldFactory.QueryFieldType.PHOTOGRAPHED, Messages.Name.QUERY_PHOTOGRAPHED).put(QueryFieldFactory.QueryFieldType.SIGHTING_NOTES, Messages.Name.QUERY_SIGHTING_NOTES).put(QueryFieldFactory.QueryFieldType.VISIT_COMMENTS, Messages.Name.QUERY_VISIT_COMMENTS).put(QueryFieldFactory.QueryFieldType.SEX_AGE, Messages.Name.QUERY_SEX_AGE).put(QueryFieldFactory.QueryFieldType.TIMES_SIGHTED, Messages.Name.QUERY_TIMES_SIGHTED).put(QueryFieldFactory.QueryFieldType.FAMILY, Messages.Name.QUERY_FAMILY).put(QueryFieldFactory.QueryFieldType.SUBSPECIES_ALLOCATED, Messages.Name.QUERY_SUBSPECIES).put(QueryFieldFactory.QueryFieldType.SP_OR_HYBRID, Messages.Name.QUERY_SP_OR_HYBRID).build();
    private final QueryFieldFactory queryFieldFactory;
    private final List<QueryEntry> queryFields = Lists.newArrayList();
    private final List<ActionListener> predicateChangedListeners = Lists.newArrayList();
    private final StoredQueries storedQueries;
    private final DefaultUserStore defaultUserStore;
    private GroupLayout layout;
    private final FontManager fontManager;
    private JPanel queryFieldsPanel;
    private final ImmutableSet<QueryFieldFactory.QueryFieldType> excludedQueryFieldTypes;
    private final ReportSet reportSet;
    private final ImmutableList<CompositeQueryDefinition.BooleanOperation> allowedBooleanOperations;

    QueryPanel(ReportSet reportSet, QueryFieldFactory queryFieldFactory, StoredQueries storedQueries, EventBusRegistrar eventBusRegistrar, DefaultUserStore defaultUserStore, FontManager fontManager, Collection<CompositeQueryDefinition.BooleanOperation> allowedBooleanOperations, boolean useNullLocationName, QueryFieldFactory.QueryFieldType ... excludedQueryFieldTypes) {
        this.reportSet = reportSet;
        this.queryFieldFactory = queryFieldFactory;
        this.storedQueries = storedQueries;
        this.defaultUserStore = defaultUserStore;
        this.fontManager = fontManager;
        this.allowedBooleanOperations = ImmutableList.copyOf(allowedBooleanOperations);
        if (useNullLocationName) {
            queryFieldFactory.useNullLocationName();
        }
        ImmutableSet.Builder excludedQueryFieldTypesBuilder = ImmutableSet.builder();
        excludedQueryFieldTypesBuilder.addAll(Arrays.asList(excludedQueryFieldTypes));
        if (reportSet.getUserSet() == null) {
            excludedQueryFieldTypesBuilder.add((Object)QueryFieldFactory.QueryFieldType.USER);
        }
        this.excludedQueryFieldTypes = excludedQueryFieldTypesBuilder.build();
        this.initUi();
        this.addNewQueryField(null);
        eventBusRegistrar.registerWhenInHierarchy(this);
    }

    public CompositeQueryDefinition queryDefinition(Taxonomy taxonomy, Taxon.Type depth) {
        ArrayList fields = this.queryFields.stream().map(entry -> entry.field).collect(Collectors.toCollection(ArrayList::new));
        ArrayList operations = this.queryFields.stream().map(entry -> (CompositeQueryDefinition.BooleanOperation)((Object)((Object)entry.booleanOperation.getSelectedItem()))).collect(Collectors.toCollection(ArrayList::new));
        if (this.defaultUserStore.getUser() != null && !this.containsQueryFieldType(QueryFieldFactory.QueryFieldType.USER)) {
            UserQueryField userField = new UserQueryField(this.reportSet.getUserSet());
            userField.setUser(this.defaultUserStore.getUser());
            fields.add(userField);
            operations.add(CompositeQueryDefinition.BooleanOperation.ALL);
        }
        return new CompositeQueryDefinition(this.reportSet, fields, operations, taxonomy, depth);
    }

    public Set<Location> getLocations() {
        HashSet<Location> locations = Sets.newHashSet();
        for (QueryEntry entry : this.queryFields) {
            if (!(entry.field instanceof LocationQueryField)) continue;
            locations.add(((LocationQueryField)entry.field).getLocation());
        }
        return locations;
    }

    public void addPredicateChangedListener(ActionListener l) {
        this.predicateChangedListeners.add(l);
    }

    public String persist() {
        ArrayList<QueryFieldFactory.QueryField> fields = Lists.newArrayList();
        ArrayList<CompositeQueryDefinition.BooleanOperation> operations = Lists.newArrayList();
        for (QueryEntry entry : this.queryFields) {
            fields.add(entry.field);
            operations.add((CompositeQueryDefinition.BooleanOperation)((Object)entry.booleanOperation.getSelectedItem()));
        }
        return this.storedQueries.persist(fields, operations);
    }

    public void restore(String json) {
        Optional<StoredQueries.RestoredQuery> restored = this.storedQueries.restore(json);
        if (restored.isPresent()) {
            this.restore(restored.get());
        }
    }

    public void restore(StoredQueries.RestoredQuery restored) {
        this.queryFields.clear();
        this.queryFieldsPanel.removeAll();
        for (int i = 0; i < restored.fields.size(); ++i) {
            QueryFieldFactory.QueryField field = (QueryFieldFactory.QueryField)restored.fields.get(i);
            CompositeQueryDefinition.BooleanOperation operation = (CompositeQueryDefinition.BooleanOperation)((Object)restored.booleanOperations.get(i));
            this.addQueryField(field, this.queryFields.size(), operation);
        }
        this.rebuildLayout();
        this.firePredicateChanged();
    }

    public boolean containsQueryFieldType(QueryFieldFactory.QueryFieldType type) {
        for (QueryEntry entry : this.queryFields) {
            if (type != entry.field.getType()) continue;
            return true;
        }
        return false;
    }

    public boolean containsQueryFieldTypeThatIsNotANoOp(QueryFieldFactory.QueryFieldType type) {
        for (QueryEntry entry : this.queryFields) {
            if (type != entry.field.getType() || entry.field.isNoOp()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public Optional<Boolean> getBooleanValueIfPresent(QueryFieldFactory.QueryFieldType type) {
        for (QueryEntry entry : this.queryFields) {
            Optional<Boolean> booleanValue;
            if (type != entry.field.getType() || !(booleanValue = entry.field.getBooleanValue()).isPresent() || entry.booleanOperation.getSelectedItem() != CompositeQueryDefinition.BooleanOperation.NEVER && entry.booleanOperation.getSelectedItem() != CompositeQueryDefinition.BooleanOperation.NEVER_ALL) continue;
            booleanValue = Optional.of(booleanValue.get() == false);
        }
        return null;
    }

    public Location getRootLocation() {
        boolean foundLocationField = false;
        Location rootLocation = null;
        for (QueryEntry entry : this.queryFields) {
            if (QueryFieldFactory.QueryFieldType.LOCATION != entry.field.getType()) continue;
            if (foundLocationField) {
                return null;
            }
            foundLocationField = true;
            rootLocation = ((LocationQueryField)entry.field).getRootLocation();
        }
        return rootLocation;
    }

    private void firePredicateChanged() {
        ActionEvent event = new ActionEvent(this, 0, null);
        for (ActionListener l : this.predicateChangedListeners) {
            l.actionPerformed(event);
        }
    }

    private QueryEntry addQueryField(QueryFieldFactory.QueryField newField, int index, CompositeQueryDefinition.BooleanOperation booleanOperation) {
        final QueryEntry entry = new QueryEntry();
        entry.typeChooser = this.createQueryFieldChooser(newField.getType());
        entry.remove = this.newRemoveButton();
        entry.add = this.newAddButton();
        entry.field = newField;
        entry.booleanOperation = new JComboBox<CompositeQueryDefinition.BooleanOperation>((CompositeQueryDefinition.BooleanOperation[])this.allowedBooleanOperations.toArray(CompositeQueryDefinition.BooleanOperation[]::new));
        entry.booleanOperation.setSelectedItem((Object)booleanOperation);
        this.queryFields.add(index, entry);
        this.queryFieldsPanel.add(entry.booleanOperation);
        this.queryFieldsPanel.add(entry.typeChooser);
        if (newField.getComparisonChooser() != null) {
            this.queryFieldsPanel.add(newField.getComparisonChooser());
        }
        this.queryFieldsPanel.add(newField.getValueField());
        this.queryFieldsPanel.add(entry.remove);
        this.queryFieldsPanel.add(entry.add);
        entry.booleanOperation.addActionListener(e -> this.firePredicateChanged());
        entry.field.addPredicateUpdatedListener(e -> this.firePredicateChanged());
        entry.typeChooser.addActionListener(e -> this.updateQueryField(entry));
        entry.add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryEntry newQueryField = QueryPanel.this.addNewQueryField(entry);
                JComponent valueField = newQueryField.field.getValueField();
                if (valueField.isFocusable()) {
                    valueField.requestFocusInWindow();
                } else {
                    Component focusableComponent = valueField.getFocusTraversalPolicy().getFirstComponent(valueField);
                    if (focusableComponent != null) {
                        focusableComponent.requestFocusInWindow();
                    }
                }
                QueryPanel.this.maybeResizeWindow();
            }
        });
        entry.remove.addActionListener(e -> this.removeQueryField(entry));
        return entry;
    }

    protected void maybeResizeWindow() {
    }

    private void removeQueryField(QueryEntry entry) {
        this.queryFieldsPanel.remove(entry.remove);
        this.queryFieldsPanel.remove(entry.add);
        this.queryFieldsPanel.remove(entry.field.getValueField());
        if (entry.field.getComparisonChooser() != null) {
            this.queryFieldsPanel.remove(entry.field.getComparisonChooser());
        }
        this.queryFieldsPanel.remove(entry.typeChooser);
        this.queryFieldsPanel.remove(entry.booleanOperation);
        this.queryFields.remove(entry);
        this.rebuildLayout();
        this.firePredicateChanged();
    }

    private QueryEntry addNewQueryField(QueryEntry after) {
        CompositeQueryDefinition.BooleanOperation booleanOperation = after == null ? CompositeQueryDefinition.BooleanOperation.ALL : (CompositeQueryDefinition.BooleanOperation)((Object)after.booleanOperation.getSelectedItem());
        int indexToAdd = this.queryFields.size();
        EnumSet<QueryFieldFactory.QueryFieldType> unusedFields = EnumSet.allOf(QueryFieldFactory.QueryFieldType.class);
        int loopIndex = 0;
        for (QueryEntry queryEntry : this.queryFields) {
            unusedFields.remove((Object)queryEntry.field.getType());
            ++loopIndex;
            if (queryEntry != after) continue;
            indexToAdd = loopIndex;
        }
        QueryFieldFactory.QueryFieldType newType = QueryFieldFactory.QueryFieldType.DATE;
        for (QueryFieldFactory.QueryFieldType type : this.allowedQueryFieldTypes()) {
            if (!unusedFields.contains((Object)type)) continue;
            newType = type;
            break;
        }
        QueryEntry queryEntry = this.addQueryField(this.queryFieldFactory.newField(newType), indexToAdd, booleanOperation);
        this.rebuildLayout();
        this.firePredicateChanged();
        return queryEntry;
    }

    private void updateQueryField(QueryEntry entry) {
        ImmutableList<QueryFieldFactory.QueryFieldType> fieldTypesList = ImmutableList.copyOf(this.allowedQueryFieldTypes());
        QueryFieldFactory.QueryFieldType newType = (QueryFieldFactory.QueryFieldType)((Object)fieldTypesList.get(entry.typeChooser.getSelectedIndex()));
        if (newType == entry.field.getType()) {
            return;
        }
        QueryFieldFactory.QueryField newField = this.queryFieldFactory.newField(newType);
        if (entry.field.getComparisonChooser() != null) {
            if (newField.getComparisonChooser() == null) {
                this.queryFieldsPanel.remove(entry.field.getComparisonChooser());
            } else {
                this.replaceComponent(entry.field.getComparisonChooser(), newField.getComparisonChooser());
            }
        } else if (newField.getComparisonChooser() != null) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component child = this.getComponent(i);
                if (child != entry.field.getValueField()) continue;
                this.queryFieldsPanel.add((Component)entry.field.getComparisonChooser(), i);
                break;
            }
        }
        this.replaceComponent(entry.field.getValueField(), newField.getValueField());
        entry.field = newField;
        entry.field.addPredicateUpdatedListener(e -> this.firePredicateChanged());
        if (newType.onlyAllowsAll()) {
            entry.booleanOperation.setSelectedItem((Object)CompositeQueryDefinition.BooleanOperation.ALL);
            entry.booleanOperation.setEnabled(false);
        } else {
            entry.booleanOperation.setEnabled(true);
        }
        this.firePredicateChanged();
        this.rebuildLayout();
    }

    private Iterable<QueryFieldFactory.QueryFieldType> allowedQueryFieldTypes() {
        return Iterables.filter(FIELD_TYPE_TO_TITLE.keySet(), Predicates.not(Predicates.in(this.excludedQueryFieldTypes)));
    }

    private void replaceComponent(JComponent old, JComponent replacement) {
        for (int i = 0; i < this.queryFieldsPanel.getComponentCount(); ++i) {
            if (this.queryFieldsPanel.getComponent(i) != old) continue;
            this.queryFieldsPanel.remove(i);
            this.queryFieldsPanel.add((Component)replacement, i);
            return;
        }
    }

    private JButton newAddButton() {
        JButton button = new JButton("+");
        button.setMargin(new Insets(0, 0, 0, 0));
        return button;
    }

    private JButton newRemoveButton() {
        JButton button = new JButton("-");
        button.setMargin(new Insets(0, 0, 0, 0));
        return button;
    }

    private void rebuildLayout() {
        GroupLayout.SequentialGroup vertical = this.layout.createSequentialGroup();
        if (!this.queryFields.isEmpty()) {
            this.queryFields.get((int)0).remove.setEnabled(this.queryFields.size() > 1);
            this.queryFields.get((int)0).booleanOperation.setVisible(this.queryFields.size() > 1);
            if (this.queryFields.size() == 1) {
                this.queryFields.get((int)0).booleanOperation.setSelectedIndex(0);
            }
        }
        for (QueryEntry entry : this.queryFields) {
            boolean isSingleLine = entry.field.isSingleLine();
            GroupLayout.ParallelGroup group = isSingleLine ? this.layout.createBaselineGroup(false, false) : this.layout.createParallelGroup();
            vertical.addGroup(group);
            group.addComponent(entry.booleanOperation, -2, -2, -2).addComponent(entry.typeChooser, -2, -2, -2);
            if (entry.field.getComparisonChooser() != null) {
                group.addComponent(entry.field.getComparisonChooser(), -2, -2, -2);
            }
            group.addComponent(entry.field.getValueField(), -2, -2, -2).addComponent(entry.remove, -2, -2, -2).addComponent(entry.add, -2, -2, -2);
            vertical.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
        }
        this.layout.setVerticalGroup(vertical);
        GroupLayout.SequentialGroup horizontal = this.layout.createSequentialGroup();
        GroupLayout.ParallelGroup allOrAnyChoosers = this.layout.createParallelGroup();
        GroupLayout.ParallelGroup typeChoosers = this.layout.createParallelGroup();
        for (QueryEntry entry : this.queryFields) {
            allOrAnyChoosers.addComponent(entry.booleanOperation, -2, -2, -2);
            typeChoosers.addComponent(entry.typeChooser, -2, -2, -2);
        }
        GroupLayout.ParallelGroup comparisonAndValue = this.layout.createParallelGroup();
        GroupLayout.ParallelGroup comparisonChoosers = this.layout.createParallelGroup();
        GroupLayout.ParallelGroup valueFields = this.layout.createParallelGroup();
        comparisonAndValue.addGroup(this.layout.createSequentialGroup().addGroup(comparisonChoosers).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(valueFields));
        for (QueryEntry entry : this.queryFields) {
            JComponent comparisonChooser = entry.field.getComparisonChooser();
            JComponent valueField = entry.field.getValueField();
            if (comparisonChooser == null) {
                comparisonAndValue.addComponent(valueField, -2, -2, -2);
                continue;
            }
            comparisonChoosers.addComponent(comparisonChooser, -2, -2, -2);
            valueFields.addComponent(valueField, -2, -2, -2);
        }
        GroupLayout.ParallelGroup adds = this.layout.createParallelGroup();
        GroupLayout.ParallelGroup removes = this.layout.createParallelGroup();
        for (QueryEntry entry : this.queryFields) {
            adds.addComponent(entry.add, -2, -2, -2);
            removes.addComponent(entry.remove, -2, -2, -2);
            this.layout.linkSize(entry.add, entry.remove);
        }
        horizontal.addGroup(allOrAnyChoosers).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(typeChoosers).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(comparisonAndValue).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(removes).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(adds);
        this.layout.setHorizontalGroup(horizontal);
        this.fontManager.applyTo(this);
    }

    private JComboBox<String> createQueryFieldChooser(QueryFieldFactory.QueryFieldType type) {
        ImmutableList<QueryFieldFactory.QueryFieldType> fieldTypesList = ImmutableList.copyOf(this.allowedQueryFieldTypes());
        List<String> titlesList = Lists.transform(fieldTypesList, t -> Messages.getMessage(FIELD_TYPE_TO_TITLE.get(t)));
        String[] titles = titlesList.toArray(new String[0]);
        JComboBox<String> chooser = new JComboBox<String>(titles);
        chooser.setSelectedIndex(fieldTypesList.indexOf((Object)type));
        chooser.setMaximumRowCount(fieldTypesList.size());
        return chooser;
    }

    private void initUi() {
        this.setLayout(new BoxLayout(this, 3));
        this.queryFieldsPanel = new JPanel();
        this.queryFieldsPanel.setBorder(new TitledBorder((String)null));
        this.layout = new GroupLayout(this.queryFieldsPanel);
        this.queryFieldsPanel.setLayout(this.layout);
        this.queryFieldsPanel.setAlignmentX(0.0f);
        this.add(this.queryFieldsPanel);
    }

    public Optional<String> getQueryAbbreviation() {
        ArrayList<Optional<String>> abbreviations = Lists.newArrayList();
        for (QueryEntry queryEntry : this.queryFields) {
            Optional<String> abbreviation = queryEntry.field.abbreviation();
            if (queryEntry.booleanOperation.getSelectedItem() == CompositeQueryDefinition.BooleanOperation.NEVER || queryEntry.booleanOperation.getSelectedItem() == CompositeQueryDefinition.BooleanOperation.NEVER_ALL) {
                abbreviation = abbreviation.transform(s -> Messages.getFormattedMessage(Messages.Name.NEVER_FORMAT, s));
            }
            abbreviations.add(abbreviation);
        }
        String joined = Joiner.on('-').join(Optional.presentInstances(abbreviations));
        if ("".equals(joined)) {
            return Optional.absent();
        }
        return Optional.of(joined.replace(File.separatorChar, '-'));
    }

    public Optional<String> getQueryName() {
        ArrayList<Optional<String>> names = Lists.newArrayList();
        for (QueryEntry queryEntry : this.queryFields) {
            Optional<String> name = queryEntry.field.name();
            if (queryEntry.booleanOperation.getSelectedItem() == CompositeQueryDefinition.BooleanOperation.NEVER || queryEntry.booleanOperation.getSelectedItem() == CompositeQueryDefinition.BooleanOperation.NEVER_ALL) {
                name = name.transform(s -> Messages.getFormattedMessage(Messages.Name.NEVER_FORMAT, s));
            }
            names.add(name);
        }
        String joined = Joiner.on(' ').join(Optional.presentInstances(names));
        if ("".equals(joined)) {
            return Optional.absent();
        }
        return Optional.of(joined);
    }

    public void taxonomyUpdated() {
        for (QueryEntry queryEntry : this.queryFields) {
            queryEntry.field.taxonomyUpdated();
        }
    }

    @Subscribe
    public void defaultUserUpdated(DefaultUserChangedEvent userChangedEvent) {
        this.firePredicateChanged();
    }

    static class QueryEntry {
        public JComboBox<CompositeQueryDefinition.BooleanOperation> booleanOperation;
        public JButton remove;
        public JButton add;
        public QueryFieldFactory.QueryField field;
        public JComboBox<String> typeChooser;

        QueryEntry() {
        }
    }
}

