/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.gson.JsonElement;
import com.scythebill.birdlist.model.query.QueryDefinition;
import com.scythebill.birdlist.model.query.SightingPredicates;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.ui.components.VisitInfoPreferences;
import com.scythebill.birdlist.ui.events.TaxonomyStore;
import com.scythebill.birdlist.ui.panels.reports.BooleanQueryField;
import com.scythebill.birdlist.ui.panels.reports.BreedingBirdCodeQueryField;
import com.scythebill.birdlist.ui.panels.reports.DateQueryField;
import com.scythebill.birdlist.ui.panels.reports.DescriptionQueryField;
import com.scythebill.birdlist.ui.panels.reports.FamilyQueryField;
import com.scythebill.birdlist.ui.panels.reports.FirstSightingsQueryField;
import com.scythebill.birdlist.ui.panels.reports.LocationQueryField;
import com.scythebill.birdlist.ui.panels.reports.PhotographedQueryField;
import com.scythebill.birdlist.ui.panels.reports.QueryPanelFactory;
import com.scythebill.birdlist.ui.panels.reports.SexAgeQueryField;
import com.scythebill.birdlist.ui.panels.reports.SightingStatusQueryField;
import com.scythebill.birdlist.ui.panels.reports.SpOrHybridStatusQueryField;
import com.scythebill.birdlist.ui.panels.reports.SpeciesStatusQueryField;
import com.scythebill.birdlist.ui.panels.reports.SubspeciesAllocatedQueryField;
import com.scythebill.birdlist.ui.panels.reports.TimesSightedQueryField;
import com.scythebill.birdlist.ui.panels.reports.UserQueryField;
import com.scythebill.birdlist.ui.panels.reports.VisitCommentsQueryField;
import com.scythebill.birdlist.ui.util.LocationScorer;
import java.awt.event.ActionListener;
import javax.swing.JComponent;

final class QueryFieldFactory {
    private final ReportSet reportSet;
    private final TaxonomyStore taxonomyStore;
    private final VisitInfoPreferences visitInfoPreferences;
    private final LocationScorer locationScorer;
    private final QueryPanelFactory queryPanelFactory;
    private boolean useNullLocationName = false;

    QueryFieldFactory(ReportSet reportSet, TaxonomyStore taxonomyStore, VisitInfoPreferences visitInfoPreferences, LocationScorer locationScorer, QueryPanelFactory queryPanelFactory) {
        this.reportSet = reportSet;
        this.taxonomyStore = taxonomyStore;
        this.visitInfoPreferences = visitInfoPreferences;
        this.locationScorer = locationScorer;
        this.queryPanelFactory = queryPanelFactory;
    }

    public QueryField newField(QueryFieldType type) {
        return type.newField(this);
    }

    public void useNullLocationName() {
        this.useNullLocationName = true;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum QueryFieldType {
        DATE{

            @Override
            QueryField newField(QueryFieldFactory factory) {
                return new DateQueryField();
            }
        }
        ,
        LOCATION{

            @Override
            QueryField newField(QueryFieldFactory factory) {
                return new LocationQueryField(factory.reportSet.getLocations(), factory.visitInfoPreferences, factory.locationScorer, factory.useNullLocationName);
            }
        }
        ,
        ALLOW_HEARD_ONLY{

            @Override
            QueryField newField(QueryFieldFactory factory) {
                return new BooleanQueryField(ALLOW_HEARD_ONLY, false){

                    @Override
                    protected Predicate<Sighting> predicateFromBoolean(boolean currentValue) {
                        return currentValue ? SightingPredicates.isHeardOnly() : Predicates.not(SightingPredicates.isHeardOnly());
                    }
                };
            }
        }
        ,
        PHOTOGRAPHED{

            @Override
            QueryField newField(QueryFieldFactory factory) {
                return new PhotographedQueryField();
            }
        }
        ,
        SIGHTING_STATUS{

            @Override
            QueryField newField(QueryFieldFactory factory) {
                return new SightingStatusQueryField();
            }
        }
        ,
        SPECIES_STATUS{

            @Override
            QueryField newField(QueryFieldFactory factory) {
                return new SpeciesStatusQueryField(factory.taxonomyStore);
            }
        }
        ,
        SIGHTING_NOTES{

            @Override
            QueryField newField(QueryFieldFactory factory) {
                return new DescriptionQueryField();
            }
        }
        ,
        VISIT_COMMENTS{

            @Override
            QueryField newField(QueryFieldFactory factory) {
                return new VisitCommentsQueryField();
            }
        }
        ,
        BREEDING_CODE{

            @Override
            QueryField newField(QueryFieldFactory factory) {
                return new BreedingBirdCodeQueryField();
            }
        }
        ,
        SP_OR_HYBRID{

            @Override
            QueryField newField(QueryFieldFactory factory) {
                return new SpOrHybridStatusQueryField(factory.taxonomyStore);
            }
        }
        ,
        SEX_AGE{

            @Override
            QueryField newField(QueryFieldFactory factory) {
                return new SexAgeQueryField();
            }
        }
        ,
        SUBSPECIES_ALLOCATED{

            @Override
            QueryField newField(QueryFieldFactory factory) {
                return new SubspeciesAllocatedQueryField(factory.taxonomyStore);
            }
        }
        ,
        FIRST_SIGHTINGS{

            @Override
            QueryField newField(QueryFieldFactory factory) {
                return new FirstSightingsQueryField(factory.reportSet.getLocations(), factory.taxonomyStore, factory.queryPanelFactory);
            }
        }
        ,
        TIMES_SIGHTED{

            @Override
            QueryField newField(QueryFieldFactory factory) {
                return new TimesSightedQueryField();
            }

            @Override
            boolean onlyAllowsAll() {
                return true;
            }
        }
        ,
        FAMILY{

            @Override
            QueryField newField(QueryFieldFactory factory) {
                return new FamilyQueryField(factory.taxonomyStore);
            }
        }
        ,
        USER{

            @Override
            QueryField newField(QueryFieldFactory factory) {
                return new UserQueryField(factory.reportSet.getUserSet());
            }
        };


        abstract QueryField newField(QueryFieldFactory var1);

        boolean onlyAllowsAll() {
            return false;
        }
    }

    public static interface QueryField {
        public JComponent getComparisonChooser();

        public JComponent getValueField();

        public void addPredicateUpdatedListener(ActionListener var1);

        public QueryDefinition queryDefinition(ReportSet var1, Taxon.Type var2);

        public QueryFieldType getType();

        public boolean isNoOp();

        default public Optional<Boolean> getBooleanValue() {
            return Optional.absent();
        }

        default public boolean isSingleLine() {
            return true;
        }

        default public Optional<String> abbreviation() {
            return Optional.absent();
        }

        default public Optional<String> name() {
            return Optional.absent();
        }

        public JsonElement persist();

        public void restore(JsonElement var1);

        default public void taxonomyUpdated() {
        }
    }
}

