/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.query.QueryDefinition;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.components.OkCancelPanel;
import com.scythebill.birdlist.ui.events.DefaultUserStore;
import com.scythebill.birdlist.ui.events.EventBusRegistrar;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.reports.CompositeQueryDefinition;
import com.scythebill.birdlist.ui.panels.reports.QueryFieldFactory;
import com.scythebill.birdlist.ui.panels.reports.QueryPanel;
import com.scythebill.birdlist.ui.panels.reports.QueryPanelFactory;
import com.scythebill.birdlist.ui.panels.reports.StoredQueries;
import com.scythebill.birdlist.ui.util.UIUtils;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JLabel;

public class QueryDialog {
    private final QueryFieldFactory queryFieldFactory;
    private final StoredQueries storedQueries;
    private final FontManager fontManager;
    private EventBusRegistrar eventBusRegistrar;
    private DefaultUserStore defaultUserStore;

    @Inject
    public QueryDialog(QueryPanelFactory queryPanelFactory, StoredQueries storedQueries, EventBusRegistrar eventBusRegistrar, DefaultUserStore defaultUserStore, FontManager fontManager) {
        this.queryFieldFactory = queryPanelFactory.newQueryFieldFactory();
        this.storedQueries = storedQueries;
        this.eventBusRegistrar = eventBusRegistrar;
        this.defaultUserStore = defaultUserStore;
        this.fontManager = fontManager;
    }

    public void showQueryDefinition(Window parent, String message, ReportSet reportSet, final Taxonomy taxonomy, final QueryDefinitionReceiver receiver) {
        Dialog.ModalityType modality = Toolkit.getDefaultToolkit().isModalityTypeSupported(Dialog.ModalityType.DOCUMENT_MODAL) ? Dialog.ModalityType.DOCUMENT_MODAL : Dialog.ModalityType.APPLICATION_MODAL;
        final JDialog dialog = new JDialog(parent, Messages.getMessage(Messages.Name.CHOOSE_A_REPORT), modality);
        final QueryPanel queryPanel = new QueryPanel(reportSet, this.queryFieldFactory, this.storedQueries, this.eventBusRegistrar, this.defaultUserStore, this.fontManager, ImmutableList.of(CompositeQueryDefinition.BooleanOperation.ALL, CompositeQueryDefinition.BooleanOperation.ANY), false, new QueryFieldFactory.QueryFieldType[]{QueryFieldFactory.QueryFieldType.FIRST_SIGHTINGS, QueryFieldFactory.QueryFieldType.FAMILY, QueryFieldFactory.QueryFieldType.TIMES_SIGHTED}){

            @Override
            protected void maybeResizeWindow() {
                Dimension preferredSize = dialog.getPreferredSize();
                Dimension currentSize = dialog.getSize();
                Dimension resizeTo = new Dimension(Math.max(preferredSize.width, currentSize.width), Math.max(preferredSize.height, currentSize.height));
                dialog.setSize(resizeTo);
                UIUtils.keepWindowOnScreen(dialog);
            }
        };
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                receiver.cancelled();
                dialog.dispose();
            }
        };
        AbstractAction okAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                receiver.queryDefinitionAvailable(queryPanel.queryDefinition(taxonomy, Taxon.Type.species), queryPanel.getQueryName());
                dialog.dispose();
            }
        };
        Box box = Box.createVerticalBox();
        box.add(new JLabel(message));
        box.add(Box.createVerticalStrut(this.fontManager.scale(20)));
        box.add(queryPanel);
        box.add(Box.createVerticalStrut(this.fontManager.scale(20)));
        OkCancelPanel okCancel = new OkCancelPanel(okAction, cancelAction, box, queryPanel);
        dialog.setContentPane(okCancel);
        dialog.pack();
        dialog.setVisible(true);
    }

    public static interface QueryDefinitionReceiver {
        public void queryDefinitionAvailable(QueryDefinition var1, Optional<String> var2);

        public void cancelled();
    }
}

